/*
 * The source code contained herein is licensed under the IBM Public License   
 * Version 1.0, which has been approved by the Open Source Initiative.
 * Copyright (C) 2001, International Business Machines Corporation
 * All Rights Reserved.         
 * 
 */

package com.ibm.uddi.response;
import java.util.Vector;
import org.w3c.dom.*;
import com.ibm.uddi.*;
import com.ibm.uddi.datatype.*;
import com.ibm.uddi.datatype.binding.*;
import com.ibm.uddi.datatype.business.*;
import com.ibm.uddi.datatype.service.*;
import com.ibm.uddi.datatype.tmodel.*;
import com.ibm.uddi.request.*;
import com.ibm.uddi.response.*;
import com.ibm.uddi.util.*;

/**
 * <p><b>General information:</b><p>
 *
 * This class represents an element within the UDDI version 1.0 schema.
 * This class contains the following types of methods:<ul>
 *
 *   <li>Constructor passing required fields.
 *   <li>Constructor that will instantiate the object from an XML DOM element
 *       that is the appropriate element for this object.
 *   <li>Get/set methods for each attribute that this element can contain.
 *   <li>For sets of attributes, a get/setVector method is provided.
 *   <li>SaveToXML method. Serialized this class within a passed in element.
 *
 * </ul>
 * Typically this class is used to construct parameters for, or interpret
 * responses from methods in the UDDIProxy class.
 * 
 * <p><b>Element description:</b><p>
 * This structure supports the dispositionReport structure.
 * 
 * <p>
 *
 * @author David Melgar
 */
public class Result extends UDDIElement {
   public static final String UDDI_TAG = "result";

   protected Element base = null;

   String keyType = null;
   String errno = null;
   ErrInfo errInfo = null;

   /**
    * Default constructor.
    * Use of this constructor should be avoided. Use the required fields
    * constructor to provide validation. No validation of required
    * fields is performed when using the default constructor.
    *
    */
   public Result() {
   }

   /**
    * Construct the object with required fields.
    *
    * @param errno	String
    */
   public Result(String errno) {
      this.errno = errno;
   }

   /**
    * Construct the object from a DOM tree. Used by 
    * UDDIProxy to construct object from received UDDI
    * message.
    * 
    * @param base   Element with name appropriate for this class.
    * @exception UDDIException
    *                   Thrown if DOM tree contains a SOAP fault or
    *                   disposition report indicating a UDDI error.
    */
   public Result(Element base) throws UDDIException {
      // Check if its a fault. Throw exception if it is
      super(base);
      keyType = base.getAttribute("keyType");
      errno = base.getAttribute("errno");
      NodeList nl = null;
      nl = getChildElementsByTagName(base, ErrInfo.UDDI_TAG);
      if (nl.getLength() > 0) {
         errInfo = new ErrInfo((Element)nl.item(0));
      }
   }

   public void setKeyType(String s) {
      keyType = s;
   }

   public void setErrno(String s) {
      errno = s;
   }

   public void setErrInfo(ErrInfo s) {
      errInfo = s;
   }

   public String getKeyType() {
      return keyType;
   }


   public String getErrno() {
      return errno;
   }


   public ErrInfo getErrInfo() {
      return errInfo;
   }


   /**
    * Save object to DOM tree. Used to serialize object
    * to a DOM tree, typically to send a UDDI message.
    * 
    * <BR>Used by UDDIProxy.
    * 
    * @param parent Object will serialize as a child element under the
    *               passed in parent element.
    */
   public void saveToXML(Element parent) {
      base = parent.getOwnerDocument().createElement(UDDI_TAG);
      // Save attributes
      if (keyType!=null) {
         base.setAttribute("keyType", keyType);
      }
      if (errno!=null) {
         base.setAttribute("errno", errno);
      }
      if (errInfo!=null) {
         errInfo.saveToXML(base);
      }
      parent.appendChild(base);
   }
}
