/*
 * The source code contained herein is licensed under the IBM Public License   
 * Version 1.0, which has been approved by the Open Source Initiative.
 * Copyright (C) 2001, International Business Machines Corporation
 * All Rights Reserved.         
 * 
 */

import com.ibm.uddi.*;
import com.ibm.uddi.datatype.business.*;
import com.ibm.uddi.response.*;
import com.ibm.uddi.client.*;
import org.w3c.dom.Element;
import java.util.Vector;
import java.util.Properties;

/**
 * Sample code that exercises the publish API. Attempts
 * to delete a business named 'Sample Business'. 
 * <ol>
 * <li>Performs an inquiry to find this business
 * <li>get_authToken to login to server
 * <li>delete any businesses with key found in step 1.
 * </ol>
 */
public class DeleteBusinessExample {
   public static void main (String args[]) {
      /*****************************************************************/
      /* Comment out the following lines to disable SSL and HTTPS support
       * or if using a different SSL provider.
       * JSSE must be in the classpath to use or compile these lines.
       */
      System.setProperty("java.protocol.handler.pkgs",
                         "com.sun.net.ssl.internal.www.protocol");
      java.security.Security.addProvider(new com.sun.net.ssl.internal.ssl.Provider());
      /*****************************************************************/

      DeleteBusinessExample app = new DeleteBusinessExample();
      app.run();
      System.exit(0);
   }

   public void run() {
      // Construct a UDDIProxy object. Enables SSL support
      UDDIProxy proxy = new UDDIProxy();

      try {
         // Select the desired UDDI server node

         // The following values point to the IBM UDDI test site
         proxy.setInquiryURL("http://www-3.ibm.com/services/uddi/testregistry/inquiryapi");
         proxy.setPublishURL("https://www-3.ibm.com/services/uddi/testregistry/protect/publishapi");

         // The following values point to the IBM UDDI official site
         // proxy.setInquiryURL("http://www-3.ibm.com/services/uddi/inquiryapi");
         // proxy.setPublishURL("https://www-3.ibm.com/services/uddi/protect/publishapi");

         // The following values point to the Microsoft UDDI test site
         // proxy.setInquiryURL("http://test.uddi.microsoft.com/inquire");
         // proxy.setPublishURL("https://test.uddi.microsoft.com/publish");

         // The following values point to the Microsoft UDDI official site
         // proxy.setInquiryURL("http://uddi.microsoft.com/inquire");
         // proxy.setPublishURL("https://uddi.microsoft.com/publish");

         // The following values for a locally installed test server
         // proxy.setInquiryURL("http://localhost:8080/services/uddi/servlet/uddi");
         // proxy.setInquiryURL("http://localhost:8080/services/uddi/servlet/uddi");

      } catch (Exception e) {
         e.printStackTrace();
      }
      try {

         // Get an authorization token
         System.out.println("\nGet authtoken");
         
         // Pass in userid and password registered at the UDDI site
         AuthToken token = proxy.get_authToken("userid",
                                               "password" );

         System.out.println("Returned authToken:" + token.getAuthInfoString());

         System.out.println("Search for 'Sample business' to delete");

         // Find businesses starting with 'Sample business'
         BusinessList bl = proxy.find_business("Sample business", null, 0);

         Vector businessInfoVector  = bl.getBusinessInfos().getBusinessInfoVector();

         // Try to delete any businesses with this name. Multiple businesses with the same
         // name may have been created by different userids. Delete will fail for businesses
         // not created by this id
         for (int i = 0; i < businessInfoVector.size(); i++) {
            BusinessInfo bi = (BusinessInfo)businessInfoVector.elementAt(i);
            System.out.println("Found business key:" + bi.getBusinessKey());

            // Have found the matching business key, delete using the authToken
            DispositionReport dr = proxy.delete_business(token.getAuthInfoString(),
                                                         bi.getBusinessKey());

            if (dr.success()) {
               System.out.println("Business successfully deleted");
            } else {
               System.out.println("Errno:" + dr.getErrno() +
                                  "\n ErrCode:" + dr.getErrCode() +
                                  "\n ErrText:" + dr.getErrInfoText() );
            }
         }

      // Handle possible errors
      } catch (UDDIException e) {
         DispositionReport dr = e.getDispositionReport();
         if (dr!=null) {
            System.out.println("UDDIException faultCode:" + e.getFaultCode() +
                               "\n operator:" + dr.getOperator() +
                               "\n generic:"  + dr.getGeneric() +
                               "\n errno:"    + dr.getErrno() +
                               "\n errCode:"  + dr.getErrCode() +
                               "\n errInfoText:" + dr.getErrInfoText());
         }
         e.printStackTrace();

      // Catch any other exception that may occur
      } catch (Exception e) {
         e.printStackTrace();
      }
   }
}
