/*
 * The source code contained herein is licensed under the IBM Public License   
 * Version 1.0, which has been approved by the Open Source Initiative.
 * Copyright (C) 2001, International Business Machines Corporation
 * All Rights Reserved.         
 * 
 */

import com.ibm.uddi.*;
import com.ibm.uddi.datatype.business.*;
import com.ibm.uddi.response.*;
import com.ibm.uddi.client.*;
import org.w3c.dom.Element;
import java.util.Vector;
import java.util.Properties;

/**
 * Very simple use of UDDI API. Invoke a inquiry API to
 * find all businesses starting with "S". 
 */
public class FindBusinessExample {
   public static void main (String args[]) {

      FindBusinessExample app = new FindBusinessExample();
      app.run();
      System.exit(0);
   }

   public void run() {
      // Construct a UDDIProxy object. Enables SSL support
      UDDIProxy proxy = new UDDIProxy();

      try {
         // Select the desired UDDI server node

         // The following values point to the IBM UDDI test site
         proxy.setInquiryURL("http://www-3.ibm.com/services/uddi/testregistry/inquiryapi");
         // proxy.setPublishURL("https://www-3.ibm.com/services/uddi/testregistry/protect/publishapi");

         // The following values point to the IBM UDDI test site
         // proxy.setInquiryURL("http://www-3.ibm.com/services/uddi/inquiryapi");
         // proxy.setPublishURL("https://www-3.ibm.com/services/uddi/protect/publishapi");

         // The following values point to the Microsoft UDDI test site
         // proxy.setInquiryURL("http://test.uddi.microsoft.com/inquire");
         // proxy.setPublishURL("https://test.uddi.microsoft.com/publish");

         // The following values point to the Microsoft UDDI official site
         // proxy.setInquiryURL("http://uddi.microsoft.com/inquire");
         // proxy.setPublishURL("https://uddi.microsoft.com/publish");

         // The following values for a locally installed test server
         // proxy.setInquiryURL("http://localhost:8080/services/uddi/servlet/uddi");
         // proxy.setInquiryURL("http://localhost:8080/services/uddi/servlet/uddi");

      } catch (Exception e) {
         e.printStackTrace();
      }
      try {

         // Find businesses who's name starts with S
         BusinessList bl = proxy.find_business("S", null, 0);

         Vector businessInfoVector  = bl.getBusinessInfos().getBusinessInfoVector();
         for (int i = 0; i < businessInfoVector.size(); i++) {
            BusinessInfo businessInfo = (BusinessInfo)businessInfoVector.elementAt(i);

            // Print name for each business
            System.out.println(businessInfo.getNameString());
         }

      // Handle possible errors
      } catch (UDDIException e) {
         DispositionReport dr = e.getDispositionReport();
         if (dr!=null) {
            System.out.println("UDDIException faultCode:" + e.getFaultCode() +
                               "\n operator:" + dr.getOperator() +
                               "\n generic:"  + dr.getGeneric() +
                               "\n errno:"    + dr.getErrno() +
                               "\n errCode:"  + dr.getErrCode() +
                               "\n errInfoText:" + dr.getErrInfoText());
         }
         e.printStackTrace();

      // Catch any other exception that may occur
      } catch (Exception e) {
         e.printStackTrace();
      }
   }
}
