/*
 * @(#)condvar_md.h	1.10 95/11/18
 *
 * Copyright (c) 1995 Sun Microsystems, Inc. All Rights Reserved.
 *
 * Permission to use, copy, modify, and distribute this software
 * and its documentation for NON-COMMERCIAL purposes and without
 * fee is hereby granted provided that this copyright notice
 * appears in all copies. Please refer to the file "copyright.html"
 * for further important copyright and licensing information.
 *
 * SUN MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF
 * THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
 * TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
 * PARTICULAR PURPOSE, OR NON-INFRINGEMENT. SUN SHALL NOT BE LIABLE FOR
 * ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR
 * DISTRIBUTING THIS SOFTWARE OR ITS DERIVATIVES.
 */

#ifndef	_WIN32_CONDVAR_MD_H_
#define	_WIN32_CONDVAR_MD_H_

#include <windows.h>
#include "bool.h"
#include "mutex_md.h"

/*
 * Condition variable object.
 */
typedef	struct condvar {
    HANDLE event;	    /* Manual-reset event for notifications */
    unsigned int counter;   /* Current number of notifications */
    unsigned int waiters;   /* Number of threads waiting for notification */
    unsigned int tickets;   /* Number of waiters to be notified */
} condvar_t;

bool_t	condvarInit(condvar_t *);
void	condvarDestroy(condvar_t *);
void	condvarWait(condvar_t *, mutex_t *);
void	condvarTimedWait(condvar_t *, mutex_t *, unsigned long);
bool_t	condvarSignal(condvar_t *);
bool_t	condvarBroadcast(condvar_t *);

#endif	/* !_WIN32_CONDVAR_MD_H_ */
