/*
 * @(#)interrupt_md.h	1.6 95/11/29  
 *
 * Copyright (c) 1994 Sun Microsystems, Inc. All Rights Reserved.
 *
 * Permission to use, copy, modify, and distribute this software
 * and its documentation for NON-COMMERCIAL purposes and without
 * fee is hereby granted provided that this copyright notice
 * appears in all copies. Please refer to the file "copyright.html"
 * for further important copyright and licensing information.
 *
 * SUN MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF
 * THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
 * TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
 * PARTICULAR PURPOSE, OR NON-INFRINGEMENT. SUN SHALL NOT BE LIABLE FOR
 * ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR
 * DISTRIBUTING THIS SOFTWARE OR ITS DERIVATIVES.
 */

/*
 * Solaris interrupts
 */

#ifndef	_SOLARIS_INTERRUPT_MD_H_
#define	_SOLARIS_INTERRUPT_MD_H_

/*
 * Header files.
 */
#include "bool.h"

/*
 * Number of interrupt channels.
 */
#define	N_INTERRUPTS	32	/* 0 to 31 */

/*
 * Routines/Macros that actually set/get the processor interrupt level.
 */
extern void 	intrLock(void);
extern void 	intrUnlock(void);
extern bool_t 	intrIsLocked(void);

#endif	/* !_SOLARIS_INTERRUPT_MD_H_ */
