/*****************************************************************************

       Copyright  1995, 1996 Digital Equipment Corporation,
                       Maynard, Massachusetts.

                        All Rights Reserved

Permission to use, copy, modify, and distribute this software and its 
documentation for any purpose and without fee is hereby granted, provided  
that the copyright notice and this permission notice appear in all copies  
of software and supporting documentation, and that the name of Digital not  
be used in advertising or publicity pertaining to distribution of the software 
without specific, written prior permission. Digital grants this permission 
provided that you prominently mark, as not part of the original, any 
modifications made to this software or documentation.

Digital Equipment Corporation disclaims all warranties and/or guarantees  
with regard to this software, including all implied warranties of fitness for 
a particular purpose and merchantability, and makes no representations 
regarding the use of, or the results of the use of, the software and 
documentation in terms of correctness, accuracy, reliability, currentness or
otherwise; and you rely on the software, documentation and results solely at 
your own risk. 

******************************************************************************/
#include <alpha/regdef.h>
#include <asm/system.h>
#include <linux/config.h>
#include "autoconf.h"

#ifdef CALL_PAL_BROKEN
#define call_pal	.long
#endif

/* Here are some VMS PALcode functions that we need in order to
 * switch to OSF PALcode...
 */

#define PAL_mfpr_pcbb    0x12
#define PAL_ldqp	 0x03
#define PAL_stqp	 0x04
#define PAL_halt_entry	 0x00
#define PAL_cserve_entry 0x09
#define SWPPAL		 10

	.set	noreorder
	.set	noat

#if defined(__linux__) && !defined(__ELF__)
	.set singlegp
#endif

#if 0
/*
 *  Entry point for when we've jumped to the new palcode inside the
 *  miniloader.
 */
	.globl	__start_again
	.ent	__start_again
__start_again:
#if 0
	br	t0,3f			# offset 4
	.quad	_gp			# offset 8
3:	ldq	gp,0(t0)		# offset 16
#else
	br	t0,3f
3:	ldgp	gp,0(t0)
#endif
/*
 *  Zero a few arguments and jump into boot_main_again().
 */
	bis	zero,zero,a0
	bis	zero,zero,a1
	bis	zero,zero,a2

	jsr	ra, boot_main_cont

	call_pal PAL_halt
	.end 	__start_again
#endif

	.globl	imb
	.ent	imb
imb:
	call_pal	PAL_imb
	ret	zero,(ra)
	.end	imb

	.globl	entMM
	.ent	entMM
entMM:	br	zero,entMM
	br	gp,1f
1:	ldgp	gp,0(gp)
	lda	sp,-8(sp)
	stq	ra,0(sp)
	ldq	a3,8(sp)
	ldq	a4,16(sp)
	ldq	a5,24(sp)
	jsr	ra,do_entMM
	ldq	ra,0(sp)
	lda	sp,8(sp)
	ret	zero,(ra)
	.end	entMM

	.globl	entIF
	.ent	entIF
entIF:	subq	a0,3,a0		# If a0 == 3, this is an FEN fault.  
	beq	a0,1f		# Try setting FEN to 1 and trying again...
	call_pal	PAL_halt
1:	lda	sp,-48(sp)
	stq	a0,0(sp)
	stq	t0,8(sp)
	stq	t8,16(sp)
	stq	t9,24(sp)
	stq	t10,32(sp)
	stq	t11,40(sp)
	lda	a0,1(zero)
	call_pal	PAL_wrfen
	ldq	a0,0(sp)
	ldq	t0,8(sp)
	ldq	t8,16(sp)
	ldq	t9,24(sp)
	ldq	t10,32(sp)
	ldq	t11,40(sp)
	lda	sp,48(sp)
	call_pal	PAL_rti

	.end	entIF



.align 3
.globl	entUna
.ent	entUna
entUna:
	lda $30,-256($30)
	stq $0,0($30)
	stq $1,8($30)
	stq $2,16($30)
	stq $3,24($30)
	stq $4,32($30)
	stq $5,40($30)
	stq $6,48($30)
	stq $7,56($30)
	stq $8,64($30)
	stq $9,72($30)
	stq $10,80($30)
	stq $11,88($30)
	stq $12,96($30)
	stq $13,104($30)
	stq $14,112($30)
	stq $15,120($30)
	/* 16-18 PAL-saved */
	stq $19,152($30)
	stq $20,160($30)
	stq $21,168($30)
	stq $22,176($30)
	stq $23,184($30)
	stq $24,192($30)
	stq $25,200($30)
	stq $26,208($30)
	stq $27,216($30)
	stq $28,224($30)
	stq $29,232($30)
	stq $30,240($30)
	stq $31,248($30)
#if 0
	bis	zero,zero,zero		# spacer
	br	t0,1f			# offset 4
	.quad	_gp			# offset 8
1:	ldq	gp,0(t0)		# offset 16
#else
	br	t0,1f
1:	ldgp	gp,0(t0)
#endif
	lda $27,do_entUna
	jsr $26,($27),do_entUna
	ldq $0,0($30)
	ldq $1,8($30)
	ldq $2,16($30)
	ldq $3,24($30)
	ldq $4,32($30)
	ldq $5,40($30)
	ldq $6,48($30)
	ldq $7,56($30)
	ldq $8,64($30)
	ldq $9,72($30)
	ldq $10,80($30)
	ldq $11,88($30)
	ldq $12,96($30)
	ldq $13,104($30)
	ldq $14,112($30)
	ldq $15,120($30)
	/* 16-18 PAL-saved */
	ldq $19,152($30)
	ldq $20,160($30)
	ldq $21,168($30)
	ldq $22,176($30)
	ldq $23,184($30)
	ldq $24,192($30)
	ldq $25,200($30)
	ldq $26,208($30)
	ldq $27,216($30)
	ldq $28,224($30)
	ldq $29,232($30)
	ldq $30,240($30)
	lda $30,256($30)
	call_pal	PAL_rti
.end entUna

/*
 * These offsets must match with "struct hae" in io.h:	
 */
#define HAE_CACHE	0
#define HAE_REG		8

/*
 * This defines the normal kernel pt-regs layout.
 *
 * regs 9-15 preserved by C code
 * regs 16-18 saved by PAL-code
 * regs 29-30 saved and set up by PAL-code
 */
#define SAVE_ALL			\
	subq	$30,160,$30;		\
	stq	$0,0($30);		\
	stq	$1,8($30);		\
	stq	$2,16($30);		\
	stq	$3,24($30);		\
	stq	$4,32($30);		\
	stq	$5,40($30);		\
	stq	$6,48($30);		\
	stq	$7,56($30);		\
	stq	$8,64($30);		\
	stq	$19,72($30);		\
	stq	$20,80($30);		\
	stq	$21,88($30);		\
	stq	$22,96($30);		\
	stq	$23,104($30);		\
	stq	$24,112($30);		\
	stq	$25,120($30);		\
	stq	$26,128($30);		\
	stq	$27,136($30);		\
	stq	$28,144($30);		\
	lda	$2,hae;			\
	ldq	$2,HAE_CACHE($2);	\
	stq	$2,152($30)

#define RESTORE_ALL			\
	lda	$8,hae;			\
	ldq	$7,HAE_CACHE($8);	\
	ldq	$6,152($30);		\
	subq	$7,$6,$5;		\
	beq	$5,99f;			\
	ldq	$7,HAE_REG($8);		\
	stq	$6,HAE_CACHE($8);	\
	stq	$6,0($7);		\
	mb;				\
99:;					\
	ldq	$0,0($30);		\
	ldq	$1,8($30);		\
	ldq	$2,16($30);		\
	ldq	$3,24($30);		\
	ldq	$4,32($30);		\
	ldq	$5,40($30);		\
	ldq	$6,48($30);		\
	ldq	$7,56($30);		\
	ldq	$8,64($30);		\
	ldq	$19,72($30);		\
	ldq	$20,80($30);		\
	ldq	$21,88($30);		\
	ldq	$22,96($30);		\
	ldq	$23,104($30);		\
	ldq	$24,112($30);		\
	ldq	$25,120($30);		\
	ldq	$26,128($30);		\
	ldq	$27,136($30);		\
	ldq	$28,144($30);		\
	addq	$30,160,$30

	.text


	.align 3
	.globl	entInt
	.ent	entInt
entInt:
	/* set up the gp */
	br gp,entInt2
entInt2:
	ldgp gp,0(gp)

	SAVE_ALL

	lda	$27,do_entInt
	jsr	$26,($27),do_entInt

	RESTORE_ALL

	call_pal	PAL_rti
	.end entInt


	.align 3
	.globl	wrent
	.ent	wrent
wrent:
	call_pal	PAL_wrent
	ret ($26)
	.end wrent

	.globl	halt
	.ent	halt 2
halt:
	.option	O1
	.frame	sp, 0, ra
	call_pal PAL_halt_entry
	ret	zero, (ra)
	.end	halt


	.globl  rdsp
	.ent	rdsp
rdsp:
	.option O1
	.frame sp, 0, ra
	bis sp, zero, v0
	ret	zero, (ra)
	.end rdsp

	.globl  wrsp
	.ent	wrsp
wrsp:
	.option O1
	.frame sp, 0, ra
	bis a0, zero, sp
	ret	zero, (ra)
	.end wrsp

	.globl	cServe
	.ent	cServe 2
cServe:
	.option	O1
	.frame	sp, 0, ra
	call_pal PAL_cserve_entry
	ret	zero, (ra)
	.end	cServe


