/*****************************************************************************

       Copyright  1995, 1996 Digital Equipment Corporation,
                       Maynard, Massachusetts.

                        All Rights Reserved

Permission to use, copy, modify, and distribute this software and its 
documentation for any purpose and without fee is hereby granted, provided  
that the copyright notice and this permission notice appear in all copies  
of software and supporting documentation, and that the name of Digital not  
be used in advertising or publicity pertaining to distribution of the software 
without specific, written prior permission. Digital grants this permission 
provided that you prominently mark, as not part of the original, any 
modifications made to this software or documentation.

Digital Equipment Corporation disclaims all warranties and/or guarantees  
with regard to this software, including all implied warranties of fitness for 
a particular purpose and merchantability, and makes no representations 
regarding the use of, or the results of the use of, the software and 
documentation in terms of correctness, accuracy, reliability, currentness or
otherwise; and you rely on the software, documentation and results solely at 
your own risk. 

******************************************************************************/
/*
 *  Milo: file system support
 *
 *  david.rusling@reo.mts.dec.com
 */
#include <linux/kernel.h>
#include <linux/config.h>
#include <linux/string.h>
#include <linux/mm.h>
#include <linux/kernel_stat.h>
#include <linux/pci.h>
#include <linux/bios32.h>
#include <linux/version.h>

#include <asm/system.h>
#include <asm/io.h>
#include <asm/console.h>
#include <asm/hwrpb.h>
#include <asm/page.h>
#include <asm/pgtable.h>

#include <stdarg.h>

#include "milo.h"
#include "fs.h"

#ifndef NULL
#define NULL ((void *)0)
#endif

extern struct bootfs ext2fs;
extern struct bootfs iso9660fs;
extern struct bootfs msdosfs;

static struct bootfs *bootfs[] = {
	&ext2fs,
	&iso9660fs,
	&msdosfs,
};

#define NUM_MILO_FS (sizeof(bootfs) / sizeof(struct bootfs *))

struct bootfs *milo_open_fs = NULL;

char *fs_type_to_name(int type)
{
  return bootfs[type]->name ;
}

int fs_name_to_type(char *name)
{
  int i;

  for (i=0; i < NUM_MILO_FS; i++)
    if (strcmp(bootfs[i]->name, name) == 0) return i;

  return -1;
}

int fs_mount(char *fs_type, unsigned long device)
{
  int fs;

  fs = fs_name_to_type(fs_type);
  if (fs < 0) {
    printk("MILO: file system %s not supported\n", fs_type);
    return 0;
  }

  milo_open_fs = bootfs[fs];
  return (milo_open_fs->mount)((device));
}

void show_known_fs(void)
{
  int i;

  printk("File systems:\n    ");
  for (i=0; i < NUM_MILO_FS; i++)
    printk("%s ", bootfs[i]->name);
  printk("\n");

}
