# 1 "osfpal.S"























































































































































        .data
        .asciz "$Id: osfpal.s,v 2.12 1995/02/27 18:12:48 samberg Exp $"


# 1 "dc21064.h" 1






















































































































































































































































































































































































































































































































































































































































































































































# 156 "osfpal.S" 2

# 1 "osf.h" 1





































































































































































































































































# 275 "osf.h"

















































































					
					
					




































































































































# 157 "osfpal.S" 2

# 1 "macros.h" 1

































































































































# 158 "osfpal.S" 2

# 1 "impure.h" 1













































































































































































































































# 272 "impure.h"













# 329 "impure.h"










# 403 "impure.h"












# 433 "impure.h"










# 475 "impure.h"

# 159 "osfpal.S" 2





























        .global pal_mchk_logout
	.global pal_mchk_kernel_mode_trap
	.global pal_interrupt_post
	.global	pal_lockCell
	.global pal_impure

	.global sys_mchk
	.global sys_mchk_logout
	.global sys_crd_logout
	.global sys_scrub_mem
	.global sys_interrupt
	.global	sys_cflush
	.global sys_cserve
	.global sys_enter_console
	.global sys_reset
	.global sys_reset_swppal
















































	.text	0
	. = 0x0000

pal_base:































































 
	. = 0x0000

pal_reset:
	hw_mtpr	$1, (1<<7) + 0x0			// Save $1.
	br	$1, pal_reset_cont	// Branch over static data.

pvc$osf46$1003:				// Ignore bogus PVC halt violation.
pal_lockCell:
	.long	0			// Lock cell for LDL/STC.
	.long	(2<<8) | (8<<0)
	.long	(0<<0)
	.long	0	
	.long	pal_impure              // Pointer to impure scratch area.
        .long   0































 
	. = 0x0020

pal_mchk:





	hw_mtpr	$31, (1<<6) + 0x15		// flush the icache
	hw_mtpr    $31, 0				// stall for flush
	hw_mtpr    $31, 0
	hw_mtpr    $31, 0
	hw_mtpr    $31, 0
	hw_mtpr    $31, 0
	hw_mtpr    $31, 0
	hw_mtpr    $31, 0
	hw_mtpr    $31, 0

	hw_mtpr	$31, (1<<6) + 0xF		// make sure alt_mode is KERNEL mode
	br	$31, pal_mchk_cont	// continue elsewhere































 
	. = 0x0060

pal_arith:
	hw_mtpr	$1, (1<<7) + 0x0                 // save $1
	hw_mfpr	$1, (1<<5) + 0x4		// get pc
	hw_mtpr	$2, (1<<7) + 0x1                 // save $2
	hw_mfpr	$2, (1<<7) + 0x9			// get shadow copy of (1<<5) + 0x9
	blbs	$1, pal_mchk_pal 	// check for arith trap in PAL mode
	subq	$1, 2, $1		// start to get pc-4 when exc_addr<1>=0
	hw_mtpr	$4, (1<<7) + 0x3			// save $4
	bic	$1, 2, $1		// finish getting pc-4
	hw_mfpr	$4, (1<<6) + 0x5			// unlock mbox

	sll	    $2, 63-3, $2;	bge	    $2, 0f;	hw_mtpr    $30, (1<<7) + 0x12;	hw_mfpr    $30, (1<<7) + 0x13;	hw_mtpr    $31, (1<<7) + (1<<5) + 0x9;	0:  srl	    $2, 63-3, $2;	lda	    $30, 0-48($30); hw_stq/a   $2, 0x0000($30);	hw_stq/a   $1, 0x0008($30);	hw_stq/a   $29, 0x0010($30);	hw_stq/a   $16, 0x0018($30);	hw_stq/a   $17, 0x0020($30);	hw_stq/a   $18,	0x0028($30)	// build the stack frame

 	hw_mfpr	$1, (1<<5) + 0xA		// get the exc_sum, plus F31 (always 0)
	bis	$31, 63, $2		// get a counter
	hw_mtpr	$31, (1<<5) + 0xA		// clear so we just get MSK on read

	bis	$31, $31, $17		// clear register accumulator
	srl	$1, 2, $16	// shift exception summary into $16

	bis	$31, $31, $1		// F31 never traps so always 0
	br	$31, pal_arith_cont	// continue flow elsewhere ...

































 
	. = 0x00E0

pal_interrupt:
	hw_mtpr	$4, (1<<7) + 0x3                 // Save $4.
	hw_mfpr	$4, (1<<5) + 0xC		// Get pending interrupt requests.
	hw_mtpr	$2, (1<<7) + 0x1                 // Save $2.
	hw_mfpr	$2, (1<<5) + 0x10		// Get hardware interrupt enables.
	hw_mtpr	$1, (1<<7) + 0x0                 // Save $1
	hw_mfpr	$1, (1<<7) + 0x9			// Get shadow copy of PS.

	and	$2, $4, $4		// Only check requests that are enabled.
	hw_mfpr	$2, (1<<6) + 0x5			// Unlock mbox (which is lower priorty).
	beq	$4, 1f                  // Check for a passive release.
	hw_mfpr	$2, (1<<5) + 0x4		// Get PC.
	bic	$2, 3, $2		// Clear PC<1:0> bits.

	sll	    $1, 63-3, $1;	bge	    $1, 0f;	hw_mtpr    $30, (1<<7) + 0x12;	hw_mfpr    $30, (1<<7) + 0x13;	hw_mtpr    $31, (1<<7) + (1<<5) + 0x9;	0:  srl	    $1, 63-3, $1;	lda	    $30, 0-48($30); hw_stq/a   $1, 0x0000($30);	hw_stq/a   $2, 0x0008($30);	hw_stq/a   $29, 0x0010($30);	hw_stq/a   $16, 0x0018($30);	hw_stq/a   $17, 0x0020($30);	hw_stq/a   $18,	0x0028($30)







	and	$4, (1<<4), $2
	bne	$2, pal_crd_handler



        lda     $2, ((1<<9) | (1<<8))($31)
        and     $4, $2, $2
        bne     $2, pal_pc_handler



	br	$31, sys_interrupt



        .align  3

1:	hw_mfpr	$4, (1<<7) + 0x3			// Restore scratch registers.
	hw_mfpr	$2, (1<<7) + 0x1
	hw_mfpr	$1, (1<<7) + 0x0			
	hw_rei				// Dismiss the interrupt.



































	. = 0x01E0

pal_dtb_fault:
	hw_mtpr	$4, (1<<7) + 0x3			// Save $4.
	hw_mtpr	$5, (1<<7) + 0x4			// Save $5.
	hw_mtpr	$6, (1<<7) + 0x5			// Save $6.
	hw_mtpr	$7, (1<<7) + 0x6			// Save $7.
	hw_mfpr	$4, (1<<6) + 0x5			// Get the VA of faulting reference.
	hw_mfpr	$5, (1<<6) + 0x4		// Get the memory mgmt status.
	hw_mfpr	$7, (1<<5) + 0x4		// Get the PC of faulting instruction.
	srl	$5, 9, $6	// Get opcode of faulting instruction.
	blbs	$7, 2f			// Check for faults in PAL mode.
	cmpeq	$6, 0x18, $6		// Is this a FETCH[_M] instruction?
	bne	$6, 1f			// If so, ignore.
	hw_mfpr	$6, (1<<7) + 0x9			// Get the current processor status.

	sll	    $6, 63-3, $6;	bge	    $6, 0f;	hw_mtpr    $30, (1<<7) + 0x12;	hw_mfpr    $30, (1<<7) + 0x13;	hw_mtpr    $31, (1<<7) + (1<<5) + 0x9;	0:  srl	    $6, 63-3, $6;	lda	    $30, 0-48($30); hw_stq/a   $6, 0x0000($30);	hw_stq/a   $7, 0x0008($30);	hw_stq/a   $29, 0x0010($30);	hw_stq/a   $16, 0x0018($30);	hw_stq/a   $17, 0x0020($30);	hw_stq/a   $18,	0x0028($30)

	bis	$31, $4, $16		// Move VA of faulting reference to $16.
	and	$5, 0x000E, $6	// Isolate MM_CSR fault bits.
	srl	$6, 1, $6		// Get fault bits into correct position.
	and	$5, (1<<1), $4	// Check for access violation.
	cmovne	$4, 0x1, $6	// Resolve fault - ACV overrides FOx.
	bis	$31, $6, $17		// Move MM fault code to $17.
	and	$5, (1<<0), $18	// Establish read or write reference.
	hw_mfpr	$7, (1<<7) + 0xD		// Get kernel MM fault handler entry.
	hw_mfpr	$4, (1<<7) + 0x3			// Restore scratch registers.
	hw_mfpr	$5, (1<<7) + 0x4
	hw_mfpr	$6, (1<<7) + 0x5
	hw_mtpr	$7, (1<<5) + 0x4		// Establish kernel entry point address.
	hw_mfpr	$29, (1<<7) + 0x14		// Load the kernel global pointer.
	hw_mfpr	$7, (1<<7) + 0x6			// Restore $7.
	hw_rei				// Transfer to kernel MM fault handler.







	.align  3

1:	addq	$7, 4, $7		// Increment past FETCH[_M] instruction.
	hw_mfpr	$6, (1<<6) + 0x5			// Unlock VA.
	hw_mtpr	$7, (1<<5) + 0x4		// Load new PC address.
	hw_mfpr	$4, (1<<7) + 0x3			// Restore scratch registers.
	hw_mfpr	$5, (1<<7) + 0x4
	hw_mfpr	$6, (1<<7) + 0x5
	hw_mfpr	$7, (1<<7) + 0x6
	hw_rei				// Resume execution.
















	.align  3

2:	xor	$6, 0x1b, $6		// Is this a HW_LD?
	bne	$6, pal_mchk_ksp_not_valid // If not, must be ksp problem.
	br	$31, pal_mchk_pal	// Page table ACV or FOx.







































	. = 0x03E0

pal_itb_miss:
	hw_mtpr	$4, (1<<7) + 0x3			// Save $4.
 	hw_mfpr	$4, (1<<5) + 0x4		// Get the (1<<6) + 0x5 of target reference.
	hw_mtpr	$5, (1<<7) + 0x4			// Save $5.
	hw_mfpr	$5, (1<<7) + 0x1D		// Get the virtual page table pointer.
	hw_mtpr	$6, (1<<7) + 0x5			// Save $6.
	sll	$4, 64-43, $6	// Clear out sign extension bits of (1<<6) + 0x5.
	srl	$6, 64-43+13-3, $6	// Clear all but 3 offset bits.
        blbs    $5, 1f                  // If physical mode, map (1<<6) + 0x5->pa 1-to-1.
	or	$6, $5, $6		// Form virtual address of Level 3 PTE.
	bis	$31, $31, $5		// Clear $5 to indicate I-stream.
	hw_mtpr	$7, (1<<7) + 0x6			// Save $7.
	hw_mfpr	$7, (1<<5) + 0x4		// Save exception address.
	hw_ldq/a	$6, 0($6)		// Read the Level 3 PTE (may fault).
	blbc	$6, pal_pte_invalid	// Check for invalid PTE.
	and	$6, (1<<3), $5	// Isolate the Fault On Execute bit.
	bne	$5, pal_itb_foe		// Check for Fault On Execute.
	hw_mtpr	$4, (1<<5) + 0x0		// Write the tag.
	hw_mtpr	$6, (1<<6) + 0x0		// Select large or small page size.
	hw_mtpr	$7, (1<<5) + 0x4		// Restore the exception address.
	hw_mtpr	$6, (1<<5) + 0x1		// Write the PTE into the TB.
	hw_mfpr	$4, (1<<7) + 0x3			// Restore scratch registers.
	hw_mfpr	$5, (1<<7) + 0x4
	hw_mfpr	$6, (1<<7) + 0x5
	hw_mfpr	$7, (1<<7) + 0x6
	hw_rei				// Return and try access again.



        .align  3        

1:	sll	$4, 32-13, $5 // Fabricate PFN.
	lda	$6, 0x3371($31)	// Fabricate protection bits.
	or	$6, $5, $6		// Form PTE.
	hw_mtpr	$4, (1<<5) + 0x0		// Write the tag.	
	hw_mtpr	$6, (1<<6) + 0x0		// Select large or small page size.
	hw_mtpr	$4, (1<<5) + 0x4		// Restore the exception address.
	hw_mtpr	$6, (1<<5) + 0x1		// Write PTE into the TB and set valid.
	hw_mfpr	$4, (1<<7) + 0x3			// Restore scratch registers.
	hw_mfpr	$5, (1<<7) + 0x4
	hw_mfpr	$6, (1<<7) + 0x5
	hw_rei				// Return and try access again.

































	. = 0x07E0

pal_itb_acv:
	hw_mtpr	$4, (1<<7) + 0x3			// Save $4.
	hw_mfpr	$4, (1<<7) + 0x9			// Get the current processor status.
	hw_mtpr	$5, (1<<7) + 0x4			// Save $5.
	hw_mfpr	$5, (1<<5) + 0x4		// Get the VA of target reference.
	bic	$5, 3, $5		// Clean PC of faulting instruction.

	sll	    $4, 63-3, $4;	bge	    $4, 0f;	hw_mtpr    $30, (1<<7) + 0x12;	hw_mfpr    $30, (1<<7) + 0x13;	hw_mtpr    $31, (1<<7) + (1<<5) + 0x9;	0:  srl	    $4, 63-3, $4;	lda	    $30, 0-48($30); hw_stq/a   $4, 0x0000($30);	hw_stq/a    $5, 0x0008($30);	hw_stq/a   $29, 0x0010($30);	hw_stq/a   $16, 0x0018($30);	hw_stq/a   $17, 0x0020($30);	hw_stq/a   $18,	0x0028($30)

	bis	$31, $5, $16		// Move VA of faulting instruction to $16
	lda	$17, 0x1($31)	// Indicate ACV fault in $17.
	subq	$31, 1, $18		// Indicate I-fetch reference in $18.
	hw_mfpr	$5, (1<<7) + 0xD		// Get the kernel MM fault handler entry
	hw_mfpr	$4, (1<<7) + 0x3			// Restore $4.
	hw_mtpr	$5, (1<<5) + 0x4		// Establish kernel entry point address.
	hw_mfpr	$29, (1<<7) + 0x14		// Load the kernel global pointer.
	hw_mfpr	$5, (1<<7) + 0x4			// Restore $5.
	hw_rei				// Transfer to kernel MM fault handler.



































 
	. = 0x08E0

pal_ndtb_miss:
	hw_mtpr	$4, (1<<7) + 0x3			// Save $4.
	hw_mfpr	$4, (1<<6) + 0x5			// Get the (1<<6) + 0x5 of target reference.
	hw_mtpr	$5, (1<<7) + 0x4			// Save $5.
	hw_mfpr	$5, (1<<7) + 0x1D		// Get the virtual page table pointer.
	hw_mtpr	$6, (1<<7) + 0x5			// Save $6.
	sll	$4, 64-43, $6	// Clear out sign extension bits of (1<<6) + 0x5.
	srl	$6, 64-43+13-3, $6 // Clear all but 3 offset bits.
        blbs    $5, 1f        		// If physical mode, map (1<<6) + 0x5->pa 1-to-1.
	hw_mtpr	$7, (1<<7) + 0x6			// Save $7.
	or	$6, $5, $6		// Form virtual address of Level 3 PTE.
	hw_mfpr	$5, (1<<6) + 0x4		// Save MM_CSR in case we fault.
	hw_mfpr	$7, (1<<5) + 0x4		// Save the exception address.
	hw_ldq/a	$6, 0($6)		// Read the Level 3 PTE (may fault).
	blbc	$6, pal_pte_invalid	// Check for TNV or ACV violation.
	hw_mtpr	$7, (1<<5) + 0x4		// Restore the exception address.
	hw_mtpr	$4, (1<<5) + 0x0		// Set up the tag.
	hw_mtpr	$6, (1<<6) + 0x0		// Select large or small page size.
	hw_mtpr	$6, (1<<6) + 0x2		// Write PTE into the TB and set valid.
	hw_mfpr	$4, (1<<7) + 0x3			// Restore scratch registers.
	hw_mfpr	$5, (1<<7) + 0x4
	hw_mfpr	$6, (1<<7) + 0x5
	hw_mfpr	$7, (1<<7) + 0x6
	hw_rei				// Return and try access again.



        .align  3

1:	sll	$4, 32-13, $5 // Fabricate PFN.
	lda	$6, 0x3371($31)	// Fabricate protection bits.
	or	$6, $5, $6		// Form PTE.
	hw_mtpr	$4, (1<<5) + 0x0		// Set up the tag.
	hw_mtpr	$6, (1<<6) + 0x0		// Select large or small page size.
	hw_mtpr	$6, (1<<6) + 0x2		// Write PTE into the TB and set valid.
	hw_mfpr	$4, (1<<7) + 0x3			// Restore scratch registers.
	hw_mfpr	$5, (1<<7) + 0x4
	hw_mfpr	$6, (1<<7) + 0x5
	hw_rei				// Return and try access again.





















































	. = 0x09E0

pal_pdtb_miss:
	hw_mtpr	$8, (1<<7) + 0x17		// Save $8.
	hw_mfpr	$8, (1<<6) + 0x5			// Get the (1<<6) + 0x5 of faulting reference.
	hw_mtpr	$22, (1<<7) + 0x8			// Save $22.
	hw_mfpr	$22, (1<<7) + 0x1C		// Get the page table base.
	hw_mtpr	$25, (1<<7) + 0x15		// Save $25.
	blbs	$22, 3f			// If physical mode, map (1<<6) + 0x5->pa 1-to-1.
















	sll	$8, 64-(3*10+13), $25 // Clear out upper bits of (1<<6) + 0x5.
	srl	$25, 61-10, $25	// Get 8 * VA<SEG1>.
	addq	$25, $22, $22		// Form address of L1PTE.
	hw_ldq/p	$22, 0($22)		// Read (physical) L1PTE.
	blbc	$22, 1f			// Check if L1PTE not valid.











	sll	$8, 64-(2*10+13), $25 // Clear out upper bits of (1<<6) + 0x5.
	srl	$25, 61-10, $25	// Get 8 * VA<SEG2>.
	srl	$22, 32, $22	// Extract Level 1 PFN.
	sll	$22, 13, $22	// L1PTE<PFN> * PageSize.
	addq	$25, $22, $22		// Form address of L2PTE.
	hw_ldq/p	$22, 0($22)		// Read (physical) L2PTE.
	blbc	$22, 2f			// Check if L2PTE not valid.










	sll	$8, 64-(1*10+13), $25 // Clear out upper bits of (1<<6) + 0x5.
	srl	$25, 61-10, $25	// Get 8 * VA<SEG3>.
	srl	$22, 32, $22	// Extract Level 2 PFN.
	sll	$22, 13, $22	// L2PTE<PFN> * PageSize
	addq	$25, $22, $22		// Form address of L3PTE.
	hw_ldq/p	$22, 0($22)		// Read (physical) L3PTE.
	blbc	$22, 2f			// Check if L3PTE not valid.








	hw_mtpr	$8, (1<<5) + 0x0		// Load tag and clear TB valid bit.
	hw_mtpr	$22, (1<<6) + 0x0		// Select large or small page size.
	hw_mtpr	$22, (1<<6) + 0x2		// Write L3PTE into TB and set valid.
	hw_mfpr	$8, (1<<7) + 0x17		// Restore scratch registers.
	hw_mfpr	$22, (1<<7) + 0x8
	hw_mfpr	$25, (1<<7) + 0x15
	hw_rei				// Return and try access again.	








	.align  3		// Align on quadword boundary.

1:	hw_mfpr	$25, (1<<6) + 0x4		// Get MM_CSR.
	srl	$25, 9, $25	// Get opcode of faulting instruction.
	xor	$25, 0x1b, $25		// Is this a HW_LD?
	bne	$25, pal_mchk_ksp_not_valid // If not, must be ksp problem.
	hw_mfpr	$6, (1<<7) + 0x5			// Restore $6.
	br	$31, pal_mchk_pal	// Page tables are messed up.













	.align  3		// Align on quadword boundary

2:	hw_mfpr	$25, (1<<6) + 0x4		// Get MM_CSR.
	hw_mfpr	$8, (1<<5) + 0x4		// Get PC of the faulting instruction.
	srl	$25, 9, $25	// Get opcode of faulting instruction.
	xor	$25, 0x1b, $25		// Is this a HW_LD?
	bne	$25, pal_mchk_ksp_not_valid // If not, must be ksp problem.
	addq	$8, 4, $8		// Kick PC past faulting instruction.
	hw_mtpr	$8, (1<<5) + 0x4		// Set up for return to native TB miss.
	lda	$6, 0x3300($31)	// Make 'fake' PTE with prot. bits set.
	srl	$22, 8, $22	// Get Level 2/3 PTE<KRE> into lsb.
	cmovlbc	$22, $31, $6		// If KRE clear, force ACV upon return.
	hw_mfpr	$8, (1<<7) + 0x17		// Restore scratch registers.
	hw_mfpr	$22, (1<<7) + 0x8
	hw_mfpr	$25, (1<<7) + 0x15
	hw_rei				// Return back to native TB miss flow.



        .align  3

3:	sll	$8, 32-13, $25 // Fabricate PFN.
	lda	$22, 0x3371($31)	// Fabricate protection bits.
	or	$22, $25, $22		// Form PTE.
	hw_mtpr	$8, (1<<5) + 0x0		// Set up the tag.
	hw_mtpr	$22, (1<<6) + 0x0		// Select large or small page size.
	hw_mtpr	$22, (1<<6) + 0x2		// Write PTE into the TB and set valid.
	hw_mfpr	$8, (1<<7) + 0x17		// Restore scratch registers.
	hw_mfpr	$22, (1<<7) + 0x4
	hw_mfpr	$25, (1<<7) + 0x15
	hw_rei				// Return and try access again.

































	. = 0x11E0

pal_unalign:
	hw_mtpr	$1, (1<<7) + 0x0                 // save $1		
	hw_mfpr	$1, (1<<7) + 0x9			// get shadow osf (1<<5) + 0x9
	hw_mtpr	$2, (1<<7) + 0x1                 // save $2
	hw_mfpr	$2, (1<<5) + 0x4		// get pc
	hw_mtpr	$5, (1<<7) + 0x4                 // save $5
	hw_mfpr	$5, (1<<6) + 0x4		// get the mm_csr
	hw_mtpr	$4, (1<<7) + 0x3                 // save $4
	hw_mfpr	$4, (1<<6) + 0x5			// get the (1<<6) + 0x5
	blbs	$2, pal_mchk_pal	// unalign from PAL?
	addq	$2, 4, $2		// point to instruction past unalign
	bic	$2, 3, $2		// clean pc

	sll	    $1, 63-3, $1;	bge	    $1, 0f;	hw_mtpr    $30, (1<<7) + 0x12;	hw_mfpr    $30, (1<<7) + 0x13;	hw_mtpr    $31, (1<<7) + (1<<5) + 0x9;	0:  srl	    $1, 63-3, $1;	lda	    $30, 0-48($30); hw_stq/a   $1, 0x0000($30);	hw_stq/a   $2, 0x0008($30);	hw_stq/a   $29, 0x0010($30);	hw_stq/a   $16, 0x0018($30);	hw_stq/a   $17, 0x0020($30);	hw_stq/a   $18,	0x0028($30)

	bis	$4, $31, $16		// pass (1<<6) + 0x5 in $16
	srl	$5, 9, $17	// pass opcode in $17
	srl	$5, 4, $18 	// pass $26 in $18
	hw_mfpr	$1, (1<<7) + 0XE		// get (1<<6) + 0x5 of service routine
	and	$18, 0x1f, $18		// clean $26 to five bits
	hw_mfpr	$2, (1<<7) + 0x1                 // restore $2
	hw_mfpr	$29, (1<<7) + 0x14		// get the kernel $29
	hw_mfpr	$5, (1<<7) + 0x4	                // restore $5
	hw_mtpr	$1, (1<<5) + 0x4		// load (1<<6) + 0x5 of service routine
	hw_mfpr	$1, (1<<7) + 0x0                 // restore scratch registers
	hw_mfpr	$4, (1<<7) + 0x3
	hw_rei				// out to service routine


































	. = 0x13E0

pal_opcdec:
	hw_mtpr	$2, (1<<7) + 0x1			// save $2
	hw_mfpr	$2, (1<<5) + 0x4		// get pc
	hw_mtpr	$1, (1<<7) + 0x0			// save $1
	hw_mfpr	$1, (1<<7) + 0x9			// get shadow copy of (1<<5) + 0x9
	blbs	$2, pal_mchk_pal	// opcDec from PAL?
	addq	$2, 4, $2		// point to instruction past opcDec
	bic	$2, 3, $2		// clean pc

	sll	    $1, 63-3, $1;	bge	    $1, 0f;	hw_mtpr    $30, (1<<7) + 0x12;	hw_mfpr    $30, (1<<7) + 0x13;	hw_mtpr    $31, (1<<7) + (1<<5) + 0x9;	0:  srl	    $1, 63-3, $1;	lda	    $30, 0-48($30); hw_stq/a   $1, 0x0000($30);	hw_stq/a   $2, 0x0008($30);	hw_stq/a   $29, 0x0010($30);	hw_stq/a   $16, 0x0018($30);	hw_stq/a   $17, 0x0020($30);	hw_stq/a   $18,	0x0028($30)

	hw_mfpr	$1, (1<<7) + 0x10		// get address of service routine
	bis	$31, 4, $16		// flag as opcDec
	hw_mtpr	$1, (1<<5) + 0x4		// set (1<<6) + 0x5 of service routine
	hw_mfpr	$2, (1<<7) + 0x1			// restore scratch registers
	hw_mfpr	$1, (1<<7) + 0x0
	hw_mfpr	$29, (1<<7) + 0x14		// get the kernel $29
	hw_rei				// out to instruction fault handler


































	. = 0x17E0

pal_fen:
	hw_mtpr	$2, (1<<7) + 0x1                 // save $2
	hw_mfpr	$2, (1<<5) + 0x4		// get pc
	hw_mtpr	$1, (1<<7) + 0x0			// save $1
	hw_mfpr	$1, (1<<7) + 0x2			// get (1<<5) + 0x2 for copy of fen
	blbs	$2, pal_mchk_pal	// fen from PAL?
	hw_mtpr	$4, (1<<7) + 0x3			// save $4
	bic	$2, 3, $2		// clean pc
	srl	$1, 42, $4	// get fen to <0>
	addq	$2, 4, $1		// increment PC
	cmovlbs	$4, $1, $2		// if opcdec, use incremented PC
	hw_mfpr	$1, (1<<7) + 0x9			// get shadow osf (1<<5) + 0x9

	sll	    $1, 63-3, $1;	bge	    $1, 0f;	hw_mtpr    $30, (1<<7) + 0x12;	hw_mfpr    $30, (1<<7) + 0x13;	hw_mtpr    $31, (1<<7) + (1<<5) + 0x9;	0:  srl	    $1, 63-3, $1;	lda	    $30, 0-48($30); hw_stq/a   $1, 0x0000($30);	hw_stq/a   $2, 0x0008($30);	hw_stq/a   $29, 0x0010($30);	hw_stq/a   $16, 0x0018($30);	hw_stq/a   $17, 0x0020($30);	hw_stq/a   $18,	0x0028($30)

	hw_mfpr	$1, (1<<7) + 0x10		// get (1<<6) + 0x5 of service routine
	and	$4, 1, $16		// clean to just fen
	hw_mtpr	$1, (1<<5) + 0x4		// set (1<<6) + 0x5 of service routine
	addq	$16, 3, $16		// fen if fen=0, or opcDec if fen=1
	hw_mfpr	$4, (1<<7) + 0x3			// restore scratch registers
	hw_mfpr	$2, (1<<7) + 0x1
	hw_mfpr	$1, (1<<7) + 0x0
	hw_mfpr	$29, (1<<7) + 0x14		// get the kernel $29
	hw_rei				// out to service routine

































	.text	1
	. = 0x2000

























	. = (0x2000+(0x0000<<6))

pal_halt:
	hw_mtpr    $31, 0
	br	$31, pal_halt_cont



























	. = (0x2000+(0x0001<<6))

pal_cflush:
	hw_mtpr    $31, 0
	br	$31, sys_cflush	// All this is platform-specific

























	. = (0x2000+(0x0002<<6))

pal_draina:
	hw_mtpr    $31, 0				// Required stall.
        hw_rei				// Back to caller.

	. = (0x2000+(0x0003<<6))

pal_opcdec03:
	hw_mtpr    $31, 0
	br	$31, pal_CallPalRsvd

	. = (0x2000+(0x0004<<6))

pal_opcdec04:
	hw_mtpr    $31, 0
	br	$31, pal_CallPalRsvd

	. = (0x2000+(0x0005<<6))

pal_opcdec05:
	hw_mtpr    $31, 0
	br	$31, pal_CallPalRsvd

	. = (0x2000+(0x0006<<6))

pal_opcdec06:
	hw_mtpr    $31, 0
	br	$31, pal_CallPalRsvd

	. = (0x2000+(0x0007<<6))

pal_opcdec07:
	hw_mtpr    $31, 0
	br	$31, pal_CallPalRsvd

	. = (0x2000+(0x0008<<6))

pal_opcdec08:
	hw_mtpr    $31, 0
	br	$31, pal_CallPalRsvd


























	. = (0x2000+(0x0009<<6))

pal_cserve:
	hw_mtpr    $31, 0
	br	$31, sys_cserve	// All this is platform-specific



































































	. = (0x2000+(0x000A<<6))

pal_swppal:
	cmpule	$16, 255, $0		// Check for a PAL variant.
	cmoveq	$16, $16, $0		// If $16=0, then a valid new PAL address.
	blbc	$0, pal_swppal_cont	// Nope, must be new PAL address.
	cmpeq	$16, 2, $0		// Is this variant OSF/1?
	addq	$0, 1, $0		// If not return as unknown, otherwise,
	hw_rei				// return as not loaded.

        . = (0x2000+(0x000B<<6))

pal_opcdec0B:
	hw_mtpr    $31, 0
	br	$31, pal_CallPalRsvd

        . = (0x2000+(0x000C<<6))

pal_opcdec0C:
	hw_mtpr    $31, 0
	br	$31, pal_CallPalRsvd






























	. = (0x2000+(0x000D<<6))

pal_wripir:
	hw_mtpr    $31, 0				// Required stall
	hw_rei				// Back to caller

	. = (0x2000+(0x000E<<6))

pal_opcdec0E:
	hw_mtpr    $31, 0
	br	$31, pal_CallPalRsvd

	. = (0x2000+(0x000F<<6))

pal_opcdec0F:
	hw_mtpr    $31, 0
	br	$31, pal_CallPalRsvd


























	. = (0x2000+(0x0010<<6))

pal_rdmces:
	hw_mfpr	$0 , (1<<7) + 0x19			// get MCES
	srl	$0, 0, $0		// get mces to <0>
	and	$0, 0x1F, $0			// clean to just mces bits
	hw_rei					// out to service routine





























	. = (0x2000+(0x0011<<6))

pal_wrmces:
	hw_mfpr	$23, (1<<7) + 0x19		// get mces
	and	$16, 7, $22		// isolate <2:0>
	bis	$22, 3<<3, $22		// will clear dsc and dpc
	sll	$22, 0, $22	// move to position
	bic	$23, $22, $23		// selectively clear <2:0>, clear <4:3>
	and	$16, 3<<3, $22		// isolate dsc and dpc bits
	sll	$22, 0, $22	// move to position
	bis	$23, $22, $23		// affect dsc and dpc bits
	hw_mtpr	$23, (1<<7) + 0x19		// load MCES




	srl	$23, (3-2), $22 // Get DPC into position
	hw_mfpr	$16, (1<<7) + 0x11		           // Get ptr to impure area
	and	$22, (1<<2), $22              // Isolate DPC



	lda	$16, 0x100($16)
	hw_ldq/p	$23, 0x330($16) 

	

	br	$31, pal_wrmces_cont

	. = (0x2000+(0x0012<<6))

pal_opcdec12:
	hw_mtpr    $31, 0
	br	$31, pal_CallPalRsvd

	. = (0x2000+(0x0013<<6))

pal_opcdec13:
	hw_mtpr    $31, 0
	br	$31, pal_CallPalRsvd

	. = (0x2000+(0x0014<<6))

pal_opcdec14:
	hw_mtpr    $31, 0
	br	$31, pal_CallPalRsvd

	. = (0x2000+(0x0015<<6))

pal_opcdec15:
	hw_mtpr    $31, 0
	br	$31, pal_CallPalRsvd

	. = (0x2000+(0x0016<<6))

pal_opcdec16:
	hw_mtpr    $31, 0
	br	$31, pal_CallPalRsvd

	. = (0x2000+(0x0017<<6))

pal_opcdec17:
	hw_mtpr    $31, 0
	br	$31, pal_CallPalRsvd

	. = (0x2000+(0x0018<<6))

pal_opcdec18:
	hw_mtpr    $31, 0
	br	$31, pal_CallPalRsvd

	. = (0x2000+(0x0019<<6))

pal_opcdec19:
	hw_mtpr    $31, 0
	br	$31, pal_CallPalRsvd

	. = (0x2000+(0x001A<<6))

pal_opcdec1A:
	hw_mtpr    $31, 0
	br	$31, pal_CallPalRsvd

	. = (0x2000+(0x001B<<6))

pal_opcdec1B:
	hw_mtpr    $31, 0
	br	$31, pal_CallPalRsvd

	. = (0x2000+(0x001C<<6))

pal_opcdec1C:
	hw_mtpr    $31, 0
	br	$31, pal_CallPalRsvd

	. = (0x2000+(0x001D<<6))

pal_opcdec1D:
	hw_mtpr    $31, 0
	br	$31, pal_CallPalRsvd

	. = (0x2000+(0x001E<<6))

pal_opcdec1E:
	hw_mtpr    $31, 0
	br	$31, pal_CallPalRsvd

	. = (0x2000+(0x001F<<6))

pal_opcdec1F:
	hw_mtpr    $31, 0
	br	$31, pal_CallPalRsvd

	. = (0x2000+(0x0020<<6))

pal_opcdec20:
	hw_mtpr    $31, 0
	br	$31, pal_CallPalRsvd

	. = (0x2000+(0x0021<<6))

pal_opcdec21:
	hw_mtpr    $31, 0
	br	$31, pal_CallPalRsvd

	. = (0x2000+(0x0022<<6))

pal_opcdec22:
	hw_mtpr    $31, 0
	br	$31, pal_CallPalRsvd

	. = (0x2000+(0x0023<<6))

pal_opcdec23:
	hw_mtpr    $31, 0
	br	$31, pal_CallPalRsvd

	. = (0x2000+(0x0024<<6))

pal_opcdec24:
	hw_mtpr    $31, 0
	br	$31, pal_CallPalRsvd

	. = (0x2000+(0x0025<<6))

pal_opcdec25:
	hw_mtpr    $31, 0
	br	$31, pal_CallPalRsvd

	. = (0x2000+(0x0026<<6))

pal_opcdec26:
	hw_mtpr    $31, 0
	br	$31, pal_CallPalRsvd

	. = (0x2000+(0x0027<<6))

pal_opcdec27:
	hw_mtpr    $31, 0
	br	$31, pal_CallPalRsvd

	. = (0x2000+(0x0028<<6))

pal_opcdec28:
	hw_mtpr    $31, 0
	br	$31, pal_CallPalRsvd

	. = (0x2000+(0x0029<<6))

pal_opcdec29:
	hw_mtpr    $31, 0
	br	$31, pal_CallPalRsvd

	. = (0x2000+(0x002A<<6))

pal_opcdec2A:
	hw_mtpr    $31, 0
	br	$31, pal_CallPalRsvd




























	. = (0x2000+(0x002B<<6))

pal_wrfen:
	hw_mfpr	$22, (1<<7) + 0x1F		// Get PCB pointer
	and	$16, 1, $16		// Clean new FEN value
	hw_mfpr	$24, (1<<7) + 0x2		// Get ICCSR copy
	sll	$16, 42, $23	// Get FEN into correct position
	or	$31, 1, $25		// Get a 1
	hw_stl/p	$16, 0x0028($22)	// Set new fen bit
	sll	$25, 42, $25	// Place 1 in ICCSR<FPE> position
	bic	$24, $25, $24		// Clear ICCSR<FPE>
	bis	$24, $23, $24		// Or in new FEN value
	hw_mtpr	$24, (1<<7) + (1<<5) + 0x2		// Establish new ICCSR and shadow
	hw_mtpr    $31, 0				// Stall 4 cycles after fen write
	hw_mtpr    $31, 0
	hw_mtpr    $31, 0
	hw_mtpr    $31, 0
	hw_mtpr    $31, 0
	br	$31, pal_wrfen_cont

	. = (0x2000+(0x002C<<6))

pal_opcdec2C:
	hw_mtpr    $31, 0
	br	$31, pal_CallPalRsvd



























	. = (0x2000+(0x002D<<6))

pal_wrvptptr:
	hw_mtpr	$16, (1<<7) + 0x1D
	hw_rei

	. = (0x2000+(0x002E<<6))

pal_opcdec2E:
	hw_mtpr    $31, 0
	br	$31, pal_CallPalRsvd

	. = (0x2000+(0x002F<<6))

pal_opcdec2F:
	hw_mtpr    $31, 0
	br	$31, pal_CallPalRsvd






























	. = (0x2000+(0x0030<<6))

pal_swpctx:
	hw_mfpr	$0, (1<<7) + 0x1F		// Get the old PCB base.
	hw_mfpr	$22, (1<<7) + 0x12		// Get the user stack pointer.
	rpcc	$1			// Read the cycle counter.
	hw_stq/p	$30, 0x0000($0)	// Save the old kernel stack pointer.
	hw_stq/p	$22, 0x0008($0)	// Save the old user stack pointer.
	srl	$1, 32, $23		// Get CC<Offset>.
	addq	$1, $23, $23		// Merge with CC<Counter>.
	hw_stl/p	$23, 0x0018($0)	// Save new time.
	hw_mtpr	$16, (1<<7) + 0x1F		// Set the new PCB.
	hw_ldq/p	$30, 0x0000($16)	// Get the new kernel stack pointer.
	hw_ldq/p	$22, 0x0008($16)	// Get the new user stack pointer.
	hw_ldq/p	$23, 0x0010($16)	// Get the new page table base.
	hw_ldl/p	$24, 0x0018($16)	// Get the new cycle counter.
	hw_ldq/p	$25, 0x0028($16)	// Get the new floating point enable bit
	hw_mtpr	$22, (1<<7) + 0x12		// Save the new user stack pointer.
	br	$31, pal_swpctx_cont




























	. = (0x2000+(0x0031<<6))

pal_wrval:
	hw_mtpr	$16, (1<<7) + 0x18		// Set value
	hw_rei				// Back to caller



























	. = (0x2000+(0x0032<<6))

pal_rdval:
	hw_mfpr	$0, (1<<7) + 0x18		// Get per-processor system value
	hw_rei				// Back to caller





























	. = (0x2000+(0x0033<<6))

pal_tbi:
	addq	$16, 2, $16		// Change tbi type range to 0 - 6.
	br	$23, 1f			// Get base address of code.
1:	cmpult	$16, 6, $22		// Check if tbi type is in range.
	blbc	$22, 2f			// Return if out of range.
	sll	$16, 4, $16		// Form index into jump table.
	lda	$23, pal_tbi_table-1b($23) // Set base to start of table.
	addq	$23, $16, $23		// Form jump table target address.
pvc$osf0$3000:
	jmp	$31, ($23)		// Go do it!

2:	hw_rei






























	. = (0x2000+(0x0034<<6))

pal_wrent:


	cmpult	$17, 7, $22		// Check if entry type is in range.




	br	$23, 1f			// Get base address of code.
1:	bic	$16, 3, $16		// Clean the PC.
	blbc	$22, 2f			// Return if out of range.
	lda	$23, pal_wrent_table-1b($23) // Set base to start of table.
	s8addq	$17, $23, $23		// Form jump table target address.

pvc$osf20$3100:
	jmp	$31, ($23)		// Go do it!

2:	hw_rei


























	. = (0x2000+(0x0035<<6))

pal_swpipl:
	hw_mfpr	$0, (1<<7) + 0x16		// get interrupt mask
	and	$16, 7, $16		// get ipl
	extbl	$0, $16, $0		// get mask for this ipl
	insbl	$0, 1, $0		// move into position for (1<<5) + 0x10

	cmple   $16, 6, $22		// are crd's blocked? 0=> blocked
	s4addq	$22, 0, $22		// move into position
	bis	$0, $22, $0		// enable crd's if not high ipl

	hw_mtpr	$0, (1<<5) + 0x10		// set new mask
	br	$31, pal_swpipl_cont

























	. = (0x2000+(0x0036<<6))

pal_rdps:
	hw_mfpr	$0, (1<<7) + 0x9			// Get (1<<5) + 0x9
	hw_rei				// Back to caller



























	. = (0x2000+(0x0037<<6))

pal_wrkgp:
	hw_mtpr	$16, (1<<7) + 0x14		// Set KGP
	hw_rei				// Back to caller


























	. = (0x2000+(0x0038<<6))

pal_wrusp:
	hw_mtpr	$16, (1<<7) + 0x12		// Set user stack pointer
	hw_rei				// Back to caller





































	. = (0x2000+(0x0039<<6))

pal_wrperfmon:
	hw_mtpr    $31, 0
	beq	$16, pal_perf1_handler	// Request to disable?
	cmpeq	$16, 1, $0		// Check for enable
	bne	$0, pal_perf2_handler	// Request to enable?
	cmpeq	$16, 3, $0		// Check for options
	bne	$0, pal_perf3_handler	// Request to set options?
	cmpeq	$16, 2, $0		// Check for mux ctl
	beq	$0, 1f			// If not mux ctl, unknown request
	br	$31, pal_wrperfmon_cont
1:	hw_rei



























	. = (0x2000+(0x003A<<6))

pal_rdusp:
	hw_mfpr	$0, (1<<7) + 0x12		// Get the user stack pointer
	hw_rei				// Back to caller

	. = (0x2000+(0x003B<<6))

pal_opcdec3B:
	hw_mtpr    $31, 0
	br	$31, pal_CallPalRsvd

























	. = (0x2000+(0x003C<<6))

pal_whami:
	hw_mfpr	$0, (1<<7) + 0x1B		// Get Who-Am-I identifier.
	hw_mtpr    $31, 0
	hw_rei



























	. = (0x2000+(0x003D<<6))

pal_retsys:
	hw_mfpr    $22, (1<<7) + 0x16		// get int mask
	lda	$25, 48($30)	// pop stack
	ldq     $23, 0x0008($30)	// get pc
	ldq	$29, 0x0010($30)	// get $29
	hw_mtpr	$25, (1<<7) + 0x13		// save kernel stack
	insbl	$22, 1, $22		// move (1<<5) + 0x10 value into position
        stl_c   $25, -4($30)             // clear lock_flag
	bis	$31, 8, $24		// make value for mode=user
	hw_mtpr	$24, (1<<7) + (1<<5) + 0x9             // set new (1<<5) + 0x9
	bis	$22, (1<<2), $22	// enable crd's
	hw_mtpr	$22, (1<<5) + 0x10		// set the hardware
	br	$31, pal_retsys_cont

	. = (0x2000+(0x003E<<6))

pal_opcdec3E:
	hw_mtpr    $31, 0
	br	$31, pal_CallPalRsvd




























	. = (0x2000+(0x003F<<6))

pal_rti:
	stl_c	$18, -4($30)		// clear lock_flag
	lda	$29, 48($30)	// get updated $30
	ldq	$30, -6*8($29)		// get (1<<5) + 0x9
	rc	$17			// clear intr_flag
	hw_mfpr	$16, (1<<7) + 0x16		// get interrupt mask
	hw_mtpr	$29, (1<<7) + 0x13		// save in case rti to user

	and	$30, (1<<3), $17		// get mode
	ldq	$18, -1*8($29)		// restore $18
	beq	$17, pal_rtiToKern	// br if rti to kernel



	insbl	$16, 1, $16		// new (1<<5) + 0x10 for user mode into position

	ldq	$30, -5*8($29)		// pc
	ldq	$17, -2*8($29)		// restore $17

	bis	$16, (1<<2), $16	// or in CRE
	hw_mtpr	$16, (1<<5) + 0x10		// set the (1<<5) + 0x10
	bic	$30, 3, $30		// clean return pc

	br	$31, pal_rti_cont

















	.text	2
	. = 0x3000































 
	. = (0x3000+((0x80&0x3F)<<6))

pal_bpt:
	hw_mtpr	$1, (1<<7) + 0x0                 // save $1
	hw_mfpr	$1, (1<<7) + 0x9			// get shadow osf (1<<5) + 0x9
	hw_mtpr	$2, (1<<7) + 0x1                 // save $2
	hw_mfpr	$2, (1<<5) + 0x4		// get pc
	bic	$2, 3, $2		// clean pc
	br	$31, pal_bpt_cont
































	. = (0x3000+((0x81&0x3F)<<6))

pal_bugchk:
	hw_mtpr	$1, (1<<7) + 0x0                 // save $1
	hw_mfpr	$1, (1<<7) + 0x9			// get shadow osf (1<<5) + 0x9
	hw_mtpr	$2, (1<<7) + 0x1                 // save $2
	hw_mfpr	$2, (1<<5) + 0x4		// get pc
	bic	$2, 3, $2		// clean pc
	br	$31, pal_bugchk_cont

	. = (0x3000+((0x0082&0x3F)<<6))

pal_opcdec82:
	hw_mtpr    $31, 0
	br	$31, pal_CallPalRsvd































	. = (0x3000+((0x83&0x3F)<<6))

pal_callsys:
	hw_mfpr	$22, (1<<7) + 0x9			// get (1<<5) + 0x9
	and	$22, (1<<3), $24	// get mode
	beq	$24, pal_mchk_callsys	// in kernel mode?
	hw_mfpr	$23, (1<<5) + 0x4		// get pc
	bic	$23, 3, $23		// clean pc
	br	$31, pal_callsys_cont

	. = (0x3000+((0x0084&0x3F)<<6))

pal_opcdec84:
	hw_mtpr    $31, 0
	br	$31, pal_CallPalRsvd

	. = (0x3000+((0x0085&0x3F)<<6))

pal_opcdec85:
	hw_mtpr    $31, 0
	br	$31, pal_CallPalRsvd
























	. = (0x3000+((0x86&0x3F)<<6))

pal_imb:
	hw_mtpr	$31, (1<<6) + 0x15		// Flush the Icache
        mb				// Flush the write buffer
	hw_mtpr    $31, 0				// Required stall
	hw_mtpr    $31, 0				// Required stall
	hw_mtpr    $31, 0				// Required stall
	hw_mtpr    $31, 0
	hw_mtpr    $31, 0
	hw_mtpr    $31, 0
	hw_mtpr    $31, 0
	mb
        hw_rei				// Back to caller.

	. = (0x3000+((0x0087&0x3F)<<6))

pal_opcdec87:
	hw_mtpr    $31, 0
	br	$31, pal_CallPalRsvd

	. = (0x3000+((0x0088&0x3F)<<6))

pal_opcdec88:
	hw_mtpr    $31, 0
	br	$31, pal_CallPalRsvd

	. = (0x3000+((0x0089&0x3F)<<6))

pal_opcdec89:
	hw_mtpr    $31, 0
	br	$31, pal_CallPalRsvd

	. = (0x3000+((0x008A&0x3F)<<6))

pal_opcdec8A:
	hw_mtpr    $31, 0
	br	$31, pal_CallPalRsvd

	. = (0x3000+((0x008B&0x3F)<<6))

pal_opcdec8B:
	hw_mtpr    $31, 0
	br	$31, pal_CallPalRsvd

	. = (0x3000+((0x008C&0x3F)<<6))

pal_opcdec8C:
	hw_mtpr    $31, 0
	br	$31, pal_CallPalRsvd

	. = (0x3000+((0x008D&0x3F)<<6))

pal_opcdec8D:
	hw_mtpr    $31, 0
	br	$31, pal_CallPalRsvd

	. = (0x3000+((0x008E&0x3F)<<6))

pal_opcdec8E:
	hw_mtpr    $31, 0
	br	$31, pal_CallPalRsvd

	. = (0x3000+((0x008F&0x3F)<<6))

pal_opcdec8F:
	hw_mtpr    $31, 0
	br	$31, pal_CallPalRsvd

	. = (0x3000+((0x0090&0x3F)<<6))

pal_opcdec90:
	hw_mtpr    $31, 0
	br	$31, pal_CallPalRsvd

	. = (0x3000+((0x0091&0x3F)<<6))

pal_opcdec91:
	hw_mtpr    $31, 0
	br	$31, pal_CallPalRsvd

	. = (0x3000+((0x0092&0x3F)<<6))

pal_opcdec92:
	hw_mtpr    $31, 0
	br	$31, pal_CallPalRsvd

	. = (0x3000+((0x0093&0x3F)<<6))

pal_opcdec93:
	hw_mtpr    $31, 0
	br	$31, pal_CallPalRsvd

	. = (0x3000+((0x0094&0x3F)<<6))

pal_opcdec94:
	hw_mtpr    $31, 0
	br	$31, pal_CallPalRsvd

	. = (0x3000+((0x0095&0x3F)<<6))

pal_opcdec95:
	hw_mtpr    $31, 0
	br	$31, pal_CallPalRsvd

	. = (0x3000+((0x0096&0x3F)<<6))

pal_opcdec96:
	hw_mtpr    $31, 0
	br	$31, pal_CallPalRsvd

	. = (0x3000+((0x0097&0x3F)<<6))

pal_opcdec97:
	hw_mtpr    $31, 0
	br	$31, pal_CallPalRsvd

	. = (0x3000+((0x0098&0x3F)<<6))

pal_opcdec98:
	hw_mtpr    $31, 0
	br	$31, pal_CallPalRsvd

	. = (0x3000+((0x0099&0x3F)<<6))

pal_opcdec99:
	hw_mtpr    $31, 0
	br	$31, pal_CallPalRsvd

	. = (0x3000+((0x009A&0x3F)<<6))

pal_opcdec9A:
	hw_mtpr    $31, 0
	br	$31, pal_CallPalRsvd

	. = (0x3000+((0x009B&0x3F)<<6))

pal_opcdec9B:
	hw_mtpr    $31, 0
	br	$31, pal_CallPalRsvd

	. = (0x3000+((0x009C&0x3F)<<6))

pal_opcdec9C:
	hw_mtpr    $31, 0
	br	$31, pal_CallPalRsvd

	. = (0x3000+((0x009D&0x3F)<<6))

pal_opcdec9D:
	hw_mtpr    $31, 0
	br	$31, pal_CallPalRsvd



























	. = (0x3000+((0x9E&0x3F)<<6))

pal_rdunique:
	hw_mfpr	$0, (1<<7) + 0x1F		// Get the PCB pointer
	hw_ldq/p	$0, 0x0020($0)	// Get the unique value
	hw_rei				// Back to caller
























	. = (0x3000+((0x9F&0x3F)<<6))

pal_wrunique:
	hw_mtpr	$1, (1<<7) + 0x0			// Save $1
	hw_mfpr	$1, (1<<7) + 0x1F		// Get the PCB pointer
	hw_stq/p	$16, 0x0020($1)	// Store new value
	hw_mfpr	$1, (1<<7) + 0x0			// Restore $1
	hw_rei				// Back to caller

	. = (0x3000+((0x00A0&0x3F)<<6))

pal_opcdecA0:
	hw_mtpr    $31, 0
	br	$31, pal_CallPalRsvd

	. = (0x3000+((0x00A1&0x3F)<<6))

pal_opcdecA1:
	hw_mtpr    $31, 0
	br	$31, pal_CallPalRsvd

	. = (0x3000+((0x00A2&0x3F)<<6))

pal_opcdecA2:
	hw_mtpr    $31, 0
	br	$31, pal_CallPalRsvd

	. = (0x3000+((0x00A3&0x3F)<<6))

pal_opcdecA3:
	hw_mtpr    $31, 0
	br	$31, pal_CallPalRsvd

	. = (0x3000+((0x00A4&0x3F)<<6))

pal_opcdecA4:
	hw_mtpr    $31, 0
	br	$31, pal_CallPalRsvd

	. = (0x3000+((0x00A5&0x3F)<<6))

pal_opcdecA5:
	hw_mtpr    $31, 0
	br	$31, pal_CallPalRsvd

	. = (0x3000+((0x00A6&0x3F)<<6))

pal_opcdecA6:
	hw_mtpr    $31, 0
	br	$31, pal_CallPalRsvd

	. = (0x3000+((0x00A7&0x3F)<<6))

pal_opcdecA7:
	hw_mtpr    $31, 0
	br	$31, pal_CallPalRsvd

	. = (0x3000+((0x00A8&0x3F)<<6))

pal_opcdecA8:
	hw_mtpr    $31, 0
	br	$31, pal_CallPalRsvd

	. = (0x3000+((0x00A9&0x3F)<<6))

pal_opcdecA9:
	hw_mtpr    $31, 0
	br	$31, pal_CallPalRsvd






























 
	. = (0x3000+((0xAA&0x3F)<<6))

pal_gentrap:
	hw_mtpr	$1, (1<<7) + 0x0                 // save $1
	hw_mfpr	$1, (1<<7) + 0x9			// get shadow osf (1<<5) + 0x9
	hw_mtpr	$2, (1<<7) + 0x1                 // save $2
	hw_mfpr	$2, (1<<5) + 0x4		// get pc
	bic	$2, 3, $2		// clean pc
	br	$31, pal_gentrap_cont

	. = (0x3000+((0x00AB&0x3F)<<6))

pal_opcdecAB:
	hw_mtpr    $31, 0
	br	$31, pal_CallPalRsvd

	. = (0x3000+((0x00AC&0x3F)<<6))

pal_opcdecAC:
	hw_mtpr    $31, 0
	br	$31, pal_CallPalRsvd
































 
	. = (0x3000+((0xAD&0x3F)<<6))

pal_dbgstop:
	hw_mtpr	$1, (1<<7) + 0x0			// Save $1
	hw_mfpr	$1, (1<<7) + 0x9			// Get PS
	hw_mtpr	$2, (1<<7) + 0x1			// Save $2
	hw_mfpr	$2, (1<<5) + 0x4		// Get PC
	bic	$2, 3, $2		// Clean PC
	br	$31, pal_dbgstop_cont










	. = (0x3000+((0x00AE&0x3F)<<6))

pal_opcdecAE:
	hw_mtpr    $31, 0
	br	$31, pal_CallPalRsvd

	. = (0x3000+((0x00AF&0x3F)<<6))

pal_opcdecAF:
	hw_mtpr    $31, 0
	br	$31, pal_CallPalRsvd

	. = (0x3000+((0x00B0&0x3F)<<6))

pal_opcdecB0:
	hw_mtpr    $31, 0
	br	$31, pal_CallPalRsvd

	. = (0x3000+((0x00B1&0x3F)<<6))

pal_opcdecB1:
	hw_mtpr    $31, 0
	br	$31, pal_CallPalRsvd

	. = (0x3000+((0x00B2&0x3F)<<6))

pal_opcdecB2:
	hw_mtpr    $31, 0
	br	$31, pal_CallPalRsvd

	. = (0x3000+((0x00B3&0x3F)<<6))

pal_opcdecB3:
	hw_mtpr    $31, 0
	br	$31, pal_CallPalRsvd

	. = (0x3000+((0x00B4&0x3F)<<6))

pal_opcdecB4:
	hw_mtpr    $31, 0
	br	$31, pal_CallPalRsvd

	. = (0x3000+((0x00B5&0x3F)<<6))

pal_opcdecB5:
	hw_mtpr    $31, 0
	br	$31, pal_CallPalRsvd

	. = (0x3000+((0x00B6&0x3F)<<6))

pal_opcdecB6:
	hw_mtpr    $31, 0
	br	$31, pal_CallPalRsvd

	. = (0x3000+((0x00B7&0x3F)<<6))

pal_opcdecB7:
	hw_mtpr    $31, 0
	br	$31, pal_CallPalRsvd

	. = (0x3000+((0x00B8&0x3F)<<6))

pal_opcdecB8:
	hw_mtpr    $31, 0
	br	$31, pal_CallPalRsvd

	. = (0x3000+((0x00B9&0x3F)<<6))

pal_opcdecB9:
	hw_mtpr    $31, 0
	br	$31, pal_CallPalRsvd

	. = (0x3000+((0x00BA&0x3F)<<6))

pal_opcdecBA:
	hw_mtpr    $31, 0
	br	$31, pal_CallPalRsvd

	. = (0x3000+((0x00BB&0x3F)<<6))

pal_opcdecBB:
	hw_mtpr    $31, 0
	br	$31, pal_CallPalRsvd

	. = (0x3000+((0x00BC&0x3F)<<6))

pal_opcdecBC:
	hw_mtpr    $31, 0
	br	$31, pal_CallPalRsvd

	. = (0x3000+((0x00BD&0x3F)<<6))

pal_opcdecBD:
	hw_mtpr    $31, 0
	br	$31, pal_CallPalRsvd

	. = (0x3000+((0x00BE&0x3F)<<6))

pal_opcdecBE:
	hw_mtpr    $31, 0
	br	$31, pal_CallPalRsvd





























	. = (0x3000+((0xBF&0x3F)<<6))

pal_nphalt:
	hw_mtpr	$1, (1<<7) + 0x0                 // Save $1.
	hw_mfpr	$1, (1<<7) + 0x9                 // Get shadow copy of PS.
	sll	$1, 63-3, $1      // Get current mode into lsb.
    	bge	$1, 1f                  // Check for kernel vs. user mode.
    	hw_mtpr    $30, (1<<7) + 0x12               // Save user stack pointer.
    	hw_mfpr    $30, (1<<7) + 0x13               // Load kernel stack pointer.
    	hw_mtpr    $31, (1<<7) + (1<<5) + 0x9            // Change mode to kernel.
1:  	hw_mfpr	$1, (1<<7) + 0x0                 // Restore $1.
	br	$31, pal_halt          // Dispatch to kernel halt routine.














	.text	3
	. = 0x4000

pal_reset_cont:

        hw_mtpr    $2, (1<<7) + 0x1                 // Save $2.
	hw_ldl/p	$2, 0x10($1)		// Get offset to impure scratch area.
	bic	$1, 0x1F, $1		// Point to start of PALcode.
	addq	$2, $1, $2		// Form base address of impure area.
	hw_mtpr	$2, (1<<7) + 0x11		// Save pointer to impure scratch area.
        lda	$2, 0x100($2)	// Point to start of save state area.
        hw_stq/p   $0,  (0x0 + 0x00)($2); hw_mfpr    $0, (1<<7) + 0x0; hw_stq/p   $0,  (0x0 + 0x08)($2); hw_mfpr    $0, (1<<7) + 0x1; hw_stq/p   $0,  (0x0 + 0x10)($2); hw_stq/p   $3,  (0x0 + 0x18)($2); hw_stq/p   $4,  (0x0 + 0x20)($2); hw_stq/p   $5,  (0x0 + 0x28)($2); hw_stq/p   $6,  (0x0 + 0x30)($2); hw_stq/p   $7,  (0x0 + 0x38)($2); hw_stq/p   $8,  (0x0 + 0x40)($2); hw_stq/p   $9,  (0x0 + 0x48)($2); hw_stq/p   $10, (0x0 + 0x50)($2); hw_stq/p   $11, (0x0 + 0x58)($2); hw_stq/p   $12, (0x0 + 0x60)($2); hw_stq/p   $13, (0x0 + 0x68)($2); hw_stq/p   $14, (0x0 + 0x70)($2); hw_stq/p   $15, (0x0 + 0x78)($2); hw_stq/p   $16, (0x0 + 0x80)($2); hw_stq/p   $17, (0x0 + 0x88)($2); hw_stq/p   $18, (0x0 + 0x90)($2); hw_stq/p   $19, (0x0 + 0x98)($2); hw_stq/p   $20, (0x0 + 0xA0)($2); hw_stq/p   $21, (0x0 + 0xA8)($2); hw_stq/p   $22, (0x0 + 0xB0)($2); hw_stq/p   $23, (0x0 + 0xB8)($2); hw_stq/p   $24, (0x0 + 0xC0)($2); hw_stq/p   $25, (0x0 + 0xC8)($2); hw_stq/p   $26, (0x0 + 0xD0)($2); hw_stq/p   $27, (0x0 + 0xD8)($2); hw_stq/p   $28, (0x0 + 0xE0)($2); hw_stq/p   $29, (0x0 + 0xE8)($2); hw_stq/p   $30, (0x0 + 0xF0)($2); hw_stq/p   $31, (0x0 + 0xF8)($2)			// Save all general purpose registers.
	hw_mfpr    $0, (1<<5) + 0x4		// Save internal processor registers.
	hw_stq/p   $0, 0x300($2)
	hw_mfpr    $0, (1<<5) + 0x9
	hw_stq/p   $0, 0x308($2)
	hw_mfpr    $0, (1<<5) + 0xB
	hw_stq/p   $0, 0x310($2)
	hw_mfpr    $0, (1<<5) + 0x10
	hw_stq/p   $0, 0x318($2)
	hw_mfpr    $0, (1<<5) + 0xD
	hw_stq/p   $0, 0x320($2)
	hw_mfpr    $0, (1<<5) + 0x2
	hw_stq/p   $0, 0x328($2)

	hw_mfpr	$2, (1<<5) + 0xB		// Get the previous PAL base.
	hw_mtpr	$2, (1<<7) + 0x1E		// Save it so we can return, if needed.
	hw_mtpr	$31, (1<<6) + 0xF		// Set the ALT_MODE to kernel.
	mb				// Isolate to insure no exceptions
	mb				// occur while writing the PAL base.
	hw_mtpr	$1, (1<<5) + 0xB		// Establish the new PAL base.
	mb
	mb

	hw_mfpr	$1, (1<<7) + 0x0			// Restore $1.
	hw_mfpr	$2, (1<<7) + 0x1			// Restore $2.



	lda	$8, 0x7($31)	// Set to high IPL, mode=kernel.
	hw_mtpr	$8, (1<<7) + (1<<5) + 0x9		// Establish PS and shadow copy.



	hw_mtpr	$31, (1<<5) + 0xE		// Disable ASTs.
	hw_mtpr	$31, (1<<5) + 0x12
	hw_mtpr	$31, (1<<5) + 0xD		// Disable software interrupts.
	hw_mtpr	$31, (1<<5) + 0x11
	hw_mtpr	$31, (1<<5) + 0xC		// Disable hardware interrupts.
	hw_mtpr	$31, (1<<5) + 0x10
	hw_mtpr	$31, (1<<5) + 0x13		// Clear SLC, PCx, and CRD interrupts.



	bis	$31, 1, $8		// Get a "1"
	sll	$8, 3, $8	// Shift into correct position.
	hw_mtpr	$8, (1<<7) + 0x19		// Establish machine check error summary




	hw_mfpr	$25, (1<<7) + 0x11		// Get pointer to the impure scratch area.
	lda	$25, 0x100($25)	// Point to the save state area.
	br	$22, 1f			// Branch around static data.

	.align	3
	.quad	((1<<(42-32)) | (1<<(41-32)) | (1<<(39-32))	 | (1<<(38-32)) | (1<<(37-32)) | (1<<(36-32)) | (1<<(35-32)))
	.quad	((1<<10) | (1<<5) | (1<<3))

1:	addq	$22, 4, $22
	bic	$22, 7, $22
	hw_ldq/p	$8, 0($22)		// Read the default ICCSR value.
	sll	$8, 32, $8		// Shift it into correct position.
	hw_mtpr	$8, (1<<7) + (1<<5) + 0x2		// Establish ICCSR and shadow copy.
	hw_ldq/p	$8, 8($22)		// Read the default ABOX_CTL value.
	hw_mtpr	$8, (1<<6) + 0xE		// Establish ABOX_CTL.
	hw_stq/p	$8, 0x330($25) // Save a shadow copy in the impure area.



















	srl	$19, 16, $8		// Shift signature into lower word.

	ldah	$7, ((0xDECB+0x8000) >> 16)($31); lda	$7, (0xDECB&0xffff)($7)			// Load the expected valid signature.

	cmpeq	$8, $7, $8		// Is signature passed in $19 valid?
	beq	$8, 2f			// If invalid, don't trust input params.



	hw_mtpr	$1, (1<<6) + 0xE		// Establish ABOX_CTL.
	hw_stq/p	$1, 0x330($25)	// Save ABOX_CTL.






	bis	$2, (1<<2), $2	// OR in BIU_CTL<OE> bit.
	hw_mtpr	$2, (1<<6) + 0x12		// Establish BIU_CTL.
	hw_stq/p	$2, 0x338($25)	// Save BIU_CTL.



	hw_stq/p	$15, 0x340($25)	 // Save srom revision.
	hw_stq/p	$16, 0x348($25)	 // Save processor id.
	hw_stq/p	$17, 0x350($25)	 // Save memory size.
	hw_stq/p	$18, 0x358($25) // Save cycle count.
	hw_stq/p	$19, 0x360($25) // Save signature and system revision.
	hw_stq/p	$20, 0x368($25) // Save processor mask.
	hw_stq/p	$21, 0x370($25)	 // Save system context.

	bis	$31, $31, $19		 // Clear the signature register.
	hw_mtpr	$31, (1<<7) + 0x1B		 // Clear WHAMI and swap flag.



pvc$osf60$5100:
2:	bsr	$1, 3f			// Push PC.
	br	$31, 7f		// Join common.
pvc$osf61$5101:
3:	bsr	$2, 4f			// Push PC.
pvc$osf67$5100.1:
	ret	$31, ($1)		// Pop PC.
pvc$osf62$5102:
4:	bsr	$3, 5f			// Push PC.
pvc$osf66$5101.1:
	ret	$31, ($2)		// Pop PC.
pvc$osf63$5103:
5:	bsr	$4, 6f			// Push PC.
pvc$osf65$5102.1:
	ret	$31, ($3)		// Pop PC.
6:	hw_mtpr    $31, 0				// Wait 4 cycles.
	hw_mtpr    $31, 0
	hw_mtpr    $31, 0
	hw_mtpr    $31, 0
pvc$osf64$5103.1:
	ret	$31, ($4)		// Pop PC.



7:	hw_mfpr	$1, (1<<6) + 0x5			// Unlock VA.
	hw_mfpr	$2, (1<<6) + 0xB		// Read pseudo-IPR to unlock DC_STAT.

	hw_mfpr	$1, (1<<6) + 0x9		// Clear errors in BIU_STAT IPR by
	hw_mfpr	$2, (1<<6) + 0xD		// reading BIU_ADDR and FILL_ADDR IPRs.
	hw_mtpr	$31, (1<<6) + 0x14		// Unlock BC_TAG.



	hw_mtpr	$31, (1<<5) + 0xA
	or	$31, 64, $1		// Loop 64 times to clear all registers.
	hw_mtpr    $31, 0				// Wait before reading.
	hw_mtpr    $31, 0
	hw_mtpr    $31, 0
8:	hw_mfpr	$31, (1<<5) + 0xA		// Read and clear register mask.
	hw_mfpr	$31, (1<<5) + 0xA		// Read and clear register mask.
	hw_mfpr	$31, (1<<5) + 0xA		// Read and clear register mask.
	hw_mfpr	$31, (1<<5) + 0xA		// Read and clear register mask.
	subq	$1, 4, $1		// Decrement loop counter.
	bne	$1, 8b			// Loop till $31.









	hw_mfpr	$1, (1<<7) + 0x1B		// Get swap flag.
	srl	$1, 32, $2	// Shift the SWAP flag into position.
	zapnot	$1, 0xF, $1		// Clear swap flag longword.
	hw_mtpr	$1, (1<<7) + 0x1B		// Update the chip.

	ldah	$22, ((0x53574150+0x8000) >> 16)($31); lda	$22, (0x53574150&0xffff)($22)		// Get swap flag constant.

	cmpeq	$2, $22, $2		// Compare flag against constant.
	beq	$2, 9f			// Branch if not SWPPAL, to come up as normal.




	rpcc	$2			// Read the process cycle counter.
	hw_mtpr	$18, (1<<7) + 0x1F		// Set the new PCBB.
	hw_ldq/p	$30, 0x0000($18)	// Get the new kernel stack pointer.
	hw_ldq/p	$22, 0x0008($18)	// Get the new user stack pointer.
	hw_ldq/p	$23, 0x0010($18)	// Get the new page table base.
	hw_ldq/p	$24, 0x0018($18)	// Get the new cycle counter.
	hw_ldq/p	$25, 0x0028($18)	// Get the new floating point enable.
	hw_mtpr	$22, (1<<7) + 0x12		// Set the new USP.	





	srl	$23, 63, $1		// Check new PTBR<63> for physical mode.
	bis	$19, $1, $19		// If physical mode, mark it so.

	sll	$23, 13, $23	// Convert PFN to PTBR physical address.
	bis	$23, $1, $23		// If physical mode, mark it so.
	hw_mtpr	$23, (1<<7) + 0x1C		// Set the new PTBR.

	subl	$24, $2, $2		// Generate new CC<Offset>.
	sll	$2, 32, $2		// Shift into position.
	hw_mtpr	$2, (1<<6) + 0x10			// Set the new PCC.






	hw_mtpr    $31, 0
	srl	$25, 63-4, $1		// Move PME to position relative to FEN.
	hw_mfpr	$3, (1<<7) + 0x2			// Get current ICCSR shadow value.
	lda	$4, 0x7F9($31)		// ICCSR<53:42> bit mask.
	sll	$4, 42, $4	// Shift mask into correct position.
	and	$25, 1, $25		// Isolate FEN.
	bic	$3, $4, $3		// Clear ASN, PME, and FPE bits.
	or	$1, $25, $25		// Merge FEN and PME.
	bic	$25, 0x16, $25		// Clear stray bits.
	srl	$24, 32-5, $24		// Move ASN to low order position.
	bic	$24, 0x1F, $24		// Isolate ASN.
	or	$24, $25, $24		// Merge FEN/PME and ASN bits.
	sll	$24, 42, $24	// Shift into correct position.
	or	$3, $24, $3		// Merge into ICCSR.
	hw_mtpr	$3, (1<<7) + (1<<5) + 0x2		// Update ICCSR and shadow.

	hw_mtpr	$31, (1<<6) + 0x15		// Flush the I-cache.
	hw_mtpr    $31, 0				// Need 9 stalls after flush.
	hw_mtpr    $31, 0
	hw_mtpr    $31, 0
	hw_mtpr    $31, 0
	hw_mtpr    $31, 0
	hw_mtpr    $31, 0
	hw_mtpr    $31, 0
	hw_mtpr    $31, 0
	hw_mtpr    $31, 0
	hw_mtpr	$31, (1<<6) + (1<<5) + 0x6		// Zap the ITB/DTB.
	bic	$17, 3, $17		// Clean the PC.
	hw_mtpr	$17, (1<<5) + 0x4		// Set the new PC.
	hw_mtpr	$19, (1<<7) + 0x1D		// Set the new VPTPTR.

pvc$osf70$5020:
	bsr	$0, sys_reset_swppal	// Do platform specific stuff.

	bis	$31, $31, $0		// Set return status to success.
	hw_mtpr    $31, 0
	hw_rei				// Begin execution at new PC.











9:      hw_mtpr    $31, (1<<7) + 0x1C            // Clear page table base register.
	hw_mtpr	$31, (1<<7) + 0x13		// Clear kernel stack pointer.
	hw_mtpr	$31, (1<<7) + 0x18		// Clear system value register.






	hw_mtpr    $31, 0				// Avoid MT/MF conflict
	hw_mtpr    $31, 0
	hw_mfpr	$1, (1<<7) + 0x11		// Get base of impure area.
	lda	$1, 0xA0($1)	// Point to a scratch location.
	hw_mtpr	$1, (1<<7) + 0x1F		// Initialize PCB to scratch location.

        lda     $1, 2($31)             // Get a '2'
        sll     $1, 32, $1              // Generate upper bits.
	hw_mtpr	$1, (1<<7) + 0x1D		// Establish virtual page table pointer.




	or	$0, $31, $0
	or	$1, $31, $1
	or	$2, $31, $2
	or	$3, $31, $3
	or	$4, $31, $4
	or	$5, $31, $5
	or	$6, $31, $6
	or	$7, $31, $7
	or	$8, $31, $8
	or	$9, $31, $9
	or	$10, $31, $10
	or	$11, $31, $11
	or	$12, $31, $12
	or	$13, $31, $13
	or	$14, $31, $14
	or	$15, $31, $15
	or	$16, $31, $16
	or	$17, $31, $17
	or	$18, $31, $18
	or	$19, $31, $19
	or	$20, $31, $20
	or	$21, $31, $21
	or	$22, $31, $22
	or	$23, $31, $23
	or	$24, $31, $24
	or	$25, $31, $25
	or	$26, $31, $26
	or	$27, $31, $27
	or	$28, $31, $28
	or	$29, $31, $29
	or	$30, $31, $30



	hw_mtpr	$31, (1<<6) + 0x11		// Clear CC<31:0>
	hw_mtpr	$31, (1<<6) + 0x10		// Clear CC<63:32>
	lda	$3, 0x1($31)		// Get a '1'
	sll	$3, 32, $3		// Shift it into position.
	hw_mtpr	$3, (1<<6) + 0x11		// Enable the cycle counter.

	hw_mtpr	$31, (1<<6) + (1<<5) + 0x6		// Clear the translation buffers.

pvc$osf68$5104:
	bsr	$26, sys_reset		// Do platform specific initialization.
	rc	$31			// Clear the intr_flag.

	hw_mfpr	$2, (1<<7) + 0x11		// Get the base of impure scratch area.
	lda	$2, 0x100($2)	// Point to the save state area.

	hw_ldq/p   $0,  (0x0 + 0x00)($2); hw_ldq/p   $1,  (0x0 + 0x08)($2); hw_ldq/p   $3,  (0x0 + 0x18)($2); hw_ldq/p   $4,  (0x0 + 0x20)($2); hw_ldq/p   $5,  (0x0 + 0x28)($2); hw_ldq/p   $6,  (0x0 + 0x30)($2); hw_ldq/p   $7,  (0x0 + 0x38)($2); hw_ldq/p   $8,  (0x0 + 0x40)($2); hw_ldq/p   $9,  (0x0 + 0x48)($2); hw_ldq/p   $10, (0x0 + 0x50)($2); hw_ldq/p   $11, (0x0 + 0x58)($2); hw_ldq/p   $12, (0x0 + 0x60)($2); hw_ldq/p   $13, (0x0 + 0x68)($2); hw_ldq/p   $14, (0x0 + 0x70)($2); hw_ldq/p   $15, (0x0 + 0x78)($2); hw_ldq/p   $16, (0x0 + 0x80)($2); hw_ldq/p   $17, (0x0 + 0x88)($2); hw_ldq/p   $18, (0x0 + 0x90)($2); hw_ldq/p   $19, (0x0 + 0x98)($2); hw_ldq/p   $20, (0x0 + 0xA0)($2); hw_ldq/p   $21, (0x0 + 0xA8)($2); hw_ldq/p   $22, (0x0 + 0xB0)($2); hw_ldq/p   $23, (0x0 + 0xB8)($2); hw_ldq/p   $24, (0x0 + 0xC0)($2); hw_ldq/p   $25, (0x0 + 0xC8)($2); hw_ldq/p   $26, (0x0 + 0xD0)($2); hw_ldq/p   $27, (0x0 + 0xD8)($2); hw_ldq/p   $28, (0x0 + 0xE0)($2); hw_ldq/p   $29, (0x0 + 0xE8)($2); hw_ldq/p   $30, (0x0 + 0xF0)($2); hw_ldq/p   $31, (0x0 + 0xF8)($2); hw_ldq/p   $2,  (0x0 + 0x10)($2)			// Restore previous saved GPR state.

	hw_mtpr	$1, (1<<7) + 0x0			// Save original $1 in (1<<7) + 0x0.
	lda	$1, 0x0000($31)	// Mark reason for entry
        br      $31, sys_enter_console // Transfer to console I/O mode ...





	.align  5

pal_mchk_cont:
	hw_mtpr	$1, (1<<7) + 0x0			// Save $1.
	hw_mtpr	$2, (1<<7) + 0x1                 // Save $2.
	hw_mtpr	$4, (1<<7) + 0x3                 // Save $4.

	hw_mfpr	$1, (1<<5) + 0x4		// Get PC
	subq	$1, 2, $1		// If CALL_PAL need PC-4, otherwise,
	bic	$1, 2, $1		// just clean bottom bits of PC.
	hw_mtpr	$1, (1<<5) + 0x4		// Update the chip.

	blbc	$1, 1f			// Check for MCHK from PAL mode.
	lda	$1, 0x0007($31)	// If yes, load halt code and
	br	$31, sys_enter_console		// enter console ...

	.align  3
1:






	hw_mfpr	$2, (1<<7) + 0x11		// Get pointer to impure scratch area.
	lda	$2, 0x100($2)	// Point to the save state area.
	hw_ldq/p	$4, 0x338($2) 	// Read BIU_CTL
	and	$4, (1<<1), $1	// Check if ECC or parity mode?
	bne	$1, 2f			// If ECC, no need to flush the D-cache.






	lda	$4, (1<<1)($31)
	hw_mtpr	$4, (1<<6) + 0xE		// Flush the D-cache.
	hw_mtpr    $31, 0				// Required stall ...
	hw_mtpr    $31, 0
	hw_ldq/p	$4, 0x330($2)
	hw_mtpr	$4, (1<<6) + 0xE		// Restore saved ABOX_CTL value.
	hw_mtpr    $31, 0				// Required stall ...
	hw_mtpr    $31, 0




2:	lda	$4, 0x008A($31) // Assume error is unknown for now. 
	hw_mfpr	$1, (1<<6) + 0xA		 // Read BIU status.




	and	$1, (1<<2), $2
	cmovne	$2, 0x0080, $4




	and	$1, (1<<3), $2
	cmovne	$2, 0x0082, $4



	and	$1, (1<<0), $2
	cmovne	$2, 0x0084, $4

	cmpeq	$4, 0x008A, $2	 // Is error still unknown?
	beq	$2, pal_mchk_logout	 // If not, go create the logout frame








	hw_mfpr	$2, (1<<6) + 0xC		// Check who we are.
				        // (this will reset EV45 error bits)
	lda	$4, 0x0088($31)	// Assume uncorrectable ECC error
	blbc	$2, pal_mchk_logout	// Doesn't support ECC or cache parity



	and	$2, ((1<<4) | (1<<5)), $4
	beq	$4, 4f			// Not cache parity, go try ECC ..

	lda	$4, (1<<8)($31)
	and	$4, $1, $4 		// Check for an ECC error.
	blbc	$4, 3f    		// Not ECC, so continue ..
	lda	$4, 0x008A($31)// If ECC error, give up!
	br	$31, pal_mchk_logout	// Go build the logout frame ...



	.align  3

3:	lda	$4, 0x0094($31)	// Assume it's an I-cache parity error.
	and	$2, (1<<5), $1 // Is it really an I-cache error?
	cmoveq	$1, 0x0092, $4	// If not, must be D-cache parity error.
	sll	$2, 32, $2		// Shift C_STAT into upper longword.
	or	$2, $4, $4		// Put error code into lower longword.
	beq	$1, pal_mchk_logout	// Go log error if not I-cache error




	hw_mfpr	$1, (1<<7) + 0x19
	srl	$1, 0, $1	// check MIP bit
	blbc	$1, pal_mchk_logout	// if not busy log it, else dismiss it.
	hw_mfpr	$1, (1<<7) + 0x0			// Restore scratch registers
	hw_mfpr	$2, (1<<7) + 0x1
	hw_mfpr	$4, (1<<7) + 0x3
	hw_rei				// And back we go ...

	.align  3

4:	lda	$4, 0x0088($31)	// Assume uncorrectable once again.




	lda	$2, (1<<8)($31)
	and	$2, $1, $2
	beq	$2, sys_mchk 		// Not ECC, something else going on ...





	lda	$2, (1<<14)($31)
	and	$2, $1, $2
	bne	$2, pal_mchk_logout	// Unable to correct this error.



	lda	$2, (1<<9)($31)
	and	$2, $1, $2
	beq	$2, pal_mchk_logout	// If not CRD, unable to correct error.









	hw_mtpr	$5, (1<<7) + 0x4			// Save $5.
pvc$osf11$5000:
	bsr	$5, pal_mchk_and_arith	// Check for and deal with arith error.
	hw_mfpr	$5, (1<<7) + 0x4			// Restore $5.





        hw_mfpr    $1, (1<<7) + 0x9			// Get shadow copy of PS
        hw_mfpr    $2, (1<<5) + 0x4             // Get the PC.
        bic     $2, 3, $2               // Clean lower bits of PC.

	sll	    $1, 63-3, $1;	bge	    $1, 0f;	hw_mtpr    $30, (1<<7) + 0x12;	hw_mfpr    $30, (1<<7) + 0x13;	hw_mtpr    $31, (1<<7) + (1<<5) + 0x9;	0:  srl	    $1, 63-3, $1;	lda	    $30, 0-48($30); hw_stq/a   $1, 0x0000($30);	hw_stq/a   $2, 0x0008($30);	hw_stq/a   $29, 0x0010($30);	hw_stq/a   $16, 0x0018($30);	hw_stq/a   $17, 0x0020($30);	hw_stq/a   $18,	0x0028($30)

        br      $31, pal_crd_handler 	// Dispatch to CRD handler ...











 
	.align  3

pal_mchk_pal:				  // Exception illegal in PAL mode
	lda	$4, 0x008E($31)
	br	$31, pal_mchk_logout
	
	.align  3

pal_mchk_callsys:			  // Callsys from kernel mode
	lda	$4, 0x0090($31)
	br	$31, pal_mchk_logout

	.align  3

pal_mchk_ksp_not_valid:			  // kernel stack not valid halt
	hw_mfpr	$22, (1<<7) + 0x1F		  // get process control block base
        hw_mfpr	$23, (1<<7) + 0x9			  // get shadow copy of (1<<5) + 0x9
        and	$23, (1<<3), $23		  // get current mode
        beq	$23, 1f			  // check if already in kernel mode
        hw_mtpr	$30, (1<<7) + 0x12		  // save user stack
        hw_stq/p   $30, 0x0008($22)	  // store usp
        br      $31, 2f		  // join common
1:	hw_stq/p   $30, 0x0000($22)	  // store ksp
2:	rpcc	$23			  // get cycle counter
        srl	$23, 32, $24		  // move offset
        addl    $23, $24, $24		  // merge for new time
        hw_stl/p   $24, 0x0018($22)	  // save time
	lda	$1, 0x0002($31) // set the halt code
	br	$31, sys_enter_console   // go enter console ...





        .align  3

pal_mchk_logout:





	hw_mtpr	$31, (1<<6) + 0xF		// make sure altmode is KERNEL mode
	hw_mfpr	$1, (1<<7) + 0x19		// get MCES bits
	srl	$1, 0, $2	// shift MCES<MIP> into lsb
	blbc	$2, 1f          	// if no mchk's in progress, continue
	lda	$1, 0x0006($31)// else load halt code
	br	$31, sys_enter_console	// and enter console ...

1:	lda	$2, (1<<0)($31)    // get machine-check-in-progress flag
	bis	$1, $2, $1		// set the MCES<MIP> bit
	hw_mtpr	$1, (1<<7) + 0x19		// save it in the chip



	hw_mfpr	$2, (1<<7) + 0x11		// get base address of impure area
	lda	$2, ((0x100+0x378)+0x0048)($2)	// point to the full logout area
	lda	$1, 0x0110($31)// cpu offset
	hw_stl/p	$1, 0x0008($2) 	// set offset
	lda	$1, 0x01A0($31)	// sys offset
	hw_stl/p	$1, 0x000C($2) 	// set offset

	lda	$1, 0x01A0($31) 	// frame size
	hw_stl/p	$1, 0x0000($2) 	// set frame size





	zapnot	$4, 0xF, $1		// extract error code
	cmpeq	$1, 0x0094, $1	// was it an I-cache parity error?
	sll	$1, 31, $1		// answer becomes retry flag (yes = 1)
	hw_stl/p	$1, 0x0004($2)	// store retry flag
	srl	$4, 32, $1		// get C_STAT value or $31 if not 
				        // I-cache parity error
	hw_stq/p	$1, 0x0150($2)	// store C_STAT value
	zap	$4, 0xF0, $4		// clear C_STAT info (if any)

	lda	$1, 0x0001($31)	// get mchk rev level
	sll	$1, 32, $1		// move into position
	bis	$4, $1, $4		// merge rev level and error code
	hw_stq/p	$4, 0x0010($2)	// set error code (why in PT0?)



	hw_mfpr	$1, (1<<7) + 0x1
	hw_stq/p	$1, 0x0018($2)
	hw_mfpr	$1, (1<<7) + 0x2
	hw_stq/p	$1, 0x0020($2)
	hw_mfpr	$1, (1<<7) + 0x3
	hw_stq/p	$1, 0x0028($2)
	hw_mfpr	$1, (1<<7) + 0x4
	hw_stq/p	$1, 0x0030($2)
	hw_mfpr	$1, (1<<7) + 0x5
	hw_stq/p	$1, 0x0038($2)
	hw_mfpr	$1, (1<<7) + 0x6
	hw_stq/p	$1, 0x0040($2)
	hw_mfpr	$1, (1<<7) + 0x7
	hw_stq/p	$1, 0x0048($2)
	hw_mfpr	$1, (1<<7) + 0x8
	hw_stq/p	$1, 0x0050($2)
	hw_mfpr	$1, (1<<7) + 0x9
	hw_stq/p	$1, 0x0058($2)
	hw_mfpr	$1, (1<<7) + 0xA
	hw_stq/p	$1, 0x0060($2)
	hw_mfpr	$1, (1<<7) + 0xB
	hw_stq/p	$1, 0x0068($2)
	hw_mfpr	$1, (1<<7) + 0xC
	hw_stq/p	$1, 0x0070($2)
	hw_mfpr	$1, (1<<7) + 0xD
	hw_stq/p	$1, 0x0078($2)
	hw_mfpr	$1, (1<<7) + 0XE
	hw_stq/p	$1, 0x0080($2)
	hw_mfpr	$1, (1<<7) + 0xF
	hw_stq/p	$1, 0x0088($2)
	hw_mfpr	$1, (1<<7) + 0x10
	hw_stq/p	$1, 0x0090($2)
	hw_mfpr	$1, (1<<7) + 0x11
	hw_stq/p	$1, 0x0098($2)
	hw_mfpr	$1, (1<<7) + 0x12
	hw_stq/p	$1, 0x00A0($2)
	hw_mfpr	$1, (1<<7) + 0x13
	hw_stq/p	$1, 0x00A8($2)
	hw_mfpr	$1, (1<<7) + 0x14
	hw_stq/p	$1, 0x00B0($2)
	hw_mfpr	$1, (1<<7) + 0x15
	hw_stq/p	$1, 0x00B8($2)
	hw_mfpr	$1, (1<<7) + 0x16
	hw_stq/p	$1, 0x00C0($2)
	hw_mfpr	$1, (1<<7) + 0x17
	hw_stq/p	$1, 0x00C8($2)
	hw_mfpr	$1, (1<<7) + 0x18
	hw_stq/p	$1, 0x00D0($2)
	hw_mfpr	$1, (1<<7) + 0x19
	hw_stq/p	$1, 0x00D8($2)
	hw_mfpr	$1, (1<<7) + 0x1A
	hw_stq/p	$1, 0x00E0($2)
	hw_mfpr	$1, (1<<7) + 0x1B
	hw_stq/p	$1, 0x00E8($2)
	hw_mfpr	$1, (1<<7) + 0x1C
	hw_stq/p	$1, 0x00F0($2)
	hw_mfpr	$1, (1<<7) + 0x1D
	hw_stq/p	$1, 0x00F8($2)
	hw_mfpr	$1, (1<<7) + 0x1E
	hw_stq/p	$1, 0x0100($2)
	hw_mfpr	$1, (1<<7) + 0x1F
	hw_stq/p	$1, 0x0108($2)



	hw_mtpr	$5, (1<<7) + 0x4                 // save $5
	hw_mtpr	$2, (1<<7) + 0x5			// save frame pointer

pvc$osf13$5000:
	bsr	$5, pal_mchk_and_arith	// go check for and deal with arith
	hw_mfpr	$2, (1<<7) + 0x5			// restore frame pointer



	hw_mfpr	$1, (1<<7) + 0x9			// propagate from arith
	hw_stq/p	$1, 0x0058($2)
	hw_mfpr	$1, (1<<5) + 0x4
	hw_stq/p	$1, 0x0110($2)
	hw_mfpr	$1, (1<<5) + 0xB
	hw_stq/p	$1, 0x0130($2)
	hw_mfpr	$1, (1<<5) + 0x10
	hw_stq/p	$1, 0x0138($2)
	hw_mfpr	$1, (1<<5) + 0xC
	hw_stq/p	$1, 0x0140($2)
	hw_mfpr	$1, (1<<6) + 0x4
	hw_stq/p	$1, 0x0148($2)




	hw_ldq/p	$1, 0x0150($2)	// get DC_STAT value
	bne	$1, 1f			// if not $31, already got C_STAT
	hw_mfpr	$1, (1<<6) + 0xC		// get DC_STAT for non-EV45
	hw_stq/p	$1, 0x0150($2)   // store DC_STAT
1:	hw_mfpr	$1, (1<<6) + 0xB
	hw_stq/p	$1, 0x0158($2)



	hw_mfpr	$4, (1<<7) + 0x11
	lda	$4, 0x100($4)
	hw_ldq/p	$1, 0x330($4)
	hw_stq/p	$1, 0x0160($2)




	hw_ldq/p	$1, 0x338($4)
	hw_stq/p	$1, 0x0178($2)

        hw_mfpr	$1, (1<<6) + 0xA
        hw_stq/p	$1, 0x0168($2)
        hw_mfpr	$1, (1<<6) + 0x9
        hw_stq/p	$1, 0x0170($2)
        hw_mfpr	$1, (1<<6) + 0x13
        hw_stq/p	$1, 0x0180($2)
        hw_mfpr	$1, (1<<6) + 0xD
        hw_stq/p	$1, 0x0188($2)
        hw_mfpr	$1, (1<<6) + 0x5
        hw_stq/p	$1, 0x0190($2)
        ornot   $31, 1<<2, $1 // get acknowledge bit for crd
        hw_mtpr	$1, (1<<5) + 0x13                 // acknowledge any pending crds



        or      $31, $31, $4          // init counter
        or      $31, $31, $5          // start with no bits set
2:	hw_mfpr	$1, (1<<6) + 0x14               // get next bit of bc_tag
        sll     $1, $4, $1              // move current mask over by one
        or      $5, $1, $5              // set this bit in the mask
        addq    $4, 1, $4               // increment counter
        cmplt   $4, 64, $1              // are we done?
        blbs    $1, 2b		        // loop till done

        hw_mtpr	$31, (1<<6) + 0x14		// unlock bc_tag
        hw_stq/p   $5, 0x0198($2)	// and store it

        br      $31, sys_mchk_logout   // go log platform specific info ...









 
	.align  3

pal_mchk_kernel_mode_trap:
        hw_mfpr	$1, (1<<7) + 0x9			// Get shadow copy of PS.
        hw_mfpr	$4, (1<<5) + 0x4             // Get the PC.
	bic	$4, 3, $4		// Clean off lower bits of the PC.

	sll	    $1, 63-3, $1;	bge	    $1, 0f;	hw_mtpr    $30, (1<<7) + 0x12;	hw_mfpr    $30, (1<<7) + 0x13;	hw_mtpr    $31, (1<<7) + (1<<5) + 0x9;	0:  srl	    $1, 63-3, $1;	lda	    $30, 0-48($30); hw_stq/a   $1, 0x0000($30);	hw_stq/a   $4, 0x0008($30);	hw_stq/a   $29, 0x0010($30);	hw_stq/a   $16, 0x0018($30);	hw_stq/a   $17, 0x0020($30);	hw_stq/a   $18,	0x0028($30)

        or      $31, 0x7, $1	// Get new PS (mode=kernel, ipl=7).
        hw_mtpr	$1, (1<<7) + (1<<5) + 0x9              // Set new PS and shadow.
 	hw_mfpr	$1, (1<<7) + 0xA		// Get pointer to interrupt handler.
	subq	$31, 1, $18		// Get a '-1'
	srl	$18, 42, $18		// Shift off low bits for kseg address.
	sll	$18, 42, $18		// Shift kseg bits back into position.
	lda	$16, 0x2($31)	// Pass MCHK entry code in $16.

	hw_ldl/p	$4, 0x0010($2)	// Get back MCHK reason.
	lda	$5, 0x0200($31)	// Base value for system machine checks.
	subq	$4, $5, $5		// Code - base value.

	lda	$17, 0x0670($31)// Pass procmchk SCB vector in $17.
	blt	$5, 1f			// Branch when processor machine check.
	lda	$17, 0x0660($31)	// Change to system machine check.
1:
	hw_mfpr	$5, (1<<7) + 0x16		// Get interrupt mask.
	bis	$18, $2, $18		// Pass ptr to logout area as kseg addr.
	hw_mtpr	$1, (1<<5) + 0x4		// Load kernel interrupt handler entry.
	extbl	$5, 0x7, $5	// Get the right mask.
	insbl	$5, 1, $5		// Shift it into position for HIER.
	hw_mtpr	$5, (1<<5) + 0x10		// Set the new interrupt enable mask.

	hw_mfpr	$4, (1<<7) + 0x3			// Restore scratch registers.
	hw_mfpr	$2, (1<<7) + 0x1
	hw_mfpr	$1, (1<<7) + 0x0
	hw_mfpr	$5, (1<<7) + 0x4
	hw_mfpr	$29, (1<<7) + 0x14		// Load the kernel global pointer.
	hw_rei				// Dispatch to kernel interrupt handler












	.align  3

pal_mchk_and_arith:
	hw_mfpr	$1, (1<<5) + 0xA		// get exc_sum
	hw_mtpr	$31, (1<<5) + 0xA		// clear error bits
	srl	$1, 2, $1	// shift data to correct position
	bne	$1, 1f			// skip arith trap unless needed
pvc$osf28$5000.1:
	ret	$31, ($5)		// back we go if no arith under mchk

1:	hw_mfpr	$2, (1<<7) + 0x9			// get (1<<5) + 0x9
	hw_mfpr	$4, (1<<5) + 0x4		// get pc
	bic	$4, 3, $4		// clean pc

	sll	    $2, 63-3, $2;	bge	    $2, 0f;	hw_mtpr    $30, (1<<7) + 0x12;	hw_mfpr    $30, (1<<7) + 0x13;	hw_mtpr    $31, (1<<7) + (1<<5) + 0x9;	0:  srl	    $2, 63-3, $2;	lda	    $30, 0-48($30); hw_stq/a   $2, 0x0000($30);	hw_stq/a   $4, 0x0008($30);	hw_stq/a   $29, 0x0010($30);	hw_stq/a   $16, 0x0018($30);	hw_stq/a   $17, 0x0020($30);	hw_stq/a   $18,	0x0028($30)

	bis	$1, $31, $16		// shift exception summary into $16
	bis	$31, 63, $2		// get a counter
	bis	$31, $31, $17		// clear register acculmulator
	bis	$31, $31, $1		// fr31 never traps








2:	hw_mfpr	$18, (1<<5) + 0xA		// get next bit
	sll	$17, 1, $17		// move current mask over by one
	cmplt	$31, $1, $1		// set bit<0> if MSK was set
	bis	$17, $1, $17		// 'or' result into $17<0>
	sll	$17, 1, $17		// move current mask over by one
	hw_mfpr	$1, (1<<5) + 0xA		// get next bit
	cmplt	$31, $18, $18		// set bit<0> if MSK was set
	subq	$2, 2, $2		// dec counter
	bis	$17, $18, $17		// set this bit in mask
	bge	$2, 2b			// loop till done

	hw_mfpr	$1, (1<<7) + 0xC		// get (1<<6) + 0x5 for arithmetic exception
	hw_mfpr	$29, (1<<7) + 0x14		// get the kern $29
	hw_mtpr	$1, (1<<5) + 0x4		// set up (1<<6) + 0x5
pvc$osf29$5000.2:
	ret	$31, ($5)		// now that the arith is recorded
					// go handle the mchk.

	.align  5

pal_arith_cont:











	hw_mfpr	$18, (1<<5) + 0xA		// get next bit
	sll	$17, 1, $17		// move current mask over by one
	cmplt	$31, $1, $1		// set bit<0> if MSK was set
	bis	$17, $1, $17		// 'or' result into $17<0>
	sll	$17, 1, $17		// move current mask over by one
	hw_mfpr	$1, (1<<5) + 0xA		// get next bit
	cmplt	$31, $18, $18		// set bit<0> if MSK was set
	subq	$2, 2, $2		// decrement by 2 the counter
	bis	$17, $18, $17		// 'or' result into $17<0>
	bge	$2, pal_arith_cont	// loop till done

	hw_mfpr	$1, (1<<7) + 0xC		// get the (1<<6) + 0x5 of the arith routine
	hw_mfpr	$2, (1<<7) + 0x1			// restore scratch
	hw_mfpr	$4, (1<<7) + 0x3			// restore scratch
	hw_mfpr	$29, (1<<7) + 0x14		// set the kernel $29
	hw_mtpr	$1, (1<<5) + 0x4		// set the (1<<6) + 0x5 of the arith routine
	hw_mfpr	$1, (1<<7) + 0x0			// restore scratch
	hw_rei				// dispatch to kernel arith handler








	.align  3

pal_crd_handler:








	hw_mfpr	$16, (1<<6) + 0xA		    // Get BIU status.
	srl	$16, 8, $16 // Get ECC bit into lsb.
	and	$16, 1, $16		    // Isolate to single bit.





	hw_mfpr	$2, (1<<7) + 0x19		// Get MCES bits.
	srl	$2, 1, $2	// Shift PCE/SCE into lsb.
	and	$2, 3, $2		// Check if either bit is set.
	beq	$2, pal_crd_logout	// If clear, go build the logout frame.








	hw_mtpr    $31, 0
	hw_mfpr	$4, (1<<6) + 0xD		// Get the cache fill address.






pal_crd_merge:
	blbc	$16, 1f			// Skip scrub if SCE.
pvc$osf19$5004:
	bsr	$1, sys_scrub_mem	// Go scrub the error ...
	bis	$31, 1, $16		// Restore ECC error flag.

1:	subq	$31, 1, $1		// Get a '-1'.
	lda	$4, (1<<2)($31) // Get acknowledge bit.
	bic	$1, $4, $1		// Invert for write-$31-to-clear.
	hw_mtpr	$1, (1<<5) + 0x13		// Acknowledge the CRD interrupt.





	hw_mfpr	$1, (1<<7) + 0x19		// Get MCES bits.
	lda	$4, (1<<4)($31)	// Isolate the MCES<DSC> bit.
	srl	$4, $16, $4		// Shift DSC bit into MCES<DPC> position.
	and	$1, $4, $4		// Check if reporting is enabled.
	bne	$4, 2f			// Reporting disabled, dismiss interrupt.
	lda	$4, 3<<(1<<1)($31)	// Get mask for PCE/SCE bits.
	and	$1, $4, $4		// Check if error already in progress.
	bne	$4, 2f			// If so, dismiss the interrupt.





	lda	$4, (1<<1)($31)	// Get MCES<SCE> bit mask.
	sll	$4, $16, $4		// If ECC, shift to MCES<PCE> mask.
	bis	$1, $4, $1		// Set the proper bit in the MCES.
	hw_mtpr	$1, (1<<7) + 0x19		// Update the chip.



	lda	$17, 0x0620($31)	// Get SCB vector for SCE.
	sll	$16, 4, $16		// Get increment to change SCE to PCE.
	addq	$17, $16, $17		// Set the correct SCB vector.
	hw_mfpr	$2, (1<<7) + 0x4			// Restore base address of logout area.
	subq	$31, 1, $18		// Get a '-1'
	srl	$18, 42, $18		// Shift off low bits for kseg address.
	sll	$18, 42, $18		// Shift kseg bits back into position.
	bis	$18, $2, $18		// Pass ptr to logout area as kseg addr.
	lda	$16, 0x2($31)	// Pass MCHK entry code in $16.
	lda	$2, 0x7($31)	// Set IPL = 7.
	br	$31, pal_interrupt_post

	.align  3

2:      ldq     $29, 0x0010($30)        // Restore $29
        ldq     $1, 0x0000($30)        // Restore (1<<5) + 0x9
        ldq     $16, 0x0018($30)        // Restore $16
        ldq     $17, 0x0020($30)        // Restore $17
        ldq     $18, 0x0028($30)        // Restore $18
        lda     $30, 48($30)      // Deallocate the frame
        and     $1, (1<<3), $2         // Get the current mode
        beq     $2, 3f                  // Kernel or user mode?
        hw_mfpr    $30, (1<<7) + 0x12               // If user mode, restore $30
3:	hw_mtpr	$1, (1<<7) + (1<<5) + 0x9		// Restore original (1<<5) + 0x9 and shadow
	hw_mtpr    $31, 0
	hw_mtpr    $31, 0
        hw_mfpr    $4, (1<<7) + 0x3                 // Restore scratch registers
        hw_mfpr    $2, (1<<7) + 0x1
        hw_mfpr    $1, (1<<7) + 0x0
        hw_rei                          // Return from interrupt ...




        .align  3

pal_pc_handler:
        lda     $17, 1($31)             // Get a '1'
        subq    $31, 1, $16             // Get a '-1' (for SlClr)
        or      $31, 8, $18  // Get SL_CLR<PC0> bit
        srl     $4, 9, $2      // Get HIRR<PC0> into lsb
        and     $2, 1, $2               // Isolate to single bit
        cmovlbc $2, 15, $18    // If PC1, get SL_CLR<PC1> bit
        sll     $17, $18, $17              // Shift clearing bit into position
        bic     $16, $17, $16              // Invert for write-$31-to-clear
        hw_mtpr    $16, (1<<5) + 0x13               // Clear the correct bit
        bis     $31, 0x4, $16    // Flag as performance counter
        lda     $17, 0x650($31)         // Load the SCB vector
        cmpeq   $2, $31, $18            // $18 = 0 for PC0, $18 = 1 for PC1
        bis     $31, 0x6, $2    // Load new IPL
	br	$31, pal_interrupt_post
















	.align  3

pal_interrupt_post:

        hw_mfpr    $4, (1<<7) + 0x16           // Fetch the interrupt mask
        extbl   $4, $2, $4              // Extract the mask bits
        insbl   $4, 1, $4               // Move it to right location for HIER

	cmple   $2, 6, $1		// are crd's blocked? 0=> blocked
	s4addq	$1, 0, $1		// move into position
	bis	$4, $1, $4		// enable crd's if not high ipl

	hw_mfpr	$1, (1<<7) + 0xA		// Get ptr to the kernel interrupt handler
	hw_mtpr	$2, (1<<7) + (1<<5) + 0x9		// Set new ipl
	hw_mtpr	$4, (1<<5) + 0x10		// Set the new enable mask
	hw_mtpr	$1, (1<<5) + 0x4		// Load the (1<<6) + 0x5 of the kernel handler
	hw_mfpr    $29, (1<<7) + 0x14		// Set new $29
	hw_mfpr	$4, (1<<7) + 0x3			// Restore scratch registers
	hw_mfpr	$2, (1<<7) + 0x1
	hw_mfpr	$1, (1<<7) + 0x0			
	hw_rei				// Dispatch to kernel interrupt handler






	.align  3

pal_crd_logout:
	hw_mfpr	$2, (1<<7) + 0x11		// Get base address of impure area.
	lda	$2, (0x100+0x378)($2)	// Point to the short logout area.

	lda	$1, 0x0018($31) // Offset to CPU specific part of frame.
	hw_stl/p	$1, 0x0008($2)	// Store CPU offset.
	lda	$1, 0x0048($31)	// Get the frame size.
	hw_stl/p	$1, 0x0000($2)	// Store frame size.
	bis	$31, 1, $1		// Get a '1'.
	sll	$1, 31, $1		// Move into retry flag position.
	hw_stl/p	$1, 0x0004($2)	// Store retry flag.
	lda	$4, 0x0001($31)	// Get MCHK revision level.
	sll	$4, 32, $4		// Shift into upper longword.
	lda	$1, 0x0086($4)	// Get ECC error code into low longword.
	lda	$4, 0x008C($4)	// Get soft error code into low longword.
	cmovlbc $16, $4, $1		// Determine ECC or soft error.
	hw_stq/p	$1, 0x0010($2)	// Store error code.



	hw_mfpr	$1, (1<<6) + 0xA
	hw_stq/p	$1, 0x0018($2)
	hw_mfpr	$1, (1<<6) + 0x9
	hw_stq/p	$1, 0x0020($2)
	hw_mfpr	$1, (1<<6) + 0xC
	hw_stq/p	$1, 0x0028($2)
	hw_mfpr	$1, (1<<6) + 0x13
	hw_stq/p	$1, 0x0030($2)
	hw_mfpr	$1, (1<<6) + 0xD
	hw_stq/p	$1, 0x0038($2)

	bis	$31, $31, $1		// init counter
	bis	$31, $31, $4		// start with no bits set
1:	hw_mfpr	$17, (1<<6) + 0x14		// get next bit of bc_tag
	sll	$17, $1, $17		// shift bit over
	bis	$17, $4, $4		// set this bit in mask
	addq	$1, 1, $1		// inc counter
	cmplt	$1, 64, $17		// are we done?
	blbs	$17, 1b			// loop till done

	hw_mtpr	$31, (1<<6) + 0x14		// unlock bc_tag
	hw_stq/p	$4, 0x0040($2)	// and store it




	hw_mtpr	$5, (1<<7) + 0x4			// Save $5.
pvc$osf17$5105:				// Ignore PVC computed goto violation.
	bsr	$5, sys_crd_logout
	hw_mfpr	$5, (1<<7) + 0x4			// Restore $5.




	hw_ldq/p	$4, 0x0038($2) // Get the saved cache fill address
	hw_mtpr	$2, (1<<7) + 0x4			// Save base address of logout area
	br	$31, pal_crd_merge
	


































 
	.align  3

pal_pte_invalid:
	hw_mtpr	$8, (1<<7) + 0x7			// Save $8.
	srl	$5, 9, $8	// Get opcode of faulting instruction.
	bic	$7, 3, $7		// Clean PC of faulting instruction.
	cmpeq	$8, 0x18, $8		// Is this a FETCH[_M] instruction?
	blbs	$8, 4f			// If so, ignore.
	hw_mfpr	$8, (1<<7) + 0x9			// Get the processor status.

	sll	    $8, 63-3, $8;	bge	    $8, 0f;	hw_mtpr    $30, (1<<7) + 0x12;	hw_mfpr    $30, (1<<7) + 0x13;	hw_mtpr    $31, (1<<7) + (1<<5) + 0x9;	0:  srl	    $8, 63-3, $8;	lda	    $30, 0-48($30); hw_stq/a   $8, 0x0000($30);	hw_stq/a   $7, 0x0008($30);	hw_stq/a   $29, 0x0010($30);	hw_stq/a   $16, 0x0018($30);	hw_stq/a   $17, 0x0020($30);	hw_stq/a   $18,	0x0028($30)

	sll	$8, 63-3, $8	// Get the current mode into msb.
	bge	$8, 1f			// Check for kernel vs user mode access.
	srl	$6, 9-8, $6 // Move the user protection fields.
1:	lda	$8, 0x1($31)	// Assume access violation.
	srl	$6, 8, $6	// Get read enable bit into lsb.
	blbc	$5, 2f			// Check for read vs write reference.
	srl	$6, 12-8, $6 // Get write enable bit into lsb.
2:	cmovlbs	$6, 0x0, $8	// Resolve TNV or ACV.
	and	$5, 1, $18		// Indicate read or write reference.
	bne	$5, 3f			// Check for I-stream vs D-stream.
	subq	$31, 1, $18		// Indicate I-stream reference.
3:	bis	$31, $8, $17		// Move MM fault code to $17.
	bis	$31, $4, $16		// Move VA of faulting reference to $16.
	hw_mfpr	$8, (1<<7) + 0xD		// Get kernel MM fault handler entry.
	hw_mfpr	$4, (1<<7) + 0x3			// Restore scratch registers.
	hw_mfpr	$5, (1<<7) + 0x4
	hw_mfpr	$6, (1<<7) + 0x5
	hw_mfpr	$7, (1<<7) + 0x6
	hw_mtpr	$8, (1<<5) + 0x4		// Establish kernel entry point address.
	hw_mfpr	$29, (1<<7) + 0x14		// Load the kernel global pointer.
	hw_mfpr	$8, (1<<7) + 0x7			// Restore $8.
	hw_rei				// Transfer to kernel MM fault handler.




	.align  3

4:	addq	$7, 4, $7		// Increment past FETCH[_M] instruction.
	hw_mfpr	$4, (1<<7) + 0x3			// Restore scratch registers.
	hw_mfpr	$5, (1<<7) + 0x4
	hw_mfpr	$6, (1<<7) + 0x5
	hw_mfpr	$8, (1<<7) + 0x7
	hw_mtpr	$7, (1<<5) + 0x4		// Load new PC address.
	hw_mfpr	$7, (1<<7) + 0x6
	hw_rei				// Resume execution.































 
	.align  3

pal_itb_foe:
	hw_mfpr	$5, (1<<7) + 0x9			// Get the processor status.
	bic	$7, 3, $7		// Clean PC of faulting instruction.

	sll	    $5, 63-3, $5;	bge	    $5, 0f;	hw_mtpr    $30, (1<<7) + 0x12;	hw_mfpr    $30, (1<<7) + 0x13;	hw_mtpr    $31, (1<<7) + (1<<5) + 0x9;	0:  srl	    $5, 63-3, $5;	lda	    $30, 0-48($30); hw_stq/a   $5, 0x0000($30);	hw_stq/a   $7, 0x0008($30);	hw_stq/a   $29, 0x0010($30);	hw_stq/a   $16, 0x0018($30);	hw_stq/a   $17, 0x0020($30);	hw_stq/a   $18,	0x0028($30)

	sll	$5, 63-3, $5	// Get the current mode into msb.
	bge	$5, 1f			// Check for kernel vs user mode access.
	srl	$6, 9-8, $6 // Move user protection fields.
1:	lda	$5, 0x1($31)	// Assume access violation.
	srl	$6, 8, $6	// Get the read enable bit into lsb.
	cmovlbs	$6, 0x3, $5	// Resolve MM fault.
	subq	$31, 1, $18		// Indicate I-fetch reference.
	bis	$31, $5, $17		// Move MM fault code to $17.
	bis	$31, $4, $16		// Move VA of faulting instruction to $16
	hw_mfpr	$5, (1<<7) + 0xD		// Get kernel MM fault handler entry.
	hw_mfpr	$4, (1<<7) + 0x3			// Restore scratch registers.
	hw_mfpr	$6, (1<<7) + 0x5
	hw_mfpr	$7, (1<<7) + 0x6
	hw_mtpr	$5, (1<<5) + 0x4		// Establish kernel entry point address.
	hw_mfpr	$29, (1<<7) + 0x14		// Load the kernel global pointer.
	hw_mfpr	$5, (1<<7) + 0x4			// Restore $5.
	hw_rei				// Transfer to kernel MM fault handler.





	.align  5

pal_halt_cont:

	hw_mtpr	$1, (1<<7) + 0x0			// Save $1.
	hw_mfpr	$1, (1<<5) + 0x4		// Get the current PC address.
	hw_mtpr	$4, (1<<7) + 0x3			// Save $4.
	hw_mfpr	$4, (1<<7) + 0x1F		// Get the process control block.
	hw_mtpr	$5, (1<<7) + 0x4			// Save $5.
	hw_mtpr	$6, (1<<7) + 0x5			// Save $6.

	hw_stq/p	$30, 0x0000($4)	// Kernel mode, store KSP.
	rpcc	$5			// Read the cycle counter.
	srl	$5, 32, $6		// Get CC<Offset>.
	addl	$5, $6, $6		// Merge with CC<Counter>.
	hw_stl/p	$6, 0x0018($4)	// Store new time.

	subq	$1, 4, $1		// Compute address of previous instr.
	hw_mtpr	$1, (1<<5) + 0x4		// Set new PC address.
	lda	$1, 0x0005($31)	// Get halt action code.

	hw_mfpr	$4, (1<<7) + 0x3			// Restore scratch registers.
	hw_mfpr	$5, (1<<7) + 0x4
	hw_mfpr	$6, (1<<7) + 0x5
	br	$31, sys_enter_console	// Transition to console.

	.align  5

pal_swppal_cont:
	hw_mfpr	$1, (1<<7) + 0x1B		// Get (1<<7) + 0x1B.
	zapnot	$1, 0xF, $1		// Clean <63:32>.

	ldah	$0, ((0x53574150+0x8000) >> 16)($31); lda	$0, (0x53574150&0xffff)($0)		// Load the swap flag constant.

	sll	$0, 32, $0	// Shift into position.
	bis	$1, $0, $1		// Set the "I've been switched" flag.
	hw_mtpr	$1, (1<<7) + 0x1B		// Update the chip.

pvc$osf47$1007:				// Ignore PVC violation on computed goto
	jmp	$31, ($16)		// Jump to new PAL!

	.align  5

pal_wrmces_cont:

	xor	$22, (1<<2), $22	// Flip DPC to reflect CRD setting
	bic	$23, (1<<2), $23 	// Clear CRD
	bis	$23, $22, $23		// merge in new CRD enable value
	hw_mtpr	$23, (1<<6) + 0xE		// update in chip and shadow copy
	hw_stq/p	$23, 0x330($16)
	hw_rei				// back to user

	.align  5

pal_wrfen_cont:
	hw_mtpr    $31, 0
	hw_mtpr    $31, 0
	hw_rei				// Return


	.align  5

pal_swpctx_cont:
	subl	$24, $1, $1		// Generate new CC<Offset>.
	sll	$1, 32, $1		// Shift into position.
	hw_mtpr	$1, (1<<6) + 0x10			// Set the new PCC.





	hw_mfpr	$24, (1<<7) + 0x1D		// Get in case we want physical mode.
	hw_mfpr	$22, (1<<7) + 0x1C		// Get the old page table base.
	srl	$23, 63, $1		// Check new PTBR<63> for physical mode.
	bis	$24, $1, $24		// If physical mode, mark it so.
	hw_mtpr	$24, (1<<7) + 0x1D		// Write it back.
	sll	$23, 13, $23	// Convert PFN to physical address.
	bis	$23, $1, $23		// If physical mode, mark it so.













 
	srl	$25, 63-4, $1		// Move PME to position relative to FEN.
	hw_mfpr	$24, (1<<7) + 0x2		// Get the current ICCSR.
	lda	$16, 0x7f9($31)		// ICCSR cleaning mask, no asn/fpe/pme.
	sll	$16, 42, $16	// Move cleaning mask into position.
	and	$25, 1, $25		// Isolate FEN.
	bic	$24, $16, $24		// Clean out <45> and <42> in ICCSR.
	or	$1, $25, $25		// Merge FEN and PME.
	bic	$25, 0x16, $25		// Clear stray bits.
	sll	$25, 42, $25	// Move into position.
	or	$24, $25, $25		// Merge into ICCSR.
	hw_mtpr	$25, (1<<7) + (1<<5) + 0x2		// Update new ICCSR and shadow.

	xor	$22, $23, $22		// old PTBR = new PTBR?
	beq	$22, 1f			// Branch if page table bases equal.
	hw_mtpr	$31, (1<<6) + (1<<5) + 0x7		// Invalidate all TB entries with ASM=0.
	hw_mtpr	$23, (1<<7) + 0x1C		// Save the new page table base.
1:	hw_mtpr    $31, 0				// Wait for IPR updates ...
	hw_mtpr    $31, 0
	hw_mtpr    $31, 0
	hw_mtpr    $31, 0
	hw_mtpr    $31, 0
	hw_mtpr    $31, 0
	hw_rei

	.align  5

pal_tbi_table:
	



pvc$osf1$3000.1:
	hw_mtpr	$31, (1<<6) + 0x15		// Flush all I-cache blocks.
	bis	    $31, $31, $31
	hw_mtpr	$31, (1<<6) + (1<<5) + 0x6		// Invalidate all ITB/DTB entries.
	br	$31, 1f	



pvc$osf2$3000.2:
	hw_mtpr	$31, (1<<6) + 0x17	// Flush all I-cache blocks with ASM=0.
	bis	    $31, $31, $31
	hw_mtpr	$31, (1<<6) + (1<<5) + 0x7		// Invalidate ITB/DTB entries with ASM=0
	br	$31, 1f



pvc$osf3$3000.3:
	hw_rei				// Just return.
	.long	0			// Pad out to 16 bytes.
	.long	0
	.long	0



pvc$osf4$3000.4:
	hw_mtpr	$31, (1<<6) + 0x15		// Flush all I-cache blocks.
	bis	    $31, $31, $31
	hw_mtpr	$17, (1<<5) + 0x8		// Invalidate single ITB entry.
	br	$31, 1f



pvc$osf5$3000.5:
	hw_mtpr	$17, (1<<6) + 0x8		// Invalidate single DTB entry.
	hw_mtpr    $31, 0
	hw_rei
	.long	0



pvc$osf6$3000.6:
	hw_mtpr	$31, (1<<6) + 0x15		// Flush all I-cache blocks.
	hw_mtpr	$17, (1<<6) + 0x8		// Invalidate single DTB entry.
	hw_mtpr	$17, (1<<5) + 0x8		// Invalidate single ITB entry.
	br	$31, 1f

	.align  3
1:	hw_mtpr    $31, 0				// Wait for IPR updates ...
	hw_mtpr    $31, 0
	hw_mtpr    $31, 0
	hw_mtpr    $31, 0
	hw_mtpr    $31, 0
	hw_mtpr    $31, 0
	hw_mtpr    $31, 0
	hw_rei

	.align  5

pal_wrent_table:

pvc$osf21$3100.1:
	hw_mtpr	$16, (1<<7) + 0xA		// Interrupt entry address 
	br	$31, 1f

pvc$osf22$3100.2:
	hw_mtpr	$16, (1<<7) + 0xC		// Arithmetic trap entry address 
	br	$31, 1f

pvc$osf23$3100.3:
	hw_mtpr	$16, (1<<7) + 0xD		// Memory-management fault entry address
	br	$31, 1f

pvc$osf24$3100.4:
	hw_mtpr	$16, (1<<7) + 0x10		// Instruction fault entry address
	br	$31, 1f

pvc$osf25$3100.5:
	hw_mtpr	$16, (1<<7) + 0XE		// Unaligned fault entry address
	br	$31, 1f

pvc$osf26$3100.6:
	hw_mtpr	$16, (1<<7) + 0xF		// Call system entry address



	br	$31, 1f

pvc$osf27$3100.7:
	hw_mtpr	$16, (1<<7) + 0xB		// Kernel debugger entry address



1:	hw_rei				// Back to caller


	.align  5

pal_swpipl_cont:

	hw_mfpr	$0, (1<<7) + 0x9			// get old ipl (cm = kernel)
	hw_mtpr	$16, (1<<7) + (1<<5) + 0x9		// set new (1<<5) + 0x9

	hw_mtpr    $31, 0
	hw_mtpr    $31, 0
	hw_mtpr    $31, 0
	hw_mtpr    $31, 0
	hw_mtpr    $31, 0

        hw_rei                          // now go back

	.align  5



pal_wrperfmon_cont:



	hw_mfpr	$22, (1<<7) + 0x2			// Get current (1<<5) + 0x2
	lda	$16, ((0xF<<8) | (1<<3) | (1<<0))($31)	// Start to build (1<<5) + 0x2 mask
	lda	$0, (7<<(32-32))($31)	// Get the rest
	sll	$0, 32, $0		// Move to correct spot
	or	$0, $16, $16		// Build cleaning mask
	and	$17, $16, $17		// Clean request mask
	bic	$22, $16, $22		// Remove old data from (1<<5) + 0x2
	or	$22, $17, $22		// Insert new stuff into (1<<5) + 0x2
	hw_mtpr	$22, (1<<7) + (1<<5) + 0x2		// Update (1<<5) + 0x2
	or	$31, 1, $0		// Set success
pvc$osf51$77:				// Disable rule checker on the hw_rei
	hw_rei				// Back to user




	.align  3



pal_perf1_handler:
	hw_mfpr	$0, (1<<7) + 0x16		// Get current interrupt masks
					// Build mask to zap pc0 and pc1
	lda	$16, (0x8181 & 0xFFFF)($31)
	ldah	$16, ((0x8181 + 32768) >> 16)($16)
	sll	$16, 16, $17		// Shift for 2 & 3
	or	$16, $17, $16		// Now is mask for 0/1/2/3
	sll	$16, 32, $17		// Shift for 4/5/6/7
	zapnot	$17, 0x3F, $17		// Clear off mask for 7/6
	bis	$16, $17, $16		// Now is mask for 0/1/2/3/4/5, not 6/7

	bic	$0, $16, $0		// Clear out old enables
	hw_mtpr	$0, (1<<7) + 0x16		// Update the mask
	or	$31, 1, $0		// Set success
	hw_rei				// Back to user




	.align  3

pal_perf2_handler:
	hw_mfpr	$0, (1<<7) + 0x16		// Get current interrupt masks
	lda	$16, (0x8181 & 0xFFFF)($31)
	ldah	$16, ((0x8181 + 32768) >> 16)($16)
	sll	$16, 16, $17		// Shift for 2 & 3
	or	$16, $17, $16		// Now is mask for 0/1/2/3
	sll	$16, 32, $17		// Shift for 4/5/6/7
	zapnot	$17, 0x3F, $17		// Clear off mask for 7/6
	bis	$16, $17, $16		// Now is mask for 0/1/2/3/4/5, not 6/7

	bis	$0, $16, $0		// Set new enables
	hw_mtpr	$0, (1<<7) + 0x16		// Update the mask
	or	$31, 1, $0		// Set success
	hw_rei				// Back to user



	.align  3

pal_perf3_handler:
	hw_mfpr	$0, (1<<7) + 0x2			// Get options from (1<<5) + 0x2
	and	$17, 3, $17		// Isolate perfmon enable bits
	lda	$1, 3($31)		// Get bits
	sll	$1, 44, $1	// Shift to position
	bic	$0, $1, $0		// Clear out old pme bits
	sll	$17, 44, $17	// Shift options to position
	or	$0, $17, $0		// Merge in new pme bits
	hw_mtpr	$0, (1<<7) + (1<<5) + 0x2		// Set the new options
	or	$31, 1, $0		// Set return status
pvc$osf52$77:				// Disable rule checker on the hw_rei
	hw_rei				// back to user

	.align  5

pal_retsys_cont:

	bic	$23, 3, $23		// clean return pc
	hw_mtpr	$23, (1<<5) + 0x4		// set return address
	hw_mfpr	$30, (1<<7) + 0x12		// get users stack
        rc      $25                     // clear inter_flag
	hw_rei

	.align  5

pal_rti_cont:

	ldq	$16, -3*8($29)		// restore $16
	hw_mtpr	$30, (1<<5) + 0x4		// set return address
	bis	$31, 8, $30		// make value for mode=user 






	ldq	$29, -4*8($29)		// restore $29
	hw_mtpr	$30, (1<<7) + (1<<5) + 0x9		// set new (1<<5) + 0x9
	hw_mfpr	$30, (1<<7) + 0x12
	hw_mtpr    $31, 0
	hw_mtpr    $31, 0
	hw_mtpr    $31, 0
	hw_mtpr    $31, 0				// 5 bubbles after hw_mtpr (1<<5) + 0x9
	hw_rei

	.align  3

pal_rtiToKern:



	and	$30, 7, $30		// get only priority
	extbl	$16, $30, $16		// get mask for this ipl
	hw_mtpr	$30, (1<<7) + (1<<5) + 0x9		// set the new ipl

	cmple	$30, 6, $17		// flag for crd's blocked, 0=>blocked
pvc$osf45$0:				// (1<<5) + 0x9 mode unchanged, so we are okay
pvc$osf31$84:				// (1<<5) + 0x9 mode unchanged, so we are okay
pvc$osf50$16:				// (1<<5) + 0x9 mode unchanged, so we are okay
	ldq	$30, -5*8($29)		// get pc
	insbl	$16, 1, $16		// move new (1<<5) + 0x10 mask into position
	s4addq  $17, 0, $17		// move $17 into position
	bis	$16, $17, $16		// enable crd's if not high ipl
	hw_mtpr	$16, (1<<5) + 0x10		// set the enables
					// pvc_violate 84 -- (1<<5) + 0x9 mode unchanged
	ldq	$17, -2*8($29)		// restore $17
	ldq	$16, -3*8($29)		// restore $16
	bic	$30, 3, $30		// clean pc

	hw_mtpr	$30, (1<<5) + 0x4		// set return address
	bis	$29, 0, $30		// restore $30






	ldq	$29, -4*8($29)		// restore $29
	hw_rei

	.align  5

pal_bpt_cont:

	sll	    $1, 63-3, $1;	bge	    $1, 0f;	hw_mtpr    $30, (1<<7) + 0x12;	hw_mfpr    $30, (1<<7) + 0x13;	hw_mtpr    $31, (1<<7) + (1<<5) + 0x9;	0:  srl	    $1, 63-3, $1;	lda	    $30, 0-48($30); hw_stq/a   $1, 0x0000($30);	hw_stq/a   $2, 0x0008($30);	hw_stq/a   $29, 0x0010($30);	hw_stq/a   $16, 0x0018($30);	hw_stq/a   $17, 0x0020($30);	hw_stq/a   $18,	0x0028($30)

	hw_mfpr	$1, (1<<7) + 0x10		// get entry point
	bis	$31, $31, $16		// flag as bpt
	hw_mtpr	$1, (1<<5) + 0x4		// load (1<<6) + 0x5 of entry point
	hw_mfpr	$2, (1<<7) + 0x1			// restore scratch
	hw_mfpr	$1, (1<<7) + 0x0
	hw_mfpr	$29, (1<<7) + 0x14		// get the kernel $29
	hw_rei				// out to service routine

	.align  3

pal_bugchk_cont:

	sll	    $1, 63-3, $1;	bge	    $1, 0f;	hw_mtpr    $30, (1<<7) + 0x12;	hw_mfpr    $30, (1<<7) + 0x13;	hw_mtpr    $31, (1<<7) + (1<<5) + 0x9;	0:  srl	    $1, 63-3, $1;	lda	    $30, 0-48($30); hw_stq/a   $1, 0x0000($30);	hw_stq/a   $2, 0x0008($30);	hw_stq/a   $29, 0x0010($30);	hw_stq/a   $16, 0x0018($30);	hw_stq/a   $17, 0x0020($30);	hw_stq/a   $18,	0x0028($30)

	hw_mfpr	$1, (1<<7) + 0x10		// get entry point
	bis	$31, 1, $16		// flag as bugchk
	hw_mtpr	$1, (1<<5) + 0x4		// load (1<<6) + 0x5 of entry point
	hw_mfpr	$2, (1<<7) + 0x1			// restore scratch
	hw_mfpr	$1, (1<<7) + 0x0
	hw_mfpr	$29, (1<<7) + 0x14		// get the kernel $29
	hw_rei				// out to service routine

	.align  5

pal_callsys_cont:

	sll	    $22, 63-3, $22;	bge	    $22, 0f;	hw_mtpr    $30, (1<<7) + 0x12;	hw_mfpr    $30, (1<<7) + 0x13;	hw_mtpr    $31, (1<<7) + (1<<5) + 0x9;	0:  srl	    $22, 63-3, $22;	lda	    $30, 0-48($30); hw_stq/a   $22, 0x0000($30);	hw_stq/a   $23, 0x0008($30);	hw_stq/a   $29, 0x0010($30);	hw_stq/a   $16, 0x0018($30);	hw_stq/a   $17, 0x0020($30);	hw_stq/a   $18,	0x0028($30)

	hw_mfpr	$24, (1<<7) + 0xF		// get entry point
	hw_mfpr	$29, (1<<7) + 0x14		// get the kernel $29
	hw_mtpr	$24, (1<<5) + 0x4		// load (1<<6) + 0x5 of entry point
	hw_mtpr    $31, 0
	hw_rei				// out to service routine

	.align  5

pal_gentrap_cont:

	sll	    $1, 63-3, $1;	bge	    $1, 0f;	hw_mtpr    $30, (1<<7) + 0x12;	hw_mfpr    $30, (1<<7) + 0x13;	hw_mtpr    $31, (1<<7) + (1<<5) + 0x9;	0:  srl	    $1, 63-3, $1;	lda	    $30, 0-48($30); hw_stq/a   $1, 0x0000($30);	hw_stq/a   $2, 0x0008($30);	hw_stq/a   $29, 0x0010($30);	hw_stq/a   $16, 0x0018($30);	hw_stq/a   $17, 0x0020($30);	hw_stq/a   $18,	0x0028($30)

	hw_mfpr	$1, (1<<7) + 0x10		// get entry point
	bis	$31, 2, $16		// flag as gentrap
	hw_mtpr	$1, (1<<5) + 0x4		// load (1<<6) + 0x5 of entry point
	hw_mfpr	$2, (1<<7) + 0x1			// restore scratch
	hw_mfpr	$1, (1<<7) + 0x0
	hw_mfpr	$29, (1<<7) + 0x14		// get the kernel $29
	hw_rei				// out to service routine



	.align  5

pal_dbgstop_cont:

	sll	    $1, 63-3, $1;	bge	    $1, 0f;	hw_mtpr    $30, (1<<7) + 0x12;	hw_mfpr    $30, (1<<7) + 0x13;	hw_mtpr    $31, (1<<7) + (1<<5) + 0x9;	0:  srl	    $1, 63-3, $1;	lda	    $30, 0-48($30); hw_stq/a   $1, 0x0000($30);	hw_stq/a   $2, 0x0008($30);	hw_stq/a   $29, 0x0010($30);	hw_stq/a   $16, 0x0018($30);	hw_stq/a   $17, 0x0020($30);	hw_stq/a   $18,	0x0028($30)

	hw_mfpr	$1, (1<<7) + 0xB		// Get debugger entry point
	bis	$31, $31, $16		// Flag as CALL_PAL dbgstop
	hw_mtpr	$1, (1<<5) + 0x4		// Load VA of entry point
	hw_mfpr	$2, (1<<7) + 0x1			// Restore scratch registers
	hw_mfpr	$1, (1<<7) + 0x0
	hw_mfpr	$29, (1<<7) + 0x14		// Get the kernel GP
	hw_rei				// Transfer to debugger



	.align  3

pal_CallPalRsvd:
	hw_mtpr	$2, (1<<7) + 0x1			// Save $2.
	hw_mfpr	$2, (1<<5) + 0x4		// Get address of faulting instruction.
	subq	$2, 4, $2		// Backup PC.
	hw_mtpr	$2, (1<<5) + 0x4		// Load PC of previous instruction.
	hw_mfpr	$2, (1<<7) + 0x1			// Restore $2.
	br	$31, pal_opcdec	// Go handle reserved opcode fault ...

	.align  13

pal_osfpal_end:
