/*****************************************************************************

       Copyright  1995, 1996 Digital Equipment Corporation,
                       Maynard, Massachusetts.

                        All Rights Reserved

Permission to use, copy, modify, and distribute this software and its 
documentation for any purpose and without fee is hereby granted, provided  
that the copyright notice and this permission notice appear in all copies  
of software and supporting documentation, and that the name of Digital not  
be used in advertising or publicity pertaining to distribution of the software 
without specific, written prior permission. Digital grants this permission 
provided that you prominently mark, as not part of the original, any 
modifications made to this software or documentation.

Digital Equipment Corporation disclaims all warranties and/or guarantees  
with regard to this software, including all implied warranties of fitness for 
a particular purpose and merchantability, and makes no representations 
regarding the use of, or the results of the use of, the software and 
documentation in terms of correctness, accuracy, reliability, currentness or
otherwise; and you rely on the software, documentation and results solely at 
your own risk. 

******************************************************************************/
#include <linux/config.h>
#include <linux/fs.h>
#include <linux/timer.h>
#include <linux/signal.h>
#include <linux/errno.h>
#include <linux/pci.h>
#include <linux/tqueue.h>
#include <linux/sched.h>

#include "milo.h"
#include "uart.h"

#if 0
#define MINI_TIMER_DEBUG 1
#endif

volatile struct timeval xtime;		/* The current time */

struct timer_struct timer_table[32];
unsigned long timer_active;

static struct timer_list timer_head = 
{ &timer_head, &timer_head, ~0, 0, NULL };

struct tq_struct tq_last = {
  &tq_last, 0, 0, 0
  };

DECLARE_TASK_QUEUE(tq_timer);
DECLARE_TASK_QUEUE(tq_immediate);
DECLARE_TASK_QUEUE(tq_scheduler);

int loops_per_sec = 1;

unsigned long volatile jiffies = 0;

void timer_interrupt(int irq, struct pt_regs *regs);
void do_timer(struct pt_regs *regs);

#ifdef MINI_TIMER_DEBUG
/*****************************************************************************
 * debug probing routines                                                    *
 *****************************************************************************/
void timer_probe(void)
{
  unsigned long flags ;
  unsigned long volatile ticks ;

  /* let some ticks happen */
  printk("Checking for interval timers ticking\n");

  /* get jiffies, drop ipl and wait a bit */
  save_flags(flags) ;
  ticks = jiffies ;
  sti();
  udelay(100);
  restore_flags(flags) ;
  
  /* did jiffies change? */
  if (ticks != jiffies) 
    printk("Timers are ticking\n");
  else
    printk("Timers not ticking\n");
}
#endif

/*****************************************************************************
 * initialise timers                                                         *
 *****************************************************************************/
void init_timers(void) 
{
  /* init the system time to null */
  xtime.tv_sec = 0 ;
  xtime.tv_usec = 0;

  /*
   * Initialize Interval Timers:
   */
  outb(0x54, 0x43);	/* counter 1: refresh timer */
  outb(0x18, 0x41);

  outb(0x36, 0x43);	/* counter 0: system timer */
  outb(0x00, 0x40);
  outb(0x00, 0x40);

  outb(0xb6, 0x43);	/* counter 2: speaker */
  outb(0x31, 0x42);
  outb(0x13, 0x42);

#ifdef MINI_TIMER_DEBUG
  timer_probe();
#endif
}

/*****************************************************************************
 * Timer routines                                                            *
 *****************************************************************************/

void add_timer(struct timer_list * timer)
  {
	unsigned long flags;
	struct timer_list *p;
  
	p = &timer_head;
	save_flags(flags);
	cli();
	do {
		p = p->next;
	} while (timer->expires > p->expires);
	timer->next = p;
	timer->prev = p->prev;
	p->prev = timer;
	timer->prev->next = timer;
	restore_flags(flags);
  }

int del_timer(struct timer_list * timer)
{
	unsigned long flags;
	save_flags(flags);
  
	cli();
	if (timer->next) {
		timer->next->prev = timer->prev;
		timer->prev->next = timer->next;
		timer->next = timer->prev = NULL;
		restore_flags(flags);
		return 1;
  	}
	restore_flags(flags);
	return 0;
  }	      

void timer_interrupt(int irq, struct pt_regs *regs)
{
    do_timer(regs);
}

void do_timer(struct pt_regs *regs)
{
    struct timer_list *timer;
    unsigned long flags;

    save_flags(flags);
    cli();

    if (xtime.tv_usec >= 1000000) {
      xtime.tv_usec -= 1000000;
      xtime.tv_sec++;
    }

    jiffies++;

	while ((timer = timer_head.next) != &timer_head 
	       && timer->expires <= jiffies) {
		void (*fn)(unsigned long) = timer->function;
		unsigned long data = timer->data;
		timer->next->prev = timer->prev;
		timer->prev->next = timer->next;
		timer->next = timer->prev = NULL;
		fn(data);
	}

    /* now the tqueue stuff */
    if (tq_timer != &tq_last) {
#ifdef MINI_TIMER_DEBUG
	printk("do_timer: calling run_task_queue @ 0x%p\n", &tq_timer);
#endif
	run_task_queue(&tq_timer);
    }

    restore_flags(flags);
}

void it_real_fn(unsigned long thing)
{
    printk("it_real_fn(): called\n");
}

void do_gettimeofday(struct timeval *tv)
{
	unsigned long flags;

	save_flags(flags);
	cli();
	*tv = xtime; 
	restore_flags(flags);
}


