/*****************************************************************************

       Copyright  1995, 1996 Digital Equipment Corporation,
                       Maynard, Massachusetts.

                        All Rights Reserved

Permission to use, copy, modify, and distribute this software and its 
documentation for any purpose and without fee is hereby granted, provided  
that the copyright notice and this permission notice appear in all copies  
of software and supporting documentation, and that the name of Digital not  
be used in advertising or publicity pertaining to distribution of the software 
without specific, written prior permission. Digital grants this permission 
provided that you prominently mark, as not part of the original, any 
modifications made to this software or documentation.

Digital Equipment Corporation disclaims all warranties and/or guarantees  
with regard to this software, including all implied warranties of fitness for 
a particular purpose and merchantability, and makes no representations 
regarding the use of, or the results of the use of, the software and 
documentation in terms of correctness, accuracy, reliability, currentness or
otherwise; and you rely on the software, documentation and results solely at 
your own risk. 

******************************************************************************/
/* The following code was stolen from OSF, but it's really Thomas Roell's
 * VGA code...
 *
 * Copyright 1990,91 by Thomas Roell, Dinkelscherben, Germany.
 *
 * Permission to use, copy, modify, distribute, and sell this software and its
 * documentation for any purpose is hereby granted without fee, provided that
 * the above copyright notice appear in all copies and that both that
 * copyright notice and this permission notice appear in supporting
 * documentation, and that the name of Thomas Roell not be used in
 * advertising or publicity pertaining to distribution of the software without
 * specific, written prior permission.  Thomas Roell makes no representations
 * about the suitability of this software for any purpose.  It is provided
 * "as is" without express or implied warranty.
 */
#include <linux/sched.h>
#include <linux/timer.h>
#include <linux/tty.h>
#include <linux/config.h>
#include <linux/kernel.h>
#include <linux/string.h>
#include <linux/errno.h>
#include <linux/kd.h>

#include <asm/io.h>
#include <asm/system.h>
#include <asm/segment.h>

#include "milo.h"
#include "video.h"

static int vgabios_init(void);
static void vgabios_putchar(unsigned char c);
static void vga_scrollscreen(void);

struct bootvideo biosvideo = {
  "BIOS VGA", 

  &vgabios_init, 
  &vgabios_putchar
  };


#define VGA_FB_ADDR     0xa0000UL
#define VGA_TX_ADDR     0xb8000UL

static unsigned short int *video_base;
static unsigned short int *video_addr;

static int col;
static int row;
static int nrows;
static int ncols;

extern void bcopy(char *dst, char *src, int count);

/*
 *  The following two definitions control debug printing and which font to select (see
 *  the note below).
 */
/* #define DEBUG_PRINT 1   */
/* #define JDU_CONS_FONT 1 */

#define INB(port)		inb((unsigned long)(port))
#define OUTB(port, val)		{outb_p((val), (unsigned long)(port)); mb();}
#define OUTW(port, val)         {outw((val), (unsigned long)(port)); mb();}

#define MINW(port)              __readw((unsigned long)(port))
#define MOUTW(port, val)         {__writew((val), (unsigned long)(port)); mb();}

static int vga_delay = 2;		/* 200000 */
#define VGA_DELAY()                             \
  {                                             \
    volatile int i;                             \
    for (i = vga_delay; i; i--);                \
  }

/*
 *-----------------------------------------------------------------------
 * vga_init --
 *      Handle the initialization of VGA register structure.
 *
 * Input:
 *      None
 *
 * Results:
 *      VGA inititalised.
 *
 * Side Effects: 
 *
 *      None.
 *
 *-----------------------------------------------------------------------
 */
static int vgabios_init(void) 
{
    extern unsigned short *vga_bios_init(int *nrows, int *ncols, 
      int *row, int *col);

#ifdef DEBUG_PRINT
    printk("vgabios_init(BIOS VGA): entry\n");
#endif					/* DEBUG_PRINT */

    video_base = vga_bios_init(&nrows, &ncols, &row, &col);
    if (video_base == NULL)
	return FALSE;
    video_addr = video_base + ncols * row + col;
    return TRUE;
}

static void vga_scrollscreen(void) 
{
    int i;
    unsigned short int ioword;
    unsigned short int *source_tx_addr;

    /* Scroll the screen by copying the entire text buffer up one line. */
    video_addr = video_base;
    source_tx_addr = video_addr + ncols;

    for (i = 0; i < (nrows - 1) * ncols; i++) {
	ioword = MINW(source_tx_addr);
	MOUTW(video_addr, ioword);
	video_addr++;
	 source_tx_addr++;
    }

    /* Clear the last row */
    ioword = (unsigned short int) ' ';
    ioword = ioword | (0x07 << 8);

    for (i = 0; i < ncols; i++) {
	MOUTW(video_addr, ioword);
	video_addr++;
    }

    /* Position cursor at bottom of cleared row */
    row = (nrows - 1);
    col = 0;
    video_addr -= ncols;
}

/*
 *-----------------------------------------------------------------------
 * vgabios_putchar --
 *      Put a character out to screen memory.
 *-----------------------------------------------------------------------
 */
static void vgabios_putchar(unsigned char c)
{
    int cursorloc;
    unsigned short int outword;

    if (c == '\n') {

	/* just go onto the next row */
	row++;
	col = 0;
    }
      else if (c == '\r') {

	/* Go to beginning of current row */
	col = 0;
    }
      else if (c == '\b') {

	/* Backspace: go back one col unless we're already at beginning of
	 * row... */
	if (col > 0)
	     col--;
    }
      else {

	/* build the character */
	outword = (unsigned short int) c;
	outword = outword | (0x07 << 8);

	/* output it to the correct location */
	video_addr = video_base + row * ncols + col;
	MOUTW(video_addr, outword);

	/* move on where to write the next character */
	col++;
    }

    /* check for rows and cols overflowing */
    if (col > ncols - 1) {
	col = 0;
	 row++;
    }
    if (row > nrows - 1) {
	vga_scrollscreen();
    }

    /* Put the cursor at the right spot... */
    cursorloc = ((row * ncols) + col);
    OUTB(0x3d4, 14);
    OUTB(0x3d5, (cursorloc & 0xff00) >> 8);
    OUTB(0x3d4, 15);
    OUTB(0x3d5, (cursorloc & 0xff));

}

