/*****************************************************************************

       Copyright  1995, 1996 Digital Equipment Corporation,
                       Maynard, Massachusetts.

                        All Rights Reserved

Permission to use, copy, modify, and distribute this software and its 
documentation for any purpose and without fee is hereby granted, provided  
that the copyright notice and this permission notice appear in all copies  
of software and supporting documentation, and that the name of Digital not  
be used in advertising or publicity pertaining to distribution of the software 
without specific, written prior permission. Digital grants this permission 
provided that you prominently mark, as not part of the original, any 
modifications made to this software or documentation.

Digital Equipment Corporation disclaims all warranties and/or guarantees  
with regard to this software, including all implied warranties of fitness for 
a particular purpose and merchantability, and makes no representations 
regarding the use of, or the results of the use of, the software and 
documentation in terms of correctness, accuracy, reliability, currentness or
otherwise; and you rely on the software, documentation and results solely at 
your own risk. 

******************************************************************************/
/* Definitions of executable file formats for Linux/Alpha,
 * Modified for a 32-bit compiler environment from the original DEC OSF/1
 * definitions. This will change or go away as we go to a self-hosted 
 * environment.
 */

typedef struct _filehdr {
    unsigned short f_magic;		/* Magic number (must be ALPHAMAGIC) */
    unsigned short f_nscns;		/* Number of sections */
    int f_timdat;			/* Time/date of creation */
    U64 f_symptr;			/* Pointer to symbolic header */
    int f_nsyms;
    unsigned short f_opthdr;		/* sozeof optional header */
    unsigned short f_flags;		/* flags */
} FILEHDR;

#define ALPHAMAGIC	0603

typedef struct _aouthdr {
    short magic;			/* Magic number (must be OMAGIC) */
    short vstamp;			/* Version stamp */
    short bldrev;			/* Build revision */
    short padcell;			/* Pad to 64 bits */
    U64 tsize;				/* Size of text segment */
    U64 dsize;				/* Size of data segment */
    U64 bsize;				/* Size of bss segment */
    U64 entry;				/* Virtual address of entry point */
    U64 text_start;			/* VA of start of text segment */
    U64 data_start;			/* VA of start of data segment */
    U64 bss_start;			/* VA of start of bss segment */
    int gprmask;			/* general purpose register mask */
    int fprmask;			/* floating point register mask */
    U64 gp_value;			/* gp value for this exe */
} AOUTHDR;

#define OMAGIC	0407
#define ZMAGIC 0413

typedef struct _scnhdr {
    char s_name[8];			/* Section name */
    U64 s_paddr;			/* Section physical address */
    U64 s_vaddr;			/* Virtual address */
    U64 s_size;				/* Size in bytes */
    U64 s_scnptr;			/* file ptr to raw data in section */
    U64 s_relptr;			/* file ptr to relocation */
    U64 s_lnnoptr;			/* file ptr to gp histogram */
    unsigned short s_nreloc;		/* number of relocation entries */
    unsigned short s_nlnno;		/* number of gp histogram entries */
    int s_flags;			/* flags */
} SCNHDR;

