/*****************************************************************************

       Copyright  1995, 1996 Digital Equipment Corporation,
                       Maynard, Massachusetts.

                        All Rights Reserved

Permission to use, copy, modify, and distribute this software and its 
documentation for any purpose and without fee is hereby granted, provided  
that the copyright notice and this permission notice appear in all copies  
of software and supporting documentation, and that the name of Digital not  
be used in advertising or publicity pertaining to distribution of the software 
without specific, written prior permission. Digital grants this permission 
provided that you prominently mark, as not part of the original, any 
modifications made to this software or documentation.

Digital Equipment Corporation disclaims all warranties and/or guarantees  
with regard to this software, including all implied warranties of fitness for 
a particular purpose and merchantability, and makes no representations 
regarding the use of, or the results of the use of, the software and 
documentation in terms of correctness, accuracy, reliability, currentness or
otherwise; and you rely on the software, documentation and results solely at 
your own risk. 

******************************************************************************/

#include <unistd.h>
#include <memory.h>

#include <linux/kernel.h>
#include <linux/types.h>
#include <linux/fcntl.h>
#include <linux/malloc.h>
#include <linux/pci.h>
#include <linux/bios32.h>

#include <asm/io.h>

#include "milo.h"
#include "sysenv.h"
#include "host.h"

#ifdef MINI_DIGITAL_BIOSEMU
/*
 *  Use Digital's BIOS emulation technology to set up the video device.
 */
extern int StartBiosEmulator(int *bios_return_data);
					/* XX: Dave ?? This was "int bios..."
					 */
extern void SetupBiosGraphics(void);

/*
 * Give it all the entrypoints/utility routines that it expects 
 */

unsigned int inportb(unsigned int p)
{   return inb(p);
}
unsigned int inportw(unsigned int p)
{   return inw(p);
}
unsigned int inportl(unsigned int p)
{   return inl(p);
}
unsigned int inport(unsigned int p)
{   return inb(p);
}
void outportb(unsigned int p, unsigned int d)
{   outb(d, p);
}
void outportw(unsigned int p, unsigned int d)
{   outw(d, p);
}
void outportl(unsigned int p, unsigned int d)
{   outl(d, p);
}

void outmemb(unsigned int p, unsigned int d)
{   writeb(d, p);
}
void outmemw(unsigned int p, unsigned int d)
{   writew(d, p);
}
void outmeml(unsigned int p, unsigned int d)
{   writel(d, p);
}
unsigned int inmemb(unsigned int p)
{   return readb(p);
}
unsigned int inmemw(unsigned int p)
{   return readw(p);
}
unsigned long inmeml(unsigned int p)
{   return readl(p);
}

unsigned int PCIGetNumberOfBusses(void)
{
  return pci_root.subordinate ;
}

void *malloc(int size)
{   return vmalloc(size);
}

unsigned char InPciCfgB(unsigned int bus, unsigned int dev, unsigned int func,
  unsigned int reg)
{
    unsigned char value;

    pcibios_read_config_byte(bus, PCI_DEVFN(dev, func), reg, &value);

    return value;
}

unsigned short int InPciCfgW(unsigned int bus, unsigned int dev,
  unsigned int func, unsigned int reg)
{
    unsigned short int value;

    pcibios_read_config_word(bus, PCI_DEVFN(dev, func), reg, &value);

    return value;
}

unsigned int InPciCfgL(unsigned int bus, unsigned int dev, unsigned int func,
  unsigned int reg)
{
    unsigned int value;

    pcibios_read_config_dword(bus, PCI_DEVFN(dev, func), reg, &value);

    return value;
}

void OutPciCfgB(unsigned int bus, unsigned int dev, unsigned int func,
  unsigned int reg, unsigned char data)
{
    pcibios_write_config_byte(bus, PCI_DEVFN(dev, func), reg, data);
}

void OutPciCfgW(unsigned int bus, unsigned int dev, unsigned int func,
  unsigned int reg, unsigned short int data)
{
    pcibios_write_config_word(bus, PCI_DEVFN(dev, func), reg, data);
}

void OutPciCfgL(unsigned int bus, unsigned int dev, unsigned int func,
  unsigned int reg, unsigned int data)
{
    pcibios_write_config_dword(bus, PCI_DEVFN(dev, func), reg, data);
}

void msleep(int ms)
{
    udelay(ms);
}

extern struct timeval xtime;		/* The current time */
unsigned long gettime(void) 
{
    return xtime.tv_sec;
}

void __cxx_dispatch(void) 
{
    printk("__cxx_dispatch() called\n");
}

void malloc_summary(char *p)
{
    printk("malloc_summary: p @ 0x%p\n", p);
}

static int bios_return_data[2];
void *vga_bios_init(int *nrows, int *ncols, int *row, int *col)
{

    /* first, try and start the emulator */
    printk("calling StartBiosEmulator()\n");
    if (!StartBiosEmulator(bios_return_data)) {
	printk("...returned (failed)\n");
	return NULL;
    }
    printk("...returned (succeeded)\n");

    /* now setup the graphics portion of the emulator */
    printk("calling SetupBiosGraphics\n");
    SetupBiosGraphics();
    printk("...returned\n");

#if 0
    printk("calling clean_mem()\n");
    clean_mem();
#endif
/*
 *  Place attribute controller into normal mode.
 *  i.e. Connected to CRT controller.
 */
    outportb(0x3c0, 0x20);

    *row = *col = 0;
    *nrows = 25;
    *ncols = 80;

    return (void *) 0xb8000UL;
}


#else
/*
 *  Use David Mosberger-Tang's BIOS emulation technology to set up the
 *  video device.  This has the advantage of being free and modifiable but
 *  it's not so complete as Digitals.  
 */
#include "x86_decode.h"
#include "x86_debug.h"
#include "x86_bios.h"

#define KB		1024
#define MEM_SIZE	(64*KB)		/* should be plenty for now */

#define OFF(addr)	(((addr) >> 0) & 0xffff)
#define SEG(addr)	(((addr) >> 4) & 0xf000)

#define VGA_BIOS_BASE	0xc0000
#define VGA_BIOS_ENTRY	(VGA_BIOS_BASE + 3)

extern void sethae(unsigned long hae);

static struct hae hae;

/*
 * BIOS Video Display Data Area 1:
 */
struct video_area1 {
    u8 pad;				/* to make things aligned */
    u8 mode;				/* active display mode */
    u16 ncols;				/* # of display columns */
    u16 len;				/* length of video buffer */
    u16 start;				/* starting address in video buffer */
    struct {
	u8 col;
	u8 row;
    } cup[8];				/* cursor position in page 0..7 */
    u16 cursor_type;
    u8 active_page;			/* number of currently active page */
    u8 base0, base1;			/* CRT controller base address */
    u8 p3x8;				/* current value of register 0x3x8 */
    u8 p3x9;				/* current value of register 0x3x9 */
};


static inline unsigned long
  mem_read(SysEnv *m, unsigned long addr, unsigned long size)
{
    unsigned long val = 0;

    if (addr >= 0xa0000 && addr <= 0xfffff) {
	switch (size) {
	    case 1: 
		val = readb(addr);
		break;
	    case 2: 
		if (addr & 0x1) {
		    val = (readb(addr) | (readb(addr + 1) << 8));
		} else {
		    val = readw(addr);
		}
		break;
	    case 4: 
		if (addr & 0x3) {
		    val = (readb(addr) | 
		      (readb(addr + 1) << 8) | 
		      (readb(addr + 2) << 16) | 
		      (readb(addr + 3) << 24));
		} else {
		    val = readl(addr);
		}
		break;
	}
    } else if (addr > m->mem_size - size) {
	printk("mem_read: address %#lx out of range!\n", addr);
	halt_sys(m);
    } else {
	switch (size) {
	    case 1: 
		val = *(u8 *) (m->mem_base + addr);
		break;
	    case 2: 
		if (addr & 0x1) {
		    val = (*(u8 *) (m->mem_base + addr) | 
		      (*(u8 *) (m->mem_base + addr + 1) << 8));
		} else {
		    val = *(u16 *) (m->mem_base + addr);
		}
		break;
	    case 4: 
		if (addr & 0x3) {
		    val = (*(u8 *) (m->mem_base + addr + 0) | 
		      (*(u8 *) (m->mem_base + addr + 1) << 8) | 
		      (*(u8 *) (m->mem_base + addr + 2) << 16) | 
		      (*(u8 *) (m->mem_base + addr + 3) << 24));
		} else {
		    val = *(u32 *) (m->mem_base + addr);
		}
		break;
	}
    }
    if (DEBUG_MEM_TRACE(m)) {
	x86_debug_printf(m, "%#08x %d -> %#x\n", addr, size, val);
    }
    return val;
}


void
  mem_write(SysEnv *m, unsigned long addr, unsigned long val, 
  unsigned long size)
{
    if (DEBUG_MEM_TRACE(m)) {
	x86_debug_printf(m, "%#08x %d <- %#x\n", addr, size, val);
    }

    if (addr >= 0xa0000 && addr <= 0xfffff) {

	/* it's an adapter BIOS ROM access */
	switch (size) {
	    case 1: 
		writeb(val, addr);
		break;
	    case 2: 
		if (addr & 0x1) {
		    writeb(val >> 0, addr);
		    writeb(val >> 8, addr + 1);
		} else {
		    writew(val, addr);
		}
		break;
	    case 4: 
		if (addr & 0x3) {
		    writeb(val >> 0, addr);
		    writeb(val >> 8, addr + 1);
		    writeb(val >> 16, addr + 1);
		    writeb(val >> 24, addr + 1);
		} else {
		    writel(val, addr);
		}
		break;
	}
    } else if (addr >= m->mem_size) {
	printk("mem_write: address %#lx out of range!\n", addr);
	halt_sys(m);
    } else {
	switch (size) {
	    case 1: 
		*(u8 *) (m->mem_base + addr) = val;
		break;
	    case 2: 
		if (addr & 0x1) {
		    *(u8 *) (m->mem_base + addr + 0) = (val >> 0) & 0xff;
		    *(u8 *) (m->mem_base + addr + 1) = (val >> 8) & 0xff;
		} else {
		    *(u16 *) (m->mem_base + addr) = val;
		}
		break;
	    case 4: 
		if (addr & 0x1) {
		    *(u8 *) (m->mem_base + addr + 0) = (val >> 0) & 0xff;
		    *(u8 *) (m->mem_base + addr + 1) = (val >> 8) & 0xff;
		    *(u8 *) (m->mem_base + addr + 2) = (val >> 16) & 0xff;
		    *(u8 *) (m->mem_base + addr + 3) = (val >> 24) & 0xff;
		} else {
		    *(u16 *) (m->mem_base + addr) = val;
		}
		break;
	}
    }
}


u8
  sys_rdb(SysEnv *m, u32 addr)
{
    return mem_read(m, addr, 1);
}


u16
  sys_rdw(SysEnv *m, u32 addr)
{
    return mem_read(m, addr, 2);
}


u32
  sys_rdl(SysEnv *m, u32 addr)
{
    return mem_read(m, addr, 4);
}


void
  sys_wrb(SysEnv *m, u32 addr, u8 val)
{
    mem_write(m, addr, val, 1);
}


void
  sys_wrw(SysEnv *m, u32 addr, u16 val)
{
    mem_write(m, addr, val, 2);
}


void
  sys_wrl(SysEnv *m, u32 addr, u32 val)
{
    mem_write(m, addr, val, 4);
}


u8
  sys_inb(SysEnv *m, u32 port)
{
    unsigned long val;

    val = inb(port);
    if (DEBUG_IO_TRACE(m)) {
	x86_debug_printf(m, "\t\t\t\t%#04x 1 -> %#x\n", port, val);
    }
    return val;
}


u16
  sys_inw(SysEnv *m, u32 port)
{
    unsigned long val;

    val = inw(port);
    if (DEBUG_IO_TRACE(m)) {
	x86_debug_printf(m, "\t\t\t\t%#04x 1 -> %#x\n", port, val);
    }
    return val;
}


u32
  sys_inl(SysEnv *m, u32 port)
{
    unsigned long val;

    val = inl(port);
    if (DEBUG_IO_TRACE(m)) {
	x86_debug_printf(m, "\t\t\t\t%#04x 1 -> %#x\n", port, val);
    }
    return val;
}


void
  sys_outb(SysEnv *m, u32 port, u8 val)
{
    if (DEBUG_IO_TRACE(m)) {
	x86_debug_printf(m, "\t\t\t\t%#04x 1 <- %#x\n", port, val);
    }
    outb(val, port);
}


void
  sys_outw(SysEnv *m, u32 port, u16 val)
{
    if (DEBUG_IO_TRACE(m)) {
	x86_debug_printf(m, "\t\t\t\t%#04x 2 <- %#x\n", port, val);
    }
    outw(val, port);
}


void
  sys_outl(SysEnv *m, u32 port, u32 val)
{
    if (DEBUG_IO_TRACE(m)) {
	x86_debug_printf(m, "\t\t\t\t%#04x 4 <- %#x\n", port, val);
    }
    outl(val, port);
}


void *
  vga_bios_init(int *nrows, int *ncols, int *row, int *col)
{
    unsigned char bus, devfn;
    SysEnv sys;
    struct video_area1 *vid1;
    u8 *vid2;

    memset(&sys, 0, sizeof(sys));

    if (pcibios_find_class(PCI_CLASS_NOT_DEFINED_VGA << 8, 0, &bus, &devfn)
      == PCIBIOS_SUCCESSFUL || 
      pcibios_find_class(PCI_CLASS_DISPLAY_VGA << 8, 0, &bus, &devfn)
      == PCIBIOS_SUCCESSFUL)
      {
	unsigned int val;

	pcibios_read_config_dword(0, devfn, 0x00, &val);
	printk("device/vendor id=%x\n", val);
	pcibios_write_config_dword(bus, devfn, PCI_ROM_ADDRESS, 
	  VGA_BIOS_BASE | PCI_ROM_ADDRESS_ENABLE);
	pcibios_read_config_dword(bus, devfn, PCI_ROM_ADDRESS, &val);
	printk("ROM base address+1=%x\n", val);
    }
    if (sys_rdw(&sys, VGA_BIOS_BASE) != 0xaa55) {
	printk("vga_bios_init: sorry, there seems to be no BIOS\n");
	return NULL;
    }
    sys.mem_base = (unsigned long) kmalloc(MEM_SIZE, 0);
    if (!sys.mem_base) {
	printk("vga_bios_init: can't alloc memory");
	return NULL;
    }
    sys.mem_size = MEM_SIZE;

    /* Initialize Interval Timers: */
    outb(0x54, 0x43);			/* counter 1: refresh timer */
    outb(0x18, 0x41);

    outb(0x36, 0x43);			/* counter 0: system timer */
    outb(0x00, 0x40);
    outb(0x00, 0x40);

    outb(0xb6, 0x43);			/* counter 2: speaker */
    outb(0x31, 0x42);
    outb(0x13, 0x42);

    /* now get started: */
    x86_bios_init(&sys);
    sys.x86.R_CS = SEG(VGA_BIOS_ENTRY);
    sys.x86.R_IP = OFF(VGA_BIOS_ENTRY);
    sys.x86.R_SS = SEG(sys.mem_size - 1);
    sys.x86.R_SP = OFF(sys.mem_size - 1);

    printk("vga_bios_init: starting emulation...\n");
    x86_exec(&sys);

    printk("vga_bios_init: emulation done...\n");

    /* Notice that the first data byte is at 0x449 but we need to make it 0x448
     * because of the padding at the beginning of the structure. */
    vid1 = (struct video_area1 *) (sys.mem_base + 0x448);
    vid2 = (u8 *) (sys.mem_base + 0x484);
    *nrows = *vid2 + 1;
    *ncols = vid1->ncols;
    *row = vid1->cup[vid1->active_page].row;
    *col = vid1->cup[vid1->active_page].col;

#if 1

    /* Explicitly set video mode 3.  This is a workaround until I figured why
     * #9 Level 12 doesn't initialize properly without this... */
    ((char *) sys.mem_base)[0x4000] = 0xcd;
					/* INT 10 */
    ((char *) sys.mem_base)[0x4001] = 0x10;
    ((char *) sys.mem_base)[0x4002] = 0xc3;
					/* RET */
    sys.x86.R_AH = 0x00;		/* set video mode 3 */
    sys.x86.R_AL = 0x03 | (1 << 7);	/* but don't clear screen */
    sys.x86.R_CS = SEG(0x04000);
    sys.x86.R_IP = OFF(0x04000);
    sys.x86.R_SS = SEG(sys.mem_size - 1);
    sys.x86.R_SP = OFF(sys.mem_size - 1);
    x86_exec(&sys);
#endif

    return (short *) (0xb8000UL + vid1->start);
}
#endif
