#
# %Z%%M% %I% %E% 1990 by Robin Miller
#
#/****************************************************************************
# *									     *
# *			  COPYRIGHT (c) 1990 - 1999			     *
# *			   This Software Provided			     *
# *				     By					     *
# *			  Robin's Nest Software Inc.			     *
# *			       2 Paradise Lane  			     *
# *			       Hudson, NH 03051				     *
# *			       (603) 883-2355				     *
# *									     *
# * Permission to use, copy, modify, distribute and sell this software and   *
# * its documentation for any purpose and without fee is hereby granted	     *
# * provided that the above copyright notice appear in all copies and that   *
# * both that copyright notice and this permission notice appear in the	     *
# * supporting documentation, and that the name of the author not be used    *
# * in advertising or publicity pertaining to distribution of the software   *
# * without specific, written prior permission.				     *
# *									     *
# * THE AUTHOR DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, 	     *
# * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN	     *
# * NO EVENT SHALL HE BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL   *
# * DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR    *
# * PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS  *
# * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF   *
# * THIS SOFTWARE.							     *
# *									     *
# ****************************************************************************/
#
# Makefile -- makefile for program 'dt'
#	

### MKMF:DEFINITIONS ###


# System makefile definitions for program makefiles

.SUFFIXES:	.ln

.c.ln:
#		@lint -i $(LINTFLAGS) $<
		@lint -c $(LINTFLAGS) $<

.c~.ln:
		@echo $<
		@$(GET) -G$*.c $(GFLAGS) $<
#		@lint -i $(LINTFLAGS) $*.c
		@lint -c $(LINTFLAGS) $*.c
		@rm -f $*.c

PRINTER=	lpr

PR_FLAGS=	-p -P28

TR_PRINTER=	$(PRINTER)

TR_FLAGS=	-t -P28

# Libraries the program links to which are considered volatile

LIBS= 

# Libraries considered static

EXTLIBS= -laio_raw -ldlm -lbinlog
#EXTLIBS= -laio -lpthreads -lc_r -lpthreads -lmach

LINTLIBS=

# P or G flag ( override on command line by invoking make PORG=-g )

PORG=	-O2 -g3

AWK=	awk
CFLAGS= $(PORG) -std1 -DAIO -DMMAP -DFIFO -DMUNSA
CPP=	/lib/cpp
CPPOPTS= $(CFLAGS)
#CPPOPTS= -P
LDFLAGS= -non_shared
LINTFLAGS= -n -whCDPR -XE -Nn6000 -Nd8000 ${LINTOPTS}

# end of system makefile definitions


HDRS=		dt.h

### MKMF:SOURCES ###


CFILES=		\
    		dt.c	\
		dtgen.c		\
		dtinfo.c	\
    		dtread.c	\
    		dtwrite.c	\
		dtstats.c	\
		dttty.c		\
    		dtutil.c	\
		dtusage.c	\
		dtprocs.c	\
		dttape.c	\
		dtaio.c		\
		dtmmap.c	\
		dtfifo.c


### MKMF:OBJECTS ###

OBJS=		\
		dt.o		\
		dtgen.o		\
		dtinfo.o	\
		dtread.o	\
		dtwrite.o	\
		dtstats.o	\
		dttty.o		\
		dtutil.o	\
		dtusage.o	\
		dtprocs.o	\
		dttape.o	\
		dtaio.o		\
		dtmmap.o	\
		dtfifo.o


### MKMF:LINTOBJS ###

LINTOBJS=		\
		dt.ln		\
		dtgen.ln	\
		dtinfo.ln	\
		dtread.ln	\
		dtwrite.ln	\
		dtstats.ln	\
		dttty.ln	\
		dtutil.ln	\
		dtusage.ln	\
		dtprocs.ln	\
		dttape.ln	\
		dtaio.ln	\
		dtmmap.ln	\
		dtfifo.ln


### MKMF:TARGETS ###

PROGRAM=	dt


# system targets for program makefile


$(PROGRAM):	$(OBJS) $(XOBJS) $(LIBS)
		@echo -n loading $(PROGRAM) ... 
		@echo -n $(CC) -o $(PROGRAM) $(CFLAGS) $(LDFLAGS) $(OBJS) $(LIBS) $(EXTLIBS)
		@$(CC) -o $(PROGRAM) $(CFLAGS) $(LDFLAGS) $(OBJS) $(LIBS) $(EXTLIBS)
		@echo done

print:;
		@$(PRINTER) $(PRINTFLAGS) $(CFILES)

prettyprint:;
		@vgrind $(CFILES) | $(TROFFPRINTER) $(TROFFPRINTERFLAGS)

lint:		$(LINTOBJS)
		lint $(LINTFLAGS) $(LINTOBJS) $(LINTLIBS)
		touch lint

clean:;
		@rm -f $(OBJS) $(PROGRAM)

tags:	$(CFILES) $(HDRS)
	ctags -wt $(CFILES) $(HDRS)

# end of system targets for program makefile


depend: makedep
	echo '/^# DO NOT DELETE THIS LINE/+1,$$d' >eddep
	echo '$$r makedep' >>eddep
	echo 'w' >>eddep
	cp Makefile Makefile.bak
	ex - Makefile < eddep
	rm eddep makedep makedep1 makedeperrs

makedep: ${CFILES}
	@cat /dev/null >makedep
	-(for i in ${CFILES} ; do \
		${CPP} -M ${CPPOPTS} $$i >> makedep; done) \
		2>makedeperrs
	sed \
		-e 's,^.*genassym\.o:,assym.s assym.L:,' \
		-e 's,^\(.*\)\.o:,\1.o \1.ln:,' makedep > makedep1
	${AWK} ' { if ($$1 != prev) { print rec; rec = $$0; prev = $$1; } \
		else { if (length(rec $$3) > 78) { print rec; rec = $$0; } \
		       else rec = rec " " $$3 } } \
	      END { print rec } ' makedep1 > makedep
	@cat makedeperrs
	@(if [ -s makedeperrs ]; then false; fi)


# DO NOT DELETE THIS LINE

dt.o dt.ln:	dt.c ./dt.h /usr/include/stdio.h /usr/include/standards.h
dt.o dt.ln:	/usr/include/sys/seek.h /usr/include/va_list.h
dt.o dt.ln:	/usr/include/sys/types.h /usr/include/mach/machine/vm_types.h
dt.o dt.ln:	/usr/include/sys/select.h /usr/include/getopt.h
dt.o dt.ln:	/usr/include/sys/limits.h /usr/include/machine/machlimits.h
dt.o dt.ln:	/usr/include/sys/syslimits.h /usr/include/machine/machtime.h
dt.o dt.ln:	/usr/include/sys/rt_limits.h /usr/include/stdlib.h
dt.o dt.ln:	/usr/include/string.h /usr/include/termios.h
dt.o dt.ln:	/usr/include/sys/ttydefaults.h /usr/include/time.h
dt.o dt.ln:	/usr/include/sys/timers.h /usr/include/time.h
dt.o dt.ln:	/usr/include/sys/signal.h /usr/include/sys/siginfo.h
dt.o dt.ln:	/usr/include/machine/signal.h /usr/include/sys/procset.h
dt.o dt.ln:	/usr/include/unistd.h /usr/include/sys/access.h
dt.o dt.ln:	/usr/include/errno.h /usr/include/sys/times.h /usr/include/ctype.h
dt.o dt.ln:	/usr/include/sys/localedef.h /usr/include/sys/lc_core.h
dt.o dt.ln:	/usr/include/fcntl.h /usr/include/sys/fcntl.h
dt.o dt.ln:	/usr/include/sys/mode.h /usr/include/signal.h
dt.o dt.ln:	/usr/include/sys/ioctl.h /usr/include/sys/secdefines.h
dt.o dt.ln:	/usr/include/sys/param.h /usr/include/machine/machparam.h
dt.o dt.ln:	/usr/include/machine/endian.h /usr/include/sys/file.h
dt.o dt.ln:	/usr/include/sys/mman.h /usr/include/sys/wait.h
dtgen.o dtgen.ln:	dtgen.c ./dt.h /usr/include/stdio.h /usr/include/standards.h
dtgen.o dtgen.ln:	/usr/include/sys/seek.h /usr/include/va_list.h
dtgen.o dtgen.ln:	/usr/include/sys/types.h /usr/include/mach/machine/vm_types.h
dtgen.o dtgen.ln:	/usr/include/sys/select.h /usr/include/getopt.h
dtgen.o dtgen.ln:	/usr/include/sys/limits.h /usr/include/machine/machlimits.h
dtgen.o dtgen.ln:	/usr/include/sys/syslimits.h /usr/include/machine/machtime.h
dtgen.o dtgen.ln:	/usr/include/sys/rt_limits.h /usr/include/stdlib.h
dtgen.o dtgen.ln:	/usr/include/string.h /usr/include/termios.h
dtgen.o dtgen.ln:	/usr/include/sys/ttydefaults.h /usr/include/time.h
dtgen.o dtgen.ln:	/usr/include/sys/timers.h /usr/include/time.h
dtgen.o dtgen.ln:	/usr/include/sys/signal.h /usr/include/sys/siginfo.h
dtgen.o dtgen.ln:	/usr/include/machine/signal.h /usr/include/sys/procset.h
dtgen.o dtgen.ln:	/usr/include/unistd.h /usr/include/sys/access.h
dtgen.o dtgen.ln:	/usr/include/errno.h /usr/include/sys/times.h
dtgen.o dtgen.ln:	/usr/include/sys/file.h /usr/include/sys/param.h
dtgen.o dtgen.ln:	/usr/include/machine/machparam.h
dtgen.o dtgen.ln:	/usr/include/machine/endian.h /usr/include/sys/fcntl.h
dtgen.o dtgen.ln:	/usr/include/sys/mode.h
dtinfo.o dtinfo.ln:	dtinfo.c ./dt.h /usr/include/stdio.h
dtinfo.o dtinfo.ln:	/usr/include/standards.h /usr/include/sys/seek.h
dtinfo.o dtinfo.ln:	/usr/include/va_list.h /usr/include/sys/types.h
dtinfo.o dtinfo.ln:	/usr/include/mach/machine/vm_types.h
dtinfo.o dtinfo.ln:	/usr/include/sys/select.h /usr/include/getopt.h
dtinfo.o dtinfo.ln:	/usr/include/sys/limits.h /usr/include/machine/machlimits.h
dtinfo.o dtinfo.ln:	/usr/include/sys/syslimits.h
dtinfo.o dtinfo.ln:	/usr/include/machine/machtime.h
dtinfo.o dtinfo.ln:	/usr/include/sys/rt_limits.h /usr/include/stdlib.h
dtinfo.o dtinfo.ln:	/usr/include/string.h /usr/include/termios.h
dtinfo.o dtinfo.ln:	/usr/include/sys/ttydefaults.h /usr/include/time.h
dtinfo.o dtinfo.ln:	/usr/include/sys/timers.h /usr/include/time.h
dtinfo.o dtinfo.ln:	/usr/include/sys/signal.h /usr/include/sys/siginfo.h
dtinfo.o dtinfo.ln:	/usr/include/machine/signal.h /usr/include/sys/procset.h
dtinfo.o dtinfo.ln:	/usr/include/unistd.h /usr/include/sys/access.h
dtinfo.o dtinfo.ln:	/usr/include/errno.h /usr/include/sys/times.h
dtinfo.o dtinfo.ln:	/usr/include/sys/ioctl.h /usr/include/sys/secdefines.h
dtinfo.o dtinfo.ln:	/usr/include/sys/param.h /usr/include/machine/machparam.h
dtinfo.o dtinfo.ln:	/usr/include/machine/endian.h /usr/include/sys/stat.h
dtinfo.o dtinfo.ln:	/usr/include/sys/mode.h
dtread.o dtread.ln:	dtread.c ./dt.h /usr/include/stdio.h
dtread.o dtread.ln:	/usr/include/standards.h /usr/include/sys/seek.h
dtread.o dtread.ln:	/usr/include/va_list.h /usr/include/sys/types.h
dtread.o dtread.ln:	/usr/include/mach/machine/vm_types.h
dtread.o dtread.ln:	/usr/include/sys/select.h /usr/include/getopt.h
dtread.o dtread.ln:	/usr/include/sys/limits.h /usr/include/machine/machlimits.h
dtread.o dtread.ln:	/usr/include/sys/syslimits.h
dtread.o dtread.ln:	/usr/include/machine/machtime.h
dtread.o dtread.ln:	/usr/include/sys/rt_limits.h /usr/include/stdlib.h
dtread.o dtread.ln:	/usr/include/string.h /usr/include/termios.h
dtread.o dtread.ln:	/usr/include/sys/ttydefaults.h /usr/include/time.h
dtread.o dtread.ln:	/usr/include/sys/timers.h /usr/include/time.h
dtread.o dtread.ln:	/usr/include/sys/signal.h /usr/include/sys/siginfo.h
dtread.o dtread.ln:	/usr/include/machine/signal.h /usr/include/sys/procset.h
dtread.o dtread.ln:	/usr/include/unistd.h /usr/include/sys/access.h
dtread.o dtread.ln:	/usr/include/errno.h /usr/include/sys/times.h
dtread.o dtread.ln:	/usr/include/sys/file.h /usr/include/sys/param.h
dtread.o dtread.ln:	/usr/include/machine/machparam.h
dtread.o dtread.ln:	/usr/include/machine/endian.h /usr/include/sys/fcntl.h
dtread.o dtread.ln:	/usr/include/sys/mode.h
dtwrite.o dtwrite.ln:	dtwrite.c ./dt.h /usr/include/stdio.h
dtwrite.o dtwrite.ln:	/usr/include/standards.h /usr/include/sys/seek.h
dtwrite.o dtwrite.ln:	/usr/include/va_list.h /usr/include/sys/types.h
dtwrite.o dtwrite.ln:	/usr/include/mach/machine/vm_types.h
dtwrite.o dtwrite.ln:	/usr/include/sys/select.h /usr/include/getopt.h
dtwrite.o dtwrite.ln:	/usr/include/sys/limits.h
dtwrite.o dtwrite.ln:	/usr/include/machine/machlimits.h
dtwrite.o dtwrite.ln:	/usr/include/sys/syslimits.h
dtwrite.o dtwrite.ln:	/usr/include/machine/machtime.h
dtwrite.o dtwrite.ln:	/usr/include/sys/rt_limits.h /usr/include/stdlib.h
dtwrite.o dtwrite.ln:	/usr/include/string.h /usr/include/termios.h
dtwrite.o dtwrite.ln:	/usr/include/sys/ttydefaults.h /usr/include/time.h
dtwrite.o dtwrite.ln:	/usr/include/sys/timers.h /usr/include/time.h
dtwrite.o dtwrite.ln:	/usr/include/sys/signal.h /usr/include/sys/siginfo.h
dtwrite.o dtwrite.ln:	/usr/include/machine/signal.h /usr/include/sys/procset.h
dtwrite.o dtwrite.ln:	/usr/include/unistd.h /usr/include/sys/access.h
dtwrite.o dtwrite.ln:	/usr/include/errno.h /usr/include/sys/times.h
dtwrite.o dtwrite.ln:	/usr/include/sys/file.h /usr/include/sys/param.h
dtwrite.o dtwrite.ln:	/usr/include/machine/machparam.h
dtwrite.o dtwrite.ln:	/usr/include/machine/endian.h /usr/include/sys/fcntl.h
dtwrite.o dtwrite.ln:	/usr/include/sys/mode.h
dtstats.o dtstats.ln:	dtstats.c ./dt.h /usr/include/stdio.h
dtstats.o dtstats.ln:	/usr/include/standards.h /usr/include/sys/seek.h
dtstats.o dtstats.ln:	/usr/include/va_list.h /usr/include/sys/types.h
dtstats.o dtstats.ln:	/usr/include/mach/machine/vm_types.h
dtstats.o dtstats.ln:	/usr/include/sys/select.h /usr/include/getopt.h
dtstats.o dtstats.ln:	/usr/include/sys/limits.h
dtstats.o dtstats.ln:	/usr/include/machine/machlimits.h
dtstats.o dtstats.ln:	/usr/include/sys/syslimits.h
dtstats.o dtstats.ln:	/usr/include/machine/machtime.h
dtstats.o dtstats.ln:	/usr/include/sys/rt_limits.h /usr/include/stdlib.h
dtstats.o dtstats.ln:	/usr/include/string.h /usr/include/termios.h
dtstats.o dtstats.ln:	/usr/include/sys/ttydefaults.h /usr/include/time.h
dtstats.o dtstats.ln:	/usr/include/sys/timers.h /usr/include/time.h
dtstats.o dtstats.ln:	/usr/include/sys/signal.h /usr/include/sys/siginfo.h
dtstats.o dtstats.ln:	/usr/include/machine/signal.h /usr/include/sys/procset.h
dtstats.o dtstats.ln:	/usr/include/unistd.h /usr/include/sys/access.h
dtstats.o dtstats.ln:	/usr/include/errno.h /usr/include/sys/times.h
dttty.o dttty.ln:	dttty.c ./dt.h /usr/include/stdio.h /usr/include/standards.h
dttty.o dttty.ln:	/usr/include/sys/seek.h /usr/include/va_list.h
dttty.o dttty.ln:	/usr/include/sys/types.h /usr/include/mach/machine/vm_types.h
dttty.o dttty.ln:	/usr/include/sys/select.h /usr/include/getopt.h
dttty.o dttty.ln:	/usr/include/sys/limits.h /usr/include/machine/machlimits.h
dttty.o dttty.ln:	/usr/include/sys/syslimits.h /usr/include/machine/machtime.h
dttty.o dttty.ln:	/usr/include/sys/rt_limits.h /usr/include/stdlib.h
dttty.o dttty.ln:	/usr/include/string.h /usr/include/termios.h
dttty.o dttty.ln:	/usr/include/sys/ttydefaults.h /usr/include/time.h
dttty.o dttty.ln:	/usr/include/sys/timers.h /usr/include/time.h
dttty.o dttty.ln:	/usr/include/sys/signal.h /usr/include/sys/siginfo.h
dttty.o dttty.ln:	/usr/include/machine/signal.h /usr/include/sys/procset.h
dttty.o dttty.ln:	/usr/include/unistd.h /usr/include/sys/access.h
dttty.o dttty.ln:	/usr/include/errno.h /usr/include/sys/times.h
dttty.o dttty.ln:	/usr/include/sys/ioctl.h /usr/include/sys/secdefines.h
dttty.o dttty.ln:	/usr/include/sys/param.h /usr/include/machine/machparam.h
dttty.o dttty.ln:	/usr/include/machine/endian.h /usr/include/sys/file.h
dttty.o dttty.ln:	/usr/include/sys/fcntl.h /usr/include/sys/mode.h
dtutil.o dtutil.ln:	dtutil.c ./dt.h /usr/include/stdio.h
dtutil.o dtutil.ln:	/usr/include/standards.h /usr/include/sys/seek.h
dtutil.o dtutil.ln:	/usr/include/va_list.h /usr/include/sys/types.h
dtutil.o dtutil.ln:	/usr/include/mach/machine/vm_types.h
dtutil.o dtutil.ln:	/usr/include/sys/select.h /usr/include/getopt.h
dtutil.o dtutil.ln:	/usr/include/sys/limits.h /usr/include/machine/machlimits.h
dtutil.o dtutil.ln:	/usr/include/sys/syslimits.h
dtutil.o dtutil.ln:	/usr/include/machine/machtime.h
dtutil.o dtutil.ln:	/usr/include/sys/rt_limits.h /usr/include/stdlib.h
dtutil.o dtutil.ln:	/usr/include/string.h /usr/include/termios.h
dtutil.o dtutil.ln:	/usr/include/sys/ttydefaults.h /usr/include/time.h
dtutil.o dtutil.ln:	/usr/include/sys/timers.h /usr/include/time.h
dtutil.o dtutil.ln:	/usr/include/sys/signal.h /usr/include/sys/siginfo.h
dtutil.o dtutil.ln:	/usr/include/machine/signal.h /usr/include/sys/procset.h
dtutil.o dtutil.ln:	/usr/include/unistd.h /usr/include/sys/access.h
dtutil.o dtutil.ln:	/usr/include/errno.h /usr/include/sys/times.h
dtutil.o dtutil.ln:	/usr/include/fcntl.h /usr/include/sys/fcntl.h
dtutil.o dtutil.ln:	/usr/include/sys/mode.h /usr/include/malloc.h
dtutil.o dtutil.ln:	/usr/include/tzfile.h /usr/include/varargs.h
dtutil.o dtutil.ln:	/usr/include/va_list.h /usr/include/sys/ioctl.h
dtutil.o dtutil.ln:	/usr/include/sys/secdefines.h /usr/include/sys/param.h
dtutil.o dtutil.ln:	/usr/include/machine/machparam.h
dtutil.o dtutil.ln:	/usr/include/machine/endian.h /usr/include/sys/resource.h
dtutil.o dtutil.ln:	/usr/include/sys/time.h /usr/include/sys/stat.h
dtusage.o dtusage.ln:	dtusage.c ./dt.h /usr/include/stdio.h
dtusage.o dtusage.ln:	/usr/include/standards.h /usr/include/sys/seek.h
dtusage.o dtusage.ln:	/usr/include/va_list.h /usr/include/sys/types.h
dtusage.o dtusage.ln:	/usr/include/mach/machine/vm_types.h
dtusage.o dtusage.ln:	/usr/include/sys/select.h /usr/include/getopt.h
dtusage.o dtusage.ln:	/usr/include/sys/limits.h
dtusage.o dtusage.ln:	/usr/include/machine/machlimits.h
dtusage.o dtusage.ln:	/usr/include/sys/syslimits.h
dtusage.o dtusage.ln:	/usr/include/machine/machtime.h
dtusage.o dtusage.ln:	/usr/include/sys/rt_limits.h /usr/include/stdlib.h
dtusage.o dtusage.ln:	/usr/include/string.h /usr/include/termios.h
dtusage.o dtusage.ln:	/usr/include/sys/ttydefaults.h /usr/include/time.h
dtusage.o dtusage.ln:	/usr/include/sys/timers.h /usr/include/time.h
dtusage.o dtusage.ln:	/usr/include/sys/signal.h /usr/include/sys/siginfo.h
dtusage.o dtusage.ln:	/usr/include/machine/signal.h /usr/include/sys/procset.h
dtusage.o dtusage.ln:	/usr/include/unistd.h /usr/include/sys/access.h
dtusage.o dtusage.ln:	/usr/include/errno.h /usr/include/sys/times.h
dtusage.o dtusage.ln:	/usr/include/tzfile.h
dtprocs.o dtprocs.ln:	dtprocs.c ./dt.h /usr/include/stdio.h
dtprocs.o dtprocs.ln:	/usr/include/standards.h /usr/include/sys/seek.h
dtprocs.o dtprocs.ln:	/usr/include/va_list.h /usr/include/sys/types.h
dtprocs.o dtprocs.ln:	/usr/include/mach/machine/vm_types.h
dtprocs.o dtprocs.ln:	/usr/include/sys/select.h /usr/include/getopt.h
dtprocs.o dtprocs.ln:	/usr/include/sys/limits.h
dtprocs.o dtprocs.ln:	/usr/include/machine/machlimits.h
dtprocs.o dtprocs.ln:	/usr/include/sys/syslimits.h
dtprocs.o dtprocs.ln:	/usr/include/machine/machtime.h
dtprocs.o dtprocs.ln:	/usr/include/sys/rt_limits.h /usr/include/stdlib.h
dtprocs.o dtprocs.ln:	/usr/include/string.h /usr/include/termios.h
dtprocs.o dtprocs.ln:	/usr/include/sys/ttydefaults.h /usr/include/time.h
dtprocs.o dtprocs.ln:	/usr/include/sys/timers.h /usr/include/time.h
dtprocs.o dtprocs.ln:	/usr/include/sys/signal.h /usr/include/sys/siginfo.h
dtprocs.o dtprocs.ln:	/usr/include/machine/signal.h /usr/include/sys/procset.h
dtprocs.o dtprocs.ln:	/usr/include/unistd.h /usr/include/sys/access.h
dtprocs.o dtprocs.ln:	/usr/include/errno.h /usr/include/sys/times.h
dtprocs.o dtprocs.ln:	/usr/include/signal.h /usr/include/sys/stat.h
dtprocs.o dtprocs.ln:	/usr/include/sys/mode.h /usr/include/sys/wait.h
dtprocs.o dtprocs.ln:	/usr/include/sys/param.h /usr/include/machine/machparam.h
dtprocs.o dtprocs.ln:	/usr/include/machine/endian.h
dttape.o dttape.ln:	dttape.c ./dt.h /usr/include/stdio.h
dttape.o dttape.ln:	/usr/include/standards.h /usr/include/sys/seek.h
dttape.o dttape.ln:	/usr/include/va_list.h /usr/include/sys/types.h
dttape.o dttape.ln:	/usr/include/mach/machine/vm_types.h
dttape.o dttape.ln:	/usr/include/sys/select.h /usr/include/getopt.h
dttape.o dttape.ln:	/usr/include/sys/limits.h /usr/include/machine/machlimits.h
dttape.o dttape.ln:	/usr/include/sys/syslimits.h
dttape.o dttape.ln:	/usr/include/machine/machtime.h
dttape.o dttape.ln:	/usr/include/sys/rt_limits.h /usr/include/stdlib.h
dttape.o dttape.ln:	/usr/include/string.h /usr/include/termios.h
dttape.o dttape.ln:	/usr/include/sys/ttydefaults.h /usr/include/time.h
dttape.o dttape.ln:	/usr/include/sys/timers.h /usr/include/time.h
dttape.o dttape.ln:	/usr/include/sys/signal.h /usr/include/sys/siginfo.h
dttape.o dttape.ln:	/usr/include/machine/signal.h /usr/include/sys/procset.h
dttape.o dttape.ln:	/usr/include/unistd.h /usr/include/sys/access.h
dttape.o dttape.ln:	/usr/include/errno.h /usr/include/sys/times.h
dtaio.o dtaio.ln:	dtaio.c ./dt.h /usr/include/stdio.h /usr/include/standards.h
dtaio.o dtaio.ln:	/usr/include/sys/seek.h /usr/include/va_list.h
dtaio.o dtaio.ln:	/usr/include/sys/types.h /usr/include/mach/machine/vm_types.h
dtaio.o dtaio.ln:	/usr/include/sys/select.h /usr/include/getopt.h
dtaio.o dtaio.ln:	/usr/include/sys/limits.h /usr/include/machine/machlimits.h
dtaio.o dtaio.ln:	/usr/include/sys/syslimits.h /usr/include/machine/machtime.h
dtaio.o dtaio.ln:	/usr/include/sys/rt_limits.h /usr/include/stdlib.h
dtaio.o dtaio.ln:	/usr/include/string.h /usr/include/termios.h
dtaio.o dtaio.ln:	/usr/include/sys/ttydefaults.h /usr/include/time.h
dtaio.o dtaio.ln:	/usr/include/sys/timers.h /usr/include/time.h
dtaio.o dtaio.ln:	/usr/include/sys/signal.h /usr/include/sys/siginfo.h
dtaio.o dtaio.ln:	/usr/include/machine/signal.h /usr/include/sys/procset.h
dtaio.o dtaio.ln:	/usr/include/unistd.h /usr/include/sys/access.h
dtaio.o dtaio.ln:	/usr/include/errno.h /usr/include/sys/times.h
dtaio.o dtaio.ln:	/usr/include/aio.h /usr/include/sys/sysaio.h
dtaio.o dtaio.ln:	/usr/include/sys/time.h /usr/include/sys/buf.h
dtaio.o dtaio.ln:	/usr/include/malloc.h /usr/include/limits.h
dtaio.o dtaio.ln:	/usr/include/sys/stat.h /usr/include/sys/mode.h
dtmmap.o dtmmap.ln:	dtmmap.c ./dt.h /usr/include/stdio.h
dtmmap.o dtmmap.ln:	/usr/include/standards.h /usr/include/sys/seek.h
dtmmap.o dtmmap.ln:	/usr/include/va_list.h /usr/include/sys/types.h
dtmmap.o dtmmap.ln:	/usr/include/mach/machine/vm_types.h
dtmmap.o dtmmap.ln:	/usr/include/sys/select.h /usr/include/getopt.h
dtmmap.o dtmmap.ln:	/usr/include/sys/limits.h /usr/include/machine/machlimits.h
dtmmap.o dtmmap.ln:	/usr/include/sys/syslimits.h
dtmmap.o dtmmap.ln:	/usr/include/machine/machtime.h
dtmmap.o dtmmap.ln:	/usr/include/sys/rt_limits.h /usr/include/stdlib.h
dtmmap.o dtmmap.ln:	/usr/include/string.h /usr/include/termios.h
dtmmap.o dtmmap.ln:	/usr/include/sys/ttydefaults.h /usr/include/time.h
dtmmap.o dtmmap.ln:	/usr/include/sys/timers.h /usr/include/time.h
dtmmap.o dtmmap.ln:	/usr/include/sys/signal.h /usr/include/sys/siginfo.h
dtmmap.o dtmmap.ln:	/usr/include/machine/signal.h /usr/include/sys/procset.h
dtmmap.o dtmmap.ln:	/usr/include/unistd.h /usr/include/sys/access.h
dtmmap.o dtmmap.ln:	/usr/include/errno.h /usr/include/sys/times.h
dtmmap.o dtmmap.ln:	/usr/include/malloc.h /usr/include/limits.h
dtmmap.o dtmmap.ln:	/usr/include/sys/mman.h /usr/include/sys/stat.h
dtmmap.o dtmmap.ln:	/usr/include/sys/mode.h
dtfifo.o dtfifo.ln:	dtfifo.c ./dt.h /usr/include/stdio.h
dtfifo.o dtfifo.ln:	/usr/include/standards.h /usr/include/sys/seek.h
dtfifo.o dtfifo.ln:	/usr/include/va_list.h /usr/include/sys/types.h
dtfifo.o dtfifo.ln:	/usr/include/mach/machine/vm_types.h
dtfifo.o dtfifo.ln:	/usr/include/sys/select.h /usr/include/getopt.h
dtfifo.o dtfifo.ln:	/usr/include/sys/limits.h /usr/include/machine/machlimits.h
dtfifo.o dtfifo.ln:	/usr/include/sys/syslimits.h
dtfifo.o dtfifo.ln:	/usr/include/machine/machtime.h
dtfifo.o dtfifo.ln:	/usr/include/sys/rt_limits.h /usr/include/stdlib.h
dtfifo.o dtfifo.ln:	/usr/include/string.h /usr/include/termios.h
dtfifo.o dtfifo.ln:	/usr/include/sys/ttydefaults.h /usr/include/time.h
dtfifo.o dtfifo.ln:	/usr/include/sys/timers.h /usr/include/time.h
dtfifo.o dtfifo.ln:	/usr/include/sys/signal.h /usr/include/sys/siginfo.h
dtfifo.o dtfifo.ln:	/usr/include/machine/signal.h /usr/include/sys/procset.h
dtfifo.o dtfifo.ln:	/usr/include/unistd.h /usr/include/sys/access.h
dtfifo.o dtfifo.ln:	/usr/include/errno.h /usr/include/sys/times.h
dtfifo.o dtfifo.ln:	/usr/include/fcntl.h /usr/include/sys/fcntl.h
dtfifo.o dtfifo.ln:	/usr/include/sys/mode.h






