/*
 * magicMain.c --
 *
 * Converted version of 'main.c' from the Magic layout editor.
 *                 pi@vlsi-cad.isi.edu  3/10/92
 *
 *     ********************************************************************* 
 *     * Copyright (C) 1985, 1990 Regents of the University of California. * 
 *     * Permission to use, copy, modify, and distribute this              * 
 *     * software and its documentation for any purpose and without        * 
 *     * fee is hereby granted, provided that the above copyright          * 
 *     * notice appear in all copies.  The University of California        * 
 *     * makes no representations about the suitability of this            * 
 *     * software for any purpose.  It is provided "as is" without         * 
 *     * express or implied warranty.  Export of this software outside     * 
 *     * of the United States of America may require an export license.    * 
 *     *********************************************************************
 */

#ifndef lint
static char rcsid[]="$Header: magicMain.c,v 6.3 90/09/12 15:17:15 cad Exp $";
#endif  not lint

#include <stdio.h>
#include <sys/types.h>
#include <sys/times.h>
#include "magic.h"
#include "magsgtty.h"	
#include "hash.h"
#include "textio.h"
#include "geometry.h"
#include "txcommands.h"
#include "graphics.h"
#include "tile.h"
#include "tech.h"
#include "database.h"
#include "drc.h"
#include "windows.h"
#include "dbwind.h"
#include "commands.h"
#include "signals.h"
#include "utils.h"
#include "runstats.h"
#include "cif.h"
#include "router.h"
#include "paths.h"

/* System library routines: */

extern char *getenv();
extern char *strcpy();
extern char *ctime();


/*
 * Global data structures
 *
 */

global char	*Path = NULL;		/* Search path */
global char	CellLibPath[100]	/* Used to find cells. */
    = MAGIC_INIT_PATH;
global char	SysLibPath[100]		/* Used to find color maps, styles, */
    = MAGIC_SYS_PATH;			/* technologies, etc. */

/*
 * See the file main.h for a description of the information kept
 * pertaining to the edit cell.
 */

global CellUse	*EditCellUse = NULL;


/*
 * data structures local to main.c
 *
 */

/* the following are used in saving our load image for fast startup */
static bool MainDoFreeze = FALSE;	/* TRUE if we should save our image */
static bool MainWasThawed = FALSE;	/* TRUE if this a restarted image */
static char *MainOrigFile;		/* File from which we were exec'd */
static char *MainSaveFile;		/* File to which image will be saved */
static char MainSaveDate[40];		/* When was image saved */


/*
 * ----------------------------------------------------------------------------
 * MainExit:
 *
 *	Magic's own exit procedure
 *
 * Results:
 *	None.
 *
 * Side effects:
 *	We exit.
 * ----------------------------------------------------------------------------
 */

global
MainExit(errNum)
int errNum;
{
    exit(errNum);
}

bool
trueProc() { return TRUE; }

Void
voidProc() {  }

Void
DummyTechClient(name)
    char *name;
{
    static int dummySec;
    TechAddClient(name, voidProc, trueProc, voidProc, (SectionID) 0, &dummySec, FALSE);
}


/*
 * ----------------------------------------------------------------------------
 * main
 *
 *	Initializes modules, read command line args, open files, and calls
 *      dispatch to process commands.
 * Results:
 *	None.
 *
 * Side effects:
 *	A VLSI design in the file system was edited!
 * ----------------------------------------------------------------------------
 */


magicMainInit()
{
    char *savedTechName;
    int(*nullProc)() = 0;
    extern bool ExtTechAddType();
    extern ExtTechInit(), ExtTechFinal();
    
    /* initialize modules and the text display */
    if (MainWasThawed)
        TxPrintf("Image saved %s", MainSaveDate);
    DBCellInit();
    DRCInit();
    DBVerbose = FALSE;

    if (MainWasThawed)
    {
        savedTechName = TechDefault;
    }

    if (!MainWasThawed)
    {
	SectionID sec_tech, sec_planes, sec_types;
	SectionID sec_connect, sec_contact, sec_compose;
	SectionID sec_cifinput, sec_cifoutput;
	SectionID sec_drc;

	/* initialize technology */
	TechInit();
	TechAddClient("tech", DBTechInit, DBTechSetTech, nullProc,
			(SectionID) 0, &sec_tech, FALSE);
        TechAddClient("version", nullProc, DBTechSetVersion, nullProc,
                        (SectionID) 0, (int *)0, TRUE);
	TechAddClient("planes",	DBTechInitPlane, DBTechAddPlane, nullProc,
			(SectionID) 0, &sec_planes, FALSE);
	TechAddClient("types", DBTechInitType, DBTechAddType, DBTechFinalType,
			sec_planes, &sec_types, FALSE);

	DummyTechClient("styles");

	TechAddClient("contact", DBTechInitContact,
			DBTechAddContact, DBTechFinalContact,
			sec_types|sec_planes, &sec_contact, FALSE);

	TechAddClient("compose", DBTechInitCompose,
			DBTechAddCompose, DBTechFinalCompose,
			sec_types|sec_planes|sec_contact, &sec_compose, FALSE);

	TechAddClient("connect", DBTechInitConnect,
			DBTechAddConnect, DBTechFinalConnect,
			sec_types|sec_planes|sec_contact, &sec_connect, FALSE);

	TechAddClient("cifoutput", CIFTechInit, CIFTechLine, CIFTechFinal,
			(SectionID) 0, &sec_cifoutput, FALSE);
	
	TechAddClient("cifinput", CIFReadTechInit, CIFReadTechLine,
		    CIFReadTechFinal, (SectionID) 0, &sec_cifinput, FALSE);

	TechAddClient("drc", DRCTechInit, DRCTechAddRule, DRCTechFinal,
			sec_types|sec_planes, &sec_drc, FALSE);

	DummyTechClient("mzrouter");
	DummyTechClient("extract");
	DummyTechClient("wiring");
	DummyTechClient("router");
	DummyTechClient("plowing");
	DummyTechClient("plot");
    }

    if (!MainWasThawed || strcmp(TechDefault, savedTechName) != 0)
    {
	if (!TechLoad(TechDefault))
	{
	    TxError("Cannot load technology \"%s\"\n", TechDefault);
	    MainExit(0);
	}
    }

    if (!MainWasThawed)
    {
	/* Freeze our load image if requested */
	if (MainDoFreeze)
	{
	    time_t saveDate;

	    time(&saveDate);
	    strcpy(MainSaveDate, ctime(&saveDate));

	    /*
	     * When the thawed image starts up, we want to
	     * see that it was thawed (hence MainWasThawed should
	     * be TRUE), and also don't want to save it again (hence
	     * MainDoFreeze should be FALSE).
	     */
	    MainDoFreeze = FALSE;
	    MainWasThawed = TRUE;

	    /* Save the image */
	    TxPrintf("Saving load image in file '%s' ...", MainSaveFile);
	    (void) fflush(stdout);
	    if (!SaveImage(MainOrigFile, MainSaveFile))
	    {
		TxError("\nCannot save load image.\n");
		MainExit(1);
	    }
	    TxPrintf("Done\n");

	    /* Restore the environment so we can continue normally */
	    MainWasThawed = FALSE;
	}
    }
}
