#include <stdio.h>
#include "subckt.h"

uptr mux2_init();
uptr mux2_func();
uptr flop_func();
uptr flop_init();

userSubCircuit subs[] =
{
    { "mux2",		mux2_func,	mux2_init	},
    { "flop",		flop_func,	flop_init	},
    { NULL,		NULL,		NULL		}
};

typedef struct _flopState {
	int prvClk ;
	int Q ;
} flopState;

uptr flop_init()
{
	flopState *thisFlop = (flopState *)malloc(sizeof(flopState));

	thisFlop->prvClk = HIGH ;
	thisFlop->Q = X ;
}


uptr flop_func( ins, outs, delay, data )
char *ins, *outs;
double *delay;
uptr  *data;
{
	flopState *ff = (flopState *)data ;

	if ( ff->prvClk == LOW && ins[1] == HIGH ) {
		printf("flop edge @ %.2fns\n", d2ns( cur_delta ));
		ff->Q = ins[0];
	}
	delay[0] = 100.0 ;
	ff->prvClk = ins[1];
	outs[0] = ff->Q;
}


typedef struct _Mux2
{
    int		dummyArg;
} muxData;

static int cnt = 0;

uptr mux2_init()
{
    muxData *udata = (muxData *)malloc(sizeof(muxData));

    udata->dummyArg = cnt++;
    /* printf("debug: initializing mux2 %x\n", udata); */
    return((uptr)udata);
}

uptr mux2_func( ins, outs, delay, udata )
char *ins;
char *outs;
double *delay;
uptr udata;
{
    muxData	*xx = (muxData *) udata;

    delay[0]=100.0;
    if (ins[2] == LOW)
	outs[0] = ins[1];
    else if (ins[2] == HIGH)
	outs[0] = ins[0];
    else
	outs[0] = X;
    /*
    outs[1] = X_X;
    outs[2] = LOW;
    */
}
