/* 
 *     ********************************************************************* 
 *     * Copyright (C) 1988, 1990 Stanford University.                     * 
 *     * Permission to use, copy, modify, and distribute this              * 
 *     * software and its documentation for any purpose and without        * 
 *     * fee is hereby granted, provided that the above copyright          * 
 *     * notice appear in all copies.  Stanford University                 * 
 *     * makes no representations about the suitability of this            * 
 *     * software for any purpose.  It is provided "as is" without         * 
 *     * express or implied warranty.  Export of this software outside     * 
 *     * of the United States of America may require an export license.    * 
 *     ********************************************************************* 
 */

/*
 * Prints various messages but deals with varargs correctly.
 */

#include <stdio.h>
#ifdef OS2
#include <stdlib.h>
#include <stdarg.h>
#else
#include <varargs.h>
#endif  /* OS2 */
#include "defs.h"


extern	FILE  *logfile;


private void logprint( s )
  register char  *s;
  {
    static int  docomment = 1;

    while( *s != '\0' )
      {
	if( docomment )
	  {
	    (void) putc( '|', logfile );
	    (void) putc( ' ', logfile );
	    docomment = 0;
	  }
	(void) putc( *s, logfile );
	if( *s++ == '\n' )
	    docomment = 1;
      }
  }


/* VARARGS */
#ifndef OS2
public void lprintf( va_alist )
  va_dcl
#else
public void lprintf(FILE *max, ... )
#endif  /* OS2 */
  {
    va_list  args;
    char     *fmt;
    FILE     *fp;
    char     buff[ 300 ];

#ifndef OS2
    va_start( args );
    fp = va_arg( args, FILE * );
#else
    va_start(args, max);
    fp = (FILE *)max;
#endif  /* OS2 */
    fmt = va_arg( args, char * );
    (void) vsprintf( buff, fmt, args );
    va_end( args );
#ifndef OS2
    (void) fputs( buff, fp );
#else
    (void) fputs( buff, fp );
#endif  /* OS2 */

    if( logfile != NULL )
	logprint( buff );
  }


/* VARARGS */
#ifndef OS2
public void error( va_alist )
  va_dcl
#else
public void error(int max, ...)
#endif  /* OS2 */
  {
    va_list  args;
    char     *filename;
    int      lineno;
    char     *fmt;
    char     buf1[ 100 ], buf2[ 200 ];

#ifndef OS2
    va_start( args );
    filename = va_arg( args, char * );
#else
    filename = (char *)max;
    max = 12;
    va_start(args, max);
#endif  /* OS2 */
    lineno = va_arg( args, int );
    fmt = va_arg( args, char * );
    (void) sprintf( buf1, "(%s,%d): ", filename, lineno );
    (void) vsprintf( buf2, fmt, args );
    va_end( args );
    (void) fputs( buf1, stderr );
    (void) fputs( buf2, stderr );
    if( logfile != NULL )
      {
	logprint( buf1 );
	logprint( buf2 );
      }
  }
