/* ************************************************************************
	uuparts.c - written by Amit Margalit (c) 1995
	
	uuparts was written to help me reduce the time I spend uudecoding.
	Generally, it takes a file containing any mixture of any number of
	uuencoded and/or sliced files, and decodes them. 
	
	You can simply save articles which contain a whole uuencoded file
	and append any number of such articles, as well as sets of many
	articles which contain slices of one big file. uuparts will ignore
	any lines which do not look like uuencoded lines if they appear 
	between 'begin' and 'end'.
	
	uuparts decodes the files by itself, and does not fork uudecode for
	each part.
	
	NOTE: This is a very very very first release. I have tested this
	only for my own purposes, and I *think* it works OK. I would be
	glad to see any bug reports.
	
	Also note: The decode part was "stolen" from uudecode's source,
	as it appears in Slackware_Source as of v2.2 Slackware. Therefore:
	THIS FILE IS SUBJECT TO THE GNU GPL!
	
	Warning: I assume no liablity for any damages you incur by using this
	program. I wrote this for me, and even I am not sure it works 100%.
	Don't blame me for loss of data of any sort. Basically what I am
	trying to say is:
	#include <disclaim.h>
	
	Amit Margalit
	amitm@doronx.iso.dec.com	- preferred!
	amargali@sunshine.biu.ac.il
*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>

/* VMS doesn't have the sys/ directory and VAXC moved things a bit */
#ifdef vms
#include unixio
#include types
#include stat
#include file
#include ssdef
#else
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <unistd.h>
#endif

enum { SKIPPING, DECODING, SKIP2 } state = SKIPPING;
int temp_cnt = 0;		/* temporary filename counter */

#define DEF_MODE	0444	/* octal 444 = -r--r--r */
#define MODE_MASK	
#define	DEC(c)	(((c) - ' ') & 077) /* single character decode */

#define VERSION        "0.2c"
int is_valid_line(char* line)
{
  int n,p,l;

  n = DEC (*line);
  l = strlen(line) - 1;
  p = l / 4;
  p *= 3;

#if 0
  if (n <= 0)	/* should be end of file */
    return 1;
#else
  if (strcmp(line,"`")==0)
    return 1;
#endif

  if(l%4 !=0 || p-n > 2)	/* data field must be a multiple of 4 */
    return 0;
    
  while(*line) {
    if(islower(*line))
      return 0;
    line++;
  }
  return 1;
}

unsigned otoi(char* l)
{
  unsigned result = 0;
  int touched = 0;
  
  while(*l) {
    switch(*l) {
    case '0': case '1': case '2': case '3':
    case '4': case '5': case '6': case '7':
      touched = 1;
      result <<= 3;
      result |= ((*l)-'0');
      break;
    default:
      if(*l == ' ' && !touched)
        break;
      else
        return result;
    } /* switch */
    l++;
  } /* while(*l) */
  return result;
} /* otoi */

unsigned getfn(char* ln,char* fn)
{
  char tmp[10];		/* store for atoi of mode */
  int i=0;

  do ln++; while (*ln != '\0' && *ln !=' ');	/* look for space */
  if(*ln=='\0') {
    sprintf(fn,"temp_name_%02d.tmp",temp_cnt++);
    return DEF_MODE;
  }

  do tmp[i++] = *ln++; while (*ln != '\0' && *ln !=' '); /* for mode */
  tmp[i]='\0'; 

  while(*ln == ' ') ln++;	/* skip whitespace before filename */
  do {
    if(*ln == ' ')
      *ln = '_';	/* convert spaces in filename to _ */
    *fn++ = *ln++;
  } while (*ln != '\0' && *ln !='\n'); /* copy filename till end of line */
  *fn='\0';

  return otoi(tmp);
}

void decode_line(char* line, int fout)
{
  char* p;
  int n,bidx=0;
  char buf[80];
  int ch;

      p = line;
      /*
       * `n' is used to avoid writing out all the characters
       * at the end of the file.
       */
      n = DEC (*p);
      if (n <= 0)	/* should be end of file */
	return;
      for (++p; n > 0; p += 4, n -= 3)
	{
	  if (n >= 3)
	    {
	      ch = DEC (p[0]) << 2 | DEC (p[1]) >> 4;
	      buf[bidx++]=ch;
	      ch = DEC (p[1]) << 4 | DEC (p[2]) >> 2;
	      buf[bidx++]=ch;
	      ch = DEC (p[2]) << 6 | DEC (p[3]);
	      buf[bidx++]=ch;
	    } 
	  else /* n<3 */
	    {
	      if (n >= 1)
		{
		  ch = DEC (p[0]) << 2 | DEC (p[1]) >> 4;
	          buf[bidx++]=ch;
		} /* n>=1 */
	      if (n >= 2)
		{
		  ch = DEC (p[1]) << 4 | DEC (p[2]) >> 2;
	          buf[bidx++]=ch;
		} /* n>=2 */
	    } /* n<3 */
       } /* for */
  if(write(fout,buf,bidx)!=bidx) {	/* write out the stuff decoded */
    fprintf(stderr,"Couldn't write to file.\n");
    exit(1);
  }
}

void usage(void)
{
  fprintf(stderr,
  "Usage: uuparts [file]  or  {cmd} | uuparts  or  uuparts < {file}\n");
  fprintf(stderr,
  "You may give uuparts one file on the command line, otherwise it reads\n");
  fprintf(stderr,
  "the uuencoded data from stdin. Any mixture of articles containing any\n");
  fprintf(stderr,
  "types of uuencoded files - either whole files or sliced - is allowed.\n");
  fprintf(stderr,
  "Note: uuparts strips the 'executable' bit from file creation masks.\n");
  
  exit(0);
}

int main(int argc, char* argv[])
{
  FILE* fin;
  int fout;
  char fn[80],tmp[80];
  char line[1024];
  unsigned mode;	/* open mode for files */

  fprintf(stderr,"uuparts v%s - By Amit Margalit (uuparts -h for help)\n",VERSION);
  strcpy(fn,"(null)");
  
  if(argc>1) {
    if(strcmp(argv[1],"-h")==0 || strcmp(argv[1],"-H")==0)
      usage();
    fin=fopen(argv[1],"r");
    if(fin==NULL) {
      fprintf(stderr,"Error opening %s as input.\n",argv[1]);
#ifdef vms
      return 0;		/* VMS's 1 is SS$_NORMAL */
#else
      return 1;
#endif
    }
  }
  else {
    fin = stdin;
#ifdef VMS
    fprintf(stderr,"This is a VMS system, I don't think you want to use stdin\n");
    return 0;		/* gives "%NONAME-E-NOMSG, Noname message #000000" */
#endif
  }
    
  while(1) {				/* main loop */
    if(fgets(line,1024,fin)==NULL) {
      if(state == SKIPPING) {		/* good, input file ended */
        fclose(fin);
#ifdef vms
	return SS$_NORMAL;
#else
        return 0;
#endif
      }
      else {
        fprintf(stderr,"Short file: %s\n",fn);
        fclose(fin);
#ifdef vms
        return 0;		/* VMS's 1 is SS$_NORMAL */
#else
        return 1;
#endif
      } /* if(state) */
    } /* if(fgets) */

    if(line[strlen(line)-1]=='\n')	/* strip linefeed at end of line */
      line[strlen(line)-1]='\0';
    if(line[strlen(line)-1]=='\r')	/* a CR also??? */
      line[strlen(line)-1]='\0';

    if(strncmp("begin",line,5)==0) {
      if(state==DECODING) {		/* short file... */
        fprintf(stderr,"Short file: %s\n",fn);
        close(fout);			/* close it */
        state=SKIPPING;		/* change state so next part starts decode */
      }
      mode=getfn(line,fn);		/* get filename and open mode */
      printf("uudecoding %s\n",fn);
      state = DECODING;
      fout=open(fn,O_CREAT|O_WRONLY,mode&DEF_MODE);
      if(fout<0) {
        sprintf(tmp,"temp_%03d_%s",temp_cnt,fn);
        fout=open(tmp,O_CREAT|O_WRONLY,mode&DEF_MODE);
        fprintf(stderr,"File exists? Trying as %s ...\n",tmp);
        if(fout<0) {
          fprintf(stderr,"Unable to create %s!\n",fn);
          state=SKIPPING;
        } /* fout <0 */
      temp_cnt++;
      } /* fout <0 */
    } /* if(strncmp("begin")) */
    
    /* if we got here this means we should start doing lines until end */
    if(state==DECODING) {
      if(is_valid_line(line)) {
        decode_line(line,fout);
      }
      else {
        state = SKIP2;
      }
    }

    if(state == SKIP2) {
      if(is_valid_line(line) && line[0] == 'M' && strlen(line)==61) {
        state = DECODING;
        decode_line(line,fout);
      }
    }
      
    if(strncmp(line,"end",3)==0) {
        state = SKIPPING;
        close(fout);
    } /* if(end) */
  } /* while(1) */
}
