.\" Copyright (c) 1994 by Digital Equipment Corporation
.\"
.\" Permission to use, copy, modify, and distribute this software for any
.\" purpose with or without fee is hereby granted, provided that the above
.\" copyright notice and this permission notice appear in all copies, and that
.\" the name of Digital Equipment Corporation not be used in advertising or
.\" publicity pertaining to distribution of the document or software without
.\" specific, written prior permission.
.\"
.\" THE SOFTWARE IS PROVIDED "AS IS" AND DIGITAL EQUIPMENT CORP. DISCLAIMS ALL
.\" WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES
.\" OF MERCHANTABILITY AND FITNESS.   IN NO EVENT SHALL DIGITAL EQUIPMENT
.\" CORPORATION BE LIABLE FOR ANY SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL
.\" DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR
.\" PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
.\" ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
.\" SOFTWARE.
.\"
.\" SCCSID: @(#)cgi.n	1.4	6/17/94
.TH cgi n Tcl Tcl "Tcl Extensions"
.SH Name
cgi \- HTTP Common Gateway Interface support for Tcl
.SH Syntax
.B cgi_get_query
.RB ? -timeout
.IR seconds ?
.br
.BI cgi_parse_query
.RB ? -strip ?
.RB ? -list ?
.I  "query array"
.RI ? list-var... ?
.br
.SH Description
.B CGI
is an extension for Tcl that implements
parts of the HTTP Server Common Gateway Interface.  The resulting Tcl shell
is useful for executing scripts invoked by the http daemon.
HTTP is the transport protocol for the World Wide Web (WWW).
.PP
Two commands are implemented, one for getting the query from the server, and
the other for parsing the query.
.PP
\fBcgi_get_query\fR ?\fB-timeout\fI seconds\fR?
.PP
Reads the query, either from standard input (for a POST query) or
from $QUERY_STRING (for a GET query).  It examines $REQUEST_METHOD
to determine which type is in use.  The resulting string is still
URL-encoded.
Because cgi_get_query may read standard input, it must not be called
more than once.
.PP
If the query is read from standard input,
.B cgi_get_query
will wait 10 seconds after the last input was received for the entire query
to be received.  This delay is
important for slow network connections, where the data may arrive in several
widely-spaced TCP segments.  The default timeout can be changed by giving the
.B -timeout
.I seconds
option.
.PP
\fBcgi_parse_query\fR ?\fB-strip\fR? ?\fB-list\fR? \fIquery array\fR ?\fIlist-var...\fR?
.PP
Parses a URL-encoded query and assigns each NAME=VALUE pair into the
array.  
.IR i.e. ,
.IR array "(NAME) <= VALUE."
If a NAME may occur more than
once in the query (script writers should know this, based upon the
form layout), the last value will overwrite all others.
However, if NAME is given as one of the optional
.IR list-var "'s,"
the VALUE is appended as a list element to the array element.
.PP
The
.B -list
option causes all VALUEs to be added to 
.IR array "(NAME)"
as list elements.  It is useful when it is not known ahead of time which
query elements should be treated as lists, such as when the HTML form
is dynamically-generated.  Note that non-list values must be extracted using
the Tcl
.B lindex
command.
.PP
The
.B -strip
option causes all non-printing, non-whitespace characters to be removed from
the query values.
.SH Usage
The expected usage is to create a Tcl interpreter (which I call tcl_cgi),
put it someplace accessable, and write scripts which use it.  So, a
typical script might look like the following.  Assuming that the form
defines two names "NAME" and "COMMENTS":
.RS
.EX
#! /usr/local/bin/tcl_cgi

cgi_parse_query [cgi_get_query] Q
set file [open {|/usr/ucb/mail -s "Comments..." smith@bigmax} w]
puts $file "Comments from $Q(NAME) (at $env(REMOTE_HOST)):\n"
puts $file $Q(COMMENTS)
close $file
puts {Content-type: text/html

<TITLE>Thank You</TITLE>
<H1>Thank You</H1>
Your comments have been submitted.
}
.EE
.RE
.SH Error Messages
From
.BR cgi_get_query :
.PP
.TP
Invalid timeout value: XXX
A non-integer or negative value was given for the
.B -timeout
option.
.TP
Invalid CONTENT_LENGTH: XXX
CONTENT_LENGTH contained a non-integer or negative value.
.TP
Usage: cgi_get_query ?-timeout seconds?
Bad options.
.TP
Can't call cgi_get_query more than once
You tried to call
.B cgi_get_query
a second time.
.TP
XXXX not set
The environment variable REQUEST_METHOD, QUERY_STRING, or CONTENT_LENGTH
wasn't set by
.IR httpd .
.TP
malloc failure (XXX bytes)
Couldn't allocate memory for buffering the incoming query.
.TP
stdin: UNIX ERROR
A system error occurred during the select or read system calls.  A
standard Unix error message is appended.
.TP
Couldn't read HTTP query: Expected XXX bytes, but only got YYY bytes
While reading the query from standard input, no input was received for 10
seconds, and the query was still incomplete.
.TP
Unsupported REQUEST_METHOD "XXX"
A REQUEST_METHOD other than GET or POST was encountered.
.PP
From
.BR cgi_parse_query :
.TP
cgi_parse_query: unknown option "XXX"
Bad options.
.TP
Usage: cgi_parse_query [-strip] query array [list-names...]
Bad options.
.TP
Missing "=" in query
Each NAME=VALUE pair is required to contain the equal sign, even if VALUE
isn't present.
.PP
Tcl errors may occur when attempting to set elements of the 
.IR array .
.PP

.SH Restrictions
Some Unix kernels only handle interpreter file names (the
"shell" after #!) of about 24 bytes in length.  This causes mysterious
failures: your Tcl script will be executed by sh if the interpreter name is
too long.  In particular, you will probably exceed this limit if you put the
interpreter in the conventional httpd location:
.BR /usr/local/etc/httpd/support/tcl_cgi .
.PP
It is important to test for and handle errors from these functions,
otherwise the user may get an incomprehensible error message.
