.\" Copyright (c) 1994 by Digital Equipment Corporation
.\"
.\" Permission to use, copy, modify, and distribute this software for any
.\" purpose with or without fee is hereby granted, provided that the above
.\" copyright notice and this permission notice appear in all copies, and that
.\" the name of Digital Equipment Corporation not be used in advertising or
.\" publicity pertaining to distribution of the document or software without
.\" specific, written prior permission.
.\"
.\" THE SOFTWARE IS PROVIDED "AS IS" AND DIGITAL EQUIPMENT CORP. DISCLAIMS ALL
.\" WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES
.\" OF MERCHANTABILITY AND FITNESS.   IN NO EVENT SHALL DIGITAL EQUIPMENT
.\" CORPORATION BE LIABLE FOR ANY SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL
.\" DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR
.\" PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
.\" ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
.\" SOFTWARE.
.\"
.\" SCCSID: @(#)pbm.n	1.4	10/17/94
.TH PBM n Tcl Tcl "Tcl Extensions"
.SH Name
PBM \- Portable Bit Map access for Tcl
.SH Syntax
.RI pbm_new " pict-name " ? options ? " filename"
.br
.RI pbm_new " pict-name " ? options ? " width height"
.br
.RI "pbm_text ?" options ? " text"
.br
pbm_list
.br
pbm_list_fonts
.PP
.IR pict " delete"
.br
.IR pict " size"
.br
.IR pict " output ?-gif? ?-ppm? ?-interlace? " filename
.br
.IR pict " duplicate " newname
.br
.IR pict " paste " ppict " ?-anchor " pos "? ?-stencil"
.IR color "?" " x y"
.br
.IR pict " pour ?-color " pcol "? ?-pattern " ppict "?"
.RI "?-anchor " pos "? ?-bleed " bcol "?"
.RI "?-8neighbor?" " x y"
.br
.IR pict " cut " newname " x y dx dy"
.br
.IR pict " crop"

.SH Description
This Tcl extension provides operations for manipulating images stored in PBM
and GIF formats.  It is derived directly from the PBM sources, so is
completely compatible with the PBM programs.
.PP
The central concept of the extension is the
.I picture
or
.IR pict ,
which holds a single rectangular image.  A pict has three attributes: width,
height, and, optionally, a color that is used to represent transparency,
plus the contents of the image itself.  Picts can be read from files,
written to files, created, destroyed, and combined in various ways.
.PP
There are four top-level commands,
.BR pbm_new ", " pbm_text ", " pbm_list ", and"
.BR pbm_list_fonts .
.PP

.SH Creating Pictures
The
.B pbm_new
command creates a new pict:
.HP
.RI pbm_new " pict-name " ? options ? " filename"
.br
Create a new pict by reading a file that contains a GIF or PNM (PBM, PGM, or
PPM) image.  The type will be determined automatically from the contents of
the file.
.HP
.RI pbm_new " pict-name " ? options ? " width height"
.br
Create an empty pict of the specified size.
The pict will initially be filled with, in order of preference,
the
.B -fill
color, the
.B -transparent
color, or white.
.PP
The
.B pbm_new
command returns the name of the pict created and creates a Tcl command of
that
.IR name ,
which is used later to manipulate the pict.
.PP
The available options are:
.HP
.RI -transparent " color"
.br
Specifies a color that will be treated as "transparent".  This color will be
ignored in an image when pasting it onto another image, and, when a GIF file
is written, the transparency option will be set appropriately.  This option
will be silently ignored if a GIF file with the transparency option is
read (because the transparency color is already determined).
The specific color used is unimportant, and the color can be
different for different picts.  The only thing that matters is that the
transparency color should not appear in the actual image.
.BR red ,
.BR green ,
and
.B blue
are often good choices.  Any of the color formats used by PBM
may be used to specify the color.
(See
.MS ppmtogif 1 .)

If
.I color
is given as
.BR auto ,
the transparency color is determined automatically by examining the colors
of the four corner pixels.  If they are all the same, that color is used as
the transparency color.  An error is returned if a transparency color can't
be determined.
.HP
.RI -fill " color"
.br
Specifies a color to fill the new pict with.  This option may not be used
when reading the image from a file.
.HP
.RI -maxval " value"
.br
Sets the maximum pixel value used in this image, an internal PBM parameter.
See the manual pages for
.MS pgm 5 
or
.MS ppm 5 .
The default (255) should almost always be used.  This option may not be used
when reading the image from a file, because the maximum value is determined
from the file.
.PP
The
.B pbm_list
command lists the existing picts, including their sizes and any options that
are active for them (-maxval and -transparent).

.SH Creating Text Pictures
The
.B pbm_text
command creates a new pict consisting of user-supplied text:
.HP
.RI "pbm_text ?" options ? " text"
.br
Create a new pict by rendering the given
.IR text .
Newlines in 
.I text
cause it to be put on multiple lines.  Tabs are expanded to
8-character tabstops.  (This assumes a fixed-width font, which is not good
assumption).
.PP
The
.B pbm_text
command returns the name of the pict created and creates a Tcl command of
that
.IR name ,
which is used later to manipulate the pict.
.PP
The available options are:
.HP
.RI -fg " color"
.br
Specifies the color for the characters.  The default is black.
Any of the color formats used by PBM may be used to specify the color.
(See
.MS ppmtogif 1 .)
.HP
.RI -bg " color"
.br
Specifies the color for the background.  By default, the background is set
to be transparent, with white as the transparency color.  If the
.B -bg
option is given, the background will no longer be transparent.  (Since text
picts will almost always be pasted onto other picts, which can have their
own transparency colors, the choice of the transparency color doesn't matter
here.)
.HP
.RI -margin " n"
.br
Add a margin
.I n
pixels wide around the text.
.HP
.RI -font " fontname"
.br
The given font is used for the text.
.I fontname
can be the name of one of the built-in fonts or the name of a font file in X
"BDF" format.  (BDF files have the word "STARTFONT" on the first line.)
The built-in fonts are named 
.BR bdf ,
which is variable-width (the default) or
.B fixed.
.HP
.RI -name " pictname"
.br
.I pictname
will be used for the name of the pict.  By default, an internally-generated
name is used.  The default names begin with a '%', so the pict is temporary
(see below).
.PP
The
.B pbm_list_fonts
command lists the fonts that have been loaded.

.SH Working With Pictures
Once a pict has been created, it is manipulated by invoking the
pict's name as a Tcl command.  For example, if a pict is named "map", then
it can be deleted with the Tcl command "map delete".  The first argument
always determines the operation, and may be any of:
.HP
.IR pict " delete"
.br
Delete the pict.
.HP
.IR pict " size"
.br
Return the (x,y) size of the pict, as a two-item list.
.HP
.IR pict " output ?-gif? ?-ppm? ?-interlace? " filename
.br
Write the pict to the given file.  -gif and -ppm force an output format,
otherwise it is determined by looking at the extension of
.I filename
(.gif or .ppm).  -interlace forces "interlace" format for GIFs, which lets
some Web browsers do better incrementally display of images.
.HP
.IR pict " duplicate " newname
.br
Create an exact copy of
.IR pict ,
giving it the name
.IR newname .
.HP
.IR pict " paste " ppict " ?-anchor " pos "? ?-stencil"
.IR color "?" " x y"
.br
.I ppict
is pasted onto 
.I pict
at the coordinates specified by 
.I x
and
.IR y ,
with (0,0) at the upper left corner.
.I pict
and
.I ppict
must refer to different picts.
If 
.I x
is negative, it specifies the distance from the right edge.  If
.I y
is negative, it specifies the distance from the bottom edge.
If any part of
.I ppict
falls outside the bounds of
.IR pict ,
.I ppict
is silently clipped.

The
.B -anchor
option specifies which point on
.I ppict
is placed at the location determined by
.RI ( x , y ).
It is a point of the compass, as defined in Tk: 
n, ne, e, se, s, sw, w, nw, or center.
If the
.B -anchor
option isn't given, the anchor point is determined by the signs of
.I x
and
.IR y :
.Ds
	coord	anchor-position
	+x +y	-nw
	+x -y	-sw
	-x +y	-ne
	-x -y	-se
.De

The
.B -stencil
option makes
.I ppict
be treated as a stencil: any part of
.I ppict
that is not transparent will be painted with the given color.  Any colors
that are associated with
.I ppict
are ignored.
.HP
.IR pict " pour ?-color " pcol "? ?-pattern " ppict "?"
.RI "?-anchor " pos "? ?-bleed " bcol "?"
.RI "?-8neighbor?" " x y"
.br
Paint is poured into the picture at the location determined by
.RI ( x , y ).
The paint flows out and fills all contiguous pixels that had the same initial
color as
.RI ( x , y ).
A pixel is contiguous to its north, south, east and west neighbors.
The paint can either be of the solid color
.I pcol
or the pattern
.IR ppict .
If a pattern is specified, it overrides any specified color.  If neither is
specified, the color defaults to black.

The
.B -anchor
option specifies which point on
.I ppict
is aligned with
.RI ( x , y ).
It is specified and interpreted as in the
.B paste
command, above.

The
.B -bleed
option causes the poured color to bleed out one pixel into the border, if
that color matches
.IR bcol .
The
.B -8neighbors
option causes paint to flow from a pixel to all eight of its neighbors,
rather than just the normal four.  This causes a more thorough fill, but is
very likely to bleed through thin diagonal lines.
.HP
.IR pict " cut " newname " x y dx dy"
.br
The portion of
.I pict
specified by
.RI ( x , y )
and
.RI ( dx , dy )
is extracted and used to create a new pict, which is given the name
.IR newname .
If any part of the specified rectangle falls outside of
.IR pict ,
an error is returned.

.RI ( x , y )
determines one corner of the rectangle.  If
.I x
is negative, it specifies the distance from the right edge.  If
.I y
is negative, it specifies the distance from the bottom edge.
.RI ( dx , dy )
must both be positive, and determine the size of the rectangle extracted.
The distance is always counted moving away from the reference edge.
That is, the command "pict cut newpict 5 -5 10 10"
will cut a 10x10 pixel square out of
.IR pict .
The lower-left corner of the extracted square will be 5 pixels away from the
lower-left corner of
.IR pict.
.HP
.IR pict " crop"
Remove all borders of the pict that consist entirely of the same color.  
If the pict has a transparency color, that color is cropped away.
Otherwise, the color to remove is determined automatically, as follows.
The four corner pixels are examined.  If they
are all the same color, that color is used.  Otherwise, the pict is
not changed.

.SH Temporary Picts
Sometimes a pict will be used only once after it is created.  In this case,
it is useful to make the pict temporary.  If a pict's name begins with a '%',
it will be deleted after it is used.  The most common use for this is
with text picts, where the pict will be generated, used in a
.B paste
operation, and then discarded.  By default, text picts' names begin
with a '%'.
.PP
Operations on a pict that modify that pict in place do
not delete it.  The
.BR paste " and " crop 
are the only two such operations.
.PP
This example reads a pbm file, generates some text, pastes it into the pict,
and writes the result to a gif file:
.Ds
	pbm_new template template.pbm
	template paste [pbm_text "Here is some text"] +2 -2
	template output test.gif
.De
.PP
This example generates some red text and outputs it to a gif file:
.Ds
	[pbm_text -fg red  "Here is\\nsome more text"] output text.gif
.De
In both of these examples, the pict generated by
.B pbm_text
is automatically deleted.

.SH Author
Glenn Trewitt, Digital Equipment Corporation, Network Systems Laboratory
.br
Ramsey Haddad, Digital Equipment Corporation, Western Research Laboratory
.br
The PBM package, which this software is derived from, is
.PP
Copyright (C) 1991 by Jeff Poskanzer
.PP
Permission to use, copy, modify, and distribute this software and its
documentation for any purpose and without fee is hereby granted, provided
that the above copyright notice appear in all copies and that both that
copyright notice and this permission notice appear in supporting
documentation.  This software is provided "as is" without express or
implied warranty.
