/*
 * Copyright (c) 1994, 1995 by Digital Equipment Corporation
 *
 * Permission to use, copy, modify, and distribute this software for any
 * purpose with or without fee is hereby granted, provided that the above
 * copyright notice and this permission notice appear in all copies, and that
 * the name of Digital Equipment Corporation not be used in advertising or
 * publicity pertaining to distribution of the document or software without
 * specific, written prior permission.
 *
 * THE SOFTWARE IS PROVIDED "AS IS" AND DIGITAL EQUIPMENT CORP. DISCLAIMS ALL
 * WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS.   IN NO EVENT SHALL DIGITAL EQUIPMENT
 * CORPORATION BE LIABLE FOR ANY SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL
 * DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR
 * PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
 * SOFTWARE.
 */

/*
 *  Tcl utility routines for doing PBM manipulations.
 *
 *	Author: Glenn Trewitt, trewitt@pa.dec.com
 *		Ramsey Haddad, haddad@pa.dec.com
 *		Digital Equipment Corporation
 *		Network Systems Laboratory
 *		Palo Alto, CA
 *
 */

static char *pbm_tcl_SccsId = "@(#)pbm_tcl.h	1.9	11/3/95";


#include <sys/types.h>
#include <tcl.h>
#include "ppm.h"


#define MODULE_NAME		"pbm"
#define PBM_VERSION		"1.3"
#define CMD_NEW			"pbm_new"
#define CMD_LIST		"pbm_list"
#define CMD_TEXT		"pbm_text"
#define CMD_FONT_LIST		"pbm_list_fonts"


/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 *
 *  Copied from Tk.h
 */

/*
 * Enumerated type for describing a point by which to anchor something:
 */
typedef enum {
    TK_ANCHOR_N, TK_ANCHOR_NE, TK_ANCHOR_E, TK_ANCHOR_SE,
    TK_ANCHOR_S, TK_ANCHOR_SW, TK_ANCHOR_W, TK_ANCHOR_NW,
    TK_ANCHOR_CENTER
} Tk_Anchor;



/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */


#define	eq(s, t)    (strcmp(s, t) == 0)
#define	eqc(s, t)    (strcasecmp(s, t) == 0)

#define Check_Alloc(value, routine)					\
	if ((value) == 0) {						\
		Tcl_ResetResult(interp);				\
		Tcl_AppendResult(interp, "malloc failure in ",		\
			(routine), (char *) NULL);			\
		goto alloc_error;					\
	}

#define StrClone(str, new, routine) {					\
	(new) = malloc(strlen(str)+1) ;					\
	if ((new) == 0) {						\
		Tcl_ResetResult(interp);				\
		Tcl_AppendResult(interp, "malloc failure in ",		\
			(routine), (char *) NULL);			\
		goto alloc_error;					\
	}								\
	strcpy((new), (str));						\
}


/*
 *  Make sure that there is a parameter following the current option.
 *  Move forward past the parameter and set <param> to point at the
 *  parameter.
 */
#define test_arg()						\
	if (argc <= 1)						\
	    goto missing_param;					\
	else {							\
	    argv++; argc--;					\
	    param = argv[0];					\
	}



/*
 *  Colors that we define.
 */
#define WHITE	"#ffffff"
#define BLACK	"#000000"


/*
 *  Options for reading and writing files.
 */
#define FILETYPE_GIF	1
#define FILETYPE_PPM	2

/*
 *  Structure used for "pour" operation.
 */
typedef struct {
    short x;
    short y;
} queue_element;
/*
 *  Structure for a single "pict", our unit of computation.
 */
typedef struct {
	char	*pp_name;		/*  Name of the pict		*/
	int	pp_x, pp_y;		/*  Width, height		*/
	pixel	**pp_bits;		/*  The actual pixels, a 2d array    */
	pixval	pp_max_val;		/*  Maximum PPM color value	*/
	pixel	pp_trans_color;		/*  color representing "transparent" */
	int	pp_is_transparent:1;	/*  Is transparency enabled	*/
	int	n_pours;		/*  Number of pours performed so far */
	/* When one pour is performed, these two structures are alloc'ed.
	 * We reuse them for subsequent pours, to cut down on alloc/free's.
         */
	queue_element	*queue;		/*  queue of pixels to paint */
	int	*touched;		/*  when was this pixel last poured to*/
} pbm_pict;

/*
 *  Picts matching this are deleted after one use.
 */
#define PBM_PICT_IS_TEMP(p) ((p)->pp_name[0] == '%')



/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 *
 *	External declarations.
 */


/*
 *  pbm_tcl.c -- main routine.
 */
extern void	Pbm_PictDelete(pbm_pict *p);
extern int	Pbm_PictCommand(pbm_pict *p, Tcl_Interp *interp, int argc, char *argv[]);


/*
 *  pbm_util.c -- utilities
 */
int Pbm_PictCreate1(Tcl_Interp *interp, char *name, int dx, int dy, pbm_pict **p);
int Pbm_FindBackground(pbm_pict *p, pixel *color);
int Tk_GetAnchor(Tcl_Interp *interp, char *string, Tk_Anchor *anchorPtr);


/*
 *  pbm_interface.c -- interface to PBM routines.
 */
extern int	Pbm_GetColor(Tcl_Interp *interp, char *txt, pixel *c, pixval maxval);
extern int	Pbm_AllocArray(Tcl_Interp *interp, int cols, int rows, pixel ***pixels);
extern int	Pbm_ReadImage(Tcl_Interp *interp, char *filename, pbm_pict *p);
extern int	Pbm_WriteImage(Tcl_Interp *interp, char *filename, pbm_pict *p, int format, int interlace);


/*
 *  Interface routines declared in the PBM-derived source files.
 */

void	tcl_ReadGIF(FILE *f, int *dx, int *dy, pixel ***bits, pixel *trans_color, int *is_trans);
void	tcl_WriteGIF(FILE *f, int dx, int dy, pixel **bits, pixval maxval, pixel trans_color, int is_trans, int interlace);
void	tcl_ReadPNM(FILE *f, int *dx, int *dy, pixel ***bits, pixval *maxval);
void	tcl_WritePNM(FILE *f, int dx, int dy, pixel **bits, pixval maxval);
