#! ./tcl_pbm

#  Compare the two files named $f1 and good/$f1 and print an appropriate
#  message.  If they're identical, remove $f1.
proc compare {f1} {
	if {[catch "exec cmp -s $f1 good/$f1" junk]} {
		puts "*** failed ***"
	} else {
		puts "OK"
		exec rm $f1
	}
	flush stdout
}

proc out-test {n} {
	$n output $n.ppm
	compare $n.ppm
}


# GIF operations
puts "GIF operations..."
puts -nonewline "\tGIF: read/write "
pbm_new testpat testfiles/testpat.gif
testpat output testpat.gif
compare testpat.gif

puts -nonewline "\tGIF: read/write with transparency "
pbm_new testpat2 testfiles/testpat-trans.gif
testpat2 output testpat-trans.gif
compare testpat-trans.gif


# PICT operations
puts "PICT operations..."
puts -nonewline "\tPICT: duplicate, crop "
testpat duplicate %dup-crop
%dup-crop crop
%dup-crop output dup-crop.ppm
compare dup-crop.ppm

pbm_text -name image -margin 100 "test image"
pbm_new xhair testfiles/xhair.gif
puts -nonewline "\tPICT: paste "
image paste xhair +2 +2
image paste xhair -stencil blue -2 +2
image paste xhair -stencil magenta -2 -2
image paste xhair -stencil cyan +2 -2
image paste xhair -stencil black -anchor center +100 +100
image paste xhair -stencil black -anchor center -100 -100
image output paste.ppm
compare paste.ppm

puts -nonewline "\tPICT: cut "
image cut cut +60 -60 120 80
out-test cut

#  Font operations
puts "Font/text operations... "

puts -nonewline "\tBuilt-in BDF font "
pbm_text -name fixed -font fixed "built in font\n\tfixed"
out-test fixed

puts -nonewline "\tBuilt-in fixed font "
pbm_text -name bdf -font bdf "built in font\n\tbdf"
out-test bdf

puts -nonewline "\tBDF font file "
pbm_text -name bdf2 -font testfiles/helvBO14.bdf "BDF font\n\thelvBO14.bdf"
out-test bdf2

puts -nonewline "\tPBM font file "
pbm_text -name pbm -font testfiles/font.pbm "PBM font/n/font.pbm"
out-test pbm

puts -nonewline "\tforeground/background "
pbm_text -name rg -fg red -bg green "Test of text foreground/background"
out-test rg

puts -nonewline "\tmargins "
pbm_text -name margin -margin 10 "Test of text margins"
out-test margin

#  Delete a couple of picts, then compare the list of picts.
margin delete
cut delete
puts -nonewline "\nCheck PICT attributes "
exec sort <<[pbm_list]\n >pbm.list
compare pbm.list
