.\" Copyright (c) 1993-1995 by Digital Equipment Corporation
.\"
.\" Permission to use, copy, modify, and distribute this software for any
.\" purpose with or without fee is hereby granted, provided that the above
.\" copyright notice and this permission notice appear in all copies, and that
.\" the name of Digital Equipment Corporation not be used in advertising or
.\" publicity pertaining to distribution of the document or software without
.\" specific, written prior permission.
.\"
.\" THE SOFTWARE IS PROVIDED "AS IS" AND DIGITAL EQUIPMENT CORP. DISCLAIMS ALL
.\" WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES
.\" OF MERCHANTABILITY AND FITNESS.   IN NO EVENT SHALL DIGITAL EQUIPMENT
.\" CORPORATION BE LIABLE FOR ANY SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL
.\" DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR
.\" PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
.\" ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
.\" SOFTWARE.
.\"
.\" SCCSID: @(#)sql.n	2.2	9/18/95
.TH sql n Tcl Tcl "Tcl Extensions"
.SH Name
sql \- SQL access routine for Tcl
.SH Syntax
.BI sql_opendb " session-handle db-spec"
.RI "?" db-spec... ?
.br
.B sql_list
.br
.B sql_which
.PP
.IB session " open"
.RB "?" -update "?"
.I cursor-handle select-stmt
.br
.IB session " exec " sql-command
.br
.IB session " commit"
.br
.IB session " rollback"
.br
.IB session " version"
.br
.IB session " closedb"
.PP
.I cursor
.br
\fIcursor \fBupdate \fR"\fItable \fRSET \fIcol\fR=\fIexpr\fR, \fIcol\fR=\fIexpr\fR..."
.br
.IB cursor " delete " table
.br
.IB cursor " close"
.br
.IB cursor " reopen"
.br
.IB cursor " names"
.br
.IB cursor " widths"
.br
.IB cursor " types"
.br
.IB cursor " count"
.PP
.SH Description
This Tcl extension provides a direct interface to SQL databases.
Currently, this package supports Informix, Ingres, and Oracle's Rdb product.
.PP
There are three top-level commands:
.br
.TP
.BI sql_opendb " session-handle db-spec" " \fR?\fIdb-spec...\fR?\fI"
creates a new session, with the named databases accessible through it.
If the creation is successful, a Tcl procedure named
.I session-handle
is created, which is used to apply commands to the session.  The
.I session-handle
string is returned.
The format of
.I db-spec
is dependent upon the underlying database system.  It may just be a name, or
it may include additional information such as user names and passwords.
If the underlying database system supports it, more than one database can be
opened in the session, in which case SQL
commands can access data in these databases simultaneously.  
.TP
.B sql_which
Returns a two-element list, identifying the underlying database (Ingres,
Rdb, \fIetc.\fR), and the version of the Tcl interface.
.TP
.B sql_list
Lists all of the open sessions.
.PP
Multiple sessions may be open at once, if the underlying database system
supports it.  Sessions are completely independent of each other.  Each has
its own transaction state, and SQL commands refer only to the data in the
database(s) open in that session.  If two sessions have the same database
open to access the same data, it is very easy to create deadlock.
.PP
Within a session, all SQL operations are available.    Note that database
systems vary considerably in the amount of system-level commands (database
creation and deletion, for example) that are available through SQL.
The
.I session-handle
is used to refer to a session.  It is a Tcl command, with subcommands that
actually operate on the open database(s).  The next section describes these
commands.
.SH "Session Commands"
.TP
.IB session " closedb"
Close the session.  Deleting the Tcl session procedure has the same effect.
Any outstanding transactions are rolled back.
If an error occurs while closing the session, the error will be returned, but
the session proc will already have been deleted.  The underlying database
system may or may not still have the database open, depending upon the error.
.TP
.IB session " exec " sql-command
Execute an SQL command.  The number of rows that were affected is returned.
If no rows were affected, zero is returned (no error is generated).  This
command cannot be used to execute any command that returns data, such as
select.  It must not be used to execute the
.BR commit " or " rollback
SQL commands, which would lead to inconsistent state between the Tcl cursor
commands and open SQL cursors.  (Use the
.BR "commit" " and " "rollback"
session commands, instead.)
.TP
.IR "session \fBopen\fR" " ?" \fB-update\fR "? " "cursor-handle select-stmt"
Open a cursor for the given SQL
.I select-stmt.
If the cursor creation is successful, a Tcl procedure named
.I cursor-handle
is created, which is used to read rows from the result.  The cursor name is
returned.  Up to 16 cursors may be open at once.
By default, cursors are opened read-only.  Specify the
.B -update
option to enable updating of the data.
.TP
.IB session " commit"
Commit the transaction in progress.  All cursors are closed.
.TP
.IB session " rollback"
Abort the transaction in progress.  All cursors are closed.
.TP
.IB session " version"
Determine the version of the database that this session is connected to.
The result is a two-element list, consisting of the name of the database
system and the version (format specific to the database system.)
.SH "Cursor Subcommands"
Once a cursor has been opened, the cursor procedure may be invoked to
retrieve data.  Cursor subcommands may be used to obtain information about
the cursor and the data it returns.
.PP
SQL has specialized data types for representing dates and money.  These are
returned in Tcl as character strings and floating-point numbers.
.PP
It is important to remember that the
.BR commit " and " rollback
commands close all open cursors, deleting the cusor procedure(s).
If an SQL error occurs while processing the cursor procedure, the SQL error
is returned and the cursor is closed.  It is up to the user, however, to
call
.BR rollback " or " commit 
to terminate the transaction.
.TP
.I cursor
Return the next row in the result as a properly formatted Tcl list.
After the last row, an empty string is returned.  However, the cursor must
still be closed.
.TP
\fIcursor \fBupdate \fR"\fItable \fRSET \fIcol\fR=\fIexpr\fR, \fIcol\fR=\fIexpr\fR..."
Updates the current row (that the cursor just returned) in the specified
.IR table ,
setting the columns to the values given.  Note that the entire update
statement (from
.I table
on) must be a single argument.  This is just shorthand for
executing the SQL command:
.br
UPDATE 
.IB table
SET
.IR "col=expr, col=expr..." " WHERE CURRENT OF " cursor
.TP
.IB cursor " delete " table
Deletes the current row (that the cursor just returned) in the specified
.IR table .
This is just shorthand for executing the SQL command:
.br
DELETE FROM 
.IR table " WHERE CURRENT OF " cursor
.TP
.IB cursor " close"
Close the cursor.  Deleting the Tcl cursor procedure has the same effect.
.TP
.IB cursor " reopen"
Close and reopen the cursor.  The rows in the cursor will be read again,
starting at the beginning.
.TP
.IB cursor " names"
Returns a list of the SQL column names for the cursor.
.TP
.IB cursor " widths"
Returns a list of column widths appropriate for formatting the cursor result.
.TP
.IB cursor " types"
Returns a list of column types.  The types that may be returned are:
.BI {integer " NN" }
(1, 2, 4, 8); 
.BI {integer " NN SS" }
NN=(1, 2, 4, 8), SS=decimal scaling; 
.BI {float " NN" }
(4, 8);
.BI {char " NN" }
and
.BI {varchar " NN" }
where
.I NN
is the number of characters in the field.  Each type is a two-element list
consisting of the base type and the number of bytes used to represent it.
The data type returned is the
converted type.  Because this package automatically converts date and money
types to char and float, those types will never be returned.
.TP
.IB cursor " count"
Returns the number of rows retrieved from the cursor, so far.

.SH "SQL Errors"
All SQL errors are returned to the user as Tcl errors, with the text of the
SQL error message forming the Tcl error message.  The Tcl error code is set
to a three-element list consisting of the string
.BR sql ,
the SQL error number, and the sql error message.
.PP
Some massaging is done to
the error message, to strip off timestamps and extra newlines.
.PP
When an SQL error occurs, the transaction is still pending.  It is up to the
user to commit or roll back the transaction.  The usual action after an error
is to roll back the transaction and return the error to higher layers.

.SH "Transactions (Commit and Rollback)"
In ANSI SQL, transactions are always enabled.  COMMIT
must be used to confirm the operations in a transaction and make them "real".
Alternatively, ROLLBACK can be used to cancel all outstanding operations.
.PP
Some databases allow modes where transactions are only used when you ask for
them.  The BEGIN WORK command marks the beginning of a transaction, and
COMMIT/ROLLBACK applies only to the operations since the BEGIN WORK command.
Operations performed outside of a transaction happen immediately.
.PP
Some databases do not use transactions at all.  In those environments, the
COMMIT and ROLLBACK commands do not work, and will produce an error.

.SH Restrictions
Binary Large Objects (BLOBs) are not supported.
.PP
Null values in the database are rendered as the empty string for character
data types, "0" for integer data types, and "0.0" for floating point data
types.
.PP
Up to 16 cursors may be open at once.  (Some SQL installations
may have a lower limit.)
.PP
A cursor is limited to 128 result columns.

.SH "Ingres Notes"
All ingres data types as of Release 6.4 are supported.
.PP
Ingres does not support creation and deletion of databases through SQL.
Use the shell programs
.BR createdb " and " destroydb .
.PP
Ingres always uses transactions.  The BEGIN WORK command doesn't even exist.

.SH "Rdb Notes"
.PP
The syntax for
.B sql_opendb
can be quite complex.  The simple form associates a single database
with the session:
.TP
.BI sql_opendb " handle db-spec"
.I db-spec
is an usually an "attach-expression", which is usually
"\fBfilename \fIattach-spec\fR".
In the simplest case, \fIattach-spec\fR is just the name of a local file
containing a database.  For more details, see Rdb's syntax for the ATTACH
command.
.TP
.BI sql_opendb " handle " DEFAULT
will open a connection to the database server with no
database attached.  This allows you to create a database without having one
to connect to:
.EX 5
sql_opendb h default
h exec "create database filename /usr/tmp/test.rdb"
h closedb
sql_opendb h "filename /usr/tmp/test.rdb"
.EE
.PP
The more complex form allows multiple databases to be accessable within a
single session.  Remember that you can still have multiple sessions.
.TP
\fBsql_opendb \fIhandle \fR{\fIalias db-spec\fR} {\fIalias db-spec\fR}...
.I db-spec
is as it was in the simple case -- each specifies a database to open.  The
.I alias
is used to identify the database when working with the session.  For
example, a select statement might look like:
"SELECT col1, col2 from \fIalias\fR.table1".
.PP
Rdb always uses transactions.  The BEGIN WORK command doesn't even exist.
.PP
Rdb's integer types support decimal scaling.  This is rendered with full
precision (including trailing zeros) on output.
.PP
Rdb's DECIMAL data type is not supported.
.PP
Rdb's DATE type is rendered as a character string, which results in an
8-character all-numeric string of the form "YYYYMMDD".
.PP
The SQL data types SEGMENTED STRING and VARBYTE are not supported.  Both of
these are BLOBs.
.PP
DATETIME and INTERVAL are not also not supported, due to lack of access to
documentation.
.PP
The
.B version
command doesn't return a useful version number, due to lack of access to
documentation.

.SH "Informix Notes"
In order to use the SQL package, the INFORMIXDIR environment variable must
be set.  Attempts to use
.B sql_opendb
will fail with an appropriate error message.  You can set INFORMIXDIR at the
beginning of your script with the command "set env(INFORMIXDIR)
/usr/local/informix".
.PP
Informix's
.I db-spec
is usually either
.IR db-name " or " db-name @ db-server .
You can connect to a server, with no associated database, using the syntax
.RI @ db-server .
This allows you to create a database without having one
to connect to.  In fact, it appears that the CREATE DATABASE command can
.B only
be used when connected to a server only, without a connection to an
explicit database.
.PP
With Informix,
.B sql_opendb
supports a user authentication option.
.TP
\fBsql_opendb\fR ?\fB-user \fIuser password\fR? \fIsession-handle db-spec\fR
.IR user " and " password
specify the user name and password to use to connect to the database.
.PP
Informix (as of 7.10) doesn't support multiple connections to a server when
shared memory is used as the transport.  Informix will return an error if a
second connection is attempted to the same server.
.PP
Database connections are opened with the WITH CONCURRENT TRANSACTION option.
As mentioned above, this means that it is possible to create deadlocks when
switching between connections to the same database.
.PP
Informix's dynamic SQL syntax is not capable of declaring a cursor FOR
UPDATE or FOR READONLY.
Non-ANSI databases' cursors are read-only by default and ANSI
databases' cursors are updatable by default, if they meet certain criteria.
Because of this, the
.B -update
option to the
.B open
command has no actual effect, and a cursor is updatable soley based upon
whether the database is ANSI or not.  If
.B -update
is used on a non-ANSI database, an error will be returned.
.PP
By default, Informix databases doesn't use transactions.  Databases created
with default options do not support transactions.  Specifying WITH LOG or
WITH LOG MODE ANSI in the CREATE DATABASE command will enable logging for
that database.  When using the Informix SE server, the START DATABASE
command can be used change the logging mode on an existing database.
.PP
To cope with these irregularities, two additional session commands,
.BR is_ansi " and " has_log ,
are provided, which return 1 if the database has that characteristic and 0
if not.
.PP
At initialization, $env(DBDATE) is set in Tcl's environment to force the
formate for DATE data to be "YYYY-MM-DD" (numeric).
.PP
DATETIME uses the same format:  "YYYY-MM-DD HH:MM:SS.FFFFF",
except that only the parts appropriate to the specific data type are
included, and any leading extended field is widened.
.IR e.g. ,
DATETIME MONTH(3) TO MINUTE would be rendered as "MMM-DD HH:MM".
.PP
INTERVAL uses the same format as DATETIME, except that Informix supresses
leading zero fields with spaces.
.PP
The SQL data types BYTES and TEXT are not supported.  (Both of these are
BLOBs).

.SH Installation
This distribution consists of a primary source and header files,
tcl_sql.sc.in and tcl_sql.h, and an additional source and header file for
each supported database system.  The embedded SQL files must be run through
an Embedded SQL preprocessor (specific to the DB system).  The Makefile is
generated by the
.B configure
script, and will contain the correct commands for database-specific
processing.
.PP
The extension must be initialized by calling
.RI Sql_Init( interp ).
Typically, this call will be made within the Tcl_AppInit() routine.
Besides linking in the
.RI libtcl_sql_ dbtype .a
library, all of the libraries required by the SQL database system must also
be linked in.
.PP
See the
.B README
file for full details.

.SH Author
Glenn Trewitt, Digital Equipment Corporation, Network Systems Laboratory
