/*
 * Copyright (c) 1995 by Digital Equipment Corporation
 *
 * Permission to use, copy, modify, and distribute this software for any
 * purpose with or without fee is hereby granted, provided that the above
 * copyright notice and this permission notice appear in all copies, and that
 * the name of Digital Equipment Corporation not be used in advertising or
 * publicity pertaining to distribution of the document or software without
 * specific, written prior permission.
 *
 * THE SOFTWARE IS PROVIDED "AS IS" AND DIGITAL EQUIPMENT CORP. DISCLAIMS ALL
 * WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS.   IN NO EVENT SHALL DIGITAL EQUIPMENT
 * CORPORATION BE LIABLE FOR ANY SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL
 * DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR
 * PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
 * SOFTWARE.
 */

/*
 *  SQL constants and localizations for Dec/Oracle Rdb.
 *
 *	Author: Glenn Trewitt, trewitt@pa.dec.com
 *		Digital Equipment Corporation
 *		Network Systems Laboratory
 *		Palo Alto, CA
 *
 */

static char *SccsId_Sql_Ingres = "@(#)sql_ingres.h	2.1\t3/28/95";

/*  DB name reported by "version" subcommand.  */
#define DB_NAME	"ingres"

/*  Usage string for "sql_dbopen" command.  */
#define SQL_OPENDB_USAGE " handle db-spec"

/*  If defined, this database can't do update cursors.  */
/*#define SQL_NO_UPDATE_CURSORS*/

/*
 *  After expansion through the ESQL preprocessor, this module should define
 *  the following things:
 *	MAXCOLUMNS	    max number of columns for select: 128
 *
 *  SQL Data Area, with all names in lower case:
 *	struct sqlda_	structure for the SQLDA with MAXCOLUMNS elements
 *	struct sqlvar_	structure for one SQLDA variable
 *
 *  And the following definitions:
 *	_sqlname	column name
 *	_sqlname_len	column name length
 *	_sqlname_maxlen	maximum name length, plus one (or more)
 *  If _sqlname_len is not defined, it is assumed that the column name will
 *  be properly null-terminated.
 *
 *  Definitions for stuff we use from sqlca:
 *	_SQL_ERROR_CODE		sqlca.sqlcode
 *	_SQL_ROW_COUNT		# rows affected by last command
 */

/*
 *	SQLCA definitions.
 */

/*  Members from SQLCA.  */
#define _SQL_ERROR_CODE		sqlca.sqlcode
#define _SQL_ROW_COUNT		sqlca.sqlerrd[2]

/*
 *	SQLDA definitions.
 */

/*
 *  If defined, the sqlda field in cursor structure is a pointer, rather
 *  than the actual structure.  In this case, the SQL DESCRIBE command
 *  allocates the sqlda and all of its constituent elements.
 */
/*#define SQLDA_IS_POINTER*/

/*
 *  Define this if sqlda.sqlvar[i].sqllen for fixed (non-varying) character
 *  type needs to be told about space for the null byte.
 */
/*#define SQLDA_FIXED_CHAR_WANTS_NULL*/

/*  Value in sqlda.sqlvar[i].sqlind that indicates NULL data.  */
#define SQLDA_VAR_IS_NULL -1

typedef IISQLDA_TYPE(sqlda_,sqlda,MAXCOLUMNS);

#define _sqlname	sqlname.sqlnamec
#define _sqlname_len	sqlname.sqlnamel
#define _sqlname_maxlen	40

/*
 *  Defines for standard conversions.
 */

/*  Macros to get the actual size and scale of integer data types.  */
#define SQL_INT_LEN(var)	((var)->sqllen)

/*  If this is defined, the database implements scaled integers.  */
/*#define SQL_INT_SCALE(var)	((var)->sqllen / 256)*/

/*
 *  These are the types to set sqltype to to get the desired effect.
 *  These types are the only ones that we will have in the sqlda after
 *  it is interpreted.
 *	NULL_TERM_STR	varying string, returned with terminating null byte,
 *			not space-padded, by the DB
 *	FIXED_STR	fixed-length string, returned as-is
 *			(probably space-padded) by the DB
 *	FLOAT_GENERIC	floating point, size determined by sqllen
 *	FLOAT8		floating point, 8 bytes
 *	FLOAT4		floating point, 4 bytes
 *	INT_GENERIC	integer, size determined by sqllen
 *	INT8		integer, 8 bytes
 *	INT4		integer, 4 bytes
 *	INT2		integer, 2 bytes
 *	INT1		integer, 1 byte
 */
#define _SQL_NULL_TERM_STR	IISQ_CHA_TYPE
#define _SQL_FLOAT_GENERIC	IISQ_FLT_TYPE
#define _SQL_INT_GENERIC	IISQ_INT_TYPE
/*
 *  These types (that we support) are not defined by ingres:
 *	_SQL_FIXED_STR
 *	_SQL_INT8		
 *	_SQL_INT4
 *	_SQL_INT2
 *	_SQL_INT1
 *	_SQL_FLOAT8
 *	_SQL_FLOAT4
 */

/*
 *  These types are converted to one of the above types by the code in 
 *  sql_ingres.sc.
 *	IISQ_DTE_TYPE
 *	IISQ_MNY_TYPE
 *	IISQ_DEC_TYPE
 *	IISQ_CHA_TYPE	This is character with 2-byte length prepended
 */
#define _SQL_DATE_LEN	IISQ_DTE_LEN
