/*
 * Copyright (c) 1993-1995 by Digital Equipment Corporation
 *
 * Permission to use, copy, modify, and distribute this software for any
 * purpose with or without fee is hereby granted, provided that the above
 * copyright notice and this permission notice appear in all copies, and that
 * the name of Digital Equipment Corporation not be used in advertising or
 * publicity pertaining to distribution of the document or software without
 * specific, written prior permission.
 *
 * THE SOFTWARE IS PROVIDED "AS IS" AND DIGITAL EQUIPMENT CORP. DISCLAIMS ALL
 * WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS.   IN NO EVENT SHALL DIGITAL EQUIPMENT
 * CORPORATION BE LIABLE FOR ANY SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL
 * DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR
 * PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
 * SOFTWARE.
 */

/*
 *  SQL access module for Tcl.
 *
 *	Author: Glenn Trewitt, trewitt@pa.dec.com
 *		Digital Equipment Corporation
 *		Network Systems Laboratory
 *		Palo Alto, CA
 *
 */

static char *SccsId_Sql = "@(#)tcl_sql.h	2.3\t9/15/95";

#define MODULE_NAME	"SQL"
#define SQL_VERSION	"2.3"
#define CMD_OPENDB	"sql_opendb"
#define CMD_LIST	"sql_list"
#define CMD_WHICH	"sql_which"

/*
 *  We'll allow up to 16 cursors open per database, with up to 128 result
 *  columns in each.  This is a lot.
 */
#define MAXCURSORS 16
#define MAXCOLUMNS 128

#ifdef SQLDB_RDB
#include "sql_rdb.h"
#endif
#ifdef SQLDB_INGRES
#include "sql_ingres.h"
#endif
#ifdef SQLDB_INFORMIX
#include "sql_informix.h"
#endif

/*
 *  For keeping track of open cursors.
 */
struct cursor {
	int		state;
	int		count;
	char		update;		/*  If cursor opened for update  */
	char		*buffer;
	char		*cname;		/*  User's name for cursor  */
	char		sname[23];	/*  Stmt name, generated  */
#ifdef SQLDA_IS_POINTER
	struct sqlda_	*pda;
#define SQLDA_PTR(cur) ((cur)->pda)
#else
	struct sqlda_	da;
#define SQLDA_PTR(cur) (&(cur)->da)
#endif
	};

#define CUR_STATE_CLOSED	0
#define CUR_STATE_OPEN		1


/*
 *  For keeping track of open databases.
 */
typedef struct {
	char		*handle;
	char		*dbname;
	Tcl_Interp	*interp;	/*  Interp that owns the session. */
	int		session_id;	/*  SQL session ID		*/
#ifdef SQLDB_INFORMIX
	char		ansi_db;	/*  Is database ANSI compliant?	*/
	char		has_log;	/*  Are transactions supported? */
#endif
	struct cursor	cursors[MAXCURSORS];
} session;


extern session	*sql_current_session;
extern int	sql_single_session;
extern int	sql_debugmask;


#define	eq(s, t)    (strcmp(s, t) == 0)

#define	eqc(s, t)    (strcasecmp(s, t) == 0)

#define CheckAlloc(value, routine)					\
	if ((value) == 0) {						\
		Tcl_ResetResult(interp);				\
		Tcl_AppendResult(interp, "malloc failure in ",		\
			(routine), (char *) NULL);			\
		goto alloc_error;					\
	}

#define StrClone(str, new, routine) {					\
	(new) = (char *) malloc(strlen(str)+1) ;			\
	if ((new) == 0) {						\
		Tcl_ResetResult(interp);				\
		Tcl_AppendResult(interp, "malloc failure in ",		\
			(routine), (char *) NULL);			\
		goto alloc_error;					\
	}								\
	strcpy((new), (str));						\
}


extern int	Sql_X_Connect(Tcl_Interp *interp,
			session *s, int *single_session, int argc, char **argv);
extern int	Sql_X_SetConnection(Tcl_Interp *interp, session *s);
extern int	Sql_X_Disconnect(Tcl_Interp *interp);
extern int	Sql_X_DbVersion(Tcl_Interp *interp, int argc, char **argv);
extern int	Sql_X_HandleError(Tcl_Interp *interp);

extern int	Sql_X_OpenCursor(Tcl_Interp *interp,
			struct cursor *cur, char *stmt, int update);
extern int	Sql_X_SetupDA(Tcl_Interp *interp, struct cursor *cur);
extern int	Sql_X_Widths(Tcl_Interp *interp, struct cursor *c);
extern int	Sql_X_Types(Tcl_Interp *interp, struct cursor *c);
extern int	Sql_X_RenderFetch(Tcl_Interp *interp, struct cursor *c);
extern int	Sql_X_Dump(Tcl_Interp *interp, struct cursor *c);
