#! ./tcl_sql_informix

#  Copyright (c) 1993,1995 by Digital Equipment Corporation
# 
#  Permission to use, copy, modify, and distribute this software for any
#  purpose with or without fee is hereby granted, provided that the above
#  copyright notice and this permission notice appear in all copies, and that
#  the name of Digital Equipment Corporation not be used in advertising or
#  publicity pertaining to distribution of the document or software without
#  specific, written prior permission.
# 
#  THE SOFTWARE IS PROVIDED "AS IS" AND DIGITAL EQUIPMENT CORP. DISCLAIMS ALL
#  WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES
#  OF MERCHANTABILITY AND FITNESS.   IN NO EVENT SHALL DIGITAL EQUIPMENT
#  CORPORATION BE LIABLE FOR ANY SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL
#  DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR
#  PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
#  ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
#  SOFTWARE.

#  SCCS ID	@(#)test_informix.tcl	2.1	3/28/95

catch "sql closedb"

if {$argc >= 1} {
	set dbname $argv
} else {
	puts "This example script will list all of the tables in a database."
	puts -nonewline "Database Name: "
	set dbname [gets stdin]
}
sql_opendb sql $dbname

puts "Information about Database \"$dbname\""

puts -nonewline "\tDatabase Owner:"
sql open c1 "select username from sysusers where usertype = 'D'"
while {"" != [set u [c1]]} { puts -nonewline " $u" }
c1 close
puts "\n"

set "type( )" ???
set type(T) table
set type(I) index
set type(V) view
set type(S) synonym
set type(L) log
set type(P) synonym

sql open c1 "select tabname, owner, tabtype, ncols, nrows
	from systables
	where tabid >= 100
	order by tabname"

puts [format "%-18.18s %-12.12s %-5s %5s %7s" "Table Name" Owner Type #Cols #Rows]
puts ---------------------------------------------------
while { [llength [set row [c1]]] > 0 } {
	puts [format "%-18.18s %-12.12s %-5s %5d %7d" [lindex $row 0] [lindex $row 1] $type([lindex $row 2]) [lindex $row 3] [lindex $row 4]]
}
c1 close
if {[sql has_log]} {sql rollback}
sql closedb
