#! ./tcl_sql_ingres

#  Copyright (c) 1993,1995 by Digital Equipment Corporation
# 
#  Permission to use, copy, modify, and distribute this software for any
#  purpose with or without fee is hereby granted, provided that the above
#  copyright notice and this permission notice appear in all copies, and that
#  the name of Digital Equipment Corporation not be used in advertising or
#  publicity pertaining to distribution of the document or software without
#  specific, written prior permission.
# 
#  THE SOFTWARE IS PROVIDED "AS IS" AND DIGITAL EQUIPMENT CORP. DISCLAIMS ALL
#  WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES
#  OF MERCHANTABILITY AND FITNESS.   IN NO EVENT SHALL DIGITAL EQUIPMENT
#  CORPORATION BE LIABLE FOR ANY SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL
#  DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR
#  PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
#  ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
#  SOFTWARE.

#  SCCS ID	@(#)test_ingres.tcl	2.1	3/28/95

catch "sql closedb"

if {$argc >= 1} {
	set dbname $argv
} else {
	puts "This example script will list all of the tables in a database."
	puts -nonewline "Database Name: "
	set dbname [gets stdin]
}
sql_opendb sql $dbname

puts "Information about Database \"$dbname\""

sql open c1 "select dba_name from iidbconstants"
puts "\tDatabase Owner: [lindex [c1] 0]\n"
c1 close

set type(T) table
set type(I) index
set type(V) view

sql open c1 "select t.table_name, t.table_owner, t.table_type, count(c.column_name), t.num_rows
	from iitables t, iicolumns c
	where t.table_owner != '\$ingres' and t.table_name = c.table_name
	group by t.table_name, t.table_owner, t.table_type, t.num_rows
	order by t.table_name"

puts [format "%-32.32s %-12.12s %-5s %5s %7s" "Table Name" Owner Type #Cols #Rows]
puts -----------------------------------------------------------------
while { [llength [set row [c1]]] > 0 } {
	puts [format "%-32.32s %-12.12s %-5s %5d %7d" [lindex $row 0] [lindex $row 1] $type([lindex $row 2]) [lindex $row 3] [lindex $row 4]]
}
c1 close
sql commit
sql closedb
