#! ./tcl_sql_rdb

#  Copyright (c) 1993,1995 by Digital Equipment Corporation
# 
#  Permission to use, copy, modify, and distribute this software for any
#  purpose with or without fee is hereby granted, provided that the above
#  copyright notice and this permission notice appear in all copies, and that
#  the name of Digital Equipment Corporation not be used in advertising or
#  publicity pertaining to distribution of the document or software without
#  specific, written prior permission.
# 
#  THE SOFTWARE IS PROVIDED "AS IS" AND DIGITAL EQUIPMENT CORP. DISCLAIMS ALL
#  WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES
#  OF MERCHANTABILITY AND FITNESS.   IN NO EVENT SHALL DIGITAL EQUIPMENT
#  CORPORATION BE LIABLE FOR ANY SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL
#  DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR
#  PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
#  ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
#  SOFTWARE.

#  SCCS ID	@(#)test_rdb.tcl	2.1	3/28/95

catch "sql closedb"

if {$argc >= 1} {
	set dbname $argv
} else {
	puts "This example script will list all of the tables in a database."
	puts -nonewline "Database Name (e.g., \"filename personnel.rdb\"): "
	set dbname [gets stdin]
}
sql_opendb sql $dbname

puts "Information about Database \"$dbname\""

#sql open c1 "select dba_name from iidbconstants"
#puts "\tDatabase Owner: [lindex [c1] 0]\n"
#c1 close

sql open c1 {select RDB$RELATION_NAME as name, 'table', 0, 0 \
	from RDB$RELATIONS \
	where RDB$SYSTEM_FLAG = 0 \
    union \
	select distinct v.RDB$VIEW_NAME as name, 'view', 0, 0 \
	from RDB$VIEW_RELATIONS v, RDB$RELATIONS r \
	where r.RDB$SYSTEM_FLAG = 0 and v.RDB$RELATION_NAME = r.RDB$RELATION_NAME \
    union \
	select distinct i.RDB$INDEX_NAME as name, 'index', 0, 0 \
	from RDB$INDICES i, RDB$RELATIONS r \
	where r.RDB$SYSTEM_FLAG = 0 and i.RDB$RELATION_NAME = r.RDB$RELATION_NAME \
    order by name}

puts [format "%-32.32s %-5s %5s %7s" "Table Name" Type #Cols #Rows]
puts ----------------------------------------------------
while { [llength [set row [c1]]] > 0 } {
	puts [format "%-32.32s %-5s %5d %7d" [lindex $row 0] [lindex $row 1] [lindex $row 2] [lindex $row 3]]
}
c1 close
puts "(#Rows and #Cols not implemented)"

sql commit
sql closedb
