/*
 * DE32K
 *
 *	This program is used to switch the DECpc433w DE100 Ethernet
 *	adapter between 32k and 64k mode.  Each time this program is
 *	is run, it switches to the other mode.  The default power and
 *	warm boot state of the 433w is 64k mode.  Running this program
 *	once after booting will put the adapter into 32k mode.
 *
 *	The DLLDEPCA driver correctly works with the adapter when it
 *	is in 32k mode.  The driver does not discover the adapter by
 *	itself.  The following invocation is needed (in
 *	DECNET\STARTNET.BAT).
 *
 *		DLLDEPCA /ADAPTER:DE100 /IRQ:5 /MEM:D800
 *
 *	There are other undocumented parameters to DLLDEPCA to set
 *	the number of buffers (/BUF:19 in 32k, /BUF:41 in 64k) and
 *	the I/O space address (/IO:0200).  Neither of these parameters
 *	currently does anything (i.e., DLLDEPCA ignores them).
 *
 *	This program was written using QuickC for Windows.  It is
 *	a straight DOS program and doesn't require MS Windows to run.
 */

#include <stdlib.h>
#include <stdio.h>
#include <conio.h>
#include <dos.h>

#define CFG_PORTA	0x800
#define  CFG_reset	  0x08
#define  CFG_32k	  0x04

#define NICSR		0x200
#define  NICSR_ien	  0x02
#define  NICSR_32k	  0x20

main ( int argc, char ** argv )
{
	int cfg_porta;
/*
 * Read and print the initial state of the configuration port.
 */
	cfg_porta = _inp ( CFG_PORTA );
	if ( cfg_porta & CFG_32k )
		printf ( "DE32k: DE100 started in 32k mode.. " );
	else
		printf ( "DE32k: DE100 started in 64k mode.. " );
/*
 * Complement the 32kb mode bit in the configuration port.
 */
	cfg_porta = (cfg_porta & ~CFG_32k) | (cfg_porta ^ CFG_32k);
	_outp ( CFG_PORTA, cfg_porta );
/*
 * Pulse the reset (1 -> 0 -> 1).
 */
	_outp ( CFG_PORTA, _inp ( CFG_PORTA ) & ~CFG_reset );
	_outp ( CFG_PORTA, _inp ( CFG_PORTA ) | CFG_reset);
/*
 * Reenable LANCE interrupts
 */
	_outp ( NICSR, _inp ( NICSR ) | NICSR_ien );
/*
 * Display the final mode of the adapter
 */
	if ( _inp ( NICSR ) & NICSR_32k )
		printf ( " ending in 32k mode\n" );
	else
		printf ( " ending in 64k mode\n" );

	exit ( 0 );
}
