/*
 *  Program:    LATCOM
 *  Module:     COMTST.C
 *  Author:     Chris Lord
 *
 *  Description
 *
 *  Simple little hack to test comm port support using DOS file I/O.  All
 *  we do is open a comm port, write any data from it to the console and
 *  send anything from the console to the comm port.  Escape sequences
 *  from the remote will of course mess us up a little, but that ain't
 *  the point of this thing anyway.
 *
 *  Copyright (C) 1991-1992 by Digital Equipment Corporation.
 *  All Rights Reserved.
 *  
 */

#include <stdio.h>
#include <stdlib.h>
#include <io.h>
#include <fcntl.h>
#include <conio.h>

void main( int argc, char *argv[] )
{
    int fh, len, ch;
    char buf[65];

    if ( argc != 2 ) {
        printf("Usage: COMTST COMn\n");
        exit(1);
        }

    /*
     *  Open the comm port as a file.  We probably should check the
     *  name to ensure it is really a comm device name, but that is
     *  left as an exercise for the user.  This is the way comm ports
     *  should be used.
     */

    if ( (fh = open(argv[1], O_RDWR|O_TEXT)) == -1 ) {
        printf("Error: Could not open comm port\n");
        exit(1);
        }

    printf("Hit <ESC> to exit.\n");

    /*
     *  This is it.  God, how much simpler can you get.  All you have to
     *  do is add you ANSI escape sequence processor in here (hee hee).
     */

    for ( ;; ) {
        while ( (len = read(fh,buf,64)) > 0 )
            write(1,buf,len);
        if ( kbhit() ) {
            ch = getch();
            if ( ch == 27 )
                break;
            buf[0] = (char)ch;
            write(fh,buf,1);
            }
        }

    /*
     *  Closing the comm port does *not* cause the port to disconnect.
     *  It will remain exactly as is until you access it again either
     *  through DOS or the BIOS.
     */

    close(fh);
    putchar('\n');
    exit(0);
}
