import webTemip.client.description.*;
import java.util.*;

public class ClarifyLiaisonDB_Component_10 extends FSComponent {

  public ClarifyLiaisonDB_Component_10() {
    super();
    setName("TeMIP Clarify Liaison FM Component ");
    setDescription("TT Liaison FM subset");

    addCommand("Command_0");
    addCommand("Command_1");
    addCommand("Command_2");
    addCommand("Command_3");
  }

  public ClarifyLiaisonDB_Component_10(boolean simple) {
    super(simple);
    setName("TeMIP Clarify Liaison FM Component ");
    setDescription("TT Liaison FM subset");
    addCommand("Command_0");
    addCommand("Command_1");
    addCommand("Command_2");
    addCommand("Command_3");
  }

  public class Command_0 extends FSCommand {
    public Command_0() {
      setName("Install");
      setDescription("Install the TT Liaison FM");
      setAppliName("TeMIP_TTL_Install");
      addArgument(new FSParameter("TeMIP Clarify Liaison FM kit location (UNIX)","String","Your Root Path/TeMIP-V400-UNIX/TeMIP-CLARIFY-LIAISON/KIT","The location of the TeMIP Clarify Liaison kit", true ));
    }
  }
  public class Command_1 extends FSCommand {
    public Command_1() {
      setName("Uninstall");
      setDescription("Uninstall the TeMIP Clarify Liaison FM");
      setAppliName("TeMIP_TTL_Uninstall");
    }
  }
  public class Command_2 extends FSCommand {
    public Command_2() {
      setName("Configure");
      setDescription("Create the single global entity: TTS TTS_name");
      setAppliName("TeMIP_TTL_Configure");
      addArgument(new FSParameter("Create flag","String","-C","Flag to create the global instance TTS", false ));
      addArgument(new FSParameter("TTS name","String","","Name of the TTS instance", true ));
      addArgument(new FSParameter("Hostname of the Clarify Server","String","","Hostname of the NT workstation where the TeMIP Clarify Liaison server will run.", true ));
    }
  }
  public class Command_3 extends FSCommand {
    public Command_3() {
      setName("Unconfigure");
      setDescription("Delete the global instance TTS TTS_name");
      setAppliName("TeMIP_TTL_Configure");
      addArgument(new FSParameter("Delete flag","String","-D","Delete flag to delete the global instance TTS", false ));
      addArgument(new FSParameter("TTS name","String","","Name of the TTS instance", true ));
    }
  }
}

