import webTemip.client.description.*;
import java.util.*;

public class ClarifyLiaisonDB_Component_11 extends FSComponent {

  public ClarifyLiaisonDB_Component_11() {
    super();
    setName("TeMIP Clarify database Component");
    setDescription("The TeMIP Clarify Liaison database Component allows the customization of the Oracle database for Clarify and the TeMIP Clarify Liaison. ");

    addCommand("Command_0");
    addCommand("Command_1");
    addCommand("Command_2");
    addCommand("Command_3");
  }

  public ClarifyLiaisonDB_Component_11(boolean simple) {
    super(simple);
    setName("TeMIP Clarify database Component");
    setDescription("The TeMIP Clarify Liaison database Component allows the customization of the Oracle database for Clarify and the TeMIP Clarify Liaison. ");
    addCommand("Command_0");
    addCommand("Command_1");
    addCommand("Command_2");
    addCommand("Command_3");
  }

  public class Command_0 extends FSCommand {
    public Command_0() {
      setName("Database Import");
      setDescription("This directive imports the Clarify and the TeMIP Clarify Liaison customization into the Oracle database. ");
      setAppliName("TeMIP_TTL_ImportDatabase");
      addArgument(new FSParameter("Name of the Oracle Administrator","String","oracle","The name of the Oracle Administrator \n(usually oracle)", true ));
      addArgument(new FSParameter("Clarify Database Name","String","","", true ));
      addArgument(new FSParameter("Import File","String","","Import File : /path/filename", true ));
      addArgument(new FSParameter("Oracle Server path","String","/usr/kits/oracle/u01/product/8.0","The location of the Oracle installation\n(often ORACLE_USER home directory \n or /usr/kits/oracle/u10/product/8.0)", true ));
    }
  }
  public class Command_1 extends FSCommand {
    public Command_1() {
      setName("Prepare Creation");
      setDescription("");
      setAppliName("TeMIP_TTL_PrepareCreate");
    }
  }
  public class Command_2 extends FSCommand {
    public Command_2() {
      setName("Dump File Warning");
      setDescription("");
      setAppliName("TeMIP_TTL_CheckDump");
      addArgument(new FSParameter("Import file","String","","Database dmp file : /path/filename", true ));
    }
  }
  public class Command_3 extends FSCommand {
    public Command_3() {
      setName("Validate Import");
      setDescription("");
      setAppliName("TeMIP_TTL_ValidateImport");
      addArgument(new FSParameter("DB name","String","clarify","The name of the Clarify DB", true ));
    }
  }
}

