import webTemip.client.description.*;
import java.util.*;

public class ClarifyLiaisonDB_Component_6 extends FSComponent {

  public ClarifyLiaisonDB_Component_6() {
    super();
    setName("Oracle Database ");
    setDescription("The Oracle Server to be used with TeMIP requires the creation, \nconfiguration, and set up of the Alarm Handling DB for TeMIP.\n\nA standard Oracle installation without creating a DB is enough. You mu" +
	"st specify  \nthe ORACLE_HOME and TNS_ADMIN directories.\n\nOracle installation includes Oracle8 Server (RDBMS), SQL*Net, \nSQL*Plus, TCP/IP Protocol Adapter.\n");

    addCommand("Command_0");
    addCommand("Command_1");
    addCommand("Command_2");
    addCommand("Command_3");
  }

  public ClarifyLiaisonDB_Component_6(boolean simple) {
    super(simple);
    setName("Oracle Database ");
    setDescription("The Oracle Server to be used with TeMIP requires the creation, \nconfiguration, and set up of the Alarm Handling DB for TeMIP.\n\nA standard Oracle installation without creating a DB is enough. You mu" +
	"st specify  \nthe ORACLE_HOME and TNS_ADMIN directories.\n\nOracle installation includes Oracle8 Server (RDBMS), SQL*Net, \nSQL*Plus, TCP/IP Protocol Adapter.\n");
    addCommand("Command_0");
    addCommand("Command_1");
    addCommand("Command_2");
    addCommand("Command_3");
  }

  public class Command_0 extends FSCommand {
    public Command_0() {
      setName("Create Clarify Database");
      setDescription("Create a Clarify Oracle database for TeMIP Clarify Liaison, if necessary");
      setAppliName("TeMIP_TTL_CreateDatabase");
      addArgument(new FSParameter("ASE Option","String","","If Oracle Server is to be configured to work \nwith an ASE Configuration (no automatic start \nat boot time), set this argument to :\n-A SERVICE_NAME \n    (replace SERVICE_NAME with your \n    ASE Se" +
	"rvice Name), \nelse leave this argument empty.\n", true ));
      addArgument(new FSParameter("Specific Script Location  ","String","-l /usr/kits/SystemMate/scripts","", true ));
      addArgument(new FSParameter("SpecificScript","String","-s clarify_create_ora","Option to use the specific oracle \ncreation script for Clarify DB.", false ));
      addArgument(new FSParameter("SID","String","-S CLARIFY","", true ));
      addArgument(new FSParameter("DB Creator Name","String","-C temip","", true ));
      addArgument(new FSParameter("Database name (Clarify)","String","clarify","The Clarify DB Name (should be clarify)", true ));
      addArgument(new FSParameter("Path of Oracle config files (Clarify)","String","/etc","The location of the Oracle Configuration files \n(usually /etc)", true ));
      addArgument(new FSParameter("Group name for Oracle DBA (Clarify)","String","dba","The group of the Database Administrator\n(usually dba)", true ));
      addArgument(new FSParameter("Name of Oracle Administrator (Clarify)","String","oracle","The name of the Oracle Administrator \n(usually oracle)", true ));
      addArgument(new FSParameter("Oracle Server path","String","/usr/kits/oracle/u01/product/8.0","The location of the Oracle installation\n(often ORACLE_USER home directory \n or /usr/kits/oracle/u10/product/8.0)", true ));
      addArgument(new FSParameter("Specific option","String","clarify 100M 2M 40M 20M 1M 8M","Specific options for specific script \nto be followed by a string of the form: \nclarify 100M 2M 40M 20M 1M 8M", true ));
    }
  }
  public class Command_1 extends FSCommand {
    public Command_1() {
      setName("Validate Clarify Database");
      setDescription("Checks that temip user may use the clarify database ");
      setAppliName("TeMIP_TTL_ValidateDatabase");
      addArgument(new FSParameter("DB Name","String","clarify","The name of the Clarify DB", true ));
    }
  }
  public class Command_2 extends FSCommand {
    public Command_2() {
      setName("Install Oracle Server");
      setDescription("Install the Oracle software.");
      setAppliName("TeMIP_TTL_InstallOracle");
      addArgument(new FSParameter("CD-ROM location","String","/cdrom","The directory (mount point) where\nthe Oracle media is located\n(usually mounted under /cdrom).\n ", true ));
      addArgument(new FSParameter("Temporary directory","String","/tmp","A directory on a file system where\n there is at least 10 Mb free \n (used for temporary storage)", true ));
      addArgument(new FSParameter("Target location","String","/usr/kits/oracle","The directory where the Oracle software\nwill be installed.", true ));
      addArgument(new FSParameter("Oracle user","String","oracle","The name of the oracle user", true ));
      addArgument(new FSParameter("DBA group","String","dba","The name of the DBA group", true ));
    }
  }
  public class Command_3 extends FSCommand {
    public Command_3() {
      setName("Oracle Warning");
      setDescription("This directive allows to warn the user that Oracle application must be installed.");
      setAppliName("TeMIP_TTL_CheckOracle");
    }
  }
}

