import webTemip.client.description.*;
import java.util.*;

public class ClarifyLiaisonDB_Configuration_14 extends FSConfiguration {


  public ClarifyLiaisonDB_Configuration_14() {
    super();
    setName("TeMIP Clarify Liaison with Oracle database Configuration for eFO85");
    setDescription("The TeMIP Clarify Liaison with Oracle DB Config for eFO8 is a configuration for 4 systems.\nThe configuration contains :\n- the TT Liaison FM\n- the Clarify database for TeMIP Clarify Liaison.\n- the " +
	"eFrontOffice 8 application\n- the TeMIP Clarify Liaison for Windows NT\n\nThis configuration is recommended for installing the TeMIP Clarify software\nwhen a new Clarify Oracle database has to be conf" +
	"igured.\n\nRefer to the TeMIP Clarify Installation and Configuration Guide for more information.\n ");
    // Sites of this config
    FSSite site_0 = addSite("ClarifyLiaisonDB_Site_13","ClarifyLiaison_eFO85");

    //List of available directives
    FSDirective directive_0 = addDirective("Install");
    FSDirective directive_2 = addDirective("Uninstall");
    directive_0.setDescription("Install and configure the TeMIP Clarify Liaison software.\nConfigure the Clarify database for Oracle.");
    directive_2.setDescription("Uninstall the TeMIP Clarify Liaison and the Clarify NT site.\nThis uninstall directive does not remove the TeMIP Clarify Database created on Installation.");
    FSAction action_1_0 = new FSAction(site_0.getDirective("Install"));
    directive_0.addAction(action_1_0);
    Vector argVector_1_0 = new Vector();
    String[][] actionArgHistory_1_1_1 = {{"0","ClarifyLiaison_eFO85","TeMIP Server System ","Install"},{"0","ClarifyLiaison_eFO85","TeMIP Clarify Liaison ComponentPackage ","Install FM"},{"2","ClarifyLiaison_eFO85","TeMIP Clarify Liaison FM Component ","Configure"},};
    FSActionArgument actionArg_1_1_0 = action_1_0.createActionArgument("Hostname of the Clarify Server","String","$CLARIFY_SERVER_SYSTEM",false,actionArgHistory_1_1_1);
    if (actionArg_1_1_0 != null ) argVector_1_0.addElement(actionArg_1_1_0);
    String[][] actionArgHistory_1_1_2 = {{"0","ClarifyLiaison_eFO85","TeMIP Server System ","Install"},{"0","ClarifyLiaison_eFO85","TeMIP Clarify Liaison ComponentPackage ","Install FM"},{"2","ClarifyLiaison_eFO85","TeMIP Clarify Liaison FM Component ","Configure"},};
    FSActionArgument actionArg_1_1_1 = action_1_0.createActionArgument("TTS name","String","$TTS_INSTANCE",false,actionArgHistory_1_1_2);
    if (actionArg_1_1_1 != null ) argVector_1_0.addElement(actionArg_1_1_1);
    action_1_0.setActionArguments(argVector_1_0);
    FSAction action_3_0 = new FSAction(site_0.getDirective("Uninstall"));
    directive_2.addAction(action_3_0);
    Vector argVector_3_0 = new Vector();
    String[][] actionArgHistory_3_1_1 = {{"0","ClarifyLiaison_eFO85","TeMIP Server System ","Uninstall"},{"0","ClarifyLiaison_eFO85","TeMIP Clarify Liaison ComponentPackage ","Uninstall FM"},{"0","ClarifyLiaison_eFO85","TeMIP Clarify Liaison FM Component ","Unconfigure"},};
    FSActionArgument actionArg_3_1_0 = action_3_0.createActionArgument("TTS name","String","$TTS_INSTANCE",false,actionArgHistory_3_1_1);
    if (actionArg_3_1_0 != null ) argVector_3_0.addElement(actionArg_3_1_0);
    action_3_0.setActionArguments(argVector_3_0);
  }

  public ClarifyLiaisonDB_Configuration_14(boolean simple) {
    super(simple);
    setName("TeMIP Clarify Liaison with Oracle database Configuration for eFO85");
    setDescription("The TeMIP Clarify Liaison with Oracle DB Config for eFO8 is a configuration for 4 systems.\nThe configuration contains :\n- the TT Liaison FM\n- the Clarify database for TeMIP Clarify Liaison.\n- the " +
	"eFrontOffice 8 application\n- the TeMIP Clarify Liaison for Windows NT\n\nThis configuration is recommended for installing the TeMIP Clarify software\nwhen a new Clarify Oracle database has to be conf" +
	"igured.\n\nRefer to the TeMIP Clarify Installation and Configuration Guide for more information.\n ");
    //List of available directives
    FSDirective directive_0 = addDirective("Install");
    FSDirective directive_2 = addDirective("Uninstall");
    directive_0.setDescription("Install and configure the TeMIP Clarify Liaison software.\nConfigure the Clarify database for Oracle.");
    directive_2.setDescription("Uninstall the TeMIP Clarify Liaison and the Clarify NT site.\nThis uninstall directive does not remove the TeMIP Clarify Database created on Installation.");
  }
}

