import webTemip.client.description.*;
import java.util.*;

public class MAPV41_Component_1 extends FSComponent {

  public MAPV41_Component_1() {
    super();
    setName("MAP Configuration");
    setDescription("MAP Application Server configuration");

    addCommand("Command_0");
    addCommand("Command_1");
    addCommand("Command_2");
    addCommand("Command_3");
    addCommand("Command_4");
  }

  public MAPV41_Component_1(boolean simple) {
    super(simple);
    setName("MAP Configuration");
    setDescription("MAP Application Server configuration");
    addCommand("Command_0");
    addCommand("Command_1");
    addCommand("Command_2");
    addCommand("Command_3");
    addCommand("Command_4");
  }

  public class Command_0 extends FSCommand {
    public Command_0() {
      setName("Configure MAP Servers");
      setDescription("Configuration of \n\n1) The Oracle host used by the MAP Servers\n\n2) The default format used by the MAP Servers \n	possible values: Map_File, Oracle\n");
      setAppliName("MAP_Setup");
      addArgument(new FSParameter("Oracle server hostname","String","Oracle_host","Enter the hostname of the Oracle database server.\nIf no Oracle database is used, enter the value:  none\n", true ));
      addArgument(new FSParameter("Default Map Format","String","Oracle","Default Map Format used by  \nthe Map Server:\nMap_File\nOracle\n", true ));
    }
  }
  public class Command_1 extends FSCommand {
    public Command_1() {
      setName("Setup Map Oracle database (MASTER)");
      setDescription("Setup the Oracle tables used by the MAP servers");
      setAppliName("MAP_ora_install_master");
      addArgument(new FSParameter("TeMIP Config Path","String","/var/mcc/config","", true ));
      addArgument(new FSParameter("Director User","String","temip","", true ));
      addArgument(new FSParameter("Oracle Home","String","/usr/kits/oracle","", true ));
      addArgument(new FSParameter("Oracle SID","String","IMPMNT","", true ));
      addArgument(new FSParameter("Oracle admin user","String","oracle","", true ));
      addArgument(new FSParameter("Database Name","String","IMPMNT","", true ));
      addArgument(new FSParameter("Database IP domain name","String","temip_domain","", true ));
      addArgument(new FSParameter("SQLNet service name master","String","","", true ));
      addArgument(new FSParameter("Database SID","String","IMPMNT","", true ));
      addArgument(new FSParameter("Master Hostname","String","","Including domain part", true ));
    }
  }
  public class Command_2 extends FSCommand {
    public Command_2() {
      setName("Setup Map Oracle database (SNAPSHOT)");
      setDescription("Defines a Map Oracle snaphot database.\nRequires an existing MAp Oracle master database.");
      setAppliName("MAP_ora_install_snapshot");
      addArgument(new FSParameter("TeMIP Config Path","String","/var/mcc/config","", true ));
      addArgument(new FSParameter("Director User","String","temip","", true ));
      addArgument(new FSParameter("Oracle Home","String","/usr/kits/oracle","", true ));
      addArgument(new FSParameter("Oracle SID","String","IMPMNT","", true ));
      addArgument(new FSParameter("Oracle admin user","String","oracle","", true ));
      addArgument(new FSParameter("Database Name","String","IMPMNT","", true ));
      addArgument(new FSParameter("Database IP domain name","String","temip_domain","", true ));
      addArgument(new FSParameter("SQLNet service name master","String","","", true ));
      addArgument(new FSParameter("SQLNet service name snapshot","String","","", true ));
      addArgument(new FSParameter("Database SID","String","IMPMNT","", true ));
      addArgument(new FSParameter("Master hostname","String","","including domain part", true ));
      addArgument(new FSParameter("Snapshot hostname","String","","including domain part", true ));
    }
  }
  public class Command_3 extends FSCommand {
    public Command_3() {
      setName("Monitor Map Oracle database");
      setDescription("");
      setAppliName("MAP_ora_monitor");
      addArgument(new FSParameter("Action","String","","either START or STOP", true ));
      addArgument(new FSParameter("TeMIP Config Path","String","/var/mcc/config","", true ));
      addArgument(new FSParameter("Director User","String","temip","", true ));
      addArgument(new FSParameter("Oracle Home","String","/usr/kits/oracle","", true ));
      addArgument(new FSParameter("Oracle SID","String","IMPMNT","", true ));
      addArgument(new FSParameter("Oracle admin user","String","oracle","", true ));
    }
  }
  public class Command_4 extends FSCommand {
    public Command_4() {
      setName("Map Oracle database objects manager");
      setDescription("For a MASTER or a SNAPSHOT\n1) REMOVE the database objects necessary to store maps.\nThis also erase all data in the MAP database.\n=> All maps will be deleted <=\n\n2) CREATE the database objects nec" +
	"essary to store maps.");
      setAppliName("MAP_ora_objects");
      addArgument(new FSParameter("Action","String","","either CREATE or REMOVE", true ));
      addArgument(new FSParameter("Type","String","","either MASTER or SNAPSHOT", true ));
      addArgument(new FSParameter("TeMIP Config Path","String","/var/mcc/config","", true ));
      addArgument(new FSParameter("Director User","String","temip","", true ));
      addArgument(new FSParameter("Oracle Home","String","/usr/kits/oracle","", true ));
      addArgument(new FSParameter("Oracle SID","String","IMPMNT","", true ));
      addArgument(new FSParameter("Database Name","String","IMPMNT","", true ));
      addArgument(new FSParameter("SQLNet Service Name Master","String","","", true ));
      addArgument(new FSParameter("SQLNet Service Name Snapshot","String","","", true ));
      addArgument(new FSParameter("Database SID","String","IMPMNT","", true ));
    }
  }
}

