 /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %                CCCC   OOO   N   N  V   V  EEEEE  RRRR   TTTTT               % O %               C      O   O  NN  N  V   V  E      R   R    T                 % O %               C      O   O  N N N  V   V  EEE    RRRR     T                 % O %               C      O   O  N  NN   V V   E      R R      T                 % O %                CCCC   OOO   N   N    V    EEEEE  R  R     T                 % O %                                                                             % O %                                                                             % O %                Convert an image from one format to another.                 % O %                                                                             % O %                                                                             % O %                                                                             % O %                              Software Design                                % O %                                John Cristy                                  % O %                                April 1992                                   % O %                                                                             % O %                                                                             % O %  Copyright 1997 E. I. Dupont de Nemours and Company                         % O %                                                                             % O %  Permission to use, copy, modify, distribute, and sell this software and    % O %  its documentation for any purpose is hereby granted without fee,           % O %  provided that the above Copyright notice appear in all copies and that     % O %  both that Copyright notice and this permission notice appear in            % O %  supporting documentation, and that the name of E. I. Dupont de Nemours     % O %  and Company not be used in advertising or publicity pertaining to          % O %  distribution of the software without specific, written prior               % O %  permission.  E. I. Dupont de Nemours and Company makes no representations  % O %  about the suitability of this software for any purpose.  It is provided    % O %  "as is" without express or implied warranty.                               % O %                                                                             % O %  E. I. Dupont de Nemours and Company disclaims all warranties with regard   % O %  to this software, including all implied warranties of merchantability      % O %  and fitness, in no event shall E. I. Dupont de Nemours and Company be      % O %  liable for any special, indirect or consequential damages or any           % O %  damages whatsoever resulting from loss of use, data or profits, whether    % O %  in an action of contract, negligence or other tortious action, arising     % O %  out of or in connection with the use or performance of this software.      % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % J %  Convert converts an input file using one image format to an output file! %  with a differing image format.  % ! %  The convert program syntax is:  % 6 %  Usage: convert [options ...] input_file output_file %  %  Where options include: D %    -adjoin              join images into a single multi-image file1 %    -average             average a set of images : %    -blur factor         apply a filter to blur the image? %    -border geometry     surround image with a border of color ; %    -box color           color for annotation bounding box 5 %    -charcoal factor     simulate a charcoal drawing ? %    -colorize value      colorize the image with the pen color A %    -colors value        preferred number of colors in the image I %    -colorspace type     GRAY, OHTA, RGB, XYZ, YCbCr, YIQ, YPbPr, or YUV 5 %    -comment string      annotate image with comment 1 %    -compress type       RunlengthEncoded or Zip > %    -contrast            enhance or reduce the image contrastJ %    -crop geometry       preferred size and location of the cropped image2 %    -cycle amount        cycle the image colormap> %    -delay value         display the next image after pausingF %    -density geometry    vertical and horizontal density of the image> %    -despeckle           reduce the speckles within an image"A %    -display server      obtain image or font from this X server - %    -dispose method      GIF disposal method H %    -dither              apply Floyd/Steinberg error diffusion to imageE %    -draw string         annotate the image with a graphic primitive E %    -edge factor         apply a filter to detect edges in the image ) %    -emboss              emboss an image I %    -enhance             apply a digital filter to enhance a noisy image D %    -equalize            perform histogram equalization to an image> %    -flip                flip image in the vertical direction@ %    -flop                flop image in the horizontal direction6 %    -font name           X11 font for displaying textB %    -frame geometry      surround image with an ornamental border3 %    -gamma value         level of gamma correction A %    -geometry geometry   perferred size or location of the image ? %    -implode amount      implode image pixels about the center 9 %    -interlace type      None, Line, Plane, or Partition 4 %    -label name          assign a label to an image1 %    -linewidth value     width of line in pixels K %    -loop iterations     add Netscape loop extension to your GIF animation L %    -map filename        transform image colors to match this set of colorsB %    -matte               store matte channel if the image has oneA %    -modulate value      vary the brightness, saturation and hue < %    -monochrome          transform image to black and white8 %    -negate              apply color inversion to image9 %    -noise               add or reduce noise in an image J %    -normalize           transform image to span the full range of colors< %    -opaque color        change this color to the pen colorB %    -page geometry       size and location of the Postscript page2 %    -paint radius        simulate an oil paintingG %    -pen color           color for annotating or changing opaque color 6 %    -pointsize value     pointsize of Postscript font. %    -quality value       JPEG quality settingK %    -raise value         lighten/darken image edges to create a 3-D effect A %    -region geometry     apply options to a portion of the image B %    -roll geometry       roll an image vertically or horizontally; %    -rotate degrees      apply Paeth rotation to the image 9 %    -sample geometry     scale image with pixel sampling , %    -scene value         image scene number* %    -segment values      segment an imageF %    -shade degrees       shade the image using a distant light source= %    -sharpen factor      apply a filter to sharpen the image K %    -shear geometry      slide one edge of the image along the X or Y axis 3 %    -size geometry       width and height of image E %    -solarize thresold   negate all pixels above the threshold level B %    -spread amount       displace image pixels by a random amount= %    -swirl degrees       swirl image pixels about the center K %    -texture filename    name of texture to tile onto the image background - %    -threshold value     threshold the image F %    -transparent color   make this color transparent within the image@ %    -treedepth value     depth of the color classification treeI %    -undercolor geometry control undercolor removal and black generation D %    -verbose             print detailed information about the image % D %  Change '-' to '+' in any option above to reverse its effect.  ForI %  example,  specify +matte to store the image without its matte channel.  % D %  By default, the image format of `file' is determined by its magicF %  number.  To specify a particular image format, precede the filenameG %  with an image format name and a colon (i.e. ps:image) or specify the H %  image type as the filename suffix (i.e. image.ps).  Specify 'file' as$ %  '-' for standard input or output. % 2 %  Convert recognizes the following image formats: %  %    Tag   Description8 %    --------------------------------------------------- %    AVS   AVS X image file./ %    BMP   Microsoft Windows bitmap image file. 6 %    CMYK  Raw cyan, magenta, yellow, and black bytes.2 %    DCX   ZSoft IBM PC multi-page Paintbrush file/ %    DIB   Microsoft Windows bitmap image file. . %    EPS   Adobe Encapsulated PostScript file.7 %    EPS2  Adobe Level II Encapsulated PostScript file. . %    EPSF  Adobe Encapsulated PostScript file.< %    EPSI  Adobe Encapsulated PostScript Interchange format. %    FAX   Group 3. + %    FITS  Flexible Image Transport System. ? %    GIF   CompuServe graphics interchange format; 8-bit color. M %    GIF87 CompuServe graphics interchange format; 8-bit color (version 87a). 9 %    GRADATION gradual passing from one shade to another.  %    GRANITE granite texture %    GRAY  Raw gray bytes.$ %    HDF   Hierarchical Data Format. %    HISTOGRAMA %    HTML  Hypertext Markup Language with a client-side image map F %    JBIG  Joint Bi-level Image experts Group file interchange format.Q %    JPEG  Joint Photographic Experts Group JFIF format; compressed 24-bit color. , %    MAP   colormap intensities and indices. %    MATTE Raw matte bytes. $ %    MIFF  Magick image file format.G %    MONO  Bi-level bitmap in least-significant-byte (LSB) first order. @ %    MPEG  Motion Picture Experts Group file interchange format.& %    MTV   MTV Raytracing image format
 %    NETSCAPE # %          Netscape 216 color cube.  %    NULL  NULL image.4 %    PBM   Portable bitmap format (black and white). %    PCD   Photo CD.( %    PCX   ZSoft IBM PC Paintbrush file.$ %    PDF   Portable Document Format.0 %    PGM   Portable graymap format (gray scale)./ %    PICT  Apple Macintosh QuickDraw/PICT file. ! %    PLASMA plasma fractal image. % %    PNG   Portable Network Graphics.  %    PNM   Portable anymap. * %    PPM   Portable pixmap format (color). %    PREVIEW! %    PS    Adobe PostScript file. * %    PS2   Adobe Level II PostScript file. %    RAD   Radiance image file. * %    RGB   Raw red, green, and blue bytes.1 %    RGBA  Raw red, green, blue, and matte bytes. 0 %    RLA   Alias/Wavefront image file; read only9 %    RLE   Utah Run length encoded image file; read only.  %    SGI   Irix RGB image file. A %    SHTML Hypertext Markup Language with a client-side image map  %    SUN   SUN Rasterfile.$ %    TEXT  raw text file; read only.' %    TGA   Truevision Targa image file. $ %    TIFF  Tagged Image File Format.> %    UYVY  16bit/pixel interleaved YUV (e.g. used by AccomWSD)% %    TILE  tile image with a texture.  %    VICAR read only. " %    VID   Visual Image Directory.+ %    VIFF  Khoros Visualization image file. - %    X     select image from X server screen. , %    XC    constant image of X server color.9 %    XBM   X Windows system bitmap, black and white only. 0 %    XPM   X Windows system pixmap file (color).5 %    XWD   X Windows system window dump file (color).  %    YUV   CCIR 601 1:1:1 file.  %  %  */   /*   Include declarations.  */ #include "magick.h"  #include "version.h"   /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   U s a g e                                                                 % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % . %  Procedure Usage displays the program usage; % & %  The format of the Usage routine is: %  %      Usage(client_name)  % J %    o client_name: a character string representing the name of the client %      program.  %  %  */* static void Usage(const char *client_name) {    char     **p;  
   static char      *ImageTypes[]=     {        "Tag   Description",E       "------------------------------------------------------------",         "AVS   AVS X image file.",3       "BMP   Microsoft Windows bitmap image file.", :       "CMYK  Raw cyan, magenta, yellow, and black bytes.",6       "DCX   ZSoft IBM PC multi-page Paintbrush file",3       "DIB   Microsoft Windows bitmap image file.", 2       "EPS   Adobe Encapsulated PostScript file.",;       "EPS2  Adobe Level II Encapsulated PostScript file.", 2       "EPSF  Adobe Encapsulated PostScript file.",@       "EPSI  Adobe Encapsulated PostScript Interchange format.",       "FAX   Group 3.", /       "FITS  Flexible Image Transport System.", C       "GIF   CompuServe graphics interchange format; 8-bit color.", Q       "GIF87 CompuServe graphics interchange format; 8-bit color (version 87a).", =       "GRADATION gradual passing from one shade to another.", !       "GRANITE granite texture.",        "GRAY  Raw gray bytes.",(       "HDF   Hierarchical Data Format.",       "HISTOGRAM",E       "HTML  Hypertext Markup Language with a client-side image map", J       "JBIG  Joint Bi-level Image experts Group file interchange format.",U       "JPEG  Joint Photographic Experts Group JFIF format; compressed 24-bit color.", 0       "MAP   colormap intensities and indices.",       "MATTE Raw matte bytes.", (       "MIFF  Magick image file format.",K       "MONO  Bi-level bitmap in least-significant-byte (LSB) first order.", D       "MPEG  Motion Picture Experts Group file interchange format.",+       "MTV   MTV Raytracing image format.", +       "NETSCAPE  Netscape 216 color cube.",        "NULL  NULL image.",8       "PBM   Portable bitmap format (black and white).",       "PCD   Photo CD.",,       "PCX   ZSoft IBM PC Paintbrush file.",(       "PDF   Portable Document Format.",4       "PGM   Portable graymap format (gray scale).",3       "PICT  Apple Macintosh QuickDraw/PICT file.", %       "PLASMA plasma fractal image.", )       "PNG   Portable Network Graphics.",        "PNM   Portable anymap.", .       "PPM   Portable pixmap format (color).",       "PREVIEW",%       "PS    Adobe PostScript file.", .       "PS2   Adobe Level II PostScript file.",#       "RAD   Radiance image file.", .       "RGB   Raw red, green, and blue bytes.",5       "RGBA  Raw red, green, blue, and matte bytes.", 5       "RLA   Alias/Wavefront image file; read only.", =       "RLE   Utah Run length encoded image file; read only.", #       "SGI   Irix RGB image file.",        "SUN   SUN Rasterfile.",(       "TEXT  raw text file; read only.",+       "TGA   Truevision Targa image file.", (       "TIFF  Tagged Image File Format.",+       "UYVY  16bit/pixel interleaved YUV.", )       "TILE  tile image with a texture.",        "VICAR read only.", &       "VID   Visual Image Directory.",/       "VIFF  Khoros Visualization image file.", 1       "X     select image from X server screen.", 0       "XC    constant image of X server color.",=       "XBM   X Windows system bitmap, black and white only.", 4       "XPM   X Windows system pixmap file (color).",9       "XWD   X Windows system window dump file (color).", #       "YUV   CCIR 601 1:1:1 file.",        (char *) NULL,     },     *options[]=      { H       "-adjoin              join images into a single multi-image file",5       "-average             average a set of images", >       "-blur factor         apply a filter to blur the image",C       "-border geometry     surround image with a border of color", ?       "-box color           color for annotation bounding box", 9       "-charcoal factor     simulate a charcoal drawing", C       "-colorize value      colorize the image with the pen color", E       "-colors value        preferred number of colors in the image", M       "-colorspace type     GRAY, OHTA, RGB, XYZ, YCbCr, YIQ, YPbPr, or YUV", 9       "-comment string      annotate image with comment", 5       "-compress type       RunlengthEncoded or Zip", B       "-contrast            enhance or reduce the image contrast",N       "-crop geometry       preferred size and location of the cropped image",6       "-cycle amount        cycle the image colormap",B       "-delay value         display the next image after pausing",J       "-density geometry    vertical and horizontal density of the image",A       "-despeckle           reduce the speckles within an image", E       "-display server      obtain image or font from this X server", 1       "-dispose method      GIF disposal method", L       "-dither              apply Floyd/Steinberg error diffusion to image",I       "-draw string         annotate the image with a graphic primitive", I       "-edge factor         apply a filter to detect edges in the image", -       "-emboss              emboss an image", M       "-enhance             apply a digital filter to enhance a noisy image", H       "-equalize            perform histogram equalization to an image",B       "-flip                flip image in the vertical direction",D       "-flop                flop image in the horizontal direction",:       "-font name           X11 font for displaying text",F       "-frame geometry      surround image with an ornamental border",7       "-gamma value         level of gamma correction", E       "-geometry geometry   perferred size or location of the image", C       "-implode amount      implode image pixels about the center", =       "-interlace type      None, Line, Plane, or Partition", 5       "-linewidth value     width of line in pixels", 8       "-label name          assign a label to an image",O       "-loop iterations     add Netscape loop extension to your GIF animation", P       "-map filename        transform image colors to match this set of colors",F       "-matte               store matte channel if the image has one",F       "-modulate value      vary the brightness, saturation, and hue",@       "-monochrome          transform image to black and white",<       "-negate              apply color inversion to image",=       "-noise               add or reduce noise in an image", N       "-normalize           transform image to span the full range of colors",@       "-opaque color        change this color to the pen color",F       "-page geometry       size and location of the Postscript page",6       "-paint radius        simulate an oil painting",K       "-pen color           color for annotating or changing opaque color", :       "-pointsize value     pointsize of Postscript font",2       "-quality value       JPEG quality setting",O       "-raise value         lighten/darken image edges to create a 3-D effect", E       "-region geometry     apply options to a portion of the image", F       "-roll geometry       roll an image vertically or horizontally",?       "-rotate degrees      apply Paeth rotation to the image", =       "-sample geometry     scale image with pixel sampling", 0       "-scene value         image scene number",.       "-segment values      segment an image",J       "-shade degrees       shade the image using a distant light source",A       "-sharpen factor      apply a filter to sharpen the image", O       "-shear geometry      slide one edge of the image along the X or Y axis", 7       "-size geometry       width and height of image", I       "-solarize thresold   negate all pixels above the threshold level", F       "-spread amount       displace image pixels by a random amount",A       "-swirl degrees       swirl image pixels about the center", O       "-texture filename    name of texture to tile onto the image background", 1       "-threshold value     threshold the image", J       "-transparent color   make this color transparent within the image",D       "-treedepth value     depth of the color classification tree",M       "-undercolor geometry control undercolor removal and black generation", H       "-verbose             print detailed information about the image",       (char *) NULL      };  +   (void) printf("Version: %s\n\n",Version); C   (void) printf("Usage: %s [options ...] input_file output_file\n",      client_name); .   (void) printf("\nWhere options include:\n");+   for (p=options; *p != (char *) NULL; p++)      (void) printf("  %s\n",*p);    (void) printf(M     "\nChange '-' to '+' in any option above to reverse its effect.  For\n");    (void) printf(O     "example,  specify +matte to store the image without an matte channel.\n");    (void) printf(M     "\nBy default, the image format of `file' is determined by its magic\n");    (void) printf(M     "number.  To specify a particular image format, precede the filename\n");    (void) printf(N     "with an image format name and a colon (i.e. ps:image) or specify the\n");   (void) printf(O     "image type as the filename suffix (i.e. image.ps).  Specify 'file' as\n"); 7   (void) printf("'-' for standard input or output.\n"); F   (void) printf("\nThe following image formats are recognized: \n\n");.   for (p=ImageTypes; *p != (char *) NULL; p++)     (void) printf("  %s\n",*p); 
   exit(1); }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %  M a i n                                                                    % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  %  %  */ int main(int argc,char *argv[])  { + #define NotInitialized  (unsigned int) (~0)      char     *client_name,      *filename,     *option;     Image      *image,      *next_image;     ImageInfo      image_info;      int      x;     register int     i;     unsigned int     average,     global_colormap,
     scene;     /*!     Initialize program variables.    */   ReadCommandlLine(argc,&argv);     client_name=ClientName(*argv);   if (argc < 3)      Usage(client_name);    /**     Read image and convert to MIFF format.   */   average=False;   filename=(char *) NULL;    image=(Image *) NULL;    global_colormap=False;   GetImageInfo(&image_info);   option=(char *) NULL; 
   scene=0;   /*!     Parse command-line arguments.    */   ExpandFilenames(&argc,&argv);    for (i=1; i < (argc-1); i++)   {      option=argv[i]; G     if ((Extent(option) < 2) || ((*option != '-') && (*option != '+')))        { 
         /*           Read input image. 
         */         filename=argv[i]; 4         (void) strcpy(image_info.filename,filename);*         next_image=ReadImage(&image_info);)         if (next_image == (Image *) NULL)            continue; 6         MogrifyImages(&image_info,i,argv,&next_image);$         if (image == (Image *) NULL)           image=next_image;          else           {              /*)               Link image into image list.              */'             next_image->previous=image; #             image->next=next_image; 1             while (image->next != (Image *) NULL)                 image=image->next;           }        }      else       switch(*(option+1))        {          case 'a': 	         { 0           if (strncmp("adjoin",option+1,2) == 0)
             { 1               image_info.adjoin=(*option == '-');                break;
             } 1           if (strncmp("average",option+1,2) == 0) 
             { '               average=(*option == '-');                break;
             } .           Error("Unrecognized option",option);           break;	         }          case 'b': 	         { .           if (strncmp("blur",option+1,3) == 0)
             { !               if (*option == '-')                  {                    i++;H                   if ((i == argc) || !sscanf(argv[i],"%f",(float *) &x))C                     Error("Missing factor on -blur",(char *) NULL);                  }                break;
             } 0           if (strncmp("border",option+1,7) == 0)
             { !               if (*option == '-')                  {                    i++;:                   if ((i == argc) || !IsGeometry(argv[i]))G                     Error("Missing geometry on -border",(char *) NULL);                  }                break;
             } 5           if (strncmp("bordercolor",option+1,7) == 0) 
             { :               if ((i == argc) || !sscanf(argv[i],"%d",&x))                 {                    i++;                    if (i == argc)I                     Error("Missing color on -bordercolor",(char *) NULL);                  }                break;
             } -           if (strncmp("box",option+1,3) == 0) 
             { !               if (*option == '-')                  {                    i++;                    if (i == argc)A                     Error("Missing color on -box",(char *) NULL);                  }                break;
             } .           Error("Unrecognized option",option);           break;	         }          case 'c': 	         { 2           if (strncmp("charcoal",option+1,2) == 0)
             { !               if (*option == '-')                  {                    i++;H                   if ((i == argc) || !sscanf(argv[i],"%f",(float *) &x))G                     Error("Missing factor on -charcoal",(char *) NULL);                  }                break;
             } 2           if (strncmp("colorize",option+1,7) == 0)
             { !               if (*option == '-')                  {                    i++;>                   if ((i == argc) || !sscanf(argv[i],"%d",&x))G                     Error("Missing value on -colorsize",(char *) NULL);                  }                break;
             } 0           if (strncmp("colors",option+1,7) == 0)
             { !               if (*option == '-')                  {                    i++;>                   if ((i == argc) || !sscanf(argv[i],"%d",&x))E                     Error("Missing colors on -colors",(char *) NULL);                  }                break;
             } 4           if (strncmp("colorspace",option+1,7) == 0)
             { !               if (*option == '-')                  {                    unsigned int                     colorspace;                      i++;                    if (i == argc)G                     Error("Missing type on -colorspace",(char *) NULL); !                   option=argv[i]; 1                   colorspace=UndefinedColorspace; 8                   if (Latin1Compare("gray",option) == 0).                     colorspace=GRAYColorspace;8                   if (Latin1Compare("ohta",option) == 0).                     colorspace=OHTAColorspace;7                   if (Latin1Compare("rgb",option) == 0) -                     colorspace=RGBColorspace; ?                   if (Latin1Compare("transparent",option) == 0) 5                     colorspace=TransparentColorspace; 7                   if (Latin1Compare("xyz",option) == 0) -                     colorspace=XYZColorspace; 9                   if (Latin1Compare("ycbcr",option) == 0) /                     colorspace=YCbCrColorspace; 7                   if (Latin1Compare("yiq",option) == 0) -                     colorspace=YIQColorspace; 9                   if (Latin1Compare("ypbpr",option) == 0) /                     colorspace=YPbPrColorspace; 7                   if (Latin1Compare("yuv",option) == 0) -                     colorspace=YUVColorspace; 8                   if (colorspace == UndefinedColorspace)K                     Error("Invalid colorspace type on -colorspace",option);                  }                break;
             } 1           if (strncmp("comment",option+1,4) == 0) 
             { !               if (*option == '-')                  {                    i++;                    if (i == argc)G                     Error("Missing comment on -comment",(char *) NULL);                  }                break;
             } 2           if (strncmp("compress",option+1,4) == 0)
             { 3               image_info.compression=NoCompression; !               if (*option == '-')                  {                    i++;                    if (i == argc)E                     Error("Missing type on -compress",(char *) NULL); !                   option=argv[i]; D                   if (Latin1Compare("runlengthencoded",option) == 0)G                     image_info.compression=RunlengthEncodedCompression;                    else9                     if (Latin1Compare("zip",option) == 0) <                       image_info.compression=ZipCompression;                     elseL                       Error("Invalid compression type on -compress",option);                 }                break;
             } 2           if (strncmp("contrast",option+1,3) == 0)             break;.           if (strncmp("crop",option+1,2) == 0)
             { !               if (*option == '-')                  {                    i++;:                   if ((i == argc) || !IsGeometry(argv[i]))E                     Error("Missing geometry on -crop",(char *) NULL);                  }                break;
             } /           if (strncmp("cycle",option+1,2) == 0) 
             { !               if (*option == '-')                  {                    i++;>                   if ((i == argc) || !sscanf(argv[i],"%d",&x))D                     Error("Missing amount on -cycle",(char *) NULL);                 }                break;
             } .           Error("Unrecognized option",option);           break;	         }          case 'd': 	         { /           if (strncmp("delay",option+1,3) == 0) 
             { -               image_info.delay=(char *) NULL; !               if (*option == '-')                  {                    i++;>                   if ((i == argc) || !sscanf(argv[i],"%d",&x))C                     Error("Missing delay on -delay",(char *) NULL); ?                   image_info.delay=PostscriptGeometry(argv[i]);                  }                break;
             } 1           if (strncmp("density",option+1,3) == 0) 
             { /               image_info.density=(char *) NULL; !               if (*option == '-')                  {                    i++;:                   if ((i == argc) || !IsGeometry(argv[i]))H                     Error("Missing geometry on -density",(char *) NULL);-                   image_info.density=argv[i];                  }                break;
             } 3           if (strncmp("despeckle",option+1,3) == 0)              break;.           if (strcmp("display",option+1) == 0)
             { 3               image_info.server_name=(char *) NULL; !               if (*option == '-')                  {                    i++;                    if (i == argc)K                     Error("Missing server name on -display",(char *) NULL); 1                   image_info.server_name=argv[i];                  }                break;
             } 1           if (strncmp("dispose",option+1,5) == 0) 
             { /               image_info.dispose=(char *) NULL; !               if (*option == '-')                  {                    i++;>                   if ((i == argc) || !sscanf(argv[i],"%d",&x))F                     Error("Missing method on -dispose",(char *) NULL);A                   image_info.dispose=PostscriptGeometry(argv[i]);                  }                break;
             } 0           if (strncmp("dither",option+1,3) == 0)
             { 1               image_info.dither=(*option == '-');                break;
             } .           if (strncmp("draw",option+1,2) == 0)
             { !               if (*option == '-')                  {                    i++;                    if (i == argc)F                     Error("Missing primitive on -draw",(char *) NULL);                 }                break;
             } .           Error("Unrecognized option",option);           break;	         }          case 'e': 	         { .           if (strncmp("edge",option+1,2) == 0)
             { !               if (*option == '-')                  {                    i++;H                   if ((i == argc) || !sscanf(argv[i],"%f",(float *) &x))C                     Error("Missing factor on -edge",(char *) NULL);                  }                break;
             } 0           if (strncmp("emboss",option+1,2) == 0)             break;1           if (strncmp("enhance",option+1,2) == 0)              break;2           if (strncmp("equalize",option+1,2) == 0)             break;.           Error("Unrecognized option",option);           break;	         }          case 'f': 	         { .           if (strncmp("flip",option+1,3) == 0)             break;.           if (strncmp("flop",option+1,3) == 0)             break;.           if (strncmp("font",option+1,2) == 0)
             { ,               image_info.font=(char *) NULL;!               if (*option == '-')                  {                    i++;                    if (i == argc)F                     Error("Missing font name on -font",(char *) NULL);*                   image_info.font=argv[i];                 }                break;
             } /           if (strncmp("frame",option+1,2) == 0) 
             { !               if (*option == '-')                  {                    i++;:                   if ((i == argc) || !IsGeometry(argv[i]))F                     Error("Missing geometry on -frame",(char *) NULL);                 }                break;
             } .           Error("Unrecognized option",option);           break;	         }          case 'g': 	         { /           if (strncmp("gamma",option+1,2) == 0) 
             { !               if (*option == '-')                  {                    i++;H                   if ((i == argc) || !sscanf(argv[i],"%f",(float *) &x))C                     Error("Missing value on -gamma",(char *) NULL);                  }                break;
             } 2           if (strncmp("geometry",option+1,2) == 0)
             { !               if (*option == '-')                  {                    i++;:                   if ((i == argc) || !IsGeometry(argv[i]))I                     Error("Missing geometry on -geometry",(char *) NULL);                  }                break;
             } .           Error("Unrecognized option",option);           break;	         }          case 'h': 	         { .           if (strncmp("help",option+1,2) == 0)
             { !               Usage(client_name);                break;
             } .           Error("Unrecognized option",option);           break;	         }          case 'i': 	         { 1           if (strncmp("implode",option+1,2) == 0) 
             { !               if (*option == '-')                  {                    i++;H                   if ((i == argc) || !sscanf(argv[i],"%f",(float *) &x))F                     Error("Missing amount on -implode",(char *) NULL);                 }                break;
             } 3           if (strncmp("interlace",option+1,3) == 0) 
             { 1               image_info.interlace=NoneInterlace; !               if (*option == '-')                  {                    i++;                    if (i == argc)F                     Error("Missing type on -interlace",(char *) NULL);!                   option=argv[i]; :                   image_info.interlace=UndefinedInterlace;8                   if (Latin1Compare("none",option) == 0)7                     image_info.interlace=NoneInterlace; 8                   if (Latin1Compare("line",option) == 0)7                     image_info.interlace=LineInterlace; 9                   if (Latin1Compare("plane",option) == 0) 8                     image_info.interlace=PlaneInterlace;=                   if (Latin1Compare("partition",option) == 0) <                     image_info.interlace=PartitionInterlace;A                   if (image_info.interlace == UndefinedInterlace) I                     Error("Invalid interlace type on -interlace",option);                  }                break;
             } .           Error("Unrecognized option",option);	         }          case 'l': 	         { /           if (strncmp("label",option+1,2) == 0) 
             { !               if (*option == '-')                  {                    i++;                    if (i == argc)H                     Error("Missing label name on -label",(char *) NULL);                 }                break;
             } 3           if (strncmp("linewidth",option+1,2) == 0) 
             { !               if (*option == '-')                  {                    i++;>                   if ((i == argc) || !sscanf(argv[i],"%d",&x))F                     Error("Missing size on -linewidth",(char *) NULL);                 }                break;
             } .           if (strncmp("loop",option+1,2) == 0)
             { 2               image_info.iterations=(char *) NULL;!               if (*option == '-')                  {                    i++;>                   if ((i == argc) || !sscanf(argv[i],"%d",&x))G                     Error("Missing iterations on -loop",(char *) NULL); D                   image_info.iterations=PostscriptGeometry(argv[i]);                 }                break;
             } .           Error("Unrecognized option",option);           break;	         }          case 'm': 	         { -           if (strncmp("map",option+1,3) == 0) 
             { /               global_colormap=(*option == '+'); !               if (*option == '-')                  {                    i++;                    if (i == argc)E                     Error("Missing file name on -map",(char *) NULL);                  }                break;
             } ,           if (strcmp("matte",option+1) == 0)             break;4           if (strncmp("mattecolor",option+1,6) == 0)
             { !               if (*option == '-')                  {                    i++;                    if (i == argc)H                     Error("Missing color on -mattecolor",(char *) NULL);                 }                break;
             } 2           if (strncmp("modulate",option+1,3) == 0)
             { !               if (*option == '-')                  {                    i++;H                   if ((i == argc) || !sscanf(argv[i],"%f",(float *) &x))F                     Error("Missing value on -modulate",(char *) NULL);                 }                break;
             } 4           if (strncmp("monochrome",option+1,4) == 0)
             { 5               image_info.monochrome=(*option == '-');                break;
             } .           Error("Unrecognized option",option);	         }          case 'n': 	         { 0           if (strncmp("negate",option+1,3) == 0)             break;/           if (strncmp("noise",option+1,3) == 0) 
             { !               if (*option == '+')                  {                    i++;                    if (i == argc)B                     Error("Missing type on +noise",(char *) NULL);!                   option=argv[i]; ?                   if ((Latin1Compare("uniform",option) != 0) && @                       (Latin1Compare("gaussian",option) != 0) &&F                       (Latin1Compare("multiplicative",option) != 0) &&?                       (Latin1Compare("impulse",option) != 0) && A                       (Latin1Compare("laplacian",option) != 0) && =                       (Latin1Compare("poisson",option) != 0)) A                     Error("Invalid noise type on +noise",option);                  }                break;
             } 3           if (strncmp("normalize",option+1,3) == 0)              break;.           Error("Unrecognized option",option);           break;	         }          case 'o': 	         { 0           if (strncmp("opaque",option+1,2) == 0)
             { !               if (*option == '-')                  {                    i++;                    if (i == argc)D                     Error("Missing color on -opaque",(char *) NULL);                 }                break;
             } .           Error("Unrecognized option",option);           break;	         }          case 'p': 	         { .           if (strncmp("page",option+1,3) == 0)
             { ,               image_info.page=(char *) NULL;!               if (*option == '-')                  {                    i++;                    if (i == argc)J                     Error("Missing page geometry on -page",(char *) NULL);>                   image_info.page=PostscriptGeometry(argv[i]);                 }                break;
             } /           if (strncmp("paint",option+1,3) == 0) 
             { !               if (*option == '-')                  {                    i++;>                   if ((i == argc) || !sscanf(argv[i],"%d",&x))D                     Error("Missing radius on -paint",(char *) NULL);                 }                break;
             } -           if (strncmp("pen",option+1,2) == 0) 
             { !               if (*option == '-')                  {                    i++;                    if (i == argc)A                     Error("Missing color on -pen",(char *) NULL);                  }                break;
             } 3           if (strncmp("pointsize",option+1,2) == 0) 
             { :               image_info.pointsize=atoi(DefaultPointSize);!               if (*option == '-')                  {                    i++;>                   if ((i == argc) || !sscanf(argv[i],"%d",&x))F                     Error("Missing size on -pointsize",(char *) NULL);5                   image_info.pointsize=atoi(argv[i]);                  }                break;
             } .           Error("Unrecognized option",option);           break;	         }          case 'q': 	         { 1           if (strncmp("quality",option+1,2) == 0) 
             { ;               image_info.quality=atoi(DefaultImageQuality); !               if (*option == '-')                  {                    i++;>                   if ((i == argc) || !sscanf(argv[i],"%d",&x))G                     Error("Missing quality on -quality",(char *) NULL); 3                   image_info.quality=atoi(argv[i]);                  }                break;
             } .           Error("Unrecognized option",option);           break;	         }          case 'r': 	         { /           if (strncmp("raise",option+1,2) == 0) 
             {                i++;:               if ((i == argc) || !sscanf(argv[i],"%d",&x))E                 Error("Missing bevel width on -raise",(char *) NULL);                break;
             } 0           if (strncmp("region",option+1,3) == 0)
             { !               if (*option == '-')                  {                    i++;:                   if ((i == argc) || !IsGeometry(argv[i]))G                     Error("Missing geometry on -region",(char *) NULL);                  }                break;
             } .           if (strncmp("roll",option+1,3) == 0)
             { !               if (*option == '-')                  {                    i++;:                   if ((i == argc) || !IsGeometry(argv[i]))E                     Error("Missing geometry on -roll",(char *) NULL);                  }                break;
             } 0           if (strncmp("rotate",option+1,3) == 0)
             { !               if (*option == '-')                  {                    i++;:                   if ((i == argc) || !IsGeometry(argv[i]))F                     Error("Missing degrees on -rotate",(char *) NULL);                 }                break;
             } .           Error("Unrecognized option",option);           break;	         }          case 's': 	         { 0           if (strncmp("sample",option+1,2) == 0)
             { !               if (*option == '-')                  {                    i++;:                   if ((i == argc) || !IsGeometry(argv[i]))G                     Error("Missing geometry on -sample",(char *) NULL);                  }                break;
             } /           if (strncmp("scene",option+1,3) == 0) 
             {                scene=0;!               if (*option == '-')                  {                    i++;>                   if ((i == argc) || !sscanf(argv[i],"%d",&x))J                     Error("Missing scene number on -scene",(char *) NULL);                 } "               scene=atoi(argv[i]);               break;
             } 1           if (strncmp("segment",option+1,3) == 0) 
             { !               if (*option == '-')                  {                    i++;H                   if ((i == argc) || !sscanf(argv[i],"%f",(float *) &x))I                     Error("Missing threshold on -segment",(char *) NULL);                  }                break;
             } /           if (strncmp("shade",option+1,5) == 0) 
             {                i++;:               if ((i == argc) || !sscanf(argv[i],"%d",&x))A                 Error("Missing azimuth on -shade",(char *) NULL);                break;
             } 1           if (strncmp("sharpen",option+1,5) == 0) 
             { !               if (*option == '-')                  {                    i++;H                   if ((i == argc) || !sscanf(argv[i],"%f",(float *) &x))F                     Error("Missing factor on -sharpen",(char *) NULL);                 }                break;
             } /           if (strncmp("shear",option+1,3) == 0) 
             { !               if (*option == '-')                  {                    i++;H                   if ((i == argc) || !sscanf(argv[i],"%f",(float *) &x))L                     Error("Missing shear geometry on -shear",(char *) NULL);                 }                break;
             } .           if (strncmp("size",option+1,2) == 0)
             { ,               image_info.size=(char *) NULL;!               if (*option == '-')                  {                    i++;:                   if ((i == argc) || !IsGeometry(argv[i]))E                     Error("Missing geometry on -size",(char *) NULL); *                   image_info.size=argv[i];                 }                break;
             } 2           if (strncmp("solarize",option+1,2) == 0)
             { !               if (*option == '-')                  {                    i++;>                   if ((i == argc) || !sscanf(argv[i],"%d",&x))J                     Error("Missing threshold on -solarize",(char *) NULL);                 }                break;
             } 0           if (strncmp("spread",option+1,2) == 0)
             { !               if (*option == '-')                  {                    i++;>                   if ((i == argc) || !sscanf(argv[i],"%d",&x))E                     Error("Missing amount on -spread",(char *) NULL);                  }                break;
             } /           if (strncmp("swirl",option+1,2) == 0) 
             { !               if (*option == '-')                  {                    i++;H                   if ((i == argc) || !sscanf(argv[i],"%f",(float *) &x))E                     Error("Missing degrees on -swirl",(char *) NULL);                  }                break;
             } .           Error("Unrecognized option",option);           break;	         }          case 't': 	         { 1           if (strncmp("texture",option+1,5) == 0) 
             { /               image_info.texture=(char *) NULL; !               if (*option == '-')                  {                    i++;                    if (i == argc)H                     Error("Missing filename on -texture",(char *) NULL);-                   image_info.texture=argv[i];                  }                break;
             } 3           if (strncmp("threshold",option+1,2) == 0) 
             { !               if (*option == '-')                  {                    i++;>                   if ((i == argc) || !sscanf(argv[i],"%d",&x))G                     Error("Missing value on -threshold",(char *) NULL);                  }                break;
             } 5           if (strncmp("transparent",option+1,3) == 0) 
             { !               if (*option == '-')                  {                    i++;                    if (i == argc)I                     Error("Missing color on -transparent",(char *) NULL);                  }                break;
             } 3           if (strncmp("treedepth",option+1,3) == 0) 
             { !               if (*option == '-')                  {                    i++;>                   if ((i == argc) || !sscanf(argv[i],"%d",&x))G                     Error("Missing depth on -treedepth",(char *) NULL);                  }                break;
             } .           Error("Unrecognized option",option);           break;	         }          case 'u': 	         { 4           if (strncmp("undercolor",option+1,2) == 0)
             { 2               image_info.undercolor=(char *) NULL;!               if (*option == '-')                  {                    i++;H                   if ((i == argc) || !sscanf(argv[i],"%f",(float *) &x))G                     Error("Missing undercolor geometry on -undercolor", %                       (char *) NULL); 0                   image_info.undercolor=argv[i];                 }                break;
             } .           Error("Unrecognized option",option);           break;	         }          case 'v': 	         { 1           if (strncmp("verbose",option+1,1) == 0) 
             { 2               image_info.verbose=(*option == '-');               break;
             } .           Error("Unrecognized option",option);           break;	         }          case '?': 	         {            Usage(client_name);            break;	         }          default:	         { .           Error("Unrecognized option",option);           break;	         }        }    }    if (image == (Image *) NULL)6     Error("Missing an image file name",(char *) NULL);   /*     Write images.    */E   if ((Extent(option) > 2) && ((*option == '-') || (*option == '+'))) -     MogrifyImages(&image_info,i,argv,&image); +   while (image->previous != (Image *) NULL)      image=image->previous;   if (average)     {        Image          *averaged_image;         /*          Average a set of images.       */*       averaged_image=AverageImages(image);+       if (averaged_image != (Image *) NULL) 	         {            DestroyImages(image);            image=averaged_image; 	         }      }    if (global_colormap)6     MapImages(image,(Image *) NULL,image_info.dither);-   (void) strcpy(image_info.filename,argv[i]); !   SetImageInfo(&image_info,True);    do   {      /*D       Transmogrify image as defined by the image processing options.     */+     (void) strcpy(image->filename,argv[i]);      image->scene=scene++;      if (!image_info.adjoin) +       (void) WriteImage(&image_info,image);      next_image=image->next; %     if (next_image != (Image *) NULL)        image=next_image; )   } while (next_image != (Image *) NULL); +   while (image->previous != (Image *) NULL)      image=image->previous;   if (image_info.adjoin))     (void) WriteImage(&image_info,image);    if (image_info.verbose) &     DescribeImage(image,stderr,False);
   exit(0);   return(False); } 