#include "xhtml.h"
#include "xfile.h"
#include "xheader.h"
#include "xmarkup.h"
#include "xstyles.h"
#include "xviewer.h"
#include "xtrans.h"
/*#include "xgraph.h"*/
/*
 * xhtml.c - (c) 1994 Copyright by John R. Punin
 *
 * * main. *
 * 
 *   A Simple HTML Editor  (ASHE)
 *
 *   John R. Punin            Feb - 26 - 1994
 */

/*
   ASHE is A Simple HTML Editor with the purpose to help the user to
   write HyperText Markup Language documents to be used in the World Wide Web
   project. This program is written using programming language C, NCSA HTML
   Widget and Motif Osf Windows. ASHE's visual interface was based on the 
   visual interface of XMosaic. 

   This program is based on a simple editor. Most of the main key bindings
   for emacs are implemented here with the purpose that the user can easily 
   move and edit a file without using the mouse. 

   The visual interface of the program is based on a widget hierarchy where the
   main_widget is the child of the top_level_widget. The main_widget has 
   two children a menubar and workarea. The menubar widget has all menus 
   as a children. The workarea is a paned widget with
   the purpose to let the user resize the windows any time.

   The workarea has as a main child ,the text widget, where the user is 
   going to write the HTML document. Other children are the label widgets
   to send messages to the user such as errors, title of the documents and
   name of the files.
*/
extern void _XEditResCheckMessages();

HTML_LIST *head_html=NULL;
HTML_LIST *tail_html=NULL;
MyAppResType myAppRes;
XtTranslations trans_table;

#ifndef VMS
void
#else
int
#endif
main(int argc, char **argv)
{
    XtAppContext app_context;	/* Application Context */
  
    Widget  top_level_widget;	/* Application Shell   */
    HTMLED *he=NULL,*ohe=NULL;
    
/*    
    Name_File[0]='\0';
    last_command = NONE;
    getwd(Home);  *//* Get the current Directory */

    /*
     * * Initialize toolkit
     */
    app_context = XtCreateApplicationContext();
    
    top_level_widget = XtVaAppInitialize(
					 &app_context,	/* app_context  */
					 "XHTML",	/* Class        */
					 NULL,	/* options      */
					 0,	/* num_options  */
					 &argc,	/* num cmd line */
					 argv,	/* cmd line     */
					 fallbacks,	/* fallback     */
					 NULL	/* args         */

	);

    if(argv[1]!=NULL)
    {
       int len=0;
       char pathname[STR_LEN];
       getwd(pathname);
       if(pathname) len = strlen(pathname);
       ohe = (HTMLED *)XtMalloc(sizeof(HTMLED));
       initialize_editor(ohe);
       ohe->href=XtMalloc(len+strlen(argv[1])+2);
       if(argv[1][0]!='/')
       {
	  strcpy(ohe->href,pathname);
#ifndef VMS
	  strcat(ohe->href,"/");
#endif
	  strcat(ohe->href,argv[1]);
       }
       else
	  strcpy(ohe->href,argv[1]);
       ohe->anchor_target = NULL;
    }
    else
       ohe = NULL;

    /* Getting HTML Directory Resource */
    XtGetApplicationResources(top_level_widget,&myAppRes, resources,
			      XtNumber(resources),NULL,0);

    Initialize_list();
    /* Initialize Translation Table */
    trans_table = XtParseTranslationTable(emacs_translations);

#ifndef VMS
    XtAddEventHandler(top_level_widget, (EventMask)0, True,
		      _XEditResCheckMessages, NULL);
#endif

    he = create_rest_widgets(top_level_widget,ohe);
    
    if(ohe)
    {
       XtFree(ohe->href);
       XtFree((char *)ohe);
    }
    Insert_html_frame(he);
    /*Print_Frames();*/
    he->shell = top_level_widget;

    XtRealizeWidget(top_level_widget);

    XtAppMainLoop(app_context);

}

HTMLED *create_rest_widgets(Widget shell,HTMLED *ohe)
{
   HTMLED *he=NULL;
   Widget  main_widget;	/* Main window.        */
   Widget  menubar;		/* Menu bar            */
   Widget  workarea;		/* Pane                */
   Widget  buttonbox;		/* Form                */
   Widget  html_widget;         /* HTML Widget         */
   Widget  text_output,title_output,
           file_output,textarea;
   Widget  bopen,blight,
           parag,btitle,reload,
           header,print,clear,
           undo,link,prefor,item;                /* pushbuttons.        */
   Arg     arglist[MAXARGS];
   int     narg;


   he = (HTMLED *)XtMalloc(sizeof(HTMLED));
   initialize_editor(he);

   
       /* We are going to use a Motif MainWindow Widget here. */

    main_widget = XtVaCreateManagedWidget("main", xmMainWindowWidgetClass, 
					  shell, NULL);

    /*
     * The Motif Menubar. * See the CreateMenubar function for all the steps
     */
    menubar= CreateMenuBar(main_widget,he);

    /*
     * * Create the Paned Widget
     */
    workarea = XtVaCreateManagedWidget("workarea", xmPanedWindowWidgetClass, 
				       main_widget, NULL);

    /*
     *  Create Text widget for messages
     */

    text_output = XtVaCreateManagedWidget("text_out",
					  xmLabelWidgetClass,workarea,
					  XmNshadowThickness, 0,
					  NULL);

    XtManageChild(text_output);
    he->text_output = text_output;

    title_output = XtVaCreateManagedWidget("title_out",
					  xmLabelWidgetClass,workarea,
					  NULL);

    XtManageChild(title_output);	  
   
    he->title_output = title_output;
    /*
     * * Create the Text child, and the button children.
     */

    narg = 0;
    XtSetArg(arglist[narg],XmNrows ,20 ); narg++;
    XtSetArg(arglist[narg],XmNcolumns ,80 ); narg++;
    XtSetArg(arglist[narg],XmNresizeWidth ,False ); narg++;
    XtSetArg(arglist[narg],XmNresizeHeight ,False ); narg++;
    XtSetArg(arglist[narg],XmNscrollingPolicy ,XmAUTOMATIC ); narg++;
    XtSetArg(arglist[narg],XmNeditMode ,XmMULTI_LINE_EDIT ); narg++;

    
    textarea = XmCreateScrolledText(workarea,"text",arglist,narg);
    XtOverrideTranslations(textarea,trans_table);
    XtManageChild(textarea);

    he->textarea = textarea;
    html_widget = CreateHTMLwidget(workarea,he);

    he->html_text = html_widget;

    file_output = XtVaCreateManagedWidget("file_out",
					   xmLabelWidgetClass,workarea,
					   NULL);


    XtManageChild(file_output);
    he->file_output = file_output;

   /* Setting the new window */
/*    if((ohe == NULL)||
       (!strcmp(ohe->href,SCRATCHFILE)))*/ /* Problem with Linux */

   narg = 0;
   if(ohe == NULL)
      narg = 1;
   else if (!strcmp(ohe->href,SCRATCHFILE))
      narg = 1;

   if(narg)
    {
       Set_label(text_output,"ASHE (A Simple HTML Editor)");
       Set_label(title_output,"");
       XmTextSetString(textarea,XTEXT_STRING);
       Set_label(file_output,SCRATCHFILE);
    }
    else
    {
       if(ohe->anchor_target != NULL)
       {
	  he->anchor_target = XtMalloc(strlen(ohe->anchor_target)+1);
	  strcpy(he->anchor_target,ohe->anchor_target);
       }
       read_file(ohe->href,he);
    }
    
    /*
     * * Create the form to hold the file, save, clear and print buttons.
     */
    buttonbox = XmCreateForm(workarea, "buttonbox", NULL, 0);
    XtManageChild(buttonbox);
    XtVaSetValues(buttonbox,XmNuserData,he,NULL);

    print = XmCreatePushButton(buttonbox, "print", NULL, 0);
    XtManageChild(print);
    clear = XmCreatePushButton(buttonbox, "clear", NULL, 0);
    XtManageChild(clear);
    bopen = XmCreatePushButton(buttonbox, "open", NULL, 0);
    XtManageChild(bopen);
    reload = XmCreatePushButton(buttonbox, "reload", NULL, 0);
    XtManageChild(reload);
    btitle =XmCreatePushButton(buttonbox, "title", NULL, 0);
    XtManageChild(btitle); 
    parag =XmCreatePushButton(buttonbox, "paragraph", NULL, 0);
    XtManageChild(parag); 
    header = XmCreatePushButton(buttonbox, "header", NULL, 0);
    XtManageChild(header);
    link = XmCreatePushButton(buttonbox, "link", NULL, 0);
    XtManageChild(link);
    prefor = XmCreatePushButton(buttonbox, "prefor", NULL, 0);
    XtManageChild(prefor);
    item = XmCreatePushButton(buttonbox, "item", NULL, 0);
    XtManageChild(item);
    undo = XmCreatePushButton(buttonbox, "undo", NULL, 0);
    XtManageChild(undo);
    blight = XmCreateToggleButton(buttonbox, "mark_tags", NULL, 0);
    XtVaSetValues(blight,
		  XtVaTypedArg,XmNlabelString,XmRString,"mark tags",10,NULL);
    XtManageChild(blight);

    /* Tell the buttons how to position themselves in the form. */


    XtVaSetValues(clear, XmNleftAttachment, XmATTACH_WIDGET, 
		  XmNleftWidget, print, NULL);
    XtVaSetValues(bopen, XmNleftAttachment, XmATTACH_WIDGET, 
		  XmNleftWidget, clear, NULL);
    XtVaSetValues(reload, XmNleftAttachment, XmATTACH_WIDGET, 
		  XmNleftWidget, bopen, NULL);
    XtVaSetValues(btitle, XmNleftAttachment, XmATTACH_WIDGET, 
		  XmNleftWidget, reload,NULL);
    XtVaSetValues(parag, XmNleftAttachment, XmATTACH_WIDGET, 
		  XmNleftWidget, btitle, NULL);
    XtVaSetValues(header, XmNleftAttachment, XmATTACH_WIDGET, 
		  XmNleftWidget, parag, NULL);
    XtVaSetValues(link, XmNleftAttachment, XmATTACH_WIDGET, 
		  XmNleftWidget, header, NULL);
    XtVaSetValues(prefor, XmNleftAttachment, XmATTACH_WIDGET, 
		  XmNleftWidget, link, NULL);
    XtVaSetValues(item, XmNleftAttachment, XmATTACH_WIDGET, 
		  XmNleftWidget, prefor, NULL);
    XtVaSetValues(undo, XmNleftAttachment, XmATTACH_WIDGET, 
		  XmNleftWidget, item, NULL);
    XtVaSetValues(blight, XmNleftAttachment, XmATTACH_WIDGET, 
		  XmNleftWidget, undo, NULL);


    /* Add the callback to verify the input to the text */
    XtAddCallback(textarea, XmNmodifyVerifyCallback, 
		  (XtCallbackProc)verify_text, (XtPointer)he);
    XtAddCallback(textarea,XmNlosingFocusCallback,(XtCallbackProc)Setmenu,
		  (XtPointer)he);
    /*XtAddCallback(textarea,XmNfocusCallback,(XtCallbackProc)gain_focus,NULL);*/

    XtAddCallback(html_widget, WbNanchorCallback, (XtCallbackProc)anchor_call,
		  (XtPointer)he);


    /* Add the callbacks */

    XtAddCallback(print, XmNactivateCallback, 
		  (XtCallbackProc)PrintButtonCallBack,(XtPointer)he);

    XtAddCallback(clear, XmNactivateCallback, 
		  (XtCallbackProc)ClearButtonCallBack,(XtPointer)he);

    XtAddCallback(bopen, XmNactivateCallback, (XtCallbackProc)file_cb,
		  (XtPointer)1);

    XtAddCallback(reload, XmNactivateCallback,(XtCallbackProc) Reload_HTML,
		  (XtPointer)he);

    XtAddCallback(btitle, XmNactivateCallback, (XtCallbackProc)create_title,
		  (XtPointer)he);

    XtAddCallback(parag, XmNactivateCallback, (XtCallbackProc)create_paragraph,
		  (XtPointer)he);

    XtAddCallback(header, XmNactivateCallback, (XtCallbackProc)create_header,
		  (XtPointer)he);

    XtAddCallback(link, XmNactivateCallback, (XtCallbackProc)create_linker,
		  (XtPointer)he);

    XtAddCallback(prefor, XmNactivateCallback, (XtCallbackProc)create_pre,
		  (XtPointer)he);

    XtAddCallback(item, XmNactivateCallback, (XtCallbackProc)set_simple_entry,
		  (XtPointer)he);

    XtAddCallback(undo, XmNactivateCallback, (XtCallbackProc)create_undo,
		  (XtPointer)he);

    XtAddCallback(blight, XmNvalueChangedCallback,
		  (XtCallbackProc)Set_Underline_Tags,(XtPointer)he);

    /* Tell the MainWindow how to position its children */
    XmMainWindowSetAreas(main_widget, menubar, NULL, NULL, NULL,
			 workarea);

   return(he);
}

void initialize_editor(HTMLED *he)
{
   he->shell = NULL;
   he->textarea = NULL;
   he->file_output = NULL;
   he->text_output = NULL;
   he->title_output = NULL;
   he->html_text = NULL;
   he->shell_graph = NULL;
   he->shell_tree = NULL;
   he->shell_html_view = NULL;
   he->editwidget = NULL;
   he->open_dialog = NULL;
   he->save_dialog = NULL;
   he->insert_dialog = NULL;
   he->export_dialog = NULL;
   he->user_data = NULL;
   he->header_num = 0;
   he->fonts = TIMES;
   he->export_option = PTEXT;
   he->modified_file=FALSE;
   he->toggle_mark_tag = FALSE;
   he->load_image = FALSE;
   he->table_support = FALSE;
   he->method = GET;
   he->last_command = NONE;
   strcpy(he->Name_File,SCRATCHFILE);
   he->format_file = NULL;
   he->warning = NULL;
   he->href = NULL;
   he->anchor_target = NULL;
   he->text_cleared = NULL;
   he->undo_buffer.ubuffer[0] = '\0';
   he->undo_buffer.right = 0;
   he->undo_buffer.left = 0;
   he->undo_buffer.lenleft =0;
   he->undo_buffer.lenright = 0;
   he->undo_buffer.com_html = NONE;
}


void 
gain_focus(Widget w, XtPointer cld, XtPointer cd)
{
   XmTextShowPosition(w,XmTextGetCursorPosition(w));
}

void 
Initialize_list(void)
{
   head_html = (HTML_LIST *)XtMalloc(sizeof(HTML_LIST));
   tail_html = (HTML_LIST *)XtMalloc(sizeof(HTML_LIST));
   head_html->fr = NULL;
   tail_html->fr = NULL;
   head_html->next = tail_html;
   tail_html->next = NULL;
}
