.TH XScreenSaver 1 "7-mar-93" "X Version 11"
.SH NAME
maze \- an automated X11 demo repeatedly creating and solving a random maze
.SH SYNOPSIS
.B maze 
[\-display \fIhost:display.screen\fP] [\-foreground \fIcolor\fP] [\-background \fIcolor\fP] [\-window] [\-root] [\-install] [\-visual \fIvisual\fP] [\-grid\-size \fIpixels\fP] [\-live\-color \fIcolor\fP] [\-dead\-color \fIcolor\fP] [\-solve\-delay \fIusecs\fP] [\-pre\-delay \fIusecs\fP] [\-post\-delay \fIusecs\fP]
.SH DESCRIPTION
The \fImaze\fP program creates a "random" maze and then solves it with 
graphical feedback. 
.SH OPTIONS
.I maze
accepts the following options:
.TP 8
.B \-window
Draw on a newly-created window.  This is the default.
.TP 8
.B \-root
Draw on the root window.
.TP 8
.B \-install
Install a private colormap for the window.
.TP 8
.B \-visual \fIvisual\fP
Specify which visual to use.  Legal values are the name of a visual class,
or the id number (decimal or hex) of a specific visual.
.TP 8
.B \-grid\-size \fIpixels\fP
The size of each block of the maze, in pixels; default is 0, meaning
pick a random grid size.
.TP 8
.B \-live\-color \fIcolor\fP
The color of the path.
.TP 8
.B \-dead\-color \fIcolor\fP
The color of the failed path (it is also stippled with a 50% pattern.)
.TP 8
.B \-solve\-delay \fIinteger\fP
Delay (in microseconds) between each step of the solution path.
Default 5000, or about 1/200th second.
.TP 8
.B \-pre\-delay \fIinteger\fP
Delay (in microseconds) between generating a maze and starting to solve it.
Default 2000000 (2 seconds.)
.TP 8
.B \-post\-delay \fIinteger\fP
Delay (in microseconds) after solving a maze and before generating a new one.
Default 4000000 (4 seconds.)
.PP
Clicking the mouse in the maze window controls it.
.TP 16
.B "LeftButton
Clears the window and restarts maze.
.TP 16
.B MiddleButton
Pause or unpause the program.
.TP 16
.B RightButton
Exit.
.SH BUGS
Expose events force a restart of maze.

Mouse actions are based on "raw" values (Button1, Button2 and Button3)
instead of using the pointer map.
.SH ENVIRONMENT
.PP
.TP 8
.B DISPLAY
to get the default host and display number.
.TP 8
.B XENVIRONMENT
to get the name of a resource file that overrides the global resources
stored in the RESOURCE_MANAGER property.
.SH SEE ALSO
.BR X (1),
.BR xscreensaver (1)
.SH COPYRIGHT
.PP
Copyright \(co 1988 by Sun Microsystems, Inc. Mountain View, CA.
.PP  
All Rights Reserved
.PP
Permission to use, copy, modify, and distribute this software and its
documentation for any purpose and without fee is hereby granted, provided that
the above copyright notice appear in all copies and that both that copyright
notice and this permission notice appear in supporting documentation, and that
the names of Sun or MIT not be used in advertising or publicity pertaining to
distribution of the software without specific prior written permission. Sun
and M.I.T.  make no representations about the suitability of this software for
any purpose. It is provided "as is" without any express or implied warranty.
.PP
SUN DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING ALL
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE. IN
NO EVENT SHALL SUN BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL
DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING
OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
.SH AUTHOR(s)
.nf
Jim Randell	[ XScreenSaver version ] jmr@mddjmr.fc.hp.com
  HPLabs, Bristol
Richard Hess	[ X11 extensions ]  	{...}!uunet!cimshop!rhess
  Consilium, Mountain View, CA
Dave Lemke	[ X11 version ]		lemke@sun.COM
  Sun MicroSystems, Mountain View, CA
Martin Weiss	[ SunView version ]
  Sun MicroSystems, Mountain View, CA
.fi
