/* --------------------------------- device.c ------------------------------- */

/* This is part of the flight simulator 'fly8'.
 * Author: Eyal Lebedinsky (eyal@ise.canberra.edu.au).
*/

/* Top level for display-device drivers
*/

#include "fly.h"


extern struct GrDriver NEAR* FAR GrDrivers[];

extern int FAR
GrPrintf (const char *fmt, ...)
{
	va_list	ap;
	int	i;
	char	*p;
	static char _Gbuf[256];

	va_start (ap, fmt);
	i = vsprintf (_Gbuf, fmt, ap);
	va_end (ap);

	for (p = _Gbuf; *p; ++p)
		Gr->TextPut (*p);
	sys_poll ();			/* text is often slow */
	return (i);
}

extern int FAR
GrNote (const char *fmt, ...)
{
	va_list	ap;
	int	i;
	char	*p;
	static char _Gbuf[256];

	va_start (ap, fmt);
	i = vsprintf (_Gbuf, fmt, ap);
	va_end (ap);

	if (st.flags & SF_INTERACTIVE) {
		Gr->PushTextPos ();
		Gr->SetTextPos (2, 1);
	}

	for (p = _Gbuf; *p; ++p)
		Gr->TextPut (*p);

	if (st.flags & SF_INTERACTIVE)
		Gr->PopTextPos ();

	sys_poll ();			/* text is often slow */
	return (i);
}

extern DEVICE * FAR
devices_select (char *dname)
{
	int	xmode;
	char	*p;
	DEVICE	*dev;

	if (vm_read ())
		return (0);

	if (dname == 0)			/* return default */
		return (Gr->devices);

	xmode = 0;
	p = strchr (dname, '=');
	if (p) {		/* "xx=dname" */
		if (1 != sscanf (dname, "%x=", &xmode))
			goto badret;
		dname = p+1;
	}

	for (dev = Gr->devices; dev; dev = dev->next)
		if (!stricmp (dev->name, dname)) {
			if (xmode)
				dev->mode = xmode;
			return (dev);
		}
badret:
	vm_free ();
	return (0);
}

extern void FAR
devices_release (void)
{
	vm_free ();
}

extern struct GrDriver NEAR* FAR
devices_init (char *name)
{
	struct GrDriver	NEAR* FAR* p;
	char		*options;
	int		n;

	p = GrDrivers;
	if (name) {
		options = strchr (name, ':');
		if (T(options = strchr (name, ':')))
			n = options - name;
		else
			n = strlen (name);

		for (; *p; ++p)
			if (!strnicmp ((*p)->name, name, n) && !(*p)->name[n])
				break;
	}
	return (*p);
}

extern void FAR
devices_term (void)
{
	if (!Gr)
		return;

	devices_release ();
	Gr = 0;
}
