/* --------------------------------- obroken.c ------------------------------ */

/* This is part of the flight simulator 'fly8'.
 * Author: Eyal Lebedinsky (eyal@ise.canberra.edu.au).
*/

/* object: broken.
*/

#include "fly.h"


static SHAPE shape_broken = {
	0,
	0,
	SH_G,
	10*1000L,	/* weight */
	0		/* drag */
};

static int FAR
init_broken (BODY *b)
{
	if (shape_read (&shape_broken, "broken"))
		return (1);
	return (0);
}

static void FAR
term_broken (BODY *b)
{
	shape_free (shape_broken.v);
}

static int FAR
create_broken (OBJECT *p)
{
	if (!st.owner)
		return (1);

	p->color = st.green;
	p->time = (Frand()%TIMEPSEC)*2 + TIMEPSEC;
	p->flags |= F_VISIBLE;
	p->owner   = st.owner;
	p->ownerid = st.owner->id;
	p->damage = 1;
	p->damaging = 1;
	if (st.owner->flags & F_IMPORTED) {
		p->flags |= F_IMPORTED;
		p->rplayer = st.owner->rplayer;
	}
	LVcopy (p->R, st.owner->R);
	Mident (p->T);
	return (0);
}

BODY BoBroken = {
	0,
	0,
	"BROKEN",
	&shape_broken,
	init_broken,
	term_broken,
	create_broken,
	body_delete,
	body_dynamics,
	body_hit
};
