/* --------------------------------- term.c --------------------------------- */

/* This is part of the flight simulator 'fly8'.
 * Author: Eyal Lebedinsky (eyal@ise.canberra.edu.au).
*/

/* shutdown code.
*/

#include "fly.h"


#define LFRAC_RES	1000L

static char * NEAR
lfrac (long a, long b)
{
	int		s, f;
	long		l;
	static char	buf[20];

	if (a < 0x7fffffffL/100L)
		l = a * 100L / b;
	else if (b >= 100L)
		l = a / (b / 100L);
	else
		return ("999.999");			/* see LFRAC_RES */
	if (l) {
		if (T(s = l < 0)) {
			f = (int)((-l)%LFRAC_RES);
			l = -((-l)/LFRAC_RES);
		} else {
			f = (int)(l%LFRAC_RES);
			l = l/LFRAC_RES;
		}
		if (s && !l)
			sprintf (buf, "  -0.%03d", f);	/* see LFRAC_RES */
		else
			sprintf (buf, "%4ld.%03d", l, f); /* see LFRAC_RES */
		return (buf);
	} else
		return ("0");
}
#undef LFRAC_RES

extern void FAR
terminate (int StackUsed)
{
	Ulong		lt;
	struct netname	*nn;
	static int	depth = 0;

	if (++depth > 4)	/* must be looping, can't tell the world :-( */
		return;

	log_flush (1);

	st.flags &= ~SF_INITED;

	if (Tm) {
		lt = st.present / 1000L;
		LogPrintf ("Time     %lu:%02lu\n", lt/60L, lt%60L);
	}

	if (st.stats[31]) {
		LogPrintf ("nFrames  %lu\n", st.stats[31]);
		LogPrintf ("Elapsed  %s\n", lfrac (st.stats[32], st.stats[31]));
		LogPrintf ("Video    %s\n", lfrac (st.stats[33], st.stats[31]));
		LogPrintf ("3D       %s\n", lfrac (st.stats[34], st.stats[31]));
		LogPrintf ("2D       %s\n", lfrac (st.stats[36], st.stats[31]));
		LogPrintf ("Simulate %s\n", lfrac (st.stats[35], st.stats[31]));
		LogPrintf ("PageFlip %s\n", lfrac (st.stats[37], st.stats[31]));
		LogPrintf ("Balance  %s\n", lfrac (st.stats[32]-st.stats[33]
			-st.stats[34]-st.stats[35]-st.stats[36]-st.stats[37],
			st.stats[31]));
	}

	stats_show ();

	nav_term ();

	remote_term ();

	if (CC)
		LogPrintf ("score    %u\n", (int)CC->score);
	CV = CC = 0;

	list_clear (&CO);

	land_term ();

	LogPrintf ("bullets  %lu\n", st.nbullets);

	LogPrintf ("last obj %lu\n", st.object_id);

	bodies_term ();

	buffers_free ();

	pointers_term ();

	funcs_term ();

	if (Snd) {
		Snd->Term ();
		sound_term ();
		Snd = &SndNone;
	}

	mac_term ();

	if (Kbd) {
		Kbd->Term ();
		keyboard_term ();
		Kbd = &KbdNone;
	}

	DEL0 (CW);
	DEL0 (CP);
	if (CS) {
		if (CS->device) {
			if (Gr) {
				if (st.misc[7])
					Gr->Shutters (-2);	/* turn off */

				if (CT) {
				    Gr->CloseTextWindow (CT);
				    DEL0 (CT);
				}
				Gr->Term (CS->device);
			}
			CS->device = 0;
		}
		DEL0 (CS);
	}

	windows_term ();

	devices_release ();
	devices_term ();

	st.iname = xfree (st.iname);
	st.mname = xfree (st.mname);
	st.fname = xfree (st.fname);
	st.vmdname = xfree (st.vmdname);
	st.navname = xfree (st.navname);
	st.lndname = xfree (st.lndname);
	st.fdir = xfree (st.fdir);
	st.ptrname = xfree (st.ptrname);
	st.grname = xfree (st.grname);
	st.grmname = xfree (st.grmname);
	st.sndname = xfree (st.sndname);
	st.kbdname = xfree (st.kbdname);
	st.nikname = xfree (st.nikname);
	st.teamname = xfree (st.teamname);
	st.homename = xfree (st.homename);
	st.timeropts = xfree (st.timeropts);
	st.ptype = xfree (st.ptype);
	st.dtype = xfree (st.dtype);

	for (nn = st.netnames; nn;) {
		xfree (nn->name);
		nn = DEL (nn);
	}

	if (st.flags & SF_SKY)
		sky_term ();

	msg_term ();

	memory_term ();

	LogPrintf ("stack used: %d bytes\n", StackUsed);
	LogPrintf ("Fly8 end: %s\n", Tm->Ctime ());

	log_term ();
	st.lname = xfree (st.lname);

	if (Tm) {
		Tm->Term ();
		Tm = &TmNone;
	}

	if (Sys) {
		Sys->Term ();
		Sys = &SysNone;
	}
	--depth;
}

extern void FAR
die (void)
{
	st.flags &= ~(SF_INITED|SF_INTERACTIVE);
	LogPrintf ("Aborting...\n");
	terminate (0);
	exit (1);
}
