.TH XSNOW 1 "Release 4" "X Version 11"
.SH NAME
xsnow \- create a snowy and Santa-y desktop
.SH SYNOPSIS
.B xsnow
[-option .,..]
.SH DESCRIPTION
Xsnow displays lovely moving snowflakes on your desktop.
.SH OPTIONS
.TP 8
-display display_name
Drop the snowflakes on the given display. Make sure the display is nearby, so you
can hear them enjoy...
.TP 8
-snowflakes num_snowflakes
This is the number of snowflakes. Default is 100, max is 1000.
.TP 8
-sc snowflake_color
Use the given string as the color for the flakes instead of the default "snow".
.TP 8
-bg background_color
Use the given string as the color for the background. Note that the usual
default desktop pattern consisting of 50% white 50% black doesn't 
particularly look good with Xsnow. 
.TP 8
-tc tree_color
Use the given string as the color for the trees. 
.TP 8
-slc sleigh_color
Use the given string as the color for the sleigh. Note that the default
color is black, so not much of Santa will be seen on a black background.
.TP 8
-santa santa_size
There are 3 sizes of Santa: 0, 1 and 2. Default is 1.
.TP 8
-santaspeed santa_speed
The speed Santa should not exceed if he doesn't want to get fined. 
The default speed for Santa size 0 is 1, for Santa 1 it's 2 and for 
Big Santa it's 4.
.TP 8
-delay delay
This is the number of milliseconds delay after updating everything.
Default is 50 milliseconds, i.e. 20 updates per second max.
.TP 8
-unsmooth
.br
If you specify this option the snowflakes will 'whirl' more dramatically,
resulting in a somewhat jerkier movement.
.TP 8 
-whirl
This sets the whirl factor, i.e. the maximum adjustment of the horizontal 
speed. The default value is 4.
.TP 8
-nowind
Default it gets windy now and then. If you prefer it quiet specify -nowind.
.TP 8
-windtimer period
With -windtimer you can specify how often it gets windy. It's sort of a
period in seconds, default value is 30.
.TP 8
-xspeed -yspeed
These options set the maximum horizontal and vertical speed. The default X
maximum speed is 4, the default maximum Y speed is 8.
.TP 8
-wsnowdepth -ssnowdepth
This sets the maximum thickness of the snow on top of windows and
at the bottom of the display respectively. The default snowdepth for 
windows is 8, at the bottom of the screen the default is 50.
.TP 8
-notrees 
Do not display the trees.
.TP 8
-nosanta
Do not display Santa Claus running all over the screen.
.TP 8
-norudolf
No Rudolf.
.TP 8
-nokeepsnow
Do not have snow sticking anywhere.
.TP 8
-nokeepsnowonwindows
Do not keep snow on top of the windows.
.TP 8
-nokeepsnowonscreen
Do not keep snow at the bottom of the screen.
.TP 8
-version
Prints the current Xsnow version.
.SH EXAMPLES
.TP 8
xsnow -bg LightSkyBlue3 -sc snow  
.br 
Sets the background to a bluish color and lets it snow white.
.TP 8
xsnow -ssnowdepth 100
Starts with a thin layer of snow that gradually builds up at the bottom 
of the screen.
.TP 8
xsnow -santa 2 -santaspeed 10
Gives you the biggest Santa at a speed that is hardly legal.
.TP 8
xsnow -delay 100 -notrees
For slow systems use longer delay and don't draw the trees.
.TP 8
xsnow -snowflakes 1000 -delay 0
.br 
Uses the maximum number of snowflakes and runs as fast as possible.
.SH FILES
See /usr/lib/X11/rgb.txt for the list of colors and their respective 
poetic names, like Chartreuse and LightSkyBlue3.
.SH BUGS
See xroach(1)
.SH COPYRIGHT
Copyright 1984, 1988, 1990, 1993 by Rick Jansen (rick@sara.nl)

Some code borrowed from xroach by J.T. Anderson (jta@locus.com)

Xsnow uses vroot.h for use with virtual window managers. 
vroot.h is copyright 1991 by Andreas Stolcke, copyright 1990 by
Solbourne Computer Inc. (stolcke@ICSI.Berkeley.EDU)

The big Santa with the nice moving antlers and reins  was made by
Holger Veit (Holger.Veit@gmd.de).

The idea and code for wind are from Eiichi TAZOE (tazoe@sfc.keio.cp.jp).
.SH AUTHORS
Rick Jansen (rick@sara.nl)
.SH "SEE ALSO"
snowplough(1), your_travel_agent(1)
.SH NOTES
Xsnow itself doen't use very much CPU time, but it can load the X server
and/or network quite substantially. Use less snowflakes and a bigger delay
in such a case. On a standalone workstation there usually will not be 
be any problem.
