///////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////
//         This example code is from the book:
//
//           Object-Oriented Programming with C++ and OSF/Motif
//         by
//           Douglas Young
//           Prentice Hall, 1992
//           ISBN 0-13-630252-1	
//
//         Copyright 1991 by Prentice Hall
//         All Rights Reserved
//
//  Permission to use, copy, modify, and distribute this software for 
//  any purpose except publication and without fee is hereby granted, provided 
//  that the above copyright notice appear in all copies of the software.
///////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////


/////////////////////////////////////////////////////////
// Message.C: Manages a message panel, 
//            using an XmLabel widget
/////////////////////////////////////////////////////////
#include "Message.h"
#include <Xm/Xm.h>
#include <Xm/Label.h>
#include <assert.h>

Message::Message ( Widget parent, char * name ) : UIComponent( name )
{
    _w = XmCreateLabel ( parent, _name, NULL, 0 );
    installDestroyHandler();
    postMessage ( " " );  // Clear the widget
}


void Message::postMessage ( char *msg )
{
    assert ( _w );
    
    // Convert the character string to a compound string for Motif
    
    XmString xmstr = XmStringCreateSimple ( msg );
    
    // Display the new label
    
    XtVaSetValues ( _w, XmNlabelString, xmstr, NULL ); 
    
    // XmLabel copies the string, so we can free our copy
    
    XmStringFree ( xmstr );
}

void Message::postAlert ( char *msg )
{
    assert ( _w );  // Must have a widget to display message
    
    if ( msg )
	postMessage ( msg );  // Display the string
    
    // Sound a bell as an alert. 
    
    XBell ( XtDisplay ( _w ), 100 );
}




