///////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////
//         This example code is from the book:
//
//           Object-Oriented Programming with C++ and OSF/Motif, 2nd Edition
//         by
//           Douglas Young
//           Prentice Hall, 1995
//           ISBN 0-13-20925507
//
//         Copyright 1995 by Prentice Hall
//         All Rights Reserved
//
//  Permission to use, copy, modify, and distribute this software for 
//  any purpose except publication and without fee is hereby granted, provided 
//  that the above copyright notice appear in all copies of the software.
///////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////


  //////////////////////////////////////////////////////////
  // MenuBar.C: A menubar whose panes support items
  //             that execute Cmd's
  //////////////////////////////////////////////////////////
  #include "MenuBar.h"
  #include "Cmd.h"
  #include "CmdList.h"
  #include "ButtonInterface.h"
  #include <Xm/RowColumn.h>
  #include <Xm/CascadeB.h>
  
  MenuBar::MenuBar ( const char *name, Widget parent ) : UIComponent ( name )
  {
      // Base widget is a Motif menubar widget
      
      _w = XmCreateMenuBar ( parent, _name, NULL, 0 );
      installDestroyHandler();
  }
  void MenuBar::createPulldown ( Widget parent, CmdList *list )
  {
      int    i;
      Widget pulldown, cascade;
      
      // Create a pulldown menu pane for this list of commands
      
      pulldown = XmCreatePulldownMenu ( parent, 
                                       (char *) list->name(), NULL, 0 );
      
      // Each entry in the menubar must have a cascade button
      // from which the user can pull down the pane
      
      cascade = XtVaCreateManagedWidget ( (char *) list->name(), 
                                          xmCascadeButtonWidgetClass,
                                          parent, 
                                          XmNsubMenuId, pulldown, NULL );
  
      // Loop through the cmdList, creating a menu 
      // entry for each command
      
      for ( i = 0; i < list->size(); i++)
      {
           	if ( (*list)[i]->type() == Cmd::List )
  	             createPulldown ( pulldown, (CmdList*) (*list)[i] );
           
           	else if ( (*list)[i]->type() == Cmd::Action )
           	{
  	             CmdInterface *ci;
  	             ci  = new ButtonInterface ( pulldown, (*list)[i] );
  	             ci->manage();
  	         }
      }
  }
  void MenuBar::addCommands ( CmdList *list )
  {
      createPulldown ( _w, list );
  }
  
