///////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////
//         This example code is from the book:
//
//           Object-Oriented Programming with C++ and OSF/Motif, 2nd Edition
//         by
//           Douglas Young
//           Prentice Hall, 1995
//           ISBN 0-13-20925507
//
//         Copyright 1995 by Prentice Hall
//         All Rights Reserved
//
//  Permission to use, copy, modify, and distribute this software for 
//  any purpose except publication and without fee is hereby granted, provided 
//  that the above copyright notice appear in all copies of the software.
///////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////



  ///////////////////////////////////////////////////////////////////
  // MenuWindow.h: Add a menubar to the features of MainWindow
  ///////////////////////////////////////////////////////////////////
  #ifndef MENUWINDOW_H
  #define MENUWINDOW_H
  #include "MainWindow.h"
  class MenuBar;
 
  class MenuWindow : public MainWindow {
  
    public:
      
      MenuWindow ( const char *name ); 
      virtual ~MenuWindow();
    protected:
  
      MenuBar *_menuBar;
      
      virtual void initialize();           // Called by Application
      virtual void createMenuPanes() = 0;  // Defined by derived
                                           // classes to specify the
                                           // contents of the menu
  };
  #endif


