///////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////
//         This example code is from the book:
//
//           Object-Oriented Programming with C++ and OSF/Motif, 2nd Edition
//         by
//           Douglas Young
//           Prentice Hall, 1995
//           ISBN 0-13-20925507
//
//         Copyright 1995 by Prentice Hall
//         All Rights Reserved
//
//  Permission to use, copy, modify, and distribute this software for 
//  any purpose except publication and without fee is hereby granted, provided 
//  that the above copyright notice appear in all copies of the software.
///////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////



  /////////////////////////////////////////////////////////////
  // NoUndoCmd.C: Base class for all commands without undo
  /////////////////////////////////////////////////////////////
  #include "NoUndoCmd.h"
 
  #define FALSE 0
 
  NoUndoCmd::NoUndoCmd ( const char *name, 
                         int         active ) :  Cmd ( name, active )
  {
      _hasUndo = FALSE; //  Derived classes have no undo
  }

void NoUndoCmd::undoit()
  {
      // Empty
  }
