///////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////
//         This example code is from the book:
//
//           Object-Oriented Programming with C++ and OSF/Motif, 2nd Edition
//         by
//           Douglas Young
//           Prentice Hall, 1995
//           ISBN 0-13-20925507
//
//         Copyright 1995 by Prentice Hall
//         All Rights Reserved
//
//  Permission to use, copy, modify, and distribute this software for 
//  any purpose except publication and without fee is hereby granted, provided 
//  that the above copyright notice appear in all copies of the software.
///////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////
 // SimpleList.C: A Simple List Template
 ///////////////////////////////////////////////////////
 #include "SimpleList.h"
 #include <X11/Intrinsic.h>
 
 template <class T>
 SimpleList<T>::SimpleList()
 {
      _size = 0;   // Initialize the array
      _data = NULL;
  }
  
  
  
  template <class T>
  SimpleList<T>::~SimpleList()
  {
      XtFree ( ( char *) _data ); 
  }
  
  
  
  template <class T>
  void SimpleList<T>::add(T t)
  {
      // Allocate the array to be one larger than its current size
  
      _data = (T*) XtRealloc ( (char *) _data, sizeof(T) * ( _size + 1 ) );
     
      // Add the new element to the end of the list
  
      _data[_size++] = t;
  }
  
  
  
  template <class T>
  void SimpleList<T>::remove(T t)
  {
      // First, find the item on the list.
  
      for ( int i = 0; i < _size; i++ )
      	    if ( _data[i] == t )
      	    {     
              // Once found, decrease the size of the list,
              // and move all remaining items in the list up one space.
  
  	            _size--;
  	    
  	            for ( int j = i; j < _size; j++ )
  		                _data[j] = _data[j+1];
  
              // Reduce the size of the list.
  		
  	            _data = (T*) XtRealloc ( (char *) _data, sizeof(T) * _size );
  
  	            return;
  	        }
  }
