///////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////
//         This example code is from the book:
//
//           Object-Oriented Programming with C++ and OSF/Motif, 2nd Edition
//         by
//           Douglas Young
//           Prentice Hall, 1995
//           ISBN 0-13-20925507
//
//         Copyright 1995 by Prentice Hall
//         All Rights Reserved
//
//  Permission to use, copy, modify, and distribute this software for 
//  any purpose except publication and without fee is hereby granted, provided 
//  that the above copyright notice appear in all copies of the software.
///////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////


  ////////////////////////////////////////////////////////////////
  // TextView.h: Abstract base class for all text (numerical)
  //             views of a ColorModel
  ////////////////////////////////////////////////////////////////
  #ifndef TEXTVIEW_H
  #define TEXTVIEW_H
  #include "ColorView.h"
 
  class TextView : public ColorView {
      
    public:
      
      TextView ( const char *, Widget );
      virtual const char *const className() { return ( "TextView" ); }
  
    protected:
      
      Widget _field1;    // An output area
      Widget _field2;
      Widget _field3;
  
      Widget _label1;    // Labels for each output area
      Widget _label2;
      Widget _label3;
  };
  
  #endif
