///////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////
//         This example code is from the book:
//
//           Object-Oriented Programming with C++ and OSF/Motif, 2nd Edition
//         by
//           Douglas Young
//           Prentice Hall, 1995
//           ISBN 0-13-20925507
//
//         Copyright 1995 by Prentice Hall
//         All Rights Reserved
//
//  Permission to use, copy, modify, and distribute this software for 
//  any purpose except publication and without fee is hereby granted, provided 
//  that the above copyright notice appear in all copies of the software.
///////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////


/////////////////////////////////////////////////////////////
// WordCountWindow.h: Count the frequency of each word
//                    in a text file, as a test of the
//                    InterruptibleCmd class
/////////////////////////////////////////////////////////////
#ifndef WORDCOUNTWINDOW_H
#define WORDCOUNTWINDOW_H
#include "MenuWindow.h"
class InterruptibleCmd;
class CountWordsCmd;

class WordCountWindow : public MenuWindow {
    
public:
    WordCountWindow ( const char * );
    
protected:
    virtual void createMenuPanes();
    virtual Widget createWorkArea ( Widget );
    
private:
    Widget _list;         // List of words found in file
    Cursor _busyCursor;   // Displayed when application is busy
    Cursor _normalCursor; // Cursor used when not busy
    
    // Functions for interfacing with the word count Cmd
    
    static void countWordsCallback ( void *, char * );
    static void taskFinishedCallback ( InterruptibleCmd *, 
				       Boolean, void * );
    void taskFinished ( CountWordsCmd * );
    void countWords ( char * );
    
    // Utility functions for manipulating cursors
    
    void setBusyCursor();
    void setNormalCursor();
};
#endif






































































































































































































