///////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////
//         This example code is from the book:
//
//           Object-Oriented Programming with C++ and OSF/Motif, 2nd Edition
//         by
//           Douglas Young
//           Prentice Hall, 1995
//           ISBN 0-13-20925507
//
//         Copyright 1995 by Prentice Hall
//         All Rights Reserved
//
//  Permission to use, copy, modify, and distribute this software for 
//  any purpose except publication and without fee is hereby granted, provided 
//  that the above copyright notice appear in all copies of the software.
///////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////
// CallbackMacros.h
///////////////////////////////////////
#include <generic.h>

#define DECL_CALLBACK(func)                           \
   private:                                           \
     static void name2(func,Callback) (Widget,        \
                                       XtPointer,     \
                                        XtPointer);   \
    protected:                                        \
      virtual void func ( Widget, XtPointer)

#define IMPL_CALLBACK(cls, func)                          \
   void cls::name2(func,Callback) (Widget w,              \
                                   XtPointer clientData,  \
                                   XtPointer callData)    \
  {                                                       \
      ((cls *)clientData)->func(w, callData);             \
  }                                                       \
                                                          \
  void cls::func(Widget w, XtPointer callData)      
