///////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////
//         This example code is from the book:
//
//           Object-Oriented Programming with C++ and OSF/Motif, 2nd Edition
//         by
//           Douglas Young
//           Prentice Hall, 1995
//           ISBN 0-13-20925507
//
//         Copyright 1995 by Prentice Hall
//         All Rights Reserved
//
//  Permission to use, copy, modify, and distribute this software for 
//  any purpose except publication and without fee is hereby granted, provided 
//  that the above copyright notice appear in all copies of the software.
///////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////



////////////////////////////////////////////////////////////////
// StopWatch.C: Group subcomponents into one stopwatch component
//              Customizable, UIComponent version
/////////////////////////////////////////////////////////////////
#include "Stopwatch.h"
#include <Xm/Xm.h>
#include <Xm/RowColumn.h>
#include "Timer.h"
#include "Face.h"
#include "Control.h"
  
XtResource Stopwatch::_resources [] = {
{
     "interval", 
     "Interval", 
     XmRInt, 
     sizeof ( int ),
     XtOffset ( Stopwatch *, _interval ), 
     XmRString, 
     (XtPointer) "1000",
  },
};

String Stopwatch::_defaults[] = {
    "*face.orientation:           horizontal",
    "*face*label*labelString:     Elapsed Time:",
    "*face*time*labelString:      000.000",
    "*face*frame*shadowType:      shadow_in",
    "*control.orientation:        horizontal",
    "*control.start.labelString:  Start",
    "*control.stop.labelString:   Stop",
     NULL,
  };


Stopwatch::Stopwatch ( Widget  parent, 
                         char   *name ) :  UIComponent ( name )
  {
      // Load the Stopwatch default resources into the database
  
      setDefaultResources ( parent, _defaults );
  
      // Create a manager widget to hold all components
  
      _w = XmCreateRowColumn ( parent, _name, NULL, 0 );
  
      // Call UIComponent hook to set up the destruction handler
  
       installDestroyHandler();
  
      // Retrieve customizable parameters for this class
  
      getResources ( _resources, XtNumber ( _resources ) );
  
      // Create the sub-components of the stopwatch
  
      _face = new  Face ( _w, "face" );
      _timer = new Timer ( XtWidgetToApplicationContext ( parent ), 
                           _face, 
                           _interval );
      _control = new Control ( _w, "control", this, _timer );
      _face->manage();
      _control->manage();
  }


Stopwatch::~Stopwatch ( )
{
    delete _face;
    delete _timer;
    delete _control;
}

void Stopwatch::timerStarted()
{
    // Empty
}

void Stopwatch::timerStopped()
{
    // Empty
}

